/***************************************************************************//**
 * @file
 * @brief ESL Tag CLI commands implementation.
 *******************************************************************************
 * # License
 * <b>Copyright 2022 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/
#include <stdarg.h>
#include <stdint.h>
#include <stdbool.h>
#include "gatt_db.h"
#include "app_log.h"
#include "sl_iostream.h"
#include "esl_tag_core.h"
#include "esl_log_config.h"
#include "sl_bt_ead_core.h"
#include "esl_tag_internal.h"
#include "sl_board_control.h"
#include "esl_tag_led_core.h"
#include "esl_tag_image_core.h"
#include "esl_tag_sensor_core.h"
#include "esl_tag_display_core.h"
#include "esl_tag_cli_test_harness.h"

// global CLI enable / disable, non-configurable in Studio, for debugging purpose
static bool cli_enabled = true;

// Two static images for OTS image transfer substitute command
#define BITS_PER_PIXEL  8
#define IMAGE_HEIGHT    128
#define IMAGE_WIDTH     128

static const uint8_t images[][(IMAGE_HEIGHT * IMAGE_WIDTH) / BITS_PER_PIXEL] = {
  {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdc, 0xff, 0xee, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff,
    0xbe, 0xff, 0x1f, 0xfe, 0xff, 0xff, 0xbf, 0xdb, 0xff, 0xfe, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0xff, 0xbc, 0xff, 0xcf, 0xfd, 0xff, 0xff, 0xbf, 0x0f, 0x61, 0xe8, 0xf8, 0x0d, 0x71, 0x78,
    0x74, 0xfc, 0xba, 0xe3, 0xef, 0xfd, 0xff, 0xff, 0xbf, 0xdf, 0xdf, 0x6e, 0xff, 0xed, 0xee,
    0xb7, 0xb3, 0xfb, 0xb2, 0xdd, 0xef, 0xfd, 0xff, 0xff, 0x7f, 0xdc, 0xdf, 0x6e, 0xff, 0xed,
    0xee, 0xb7, 0xb7, 0xfb, 0xb6, 0xbd, 0xef, 0xfb, 0xff, 0xff, 0xff, 0xdb, 0xc1, 0x6e, 0xff,
    0xed, 0x6e, 0xb0, 0x37, 0xf0, 0xae, 0xbd, 0xef, 0xfd, 0xff, 0xff, 0xff, 0xd7, 0xdd, 0x6e,
    0xff, 0xed, 0x6e, 0xb7, 0xb7, 0xff, 0x8e, 0xbd, 0xef, 0xfd, 0xff, 0xff, 0xbf, 0xd3, 0xdd,
    0x6e, 0xf7, 0xed, 0x6e, 0xb7, 0xb3, 0xff, 0x9e, 0xdd, 0xcf, 0xfd, 0xff, 0xff, 0x7f, 0x38,
    0xc1, 0xe9, 0xf8, 0xed, 0x6e, 0x70, 0x74, 0xf8, 0xbe, 0xe3, 0x1d, 0xfe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xfc, 0xdf, 0xff, 0xff, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xbf, 0xff, 0xff, 0xaf, 0xe7, 0x3f, 0xe7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x80, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x05,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0xa0, 0xff, 0xdf, 0x07, 0xd2, 0xff, 0xff,
    0x1f, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x80, 0xff, 0xbf, 0xa4, 0xfe, 0x5f, 0xfe,
    0xff, 0x7f, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x5e, 0x2a, 0x40, 0xfb, 0xff, 0xff,
    0xf1, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0x07, 0xfe, 0xff, 0xff, 0xff, 0x5f,
    0x22, 0xea, 0x7f, 0xfe, 0xff, 0xc3, 0xff, 0xff, 0xff, 0xff, 0x83, 0x0f, 0xe0, 0xff, 0xbf,
    0xa0, 0xff, 0x0b, 0xfd, 0xf9, 0xff, 0x87, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xf7, 0x2f, 0x12,
    0x00, 0xff, 0xff, 0xff, 0xf2, 0xf3, 0xff, 0x87, 0xff, 0xff, 0xff, 0x7f, 0xf0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xcf, 0xff, 0x0f, 0xff, 0xff, 0xff, 0x1f, 0xfc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x57, 0xd5, 0x1f, 0x3e, 0xff, 0x1f, 0xfe, 0xff, 0xff, 0x0f, 0xfe,
    0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xf4, 0x7c, 0xff, 0x1f, 0xfe, 0xff, 0xff, 0x0f,
    0xff, 0x7f, 0x29, 0xa0, 0xff, 0xff, 0xf9, 0xff, 0xeb, 0xf3, 0xfc, 0x3f, 0xfc, 0xff, 0xff,
    0x87, 0xff, 0x8f, 0xff, 0x8f, 0xff, 0xff, 0xfd, 0xff, 0x1f, 0xe7, 0xfb, 0x3f, 0xfc, 0xff,
    0xff, 0xcf, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0x9e, 0xf7, 0x7f, 0xfc,
    0xff, 0xff, 0xe7, 0xff, 0xf3, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0x79, 0xdf, 0x7f,
    0xf8, 0xff, 0xff, 0xc7, 0xff, 0xfb, 0xff, 0xcf, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0xfe,
    0xff, 0xf8, 0xff, 0xff, 0xe7, 0xff, 0xfd, 0xff, 0xdf, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xef,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0xff, 0xf1, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0x01,
    0xe8, 0xff, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0x5f,
    0x00, 0x80, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x07, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xc3, 0xff, 0xff, 0xf0, 0xff, 0x7f, 0xd0, 0xdf, 0xff,
    0xff, 0x01, 0x0e, 0x00, 0xf8, 0xff, 0xff, 0x87, 0xff, 0x7f, 0xf0, 0xff, 0x0f, 0x00, 0xfe,
    0xff, 0xff, 0xc0, 0x07, 0x00, 0xf0, 0xff, 0xff, 0x0f, 0xff, 0x7f, 0xf8, 0xff, 0x07, 0x04,
    0xf0, 0xff, 0x7f, 0xf8, 0x0f, 0x80, 0xe1, 0xff, 0xff, 0x0f, 0xfe, 0x1f, 0xfc, 0xff, 0x83,
    0x0b, 0xe0, 0xff, 0x3f, 0xf4, 0x0f, 0x80, 0xe6, 0xfc, 0xbf, 0x0a, 0xfc, 0x1f, 0xde, 0x95,
    0x03, 0x00, 0x80, 0xff, 0x3f, 0xfc, 0x00, 0x00, 0xc0, 0xc3, 0x5f, 0x35, 0xf8, 0x07, 0x07,
    0xff, 0x03, 0x00, 0x00, 0xf1, 0x1f, 0x3e, 0x00, 0x12, 0xc0, 0xeb, 0xff, 0xeb, 0xe0, 0x87,
    0xf3, 0xff, 0x7f, 0x01, 0x00, 0xf0, 0x3f, 0x0c, 0xf0, 0xff, 0xe0, 0xfe, 0xff, 0xbf, 0xe1,
    0xc3, 0xfc, 0xff, 0xff, 0xff, 0x00, 0xf0, 0x3f, 0x00, 0xff, 0xfe, 0xff, 0x7d, 0x80, 0x7f,
    0xc7, 0xe1, 0xde, 0xff, 0xff, 0xff, 0x0f, 0xfe, 0x7f, 0xc0, 0x7f, 0xfc, 0xff, 0x0f, 0x00,
    0xfc, 0x8d, 0x21, 0xe7, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xf1, 0xff, 0xf0, 0xff, 0x03,
    0x04, 0xf8, 0x1f, 0xe1, 0xf9, 0xea, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xff,
    0x00, 0xff, 0xf0, 0x1b, 0xb1, 0x3b, 0x00, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x81,
    0x5f, 0xc0, 0xff, 0xe3, 0x3f, 0xd0, 0x1d, 0x00, 0xfc, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0x07, 0x00, 0xe8, 0xf9, 0xc7, 0x7f, 0xd1, 0x0f, 0x2a, 0x70, 0xfc, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0x0f, 0x00, 0xfe, 0xf9, 0x87, 0x77, 0xf0, 0xfd, 0x7f, 0x00, 0xfe, 0x0f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xed, 0xff, 0xf1, 0x8f, 0x7f, 0xd1, 0xfd, 0xff, 0x00, 0xfe, 0x87, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1f, 0xf7, 0xd1, 0xfd, 0xe7, 0x80, 0xff, 0x83,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xf0, 0x9f, 0xff, 0xd1, 0xff, 0xc7, 0xff, 0xff,
    0xe0, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0x0f, 0xc0, 0x1f, 0xf7, 0xd1, 0xfd, 0xe7, 0xff,
    0x7f, 0xf0, 0xff, 0x7f, 0xc0, 0xfe, 0xff, 0xff, 0x01, 0x02, 0x1f, 0xff, 0xd3, 0xfb, 0xc7,
    0xff, 0x3f, 0xfc, 0xff, 0x7f, 0x00, 0xfd, 0xff, 0x7f, 0xc0, 0x03, 0x1e, 0xf7, 0xc3, 0xf3,
    0xc3, 0xff, 0x0f, 0xfc, 0xff, 0xff, 0x8f, 0x25, 0xf9, 0x1f, 0xf0, 0x03, 0x9c, 0xff, 0xa3,
    0xef, 0xc1, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0xff, 0xff, 0x03, 0xfc, 0x43, 0x08, 0x77,
    0x87, 0xff, 0xc1, 0xff, 0x05, 0xfc, 0xff, 0x01, 0x9f, 0xff, 0xff, 0x00, 0xff, 0xe1, 0x8f,
    0x7f, 0x47, 0xfe, 0xc1, 0xff, 0x9a, 0xf8, 0x7f, 0x00, 0x8c, 0xff, 0x1f, 0x40, 0xff, 0xf1,
    0xcf, 0x7b, 0x8f, 0xf1, 0x80, 0x3f, 0xdf, 0xf1, 0xff, 0x00, 0x86, 0xff, 0x03, 0xc0, 0xff,
    0xf0, 0xc7, 0x3b, 0x0f, 0xc7, 0x00, 0xdf, 0xff, 0xe3, 0xff, 0xff, 0xc6, 0x7f, 0x00, 0xe2,
    0x7f, 0xf0, 0xef, 0x1d, 0x1f, 0xff, 0x08, 0xfe, 0xff, 0xc3, 0xf9, 0xff, 0xc7, 0x0f, 0xa0,
    0xc7, 0x1f, 0xf0, 0xff, 0x19, 0x1f, 0x7e, 0x00, 0xf8, 0xff, 0x0f, 0xf2, 0xff, 0xff, 0x02,
    0xfc, 0xc3, 0x0f, 0xf0, 0xff, 0x0e, 0x3f, 0xfe, 0x40, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0x1f,
    0x80, 0xff, 0xe3, 0x01, 0xfc, 0xbf, 0x87, 0x3f, 0x7c, 0x40, 0x80, 0xff, 0x3f, 0xfc, 0xff,
    0x01, 0xf0, 0xff, 0x03, 0x00, 0xfc, 0xef, 0xc3, 0x7f, 0x7c, 0x60, 0x00, 0xfc, 0xff, 0xfe,
    0x17, 0x00, 0xfc, 0xff, 0x01, 0x00, 0xfe, 0xff, 0xe0, 0x7f, 0x7c, 0x60, 0x0c, 0x80, 0xfe,
    0x2f, 0x00, 0xa0, 0xf8, 0x7f, 0x00, 0x1c, 0xff, 0x7f, 0xf0, 0x7f, 0x7c, 0x60, 0x5c, 0x00,
    0x00, 0x00, 0x00, 0x7d, 0xfc, 0x1f, 0x00, 0x8f, 0xff, 0x5f, 0xf8, 0x7f, 0x7c, 0x70, 0x7e,
    0x00, 0x00, 0x00, 0xf0, 0xff, 0xf8, 0x0b, 0xc0, 0x87, 0xff, 0x3f, 0xfc, 0xff, 0x78, 0x60,
    0x7c, 0x5c, 0x01, 0x68, 0xfc, 0xff, 0x78, 0x00, 0xc0, 0xc7, 0xff, 0x1f, 0xfe, 0xff, 0x78,
    0x60, 0x3c, 0xfe, 0xc7, 0x7f, 0xfe, 0xff, 0x08, 0x00, 0xe0, 0xe3, 0xff, 0x1f, 0xff, 0xff,
    0x78, 0x00, 0x3c, 0xfc, 0x87, 0xff, 0xfc, 0xff, 0x01, 0x00, 0xe3, 0xe1, 0xff, 0x0f, 0xff,
    0xff, 0x78, 0x00, 0x1c, 0xfe, 0xc7, 0x7f, 0xfc, 0x7f, 0x00, 0xc0, 0xe3, 0xf0, 0xff, 0x87,
    0xff, 0xff, 0x78, 0x00, 0x20, 0xfe, 0xc7, 0x7f, 0xfc, 0x07, 0x00, 0xf8, 0x63, 0xf8, 0xff,
    0xc7, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x40, 0x45, 0x55, 0x54, 0x00, 0x00, 0xfd, 0x07, 0xfc,
    0xff, 0xc7, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x07,
    0xfc, 0xff, 0xe3, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff,
    0x07, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xe3,
    0xff, 0x0f, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,
    0xe3, 0xff, 0x83, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xfe, 0xe3, 0xff, 0xc0, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xfc, 0x08, 0x00, 0x00, 0x00, 0x00,
    0xe0, 0xff, 0xc3, 0x7f, 0xe0, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xf8, 0x11, 0x01, 0x00, 0x00,
    0x00, 0xe2, 0xff, 0xc7, 0x1f, 0xf8, 0xff, 0x7f, 0xf8, 0xff, 0xff, 0xfc, 0x11, 0x42, 0x00,
    0x00, 0xe9, 0xf3, 0xff, 0x87, 0x0f, 0xfc, 0xff, 0x3f, 0xfc, 0xff, 0x7f, 0xfc, 0x21, 0xc6,
    0xe3, 0x87, 0xff, 0xe3, 0xff, 0x8f, 0x03, 0xff, 0xff, 0x1f, 0xfe, 0xff, 0xff, 0xfc, 0x23,
    0x86, 0xc3, 0x0f, 0xff, 0xe3, 0xff, 0x8f, 0x82, 0xfe, 0xff, 0x0f, 0xff, 0xff, 0x7f, 0xfc,
    0x03, 0x8c, 0xc7, 0x8f, 0xff, 0xe3, 0xff, 0x1f, 0xe0, 0xff, 0xff, 0x87, 0xff, 0xff, 0x7f,
    0xfc, 0x07, 0x0f, 0xc7, 0x1f, 0xff, 0xe3, 0xff, 0x07, 0xf0, 0xdf, 0xdf, 0xc3, 0xff, 0xff,
    0x7f, 0xfc, 0x07, 0x1e, 0x8f, 0x1f, 0xff, 0xe3, 0xff, 0x08, 0xfc, 0xf7, 0xe3, 0xe0, 0xff,
    0xff, 0x7f, 0xfc, 0x0f, 0x00, 0x8f, 0x3f, 0xff, 0xe3, 0x1f, 0x00, 0xff, 0x78, 0x78, 0xf0,
    0xff, 0xff, 0x7f, 0xfe, 0x3f, 0x00, 0x0a, 0x1f, 0xff, 0xa3, 0x01, 0xc0, 0x3f, 0x5f, 0x3e,
    0xf8, 0xff, 0xff, 0x7f, 0xfc, 0x7f, 0x00, 0x00, 0x34, 0xb4, 0x00, 0x00, 0xf4, 0xcf, 0x8f,
    0x0f, 0xfe, 0xff, 0xff, 0x3f, 0xfe, 0xff, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xe3,
    0xe3, 0x03, 0xff, 0xff, 0xff, 0x7f, 0xfe, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0xf4, 0xff,
    0xfc, 0xf8, 0xc0, 0xff, 0xff, 0xff, 0x3f, 0xfe, 0xff, 0xff, 0xbf, 0x02, 0x21, 0xfd, 0xff,
    0x3f, 0x3f, 0xbe, 0xe0, 0xff, 0xff, 0xff, 0x3f, 0xfe, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc7, 0x8b, 0x2f, 0xf8, 0xff, 0xff, 0xff, 0x3f, 0xbe, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf9, 0xe2, 0x0b, 0xfe, 0xff, 0xff, 0xff, 0x3f, 0x7e, 0x7f, 0xfe, 0x7f, 0x25,
    0x95, 0xfe, 0x7f, 0x3e, 0xfc, 0x01, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x7e, 0xff, 0xfc, 0xff,
    0xff, 0xff, 0xff, 0x8f, 0x87, 0x7f, 0xc0, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xfe, 0xff, 0xe1,
    0xff, 0xff, 0xff, 0x7f, 0xf1, 0xe8, 0x1f, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x7f, 0xff,
    0x0f, 0xfd, 0xff, 0xff, 0x85, 0x9e, 0xfe, 0x07, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xfe,
    0xfc, 0xff, 0xaa, 0xbf, 0x7d, 0xfb, 0xf3, 0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
    0xfe, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xfe, 0x3f, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x3f, 0xfe, 0xc7, 0xff, 0xff, 0xff, 0x7f, 0xd5, 0xff, 0x0f, 0xfc, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x3f, 0xfe, 0x3f, 0xfc, 0xff, 0xef, 0xca, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x3f, 0xfe, 0xff, 0x01, 0x55, 0x59, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x3f, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xf0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x7f, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xfc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x05, 0xa0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00,
    0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xff, 0xff, 0xff, 0xff, 0x0f,
    0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0xff, 0xff, 0xff, 0xff,
    0x02, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xf8, 0xff, 0xff,
    0x17, 0x00, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x80, 0xfe,
    0x2b, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
    0x00, 0x00, 0x80, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x03, 0x00, 0x00, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xbf, 0x00, 0xe8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
  },
  {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdc, 0xff, 0xee, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff,
    0xbe, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xbf, 0xdb, 0xff, 0xfe, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0xff, 0xbc, 0xff, 0xc7, 0xff, 0xff, 0xff, 0xbf, 0x0f, 0x61, 0xe8, 0xf8, 0x0d, 0x71, 0x78,
    0x74, 0xfc, 0xba, 0xe3, 0xdf, 0xff, 0xff, 0xff, 0xbf, 0xdf, 0xdf, 0x6e, 0xff, 0xed, 0xee,
    0xb7, 0xb3, 0xfb, 0xb2, 0xdd, 0xdf, 0xff, 0xff, 0xff, 0x7f, 0xdc, 0xdf, 0x6e, 0xff, 0xed,
    0xee, 0xb7, 0xb7, 0xfb, 0xb6, 0xbd, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xc1, 0x6e, 0xff,
    0xed, 0x6e, 0xb0, 0x37, 0xf0, 0xae, 0xbd, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xd7, 0xdd, 0x6e,
    0xff, 0xed, 0x6e, 0xb7, 0xb7, 0xff, 0x8e, 0xbd, 0xdf, 0xff, 0xff, 0xff, 0xbf, 0xd3, 0xdd,
    0x6e, 0xf7, 0xed, 0x6e, 0xb7, 0xb3, 0xff, 0x9e, 0xdd, 0xdf, 0xff, 0xff, 0xff, 0x7f, 0x38,
    0xc1, 0xe9, 0xf8, 0xed, 0x6e, 0x70, 0x74, 0xf8, 0xbe, 0xe3, 0xdd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xfc, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x23, 0xab, 0xff, 0xff, 0x73, 0xe1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x7a, 0xf8, 0xf7, 0x9e, 0x02, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x98, 0x1f, 0x38, 0xe2, 0xf0, 0x1a,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0x66, 0xbd, 0x7e, 0xe6, 0xc0,
    0x67, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x87, 0x3a, 0x38, 0xbf, 0xf7,
    0xcc, 0xdf, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x63, 0x3e, 0x39, 0x30,
    0x7f, 0xcc, 0x73, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x3f, 0x3f,
    0x30, 0xff, 0xd4, 0xc1, 0x86, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xe8, 0x3f,
    0x7a, 0x3e, 0x76, 0xe0, 0x88, 0x1b, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xf6,
    0x7f, 0x70, 0x3e, 0x63, 0xf2, 0xf9, 0x2d, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f,
    0xd9, 0xfe, 0x60, 0x36, 0x32, 0x66, 0xfc, 0xd8, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x8f, 0x0e, 0xff, 0x47, 0x60, 0x30, 0x66, 0xe0, 0xb1, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x47, 0x83, 0x7e, 0xec, 0x70, 0x38, 0x73, 0xf2, 0x41, 0xe3, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa3, 0x71, 0xfe, 0xc4, 0xfe, 0x7f, 0x73, 0xfe, 0xc0, 0xc2, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd1, 0x63, 0xfe, 0xe0, 0x03, 0xc0, 0x97, 0x7f, 0xfc, 0xcb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe9, 0x07, 0xfe, 0x3b, 0x50, 0x05, 0x3c, 0x7c, 0xfc, 0x17, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x87, 0xff, 0x87, 0xae, 0xda, 0xe0, 0x38, 0xfe, 0x17,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x14, 0x9e, 0xff, 0xb1, 0xfa, 0x2f, 0xab, 0x1f, 0xff,
    0x2f, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x0a, 0x1c, 0x7f, 0xcc, 0xff, 0xff, 0x15, 0x9e,
    0xff, 0x5f, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x6d, 0x38, 0x1e, 0xfb, 0xff, 0xff, 0x6f,
    0x98, 0xff, 0xbf, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xc6, 0x71, 0x4c, 0xfd, 0xff, 0xff,
    0xbf, 0xf1, 0xff, 0x7f, 0xf9, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xce, 0x63, 0xa3, 0xff, 0xfd,
    0xff, 0xff, 0xe6, 0xff, 0x7f, 0xf1, 0xeb, 0xff, 0xff, 0xff, 0x4f, 0x0f, 0xc7, 0xdb, 0xff,
    0xdb, 0xf3, 0xff, 0x89, 0xff, 0xff, 0x52, 0x80, 0xff, 0xff, 0xff, 0xa7, 0x1d, 0xce, 0xe8,
    0xff, 0xc1, 0xe0, 0xff, 0x97, 0xff, 0xff, 0x02, 0x00, 0xff, 0xff, 0xff, 0xa3, 0x3c, 0xc4,
    0xf6, 0x7f, 0xe2, 0xc3, 0xff, 0x2f, 0xfe, 0x17, 0x00, 0x20, 0xfe, 0xff, 0xff, 0xd3, 0xfc,
    0x20, 0xfa, 0xff, 0xe1, 0xe1, 0xf8, 0xdf, 0x7e, 0x01, 0x00, 0xa8, 0xfe, 0xff, 0xff, 0x53,
    0xfc, 0xb1, 0xfd, 0xe1, 0xc1, 0xef, 0xf8, 0xbf, 0x08, 0x00, 0x00, 0x20, 0xfe, 0xff, 0xff,
    0x69, 0xf0, 0x9f, 0xfe, 0xe3, 0xfd, 0xff, 0xfd, 0x7f, 0xc0, 0x00, 0x80, 0x86, 0xfc, 0xff,
    0xff, 0x29, 0xc1, 0x4f, 0xff, 0xe0, 0xff, 0xff, 0xff, 0x0b, 0x00, 0x10, 0xf4, 0x0f, 0xfc,
    0xff, 0xff, 0x68, 0x17, 0xe7, 0xff, 0xd3, 0xff, 0xff, 0x1f, 0x10, 0x00, 0xc0, 0xfc, 0x0f,
    0xfc, 0xff, 0xff, 0xf4, 0x3f, 0xd6, 0xff, 0xf7, 0xff, 0xff, 0x02, 0x20, 0x00, 0xfa, 0xfe,
    0x07, 0xfd, 0xff, 0x7f, 0xf4, 0x7f, 0xd2, 0x9f, 0xff, 0xff, 0x8f, 0x04, 0x10, 0x00, 0xff,
    0xfd, 0x01, 0xfc, 0xff, 0xff, 0xfa, 0xff, 0xeb, 0x1f, 0xff, 0x7f, 0x01, 0x20, 0x00, 0x0a,
    0xff, 0xe5, 0x01, 0xfa, 0xff, 0x7f, 0xfa, 0xff, 0xe9, 0x9f, 0xff, 0x0b, 0x00, 0x00, 0xe5,
    0x1f, 0x5f, 0xe0, 0x01, 0xf8, 0xff, 0x3f, 0xfa, 0xff, 0xf5, 0xff, 0x7f, 0x00, 0x04, 0x40,
    0xf8, 0x3f, 0x0f, 0xc8, 0x93, 0xf8, 0xff, 0x7f, 0xfe, 0xbf, 0xf4, 0xff, 0x0b, 0x00, 0x00,
    0x7d, 0xf2, 0x3f, 0x1e, 0xc4, 0x23, 0xf8, 0xff, 0x3f, 0xfd, 0xff, 0xfc, 0x5f, 0x00, 0x00,
    0x20, 0xfe, 0xf1, 0x7c, 0x1e, 0xc1, 0x03, 0xf0, 0xff, 0x3f, 0xfd, 0xff, 0xfa, 0x05, 0x00,
    0x20, 0x14, 0xfe, 0xf1, 0x78, 0xfe, 0xc3, 0x03, 0xf0, 0xff, 0x3f, 0xfd, 0x7f, 0x5a, 0x80,
    0x00, 0x40, 0x1f, 0xdf, 0xe3, 0x78, 0xfe, 0x83, 0x1b, 0xf0, 0xff, 0x1f, 0xff, 0x7f, 0x00,
    0x00, 0x00, 0xf0, 0x3f, 0xcf, 0xe3, 0x39, 0xfe, 0xc3, 0x07, 0xf0, 0xff, 0x3f, 0xfe, 0x17,
    0x00, 0x00, 0xf0, 0xe1, 0x3f, 0x8f, 0xe7, 0x3d, 0x7c, 0xa1, 0x47, 0xf0, 0xff, 0x9f, 0x7e,
    0x01, 0x00, 0x40, 0xf8, 0xe7, 0x03, 0x8f, 0xe0, 0x3f, 0x1c, 0x80, 0x07, 0xe0, 0xff, 0x9f,
    0x46, 0x00, 0x0c, 0x40, 0xf8, 0xe7, 0x01, 0x0f, 0xe0, 0x7f, 0x3c, 0x80, 0x0f, 0xe0, 0xff,
    0x1f, 0x81, 0x00, 0x20, 0x04, 0xbc, 0xc7, 0x05, 0x8e, 0xc0, 0xff, 0x3c, 0x04, 0x0f, 0xe4,
    0xff, 0x0b, 0x02, 0x01, 0xf4, 0x09, 0x3c, 0xef, 0x2b, 0x1f, 0xc0, 0xf3, 0x78, 0x0d, 0x0f,
    0xe0, 0xbf, 0x00, 0x00, 0x00, 0xff, 0x0b, 0x3c, 0xc1, 0x7f, 0x1e, 0xc0, 0xf3, 0xfc, 0x0f,
    0x8f, 0xe0, 0x1f, 0x02, 0x00, 0x0d, 0xfe, 0x07, 0x7a, 0xc0, 0x7f, 0x1e, 0xcf, 0xe3, 0xf9,
    0x0f, 0x01, 0xe0, 0x0f, 0x00, 0xc0, 0x1f, 0xdf, 0x07, 0xf8, 0xc1, 0x7f, 0x1e, 0x8f, 0xf3,
    0xf9, 0x0f, 0x00, 0xe0, 0x07, 0x80, 0xc2, 0x3f, 0x9e, 0x07, 0xf8, 0x87, 0x17, 0x3c, 0x8f,
    0xe7, 0xf1, 0x00, 0x00, 0xf0, 0x07, 0xe8, 0xe7, 0x7f, 0x1e, 0x4f, 0xf0, 0xcf, 0x07, 0x3f,
    0x9e, 0xe7, 0x13, 0x00, 0x20, 0xfc, 0x07, 0xfe, 0xe7, 0x79, 0x1c, 0x0f, 0xe0, 0x9f, 0x07,
    0x3c, 0x8f, 0x47, 0x00, 0x00, 0x40, 0xff, 0x07, 0xff, 0xe7, 0xf9, 0xbe, 0x0f, 0x81, 0x9f,
    0x07, 0xf8, 0x8f, 0x07, 0x80, 0x02, 0xf8, 0xff, 0x07, 0xfe, 0xe0, 0x71, 0xfc, 0x87, 0x00,
    0x3e, 0xf7, 0xf9, 0x0f, 0x80, 0x10, 0x40, 0xf9, 0xff, 0x07, 0xf4, 0xe1, 0xf1, 0xfc, 0x07,
    0x70, 0x9c, 0xff, 0xf0, 0x03, 0x40, 0x04, 0x7c, 0xf9, 0xff, 0x0f, 0xe0, 0xe0, 0xf1, 0xfc,
    0x03, 0xf2, 0x3c, 0xff, 0xa1, 0x00, 0x10, 0xa0, 0x7f, 0xfc, 0xff, 0x47, 0xe0, 0xe1, 0xf9,
    0x79, 0x80, 0xf0, 0xbc, 0xff, 0x01, 0x04, 0x02, 0xfa, 0x7f, 0xf9, 0xff, 0x1f, 0xf0, 0xc1,
    0xe3, 0x7c, 0x29, 0xe4, 0x9f, 0x0f, 0x00, 0x20, 0x50, 0xfe, 0x7f, 0xfc, 0xfb, 0x8f, 0xc0,
    0xe3, 0xe3, 0x79, 0x02, 0xe0, 0x1f, 0x00, 0x90, 0x80, 0x3e, 0xff, 0xbf, 0xfc, 0xff, 0x0f,
    0xe0, 0xc1, 0xe3, 0x79, 0x14, 0xc8, 0x4f, 0x00, 0x02, 0xf4, 0x5f, 0xff, 0x7f, 0xfc, 0xff,
    0x1f, 0xc0, 0xc3, 0xe3, 0x71, 0x18, 0x00, 0x41, 0x00, 0x40, 0xff, 0x2f, 0xff, 0xbf, 0xfc,
    0xff, 0x1f, 0xc1, 0x83, 0xe7, 0xf9, 0x60, 0x00, 0x40, 0x00, 0xf4, 0xff, 0x9f, 0xff, 0x3f,
    0xfe, 0xff, 0x1f, 0xc0, 0xc7, 0xe7, 0xf1, 0x04, 0x00, 0x20, 0xa0, 0xff, 0xfd, 0x97, 0xff,
    0x5f, 0xfe, 0xee, 0x1f, 0x84, 0x8b, 0xff, 0xf1, 0x80, 0x00, 0x00, 0xfa, 0xff, 0xf9, 0xd7,
    0xfc, 0x5f, 0xfe, 0xff, 0x1f, 0x81, 0x07, 0xff, 0x20, 0x02, 0x01, 0xe0, 0xff, 0xff, 0xf9,
    0xcb, 0xfc, 0x3f, 0xff, 0xff, 0x3f, 0x80, 0x07, 0x7f, 0x00, 0x20, 0x00, 0xfd, 0xff, 0xff,
    0xf5, 0x6b, 0xfc, 0x2f, 0xff, 0xff, 0x3f, 0x80, 0x07, 0x1c, 0x00, 0x40, 0xf0, 0xff, 0xff,
    0xcf, 0xff, 0x25, 0xf8, 0x2f, 0xff, 0xff, 0x3f, 0x80, 0x17, 0x00, 0x00, 0x80, 0xff, 0xff,
    0xff, 0xcb, 0xff, 0x32, 0xe0, 0x8f, 0xff, 0xff, 0x3f, 0x00, 0x07, 0x00, 0x00, 0xf8, 0xbf,
    0xff, 0xbf, 0xa7, 0xff, 0x39, 0x83, 0x97, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x80, 0xfe,
    0x9f, 0xff, 0xdb, 0xc7, 0x7f, 0xc9, 0x0f, 0x86, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x3a,
    0xfd, 0x8f, 0x97, 0x93, 0xb7, 0xbf, 0xcc, 0x3f, 0xca, 0xff, 0xff, 0x7f, 0x04, 0x00, 0xa0,
    0x7f, 0xfa, 0x3f, 0xcf, 0x07, 0xff, 0x5f, 0xc6, 0x7f, 0xc3, 0xff, 0xff, 0x7f, 0x00, 0x00,
    0xfe, 0xff, 0xf4, 0xff, 0x83, 0x07, 0xff, 0x2f, 0x63, 0xfc, 0xe5, 0xff, 0xff, 0xff, 0x10,
    0x40, 0xff, 0xff, 0xe9, 0xff, 0xaf, 0xc3, 0xff, 0x93, 0x43, 0xfe, 0xe2, 0xff, 0xff, 0xff,
    0x31, 0x4f, 0xff, 0xff, 0x93, 0xff, 0xef, 0xdf, 0xff, 0xcd, 0x07, 0xee, 0xf2, 0xff, 0xff,
    0xff, 0xef, 0x8f, 0xfe, 0xff, 0x66, 0xff, 0xff, 0xff, 0x7f, 0x62, 0x1c, 0x67, 0xf1, 0xff,
    0xff, 0xff, 0xff, 0x1f, 0xfd, 0x7f, 0x8c, 0xfc, 0xff, 0xff, 0xdf, 0x39, 0x38, 0xa0, 0xf8,
    0xff, 0xff, 0xff, 0xff, 0x3f, 0xfd, 0xff, 0x38, 0xf5, 0xff, 0xff, 0x57, 0x8c, 0x78, 0xb0,
    0xfc, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xfa, 0xff, 0x61, 0x84, 0xff, 0xff, 0x14, 0x8f, 0xf3,
    0x59, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xf4, 0x7f, 0xe0, 0xb3, 0xb4, 0x95, 0xc5, 0x1d,
    0xe1, 0x2b, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x7f, 0x3c, 0x0e, 0x55, 0x35, 0x71,
    0x38, 0xc0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x7f, 0x1e, 0x7c, 0x00, 0x01,
    0x3e, 0x60, 0x8c, 0x8b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb1, 0x1f, 0x8f, 0xd9, 0x2f,
    0xfa, 0x2b, 0xf3, 0x1c, 0xc5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa7, 0x1f, 0x8f, 0x19,
    0xff, 0x7f, 0x30, 0xfe, 0xb0, 0xe5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x8e, 0xc7,
    0x58, 0xfc, 0x61, 0x34, 0xfe, 0x71, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xcd,
    0xe7, 0x8c, 0xf8, 0x40, 0x7e, 0xde, 0xb3, 0xf0, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f,
    0xda, 0x67, 0x8c, 0xf9, 0xcc, 0x64, 0x8c, 0x4f, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdd,
    0x7f, 0xf4, 0x63, 0xcc, 0xf8, 0xf8, 0xe0, 0xb8, 0x37, 0xbc, 0xff, 0xfb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xc8, 0x33, 0x0e, 0xfc, 0xf0, 0xd0, 0x88, 0x0b, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb1, 0x47, 0x86, 0xfe, 0xc1, 0xf9, 0xc1, 0x84, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x43, 0x06, 0xef, 0xff, 0xc7, 0xf8, 0x6b, 0xe3, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xf9, 0xc7, 0xff, 0xcd, 0x81, 0x5f, 0xf0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xea, 0xe7, 0xff, 0x88, 0x81, 0x2b, 0xfc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x28, 0xef, 0xff, 0xc9, 0xfb, 0x3a, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0xf8, 0xff, 0xe1, 0x97, 0x92,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x45, 0xff, 0xbf, 0x54,
    0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xb0, 0x20, 0xa1,
    0x05, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x6a,
    0x4d, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x17,
    0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7d, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x02, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd7, 0xfd, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
  }
};

void esl_tag_cli_test_harness_init(void)
{
  // Enable VCOM for CLI communication (disabled by default in Tag example)
  sl_board_enable_vcom();
}

// Get sl_status_t result status strings
static const char* get_status_str(uint32_t status_code)
{
  switch (status_code) {
    case SL_STATUS_OK:
      return "OK";

    case SL_STATUS_FAIL:
      return "Fail";

    case SL_STATUS_INVALID_STATE:
      return "Invalid state";

    case SL_STATUS_INVALID_PARAMETER:
      return "Invalid parameter";

    case SL_STATUS_NOT_READY:
      return "Not ready";

    case SL_STATUS_NOT_SUPPORTED:
      return "Not supported";

    case SL_STATUS_BUSY:
      return "Busy";

    case SL_STATUS_NO_MORE_RESOURCE:
      return "No more resource";

    case SL_STATUS_EMPTY:
      return "Empty";

    case SL_STATUS_FULL:
      return "Full";

    case SL_STATUS_WOULD_OVERFLOW:
      return "Would overflow";

    case SL_STATUS_BT_CTRL_CONNECTION_LIMIT_EXCEEDED:
      return "Connection limit exceeded";

    case SL_STATUS_INVALID_INDEX:
      return "Invalid index";

    default:
      return "Unknown";
  }
}

// Get ESL State machine status name
static const char* get_esl_state_str(esl_state_t status_code)
{
  switch (status_code) {
    case esl_state_boot:
      return "Boot";

    case esl_state_unassociated:
      return "Unassociated";

    case esl_state_configuring:
      return "Configuring";

    case esl_state_synchronized:
      return "Synchronized";

    case esl_state_unsynchronized:
      return "Unsynchronized";

    case esl_state_updating:
      return "Updating";

    default:
      return "Invalid";
  }
}

// Get ESL Basic State flag strings
static const char* get_esl_basic_flag_str(esl_basic_state_t basic_state_mask)
{
  switch (basic_state_mask) {
    case ESL_BASIC_STATE_MASK(ESL_BASIC_STATE_SERVICE_NEEDED_BIT):
      return "Service needed";

    case ESL_BASIC_STATE_MASK(ESL_BASIC_STATE_SYNCHRONIZED_BIT):
      return "Synchronized";

    case ESL_BASIC_STATE_MASK(ESL_BASIC_STATE_ACTIVE_LED_BIT):
      return "LED active";

    case ESL_BASIC_STATE_MASK(ESL_BASIC_STATE_PENDING_LED_BIT):
      return "Pending LED";

    case ESL_BASIC_STATE_MASK(ESL_BASIC_STATE_PENDING_DISPLAY_BIT):
      return "Pending display";

    default:
      return NULL;
  }
}

// Make ESL Basic State register status human readable
static void cli_decode_esl_basic_state(esl_basic_state_t basic_state)
{
  bool first = true;
  CLI_RESPONSE("Basic state value: 0x%02x", basic_state);

  if (!basic_state) {
    CLI_RESPONSE_HEADLESS("  No basic state flag is set.");
    return;
  }

  CLI_RESPONSE_HEADLESS("  Flags set: ");
  for (uint8_t i = 0; basic_state; i++) {
    const char* str;

    str = get_esl_basic_flag_str(ESL_BASIC_STATE_MASK(i) & basic_state);
    basic_state &= (esl_basic_state_t)(~(ESL_BASIC_STATE_MASK(i)));

    if (str) {
      if (first) {
        first = false;
      } else {
        CLI_RESPONSE_APPEND(", ");
      }

      CLI_RESPONSE_APPEND("%s", str);
    }
  }
  app_log_nl();
}

// Check if given component has logging enabled
static bool component_log_enabled(uint8_t component)
{
  bool enabled = (ESL_CORE_LOG_ENABLE != 0);

  // is enabled by config?
  if (enabled) {
    switch (component & ESL_LOG_FLAGS_MASK) {
      case ESL_LOG_COMPONENT_CORE:
        if (ESL_LOG_COMPONENT_CORE_ENABLE == 0) {
          enabled = false;
        }
        break;

      case ESL_LOG_COMPONENT_APP:
        if (ESL_LOG_COMPONENT_APP_ENABLE == 0) {
          enabled = false;
        }
        break;

      case ESL_LOG_COMPONENT_DISPLAY:
        if (ESL_LOG_COMPONENT_DISPLAY_ENABLE == 0) {
          enabled = false;
        }
        break;

      case ESL_LOG_COMPONENT_RAM_IMAGE:
        if (ESL_LOG_COMPONENT_RAM_IMAGE_ENABLE == 0) {
          enabled = false;
        }
        break;

      case ESL_LOG_COMPONENT_NVM_IMAGE:
        if (ESL_LOG_COMPONENT_NVM_IMAGE_ENABLE == 0) {
          enabled = false;
        }
        break;

      case ESL_LOG_COMPONENT_LED:
        if (ESL_LOG_COMPONENT_LED_ENABLE == 0) {
          enabled = false;
        }
        break;

      case ESL_LOG_COMPONENT_OTS:
        if (ESL_LOG_COMPONENT_OTS_ENABLE == 0) {
          enabled = false;
        }
        break;

      case ESL_LOG_COMPONENT_SENSOR:
        if (ESL_LOG_COMPONENT_SENSOR_ENABLE == 0) {
          enabled = false;
        }
        break;

      default:
        // do not block any future components by default
        break;
    }
  }

  return enabled;
}

void cli_esl_tag_address_get(sl_cli_command_arg_t *arguments)
{
  esl_address_t address = 0;
  sl_status_t sc = esl_core_read_esl_address(&address);
  (void)sc; // warning elimination if logging disabled

  (void)arguments;
  if (cli_enabled) {
    CLI_RESPONSE("ESL Address: 0x%04X", address);
    CLI_RESPONSE_HEADLESS("  ID: %u in group: %u",
                          esl_core_get_id(address),
                          esl_core_get_group_id(address));
    CLI_RESPONSE("Result: %s (0x%04lX)", get_status_str(sc), sc);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_ap_key_get(sl_cli_command_arg_t *arguments)
{
  struct sl_bt_ead_key_material_s key_data = { 0 };
  sl_status_t sc = esl_core_read_ap_key(&key_data);
  (void)sc; // warning elimination if logging disabled

  (void)arguments;
  if (cli_enabled) {
    uint32_t i = sizeof(key_data);
    CLI_RESPONSE("ESL Ap Key: 0x");
    while (i--) {
      CLI_RESPONSE_APPEND("%02x", ((uint8_t *)&key_data)[i]);
    }
    CLI_RESPONSE_APPEND(APP_LOG_NL);
    CLI_RESPONSE("Result: %s (0x%04lX)", get_status_str(sc), sc);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_response_key_get(sl_cli_command_arg_t *arguments)
{
  struct sl_bt_ead_key_material_s key_data = { 0 };
  sl_status_t sc = esl_core_read_response_key(&key_data);
  (void)sc; // warning elimination if logging disabled

  (void)arguments;
  if (cli_enabled) {
    uint32_t i = sizeof(key_data);
    CLI_RESPONSE("ESL Response Key: 0x");
    while (i--) {
      CLI_RESPONSE_APPEND("%02x", ((uint8_t *)&key_data)[i]);
    }
    CLI_RESPONSE_APPEND(APP_LOG_NL);
    CLI_RESPONSE("Result: %s (0x%04lX)", get_status_str(sc), sc);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_absolute_time_get(sl_cli_command_arg_t *arguments)
{
  uint32_t time = 0;
  sl_status_t sc = esl_core_read_absolute_time(&time);
  (void)sc; // warning elimination if logging disabled

  (void)arguments;
  if (cli_enabled) {
    CLI_RESPONSE("ESL Absolute Time: %lu (0x%lX)", time, time);
    CLI_RESPONSE("Result: %s (0x%04lX)", get_status_str(sc), sc);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_led_info_get(sl_cli_command_arg_t *arguments)
{
  sl_status_t sc = SL_STATUS_OK;
  (void)sc; // warning elimination if logging disabled

  (void)arguments;
  if (cli_enabled) {
    uint8_t led_count = esl_led_get_count();
    (void)led_count; // warning elimination if logging disabled

    CLI_RESPONSE("LED count: %d", led_count);
    CLI_RESPONSE("Result: %s (0x%04lX)", get_status_str(sc), sc);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_display_info_get(sl_cli_command_arg_t *arguments)
{
  sl_status_t sc = SL_STATUS_NOT_SUPPORTED;

  (void)arguments;
  if (cli_enabled) {
#if defined(gattdb_esl_display_info)
    uint8_t display_count = esl_display_get_count();

    CLI_RESPONSE("Display count: %d", display_count);
    if (display_count) {
      for (uint8_t i = 0; i < display_count; i++) {
        uint16_t width;
        uint16_t height;
        uint8_t  type;

        CLI_RESPONSE_HEADLESS("  Display %u:", i);

        sc = esl_display_get_height(i, &height);
        if (sc != SL_STATUS_OK) {
          break;
        }

        sc = esl_display_get_width(i, &width);
        if (sc != SL_STATUS_OK) {
          break;
        }

        sc = esl_display_get_type(i, &type);
        if (sc != SL_STATUS_OK) {
          break;
        }

        CLI_RESPONSE_HEADLESS("    Width:  %4u px", width);
        CLI_RESPONSE_HEADLESS("    Height: %4u px", height);
        CLI_RESPONSE_HEADLESS("    Type:   0x%02x", type);
      }
    }
#endif // defined(gattdb_esl_display_info)
    CLI_RESPONSE("Result: %s (0x%04lX)", get_status_str(sc), sc);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_image_info_get(sl_cli_command_arg_t *arguments)
{
  sl_status_t sc = SL_STATUS_NOT_SUPPORTED;

  (void)arguments;
  (void)sc;

  if (cli_enabled) {
#if defined(gattdb_esl_image_info)
    uint8_t gatt_data;
    size_t gatt_len;
    sc = sl_bt_gatt_server_read_attribute_value(gattdb_esl_image_info,
                                                0,
                                                sizeof(gatt_data),
                                                &gatt_len,
                                                &gatt_data);

    CLI_RESPONSE("Max. number of images: %d", gatt_data + 1);
#endif // defined(gattdb_esl_image_info)
    CLI_RESPONSE("Result: %s (0x%04lX)", get_status_str(sc), sc);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_sensor_info_get(sl_cli_command_arg_t *arguments)
{
  sl_status_t sc = SL_STATUS_OK;
  (void)sc; // warning elimination if logging disabled
  (void)arguments;

  if (cli_enabled) {
    uint8_t sensor_count = esl_sensor_get_count();
    (void)sensor_count; // warning elimination if logging disabled

    CLI_RESPONSE("Sensor count: %d", sensor_count);
    CLI_RESPONSE("Result: %s (0x%04lX)", get_status_str(sc), sc);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_status_get(sl_cli_command_arg_t *arguments)
{
  esl_state_t status = esl_core_get_status();
  (void)status; // warning elimination if logging disabled
  (void)arguments;

  if (cli_enabled) {
    CLI_RESPONSE("ESL State: %s (0x%04X)", get_esl_state_str(status), status);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_basic_state_get(sl_cli_command_arg_t *arguments)
{
  (void)arguments;

  if (cli_enabled) {
    esl_basic_state_t basic_state = esl_core_get_basic_state();
    cli_decode_esl_basic_state(basic_state);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_service_needed_set(sl_cli_command_arg_t *arguments)
{
  sl_status_t sc = SL_STATUS_NOT_SUPPORTED;
  (void)sc; // warning elimination if logging disabled

  if (cli_enabled) {
    esl_state_t value = (esl_state_t)sl_cli_get_argument_uint8(arguments, 0);
    if (ESL_SET == value || ESL_CLEAR == value) {
      esl_basic_state_t basic_state;
      basic_state = esl_core_set_basic_state_bit(ESL_BASIC_STATE_SERVICE_NEEDED_BIT,
                                                 value);
      cli_decode_esl_basic_state(basic_state);
      sc = SL_STATUS_OK;
    } else {
      sc = SL_STATUS_INVALID_PARAMETER;
    }
    CLI_RESPONSE("Result: %s (0x%04lX)", get_status_str(sc), sc);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_advertising_set(sl_cli_command_arg_t *arguments)
{
  sl_status_t sc = SL_STATUS_NOT_SUPPORTED;
  (void)sc; // warning elimination if logging disabled

  (void)arguments;
  if (cli_enabled) {
    sc = esl_core_start_advertising();
    CLI_RESPONSE("Result: %s (0x%04lX)", get_status_str(sc), sc);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_image_set(sl_cli_command_arg_t *arguments)
{
  sl_status_t sc = SL_STATUS_NOT_SUPPORTED;

  if (cli_enabled) {
#if defined(gattdb_esl_image_info)
    esl_state_t request = (esl_state_t)sl_cli_get_argument_uint8(arguments, 0);
    uint32_t source_image = request & 1;
    esl_image_object_id_t object_id = { 0 };

    object_id[0] = request;
    object_id[1] = ESL_IMAGE_OBJECT_BASE >> BITS_PER_PIXEL;

    sc = esl_image_select_object(object_id, sizeof(object_id));

    if (sc == SL_STATUS_OK) {
      sc = esl_image_chunk_received(images[source_image],
                                    0,
                                    sizeof(images[source_image]));
    }
#else
    (void)arguments;
    (void)images;
#endif // defined(gattdb_esl_image_info)
    CLI_RESPONSE("Result: %s (0x%04lX)", get_status_str(sc), sc);
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void cli_esl_tag_restart(sl_cli_command_arg_t *arguments)
{
  if (cli_enabled) {
    if (sl_cli_get_argument_uint8(arguments, 0) == 1) {
      sl_bt_system_reboot();
    } else if (sl_cli_get_argument_uint8(arguments, 0) == 2) {
      esl_core_unassociate();
      sl_bt_system_reboot();
    } else {
      CLI_RESPONSE("Unconfirmed request, ignored!");
    }
  } else {
    CLI_RESPONSE(CLI_ERROR);
  }
}

void sli_bt_esl_logger(uint8_t component, uint8_t level, const char *fmt, ...)
{
#if defined(APP_LOG_ENABLE) && APP_LOG_ENABLE
  if (component_log_enabled(component)) {
    va_list va;
    va_start(va, fmt);

    if (app_log_check_level(level)) {
      if (!(component & ESL_LOG_FLAG_APPEND)) {
        app_log_nl();
      }

      _app_log_print_color(level);

      if (!(component & (ESL_LOG_FLAG_NOHEADER | ESL_LOG_FLAG_APPEND))) {
        _app_log_print_prefix(level);
        _app_log_time();
        _app_log_counter();
        _app_log_print_trace();
      }

      sl_iostream_vprintf(app_log_iostream, fmt, va);
    }
    va_end(va);
  }
#else // defined(APP_LOG_ENABLE) && APP_LOG_ENABLE
  (void)component;
  (void)level;
  (void)fmt;
#endif // defined(APP_LOG_ENABLE) && APP_LOG_ENABLE
}

void sli_bt_esl_log_hex_dump(uint8_t component,
                             uint8_t level,
                             void    *p_data,
                             uint8_t len)
{
#if defined(APP_LOG_ENABLE) && APP_LOG_ENABLE
  if (component_log_enabled(component)) {
    if (app_log_check_level(level)) {
      uint8_t *tmp = (uint8_t *)p_data;

      if (!(component & ESL_LOG_FLAG_APPEND)) {
        app_log_nl();
      }

      _app_log_print_color(level);

      if (!(component & (ESL_LOG_FLAG_NOHEADER | ESL_LOG_FLAG_APPEND))) {
        _app_log_print_prefix(level);
        _app_log_time();
        _app_log_counter();
        _app_log_print_trace();
      }

      while (len--) {
        if (tmp != p_data) {
          app_log_append(APP_LOG_HEXDUMP_SEPARATOR);
        }

        app_log_append(APP_LOG_HEXDUMP_PREFIX);
        app_log_append(APP_LOG_HEXDUMP_FORMAT,
                       *tmp++);
      }
    }
  }
#else // defined(APP_LOG_ENABLE) && APP_LOG_ENABLE
  (void)component;
  (void)level;
  (void)p_data;
  (void)len;
#endif // defined(APP_LOG_ENABLE) && APP_LOG_ENABLE
}

void sli_bt_esl_assert_func(const char *func,
                            const char *file,
                            const char *expr,
                            int        line)
{
  sli_bt_esl_logger(ESL_LOG_COMPONENT_CLI,
                    ESL_LOG_LEVEL_CRITICAL,
                    "Assert failed: (%s) in file: %s, function: %s @ line: %d.",
                    expr, file, func, line);
  while (1) ; // Halt
}
