/***************************************************************************//**
 * @file
 * @brief
 *******************************************************************************
 * # License
 * <b>Copyright 2021 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/
#ifndef APP_BTMESH_UTIL_CONFIG_H
#define APP_BTMESH_UTIL_CONFIG_H

// <<< Use Configuration Wizard in Context Menu >>>

// <h> App BT Mesh Utility configuration

// <o APP_BTMESH_UTIL_LOG_LEVEL_APP_KEY_NOT_BOUND> Log Level of not bound appkey BT Mesh error
// <APP_LOG_LEVEL_DEBUG=> DEBUG
// <APP_LOG_LEVEL_INFO=> INFO
// <APP_LOG_LEVEL_WARNING=> WARNING
// <APP_LOG_LEVEL_ERROR=> ERROR
// <APP_LOG_LEVEL_CRITICAL=> CRITICAL
// <i> Default: DEBUG
#define APP_BTMESH_UTIL_LOG_LEVEL_APP_KEY_NOT_BOUND   APP_LOG_LEVEL_DEBUG

// <o APP_BTMESH_UTIL_LOG_LEVEL_PUBLISH_NOT_CONF> Log Level of not configured publish BT Mesh error
// <APP_LOG_LEVEL_DEBUG=> DEBUG
// <APP_LOG_LEVEL_INFO=> INFO
// <APP_LOG_LEVEL_WARNING=> WARNING
// <APP_LOG_LEVEL_ERROR=> ERROR
// <APP_LOG_LEVEL_CRITICAL=> CRITICAL
// <i> Default: DEBUG
#define APP_BTMESH_UTIL_LOG_LEVEL_PUBLISH_NOT_CONF    APP_LOG_LEVEL_DEBUG

// </h>

// <<< end of configuration section >>>

#endif // APP_BTMESH_UTIL_CONFIG_H
