/***************************************************************************//**
 * @file
 * @brief Node init and provision config
 *******************************************************************************
 * # License
 * <b>Copyright 2022 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/
#ifndef SL_BTMESH_PROVISIONEE_CONFIG_H
#define SL_BTMESH_PROVISIONEE_CONFIG_H

// <<< Use Configuration Wizard in Context Menu >>>

// <q SL_BTMESH_PROVISIONEE_LOGGING_CFG_VAL> Enable logging
// <d> 1
#define SL_BTMESH_PROVISIONEE_LOGGING_CFG_VAL 1

// <q SL_BTMESH_PROVISIONEE_AUTO_RESET> Enable automatic reset on node reset
// <d> 1
#define SL_BTMESH_PROVISIONEE_AUTO_RESET 1

// <o SL_BTMESH_PROVISIONEE_AUTO_RESET_DELAY> Delay of automatic reset in ms
// <d> 0
#define SL_BTMESH_PROVISIONEE_AUTO_RESET_DELAY 0

// <o SL_BTMESH_PROVISIONEE_AUTO_UNPROV_BEACONING_CFG_VAL> Automatic unprovisioned device beaconing
// <i> Start unprovisioned device beaconing automatically with the selected bearers after node initialization is complete.
// <0=> Disable
// <1=> PB-ADV
// <2=> PB-GATT
// <3=> PB-ADV and PB-GATT
// <d> 3
#define SL_BTMESH_PROVISIONEE_AUTO_UNPROV_BEACONING_CFG_VAL 3

// <q SL_BTMESH_PROVISIONEE_INIT_PROV_RECORDS_CFG_VAL> Initialize provisioning records
// <d> 0
#define SL_BTMESH_PROVISIONEE_INIT_PROV_RECORDS_CFG_VAL 0

// <e SL_BTMESH_PROVISIONEE_OOB_ENABLE_CFG_VAL> Enable OOB (out-of-band) settings
// <d> 1
#define SL_BTMESH_PROVISIONEE_OOB_ENABLE_CFG_VAL 0

// <q SL_BTMESH_PROVISIONEE_OOB_PUBLIC_KEY_ENABLE_CFG_VAL> OOB public key
// <i> Use the ECC key stored in the persistent storage during provisioning instead of an ephemeral key.
// <d> 1
  #define SL_BTMESH_PROVISIONEE_OOB_PUBLIC_KEY_ENABLE_CFG_VAL 0

// <e SL_BTMESH_PROVISIONEE_AUTH_NO_OOB_CFG_VAL> No OOB support
// <i>  Support authentication without OOB data
// <d> 1
  #define SL_BTMESH_PROVISIONEE_AUTH_NO_OOB_CFG_VAL 1
// </e>

// <e SL_BTMESH_PROVISIONEE_AUTH_STATIC_OOB_CFG_VAL> Static OOB support
// <i> Support authentication with static OOB data
// <d> 0
  #define SL_BTMESH_PROVISIONEE_AUTH_STATIC_OOB_CFG_VAL 0
// </e>

// <e SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_CFG_VAL> Output OOB support
// <i> Support authentication with output OOB data
// <d> 1
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_CFG_VAL 0
// <o SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_SIZE_CFG_VAL> Maximum size <1..8>
// <i> Maximum size of output OOB supported
// <d> 1
    #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_SIZE_CFG_VAL 1
// <q SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BLINK_CFG_VAL> Blink
// <d> 0
    #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BLINK_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BEEP_CFG_VAL> Beep
// <d> 0
    #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BEEP_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_VIBRATE_CFG_VAL> Vibrate
// <d> 0
    #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_VIBRATE_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_NUMERIC_CFG_VAL> Numeric
// <d> 0
    #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_NUMERIC_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_ALPHA_CFG_VAL> Alphanumeric
// <d> 0
    #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_ALPHA_CFG_VAL 0
// </e>

// <e SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_CFG_VAL> Input OOB support
// <i> Support authentication with input OOB data
// <d> 0
  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_CFG_VAL 0
// <o SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_SIZE_CFG_VAL> Maximum size <1..8>
// <i> Maximum size of input OOB supported
// <d> 1
    #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_SIZE_CFG_VAL 1
// <q SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_PUSH_CFG_VAL> Push
// <d> 0
    #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_PUSH_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_TWIST_CFG_VAL> Twist
// <d> 0
    #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_TWIST_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_NUMERIC_CFG_VAL> Numeric
// <d> 0
    #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_NUMERIC_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_ALPHA_CFG_VAL> Alphanumeric
// <d> 0
    #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_ALPHA_CFG_VAL 0
// </e>

// <h> OOB Information
// <q SL_BTMESH_PROVISIONEE_OOB_INFO_OTHER_CFG_VAL> Other
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_OTHER_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_OOB_INFO_URI_CFG_VAL> Electronic / URI
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_URI_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_OOB_INFO_2D_MR_CODE_CFG_VAL> 2D machine-readable code
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_2D_MR_CODE_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_OOB_INFO_BAR_CODE_CFG_VAL> Bar code
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_BAR_CODE_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_OOB_INFO_NFC_CFG_VAL> Near Field Communication (NFC)
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_NFC_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_OOB_INFO_NUMBER_CFG_VAL> Number
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_NUMBER_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_OOB_INFO_STRING_CFG_VAL> String
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_STRING_CFG_VAL 0

// CBP PROV_RECORDS RFU_9 RFU_10

// <q SL_BTMESH_PROVISIONEE_OOB_INFO_ON_BOX_CFG_VAL> On box
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_ON_BOX_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_OOB_INFO_IN_BOX_CFG_VAL> Inside box
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_IN_BOX_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_OOB_INFO_ON_PAPER_CFG_VAL> On piece of paper
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_ON_PAPER_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_OOB_INFO_IN_MANUAL_CFG_VAL> Inside manual
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_IN_MANUAL_CFG_VAL 0
// <q SL_BTMESH_PROVISIONEE_OOB_INFO_ON_DEVICE_CFG_VAL> On device
// <d> 0
    #define SL_BTMESH_PROVISIONEE_OOB_INFO_ON_DEVICE_CFG_VAL 0
// </h>

// </e>
// <<< end of configuration section >>>

#if SL_BTMESH_PROVISIONEE_OOB_ENABLE_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_PUBLIC_KEY_ENABLE SL_BTMESH_PROVISIONEE_OOB_PUBLIC_KEY_ENABLE_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_AUTH_NO_OOB SL_BTMESH_PROVISIONEE_AUTH_NO_OOB_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_AUTH_STATIC_OOB SL_BTMESH_PROVISIONEE_AUTH_STATIC_OOB_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_CFG_VAL

  #define SL_BTMESH_PROVISIONEE_OOB_INFO_OTHER SL_BTMESH_PROVISIONEE_OOB_INFO_OTHER_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_URI SL_BTMESH_PROVISIONEE_OOB_INFO_URI_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_2D_MR_CODE SL_BTMESH_PROVISIONEE_OOB_INFO_2D_MR_CODE_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_BAR_CODE SL_BTMESH_PROVISIONEE_OOB_INFO_BAR_CODE_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_NFC SL_BTMESH_PROVISIONEE_OOB_INFO_NFC_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_NUMBER SL_BTMESH_PROVISIONEE_OOB_INFO_NUMBER_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_STRING SL_BTMESH_PROVISIONEE_OOB_INFO_STRING_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_ON_BOX SL_BTMESH_PROVISIONEE_OOB_INFO_ON_BOX_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_IN_BOX SL_BTMESH_PROVISIONEE_OOB_INFO_IN_BOX_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_ON_PAPER SL_BTMESH_PROVISIONEE_OOB_INFO_ON_PAPER_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_IN_MANUAL SL_BTMESH_PROVISIONEE_OOB_INFO_IN_MANUAL_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_ON_DEVICE SL_BTMESH_PROVISIONEE_OOB_INFO_ON_DEVICE_CFG_VAL
#else
  #define SL_BTMESH_PROVISIONEE_OOB_PUBLIC_KEY_ENABLE 0
  #define SL_BTMESH_PROVISIONEE_AUTH_NO_OOB 1
  #define SL_BTMESH_PROVISIONEE_AUTH_STATIC_OOB 0
  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB 0
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB 0

  #define SL_BTMESH_PROVISIONEE_OOB_INFO_OTHER 0
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_URI 0
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_2D_MR_CODE 0
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_BAR_CODE 0
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_NFC 0
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_NUMBER 0
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_STRING 0
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_ON_BOX 0
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_IN_BOX 0
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_ON_PAPER 0
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_IN_MANUAL 0
  #define SL_BTMESH_PROVISIONEE_OOB_INFO_ON_DEVICE 0
#endif

#define SL_BTMESH_PROVISIONEE_AUTH_METHODS        \
  ((SL_BTMESH_PROVISIONEE_AUTH_NO_OOB       << 0) \
   | (SL_BTMESH_PROVISIONEE_AUTH_STATIC_OOB << 1) \
   | (SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB  << 2) \
   | (SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB << 3))

#define SL_BTMESH_PROVISIONEE_OOB_INFO                 \
  ((SL_BTMESH_PROVISIONEE_OOB_INFO_OTHER        << 0)  \
   | (SL_BTMESH_PROVISIONEE_OOB_INFO_URI        << 1)  \
   | (SL_BTMESH_PROVISIONEE_OOB_INFO_2D_MR_CODE << 2)  \
   | (SL_BTMESH_PROVISIONEE_OOB_INFO_BAR_CODE   << 3)  \
   | (SL_BTMESH_PROVISIONEE_OOB_INFO_NFC        << 4)  \
   | (SL_BTMESH_PROVISIONEE_OOB_INFO_NUMBER     << 5)  \
   | (SL_BTMESH_PROVISIONEE_OOB_INFO_STRING     << 6)  \
   | (SL_BTMESH_PROVISIONEE_OOB_INFO_ON_BOX     << 11) \
   | (SL_BTMESH_PROVISIONEE_OOB_INFO_IN_BOX     << 12) \
   | (SL_BTMESH_PROVISIONEE_OOB_INFO_ON_PAPER   << 13) \
   | (SL_BTMESH_PROVISIONEE_OOB_INFO_IN_MANUAL  << 14) \
   | (SL_BTMESH_PROVISIONEE_OOB_INFO_ON_DEVICE  << 15))

#if SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_SIZE SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_SIZE_CFG_VAL

  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BLINK SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BLINK_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BEEP SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BEEP_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_VIBRATE SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_VIBRATE_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_NUMERIC SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_NUMERIC_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_ALPHA SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_ALPHA_CFG_VAL
#else
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_SIZE 0

  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BLINK 0
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BEEP 0
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_VIBRATE 0
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_NUMERIC 0
  #define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_ALPHA 0
#endif

#define SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_ACTIONS     \
  ((SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BLINK     << 0) \
   | (SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_BEEP    << 1) \
   | (SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_VIBRATE << 2) \
   | (SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_NUMERIC << 3) \
   | (SL_BTMESH_PROVISIONEE_AUTH_OUTPUT_OOB_ALPHA   << 4))

#if SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB
  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_SIZE SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_SIZE_CFG_VAL

  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_PUSH SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_PUSH_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_TWIST SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_TWIST_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_NUMERIC SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_NUMERIC_CFG_VAL
  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_ALPHA SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_ALPHA_CFG_VAL
#else
  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_SIZE 0

  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_PUSH 0
  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_TWIST 0
  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_NUMERIC 0
  #define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_ALPHA 0
#endif

#define SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_ACTIONS     \
  ((SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_PUSH      << 0) \
   | (SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_TWIST   << 1) \
   | (SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_NUMERIC << 2) \
   | (SL_BTMESH_PROVISIONEE_AUTH_INPUT_OOB_ALPHA   << 3))

#endif // SL_BTMESH_PROVISIONEE_CONFIG_H
