# Copyright 2022 Silicon Laboratories Inc. www.silabs.com
#
# SPDX-License-Identifier: Zlib
#
# The licensor of this software is Silicon Laboratories Inc.
#
# This software is provided 'as-is', without any express or implied
# warranty. In no event will the authors be held liable for any damages
# arising from the use of this software.
#
# Permission is granted to anyone to use this software for any purpose,
# including commercial applications, and to alter it and redistribute it
# freely, subject to the following restrictions:
#
# 1. The origin of this software must not be misrepresented; you must not
#    claim that you wrote the original software. If you use this software
#    in a product, an acknowledgment in the product documentation would be
#    appreciated but is not required.
# 2. Altered source versions must be plainly marked as such, and must not be
#    misrepresented as being the original software.
# 3. This notice may not be removed or altered from any source distribution.

#                __        __               _             _                    #
#                \ \      / /_ _ _ __ _ __ (_)_ __   __ _| |                   #
#                 \ \ /\ / / _` | '__| '_ \| | '_ \ / _` | |                   #
#                  \ V  V / (_| | |  | | | | | | | | (_| |_|                   #
#                   \_/\_/ \__,_|_|  |_| |_|_|_| |_|\__, (_)                   #
#                                                   |___/                      #
#                                                                              #
#    This file is generated by btmesh_host_dfu/gen/slstatus_gen.py script.     #

import enum


@enum.unique
class SlStatus(enum.IntEnum):
    @classmethod
    def get_name(cls, value):
        try:
            return cls(value).name
        except ValueError:
            return "UNKNOWN_VALUE"

    @classmethod
    def from_int(cls, value):
        try:
            return cls(value)
        except ValueError:
            return cls.UNKNOWN_VALUE

    OK = 0x0000
    FAIL = 0x0001
    INVALID_STATE = 0x0002
    NOT_READY = 0x0003
    BUSY = 0x0004
    IN_PROGRESS = 0x0005
    ABORT = 0x0006
    TIMEOUT = 0x0007
    PERMISSION = 0x0008
    WOULD_BLOCK = 0x0009
    IDLE = 0x000A
    IS_WAITING = 0x000B
    NONE_WAITING = 0x000C
    SUSPENDED = 0x000D
    NOT_AVAILABLE = 0x000E
    NOT_SUPPORTED = 0x000F
    INITIALIZATION = 0x0010
    NOT_INITIALIZED = 0x0011
    ALREADY_INITIALIZED = 0x0012
    DELETED = 0x0013
    ISR = 0x0014
    NETWORK_UP = 0x0015
    NETWORK_DOWN = 0x0016
    NOT_JOINED = 0x0017
    NO_BEACONS = 0x0018
    ALLOCATION_FAILED = 0x0019
    NO_MORE_RESOURCE = 0x001A
    EMPTY = 0x001B
    FULL = 0x001C
    WOULD_OVERFLOW = 0x001D
    HAS_OVERFLOWED = 0x001E
    OWNERSHIP = 0x001F
    IS_OWNER = 0x0020
    INVALID_PARAMETER = 0x0021
    NULL_POINTER = 0x0022
    INVALID_CONFIGURATION = 0x0023
    INVALID_MODE = 0x0024
    INVALID_HANDLE = 0x0025
    INVALID_TYPE = 0x0026
    INVALID_INDEX = 0x0027
    INVALID_RANGE = 0x0028
    INVALID_KEY = 0x0029
    INVALID_CREDENTIALS = 0x002A
    INVALID_COUNT = 0x002B
    INVALID_SIGNATURE = 0x002C
    NOT_FOUND = 0x002D
    ALREADY_EXISTS = 0x002E
    IO = 0x002F
    IO_TIMEOUT = 0x0030
    TRANSMIT = 0x0031
    TRANSMIT_UNDERFLOW = 0x0032
    TRANSMIT_INCOMPLETE = 0x0033
    TRANSMIT_BUSY = 0x0034
    RECEIVE = 0x0035
    OBJECT_READ = 0x0036
    OBJECT_WRITE = 0x0037
    MESSAGE_TOO_LONG = 0x0038
    EEPROM_MFG_VERSION_MISMATCH = 0x0039
    EEPROM_STACK_VERSION_MISMATCH = 0x003A
    FLASH_WRITE_INHIBITED = 0x003B
    FLASH_VERIFY_FAILED = 0x003C
    FLASH_PROGRAM_FAILED = 0x003D
    FLASH_ERASE_FAILED = 0x003E
    MAC_NO_DATA = 0x003F
    MAC_NO_ACK_RECEIVED = 0x0040
    MAC_INDIRECT_TIMEOUT = 0x0041
    MAC_UNKNOWN_HEADER_TYPE = 0x0042
    MAC_ACK_HEADER_TYPE = 0x0043
    MAC_COMMAND_TRANSMIT_FAILURE = 0x0044
    CLI_STORAGE_NVM_OPEN_ERROR = 0x0045
    SECURITY_IMAGE_CHECKSUM_ERROR = 0x0046
    SECURITY_DECRYPT_ERROR = 0x0047
    COMMAND_IS_INVALID = 0x0048
    COMMAND_TOO_LONG = 0x0049
    COMMAND_INCOMPLETE = 0x004A
    BUS_ERROR = 0x004B
    CCA_FAILURE = 0x004C
    MAC_SCANNING = 0x004D
    MAC_INCORRECT_SCAN_TYPE = 0x004E
    INVALID_CHANNEL_MASK = 0x004F
    BAD_SCAN_DURATION = 0x0050
    BT_OUT_OF_BONDS = 0x0402
    BT_UNSPECIFIED = 0x0403
    BT_HARDWARE = 0x0404
    BT_NO_BONDING = 0x0406
    BT_CRYPTO = 0x0407
    BT_DATA_CORRUPTED = 0x0408
    BT_INVALID_SYNC_HANDLE = 0x040A
    BT_INVALID_MODULE_ACTION = 0x040B
    BT_RADIO = 0x040C
    BT_L2CAP_REMOTE_DISCONNECTED = 0x040D
    BT_L2CAP_LOCAL_DISCONNECTED = 0x040E
    BT_L2CAP_CID_NOT_EXIST = 0x040F
    BT_L2CAP_LE_DISCONNECTED = 0x0410
    BT_L2CAP_FLOW_CONTROL_VIOLATED = 0x0412
    BT_L2CAP_FLOW_CONTROL_CREDIT_OVERFLOWED = 0x0413
    BT_L2CAP_NO_FLOW_CONTROL_CREDIT = 0x0414
    BT_L2CAP_CONNECTION_REQUEST_TIMEOUT = 0x0415
    BT_L2CAP_INVALID_CID = 0x0416
    BT_L2CAP_WRONG_STATE = 0x0417
    BT_PS_STORE_FULL = 0x041B
    BT_PS_KEY_NOT_FOUND = 0x041C
    BT_APPLICATION_MISMATCHED_OR_INSUFFICIENT_SECURITY = 0x041D
    BT_APPLICATION_ENCRYPTION_DECRYPTION_ERROR = 0x041E
    BT_CTRL_UNKNOWN_CONNECTION_IDENTIFIER = 0x1002
    BT_CTRL_AUTHENTICATION_FAILURE = 0x1005
    BT_CTRL_PIN_OR_KEY_MISSING = 0x1006
    BT_CTRL_MEMORY_CAPACITY_EXCEEDED = 0x1007
    BT_CTRL_CONNECTION_TIMEOUT = 0x1008
    BT_CTRL_CONNECTION_LIMIT_EXCEEDED = 0x1009
    BT_CTRL_SYNCHRONOUS_CONNECTION_LIMIT_EXCEEDED = 0x100A
    BT_CTRL_ACL_CONNECTION_ALREADY_EXISTS = 0x100B
    BT_CTRL_COMMAND_DISALLOWED = 0x100C
    BT_CTRL_CONNECTION_REJECTED_DUE_TO_LIMITED_RESOURCES = 0x100D
    BT_CTRL_CONNECTION_REJECTED_DUE_TO_SECURITY_REASONS = 0x100E
    BT_CTRL_CONNECTION_REJECTED_DUE_TO_UNACCEPTABLE_BD_ADDR = 0x100F
    BT_CTRL_CONNECTION_ACCEPT_TIMEOUT_EXCEEDED = 0x1010
    BT_CTRL_UNSUPPORTED_FEATURE_OR_PARAMETER_VALUE = 0x1011
    BT_CTRL_INVALID_COMMAND_PARAMETERS = 0x1012
    BT_CTRL_REMOTE_USER_TERMINATED = 0x1013
    BT_CTRL_REMOTE_DEVICE_TERMINATED_CONNECTION_DUE_TO_LOW_RESOURCES = 0x1014
    BT_CTRL_REMOTE_POWERING_OFF = 0x1015
    BT_CTRL_CONNECTION_TERMINATED_BY_LOCAL_HOST = 0x1016
    BT_CTRL_REPEATED_ATTEMPTS = 0x1017
    BT_CTRL_PAIRING_NOT_ALLOWED = 0x1018
    BT_CTRL_UNSUPPORTED_REMOTE_FEATURE = 0x101A
    BT_CTRL_UNSPECIFIED_ERROR = 0x101F
    BT_CTRL_LL_RESPONSE_TIMEOUT = 0x1022
    BT_CTRL_LL_PROCEDURE_COLLISION = 0x1023
    BT_CTRL_ENCRYPTION_MODE_NOT_ACCEPTABLE = 0x1025
    BT_CTRL_LINK_KEY_CANNOT_BE_CHANGED = 0x1026
    BT_CTRL_INSTANT_PASSED = 0x1028
    BT_CTRL_PAIRING_WITH_UNIT_KEY_NOT_SUPPORTED = 0x1029
    BT_CTRL_DIFFERENT_TRANSACTION_COLLISION = 0x102A
    BT_CTRL_CHANNEL_ASSESSMENT_NOT_SUPPORTED = 0x102E
    BT_CTRL_INSUFFICIENT_SECURITY = 0x102F
    BT_CTRL_PARAMETER_OUT_OF_MANDATORY_RANGE = 0x1030
    BT_CTRL_SIMPLE_PAIRING_NOT_SUPPORTED_BY_HOST = 0x1037
    BT_CTRL_HOST_BUSY_PAIRING = 0x1038
    BT_CTRL_CONNECTION_REJECTED_DUE_TO_NO_SUITABLE_CHANNEL_FOUND = 0x1039
    BT_CTRL_CONTROLLER_BUSY = 0x103A
    BT_CTRL_UNACCEPTABLE_CONNECTION_INTERVAL = 0x103B
    BT_CTRL_ADVERTISING_TIMEOUT = 0x103C
    BT_CTRL_CONNECTION_TERMINATED_DUE_TO_MIC_FAILURE = 0x103D
    BT_CTRL_CONNECTION_FAILED_TO_BE_ESTABLISHED = 0x103E
    BT_CTRL_MAC_CONNECTION_FAILED = 0x103F
    BT_CTRL_COARSE_CLOCK_ADJUSTMENT_REJECTED_BUT_WILL_TRY_TO_ADJUST_USING_CLOCK_DRAGGING = 0x1040
    BT_CTRL_UNKNOWN_ADVERTISING_IDENTIFIER = 0x1042
    BT_CTRL_LIMIT_REACHED = 0x1043
    BT_CTRL_OPERATION_CANCELLED_BY_HOST = 0x1044
    BT_CTRL_PACKET_TOO_LONG = 0x1045
    BT_ATT_INVALID_HANDLE = 0x1101
    BT_ATT_READ_NOT_PERMITTED = 0x1102
    BT_ATT_WRITE_NOT_PERMITTED = 0x1103
    BT_ATT_INVALID_PDU = 0x1104
    BT_ATT_INSUFFICIENT_AUTHENTICATION = 0x1105
    BT_ATT_REQUEST_NOT_SUPPORTED = 0x1106
    BT_ATT_INVALID_OFFSET = 0x1107
    BT_ATT_INSUFFICIENT_AUTHORIZATION = 0x1108
    BT_ATT_PREPARE_QUEUE_FULL = 0x1109
    BT_ATT_ATT_NOT_FOUND = 0x110A
    BT_ATT_ATT_NOT_LONG = 0x110B
    BT_ATT_INSUFFICIENT_ENC_KEY_SIZE = 0x110C
    BT_ATT_INVALID_ATT_LENGTH = 0x110D
    BT_ATT_UNLIKELY_ERROR = 0x110E
    BT_ATT_INSUFFICIENT_ENCRYPTION = 0x110F
    BT_ATT_UNSUPPORTED_GROUP_TYPE = 0x1110
    BT_ATT_INSUFFICIENT_RESOURCES = 0x1111
    BT_ATT_OUT_OF_SYNC = 0x1112
    BT_ATT_VALUE_NOT_ALLOWED = 0x1113
    BT_ATT_APPLICATION = 0x1180
    BT_ATT_WRITE_REQUEST_REJECTED = 0x11FC
    BT_ATT_CLIENT_CHARACTERISTIC_CONFIGURATION_DESCRIPTOR_IMPROPERLY_CONFIGURED = 0x11FD
    BT_ATT_PROCEDURE_ALREADY_IN_PROGRESS = 0x11FE
    BT_ATT_OUT_OF_RANGE = 0x11FF
    BT_SMP_PASSKEY_ENTRY_FAILED = 0x1201
    BT_SMP_OOB_NOT_AVAILABLE = 0x1202
    BT_SMP_AUTHENTICATION_REQUIREMENTS = 0x1203
    BT_SMP_CONFIRM_VALUE_FAILED = 0x1204
    BT_SMP_PAIRING_NOT_SUPPORTED = 0x1205
    BT_SMP_ENCRYPTION_KEY_SIZE = 0x1206
    BT_SMP_COMMAND_NOT_SUPPORTED = 0x1207
    BT_SMP_UNSPECIFIED_REASON = 0x1208
    BT_SMP_REPEATED_ATTEMPTS = 0x1209
    BT_SMP_INVALID_PARAMETERS = 0x120A
    BT_SMP_DHKEY_CHECK_FAILED = 0x120B
    BT_SMP_NUMERIC_COMPARISON_FAILED = 0x120C
    BT_SMP_BREDR_PAIRING_IN_PROGRESS = 0x120D
    BT_SMP_CROSS_TRANSPORT_KEY_DERIVATION_GENERATION_NOT_ALLOWED = 0x120E
    BT_SMP_KEY_REJECTED = 0x120F
    BT_MESH_ALREADY_EXISTS = 0x0501
    BT_MESH_DOES_NOT_EXIST = 0x0502
    BT_MESH_LIMIT_REACHED = 0x0503
    BT_MESH_INVALID_ADDRESS = 0x0504
    BT_MESH_MALFORMED_DATA = 0x0505
    BT_MESH_ALREADY_INITIALIZED = 0x0506
    BT_MESH_NOT_INITIALIZED = 0x0507
    BT_MESH_NO_FRIEND_OFFER = 0x0508
    BT_MESH_PROV_LINK_CLOSED = 0x0509
    BT_MESH_PROV_INVALID_PDU = 0x050A
    BT_MESH_PROV_INVALID_PDU_FORMAT = 0x050B
    BT_MESH_PROV_UNEXPECTED_PDU = 0x050C
    BT_MESH_PROV_CONFIRMATION_FAILED = 0x050D
    BT_MESH_PROV_OUT_OF_RESOURCES = 0x050E
    BT_MESH_PROV_DECRYPTION_FAILED = 0x050F
    BT_MESH_PROV_UNEXPECTED_ERROR = 0x0510
    BT_MESH_PROV_CANNOT_ASSIGN_ADDR = 0x0511
    BT_MESH_ADDRESS_TEMPORARILY_UNAVAILABLE = 0x0512
    BT_MESH_ADDRESS_ALREADY_USED = 0x0513
    BT_MESH_PUBLISH_NOT_CONFIGURED = 0x0514
    BT_MESH_APP_KEY_NOT_BOUND = 0x0515
    BT_MESH_FOUNDATION_INVALID_ADDRESS = 0x1301
    BT_MESH_FOUNDATION_INVALID_MODEL = 0x1302
    BT_MESH_FOUNDATION_INVALID_APP_KEY = 0x1303
    BT_MESH_FOUNDATION_INVALID_NET_KEY = 0x1304
    BT_MESH_FOUNDATION_INSUFFICIENT_RESOURCES = 0x1305
    BT_MESH_FOUNDATION_KEY_INDEX_EXISTS = 0x1306
    BT_MESH_FOUNDATION_INVALID_PUBLISH_PARAMS = 0x1307
    BT_MESH_FOUNDATION_NOT_SUBSCRIBE_MODEL = 0x1308
    BT_MESH_FOUNDATION_STORAGE_FAILURE = 0x1309
    BT_MESH_FOUNDATION_NOT_SUPPORTED = 0x130A
    BT_MESH_FOUNDATION_CANNOT_UPDATE = 0x130B
    BT_MESH_FOUNDATION_CANNOT_REMOVE = 0x130C
    BT_MESH_FOUNDATION_CANNOT_BIND = 0x130D
    BT_MESH_FOUNDATION_TEMPORARILY_UNABLE = 0x130E
    BT_MESH_FOUNDATION_CANNOT_SET = 0x130F
    BT_MESH_FOUNDATION_UNSPECIFIED = 0x1310
    BT_MESH_FOUNDATION_INVALID_BINDING = 0x1311
    WIFI_INVALID_KEY = 0x0B01
    WIFI_FIRMWARE_DOWNLOAD_TIMEOUT = 0x0B02
    WIFI_UNSUPPORTED_MESSAGE_ID = 0x0B03
    WIFI_WARNING = 0x0B04
    WIFI_NO_PACKET_TO_RECEIVE = 0x0B05
    WIFI_SLEEP_GRANTED = 0x0B08
    WIFI_SLEEP_NOT_GRANTED = 0x0B09
    WIFI_SECURE_LINK_MAC_KEY_ERROR = 0x0B10
    WIFI_SECURE_LINK_MAC_KEY_ALREADY_BURNED = 0x0B11
    WIFI_SECURE_LINK_RAM_MODE_NOT_ALLOWED = 0x0B12
    WIFI_SECURE_LINK_FAILED_UNKNOWN_MODE = 0x0B13
    WIFI_SECURE_LINK_EXCHANGE_FAILED = 0x0B14
    WIFI_WRONG_STATE = 0x0B18
    WIFI_CHANNEL_NOT_ALLOWED = 0x0B19
    WIFI_NO_MATCHING_AP = 0x0B1A
    WIFI_CONNECTION_ABORTED = 0x0B1B
    WIFI_CONNECTION_TIMEOUT = 0x0B1C
    WIFI_CONNECTION_REJECTED_BY_AP = 0x0B1D
    WIFI_CONNECTION_AUTH_FAILURE = 0x0B1E
    WIFI_RETRY_EXCEEDED = 0x0B1F
    WIFI_TX_LIFETIME_EXCEEDED = 0x0B20
    UNKNOWN_VALUE = 0xCAFEBABE
