#  mbedTLS AES Example

 This example uses hardware accelerators of the supported devices to perform AES encryption and decryption.

##  Getting Started

1. Upgrade the kit’s firmware to the latest version (see `Adapter Firmware` under [General Device Information](https://docs.silabs.com/simplicity-studio-5-users-guide/latest/ss-5-users-guide-about-the-launcher/welcome-and-device-tabs#general-device-information) in the Simplicity Studio 5 User's Guide).
2. Upgrade the device’s SE firmware to the latest version when Series 2 device is used (see `Secure Firmware` under [General Device Information](https://docs.silabs.com/simplicity-studio-5-users-guide/latest/ss-5-users-guide-about-the-launcher/welcome-and-device-tabs#general-device-information) in the Simplicity Studio 5 User's Guide).
3. Open any terminal program and connect to the kit’s VCOM port (if using `Device Console` in Simplicity Studio 5, `Line terminator:` must be set to `None`).
4. Create this platform example project in the Simplicity IDE (see [Examples](https://docs.silabs.com/simplicity-studio-5-users-guide/latest/ss-5-users-guide-getting-started/start-a-project#examples) in the Simplicity Studio 5 User's Guide).
5. Build the example and download it to the kit (see [Simple Build](https://docs.silabs.com/simplicity-studio-5-users-guide/latest/ss-5-users-guide-building-and-flashing/building#simple-build) and [Flash Programmer](https://docs.silabs.com/simplicity-studio-5-users-guide/latest/ss-5-users-guide-building-and-flashing/flashing#flash-programmer) in the Simplicity Studio 5 User's Guide).
6. When starting the application, you will get the option to run the program in encryption mode or decryption mode.

 In encryption mode, the example will ask you for a short phrase to generate an initial vector
 used in the AES encryption process. You may type any phrase ended by newline or limited to a maximum
 of 16 bytes. After the short phrase, start typing the message to be encrypted, followed
 by a newline to mark the end of the message. The message length is limited to the #define
 MAX\_MESSAGE\_SIZE\_ENCRYPTION. The program will encrypt the message (plaintext), and print out the
 ciphertext, preceded with the initial vector of 16 bytes and followed by a message digest tag of 32 bytes.
 All data is converted to hexadecimal readable text format before sent to the serial port.

 The format is as follows:
 
 **Initial Vector(16 bytes) | Ciphertext | Message Digest Tag (32 bytes)**

 You can copy the output and feed it back to the program for decryption later. You must
 reset the kit in order to run decryption mode.

 In decryption mode, the example expects to receive a decrypted message in the same format as
 generated by the encryption, terminated by a CR (Carriage Return, ASCII code 13).

##  Additional Information

 The AES and SHA operations are accelerated by the CRYPTO peripheral on Series 1 devices.
 For Series 2 HSE devices, crypto operations are accelerated in hardware by the SE. 
 For Series 2 VSE devices, crypto operations are accelerated by the CRYPTOACC peripheral.
 
###  Turning off the Hardware Acceleration

To check the performance gain of the hardware acceleration, switch it off by
switching the value of **Enable hardware acceleration of crypto operations** in the component *Mbed TLS
common functionality*. This is found under the tab *SOFTWARE COMPONENTS* → *Platform
→ Security*. 

**Useful tip:** Filter on *Configurable Components* and *Installed Components* to
 find the configuration file more easily.

## Troubleshooting

### Serial Port Settings

Be sure to select the following settings to see the serial output of this example:

* 115200 Baud Rate 
* 8-N-1 configuration
* Line terminator should be set to "None" if using Device Console in Simplicity Studio

### Programming the Radio Board

Before programming the radio board mounted on the mainboard, make sure the power supply switch is in the AEM position (right side) as shown below.

![Radio board power supply switch](image/readme_img0.png)

## Report Bugs & Get Support

You are always encouraged and welcome to report any issues you found to us via [Silicon Labs Community](https://community.silabs.com/).