/***************************************************************************//**
 * @file
 * @brief Common Lib Mem Example
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc.  Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.  This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

/********************************************************************************************************
 ********************************************************************************************************
 *                                            INCLUDE FILES
 ********************************************************************************************************
 *******************************************************************************************************/

#include  <rtos_description.h>
#include  <cpu/include/cpu.h>
#include  <common/include/lib_mem.h>
#include  <common/include/rtos_utils.h>
#include  <common/include/rtos_err.h>

/********************************************************************************************************
 ********************************************************************************************************
 *                                            LOCAL DEFINES
 ********************************************************************************************************
 *******************************************************************************************************/

#define  EX_LIB_MEM_SEG_COMPILE_SIZE                    2048u

/********************************************************************************************************
 ********************************************************************************************************
 *                                       LOCAL GLOBAL VARIABLES
 ********************************************************************************************************
 *******************************************************************************************************/

static CPU_INT08U ExMemSegData[EX_LIB_MEM_SEG_COMPILE_SIZE];
static MEM_SEG    ExMemSeg = MEM_SEG_INIT("Example compile-time memory segment",
                                          (CPU_ADDR)&ExMemSegData[0u],
                                          EX_LIB_MEM_SEG_COMPILE_SIZE,
                                          LIB_MEM_PADDING_ALIGN_NONE);

/********************************************************************************************************
 ********************************************************************************************************
 *                                          GLOBAL FUNCTIONS
 ********************************************************************************************************
 *******************************************************************************************************/

/****************************************************************************************************//**
 *                                       Ex_CommonLibMemSegCompile()
 *
 * @brief  Provide example of Mem_SegReg() function.
 *******************************************************************************************************/
void Ex_CommonLibMemSegCompile(void)
{
  RTOS_ERR err;

  //                                                               Memory segment created at compile-time and ...
  Mem_SegReg(&ExMemSeg,                                         // registered a run-time.
             &err);
  APP_RTOS_ASSERT_CRITICAL(err.Code == RTOS_ERR_NONE,; );
}
