/***************************************************************************//**
 * @file
 * @brief File System Example
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc.  Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.  This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

/********************************************************************************************************
 ********************************************************************************************************
 *                                               MODULE
 ********************************************************************************************************
 *******************************************************************************************************/

#ifndef  _EX_FS_UTILS_H_
#define  _EX_FS_UTILS_H_

#include  <rtos_description.h>

#ifdef  RTOS_MODULE_FS_AVAIL

/********************************************************************************************************
 ********************************************************************************************************
 *                                            INCLUDE FILES
 ********************************************************************************************************
 *******************************************************************************************************/

#include  <fs/include/fs_media.h>
#include  <fs/include/fs_core_vol.h>

/********************************************************************************************************
 ********************************************************************************************************
 *                                               DEFINES
 ********************************************************************************************************
 *******************************************************************************************************/

#define  EX_FS_MAX_PATH_NAME_LEN            (50u)

/********************************************************************************************************
 ********************************************************************************************************
 *                                             DATA TYPES
 ********************************************************************************************************
 *******************************************************************************************************/

/********************************************************************************************************
 ********************************************************************************************************
 *                                          GLOBAL VARIABLES
 ********************************************************************************************************
 *******************************************************************************************************/

extern MEM_SEG Ex_FS_MemSeg;                                    // Control structure to access memory segment...
                                                                // ...available to all examples.

/********************************************************************************************************
 ********************************************************************************************************
 *                                         FUNCTION PROTOTYPES
 ********************************************************************************************************
 *******************************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

FS_VOL_HANDLE Ex_FS_VolOpen(FS_MEDIA_HANDLE media_handle,
                            CPU_CHAR        *p_vol_name,
                            RTOS_ERR        *p_err);

void Ex_FS_VolClose(FS_VOL_HANDLE vol_handle,
                    RTOS_ERR      *p_err);

void Ex_FS_BufFill(CPU_INT08U *p_buf,
                   CPU_SIZE_T buf_size,
                   CPU_INT08U pattern_start);

CPU_BOOLEAN Ex_FS_BufValidate(CPU_INT08U *p_buf,
                              CPU_SIZE_T buf_size,
                              CPU_INT08U pattern_start);

void Ex_FS_FileRdWr_Exec(FS_VOL_HANDLE vol_handle,
                         CPU_CHAR      *p_file_name,
                         CPU_INT32U    file_size,
                         RTOS_ERR      *p_err);

#ifdef __cplusplus
}
#endif

/********************************************************************************************************
 ********************************************************************************************************
 *                                        CONFIGURATION ERRORS
 ********************************************************************************************************
 *******************************************************************************************************/

/********************************************************************************************************
 ********************************************************************************************************
 *                                             MODULE END
 ********************************************************************************************************
 *******************************************************************************************************/

#endif // RTOS_MODULE_FS_AVAIL
#endif
