/***************************************************************************//**
 * @file
 * @brief
 *******************************************************************************
 * # License
 * <b>Copyright 2021 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/
#ifndef APP_PROJECT_INFO_CONFIG_H
#define APP_PROJECT_INFO_CONFIG_H

// <<< Use Configuration Wizard in Context Menu >>>

// <h>Required Version configuration

// <q APP_PROJECT_INFO_COMPILER_VERSION_ENABLED> Enable compiler version
// <i> Default value: 1
#define APP_PROJECT_INFO_COMPILER_VERSION_ENABLED       1U

// <q APP_PROJECT_INFO_CMSIS_VERSION_ENABLED> Enable CMSIS version
// <i> Default value: 0
#define APP_PROJECT_INFO_CMSIS_VERSION_ENABLED          0U

// <q APP_PROJECT_INFO_STDC_VERSION_ENABLED> Enable Standard C version
// <i> Default value: 0
#define APP_PROJECT_INFO_STDC_VERSION_ENABLED           0U

// <q APP_PROJECT_INFO_RAIL_VERSION_ENABLED> Enable RAIL library version
// <i> Default value: 0
#define APP_PROJECT_INFO_RAIL_VERSION_ENABLED           0U

// <q APP_PROJECT_INFO_RTOS_VERSION_ENABLED> Enable RTOS version
// <i> Default value: 1
#define APP_PROJECT_INFO_RTOS_VERSION_ENABLED           1U

// <q APP_PROJECT_INFO_WISUN_VERSION_ENABLED> Enable Wi-SUN library version
// <i> Default value: 0
#define APP_PROJECT_INFO_WISUN_VERSION_ENABLED          0U

// <q APP_PROJECT_INFO_MBEDTLS_VERSION_ENABLED> Enable MbedTLS version
// <i> Default value: 0
#define APP_PROJECT_INFO_MBEDTLS_VERSION_ENABLED        0U

// <q APP_PROJECT_INFO_APP_VERSION_ENABLED> Enable application version
// <i> Default value: 0
#define APP_PROJECT_INFO_APP_VERSION_ENABLED            1U

// </h>

// <h> Application version
#if APP_PROJECT_INFO_APP_VERSION_ENABLED

// <o APP_PROJECT_INFO_APP_VERSION_MAJOR> App version major number
// <i> Default: 0
#define APP_PROJECT_INFO_APP_VERSION_MAJOR              0U

// <o APP_PROJECT_INFO_APP_VERSION_MINOR> App version minor number
// <i> Default: 0
#define APP_PROJECT_INFO_APP_VERSION_MINOR              0U

// <o APP_PROJECT_INFO_APP_VERSION_PATCH> App version patch number
// <i> Default: 0
#define APP_PROJECT_INFO_APP_VERSION_PATCH              0U
#endif
// </h>

// <<< end of configuration section >>>

#endif // APP_PROJECT_INFO_CONFIG_H
