/***************************************************************************//**
 * @file
 * @brief Wi-SUN Network Measurement component configuration header.
 *
 *******************************************************************************
 * # License
 * <b>Copyright 2019 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

#ifndef SL_WISUN_NETWORK_MEASUREMENT_CONFIG_H
#define SL_WISUN_NETWORK_MEASUREMENT_CONFIG_H

// <<< Use Configuration Wizard in Context Menu >>>

// <h> Network Measurement configuration

// <o SL_WISUN_NETWORK_MEASUREMENT_DEFAULT_PACKET_COUNT> Default measurement packet count
// <i> Default: 10
#define SL_WISUN_NETWORK_MEASUREMENT_DEFAULT_PACKET_COUNT            10U

// <o SL_WISUN_NETWORK_MEASUREMENT_DEFAULT_PACKET_LENGTH> Default measurement packet size
// <i> Default: 10
#define SL_WISUN_NETWORK_MEASUREMENT_DEFAULT_PACKET_LENGTH           40U

// </h>

// <<< end of configuration section >>>

#endif // SL_WISUN_NETWORK_MEASUREMENT_CONFIG_H
