/***************************************************************************//**
 * @file
 * @brief EFP Driver Config
 *******************************************************************************
 * # License
 * <b>Copyright 2021 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/
#ifndef SL_EFP_INST_CONFIG_H
#define SL_EFP_INST_CONFIG_H

#include "sl_efp.h"

#ifdef __cplusplus
extern "C" {
#endif

// <<< Use Configuration Wizard in Context Menu >>>

// <h>EFP driver configuration

// <o SL_EFP_INSTANCE_EM_CTRL_MODE> Selects method of controlling EFP Energy Mode (EM) transitions.
// <efp_em_transition_mode_gpio_bitbang=> GPIO driven direct mode EM transitions
// <efp_em_transition_mode_i2c=> I2C transfers control EM transitions
// <efp_em_transition_mode_emu=> Builtin EMU controlled direct mode EM transitions
// <i> Default: efp_em_transition_mode_i2c
#define SL_EFP_INSTANCE_EM_CTRL_MODE            efp_em_transition_mode_i2c

// <q SL_EFP_INSTANCE_IRQ_MODE> Set interrupt input mode line from EFP.
// <efp_irq_pin_disabled=> IRQ pin disabled
// <efp_irq_pin_gpio=> Enable IRQ from GPIO
// <efp_irq_pin_emu=> Enable IRQ from built-in support in EMU
// <i> Default: efp_irq_pin_gpio
#define SL_EFP_INSTANCE_IRQ_MODE                efp_irq_pin_gpio

// <q SL_EFP_INSTANCE_POWERS_HOST> This EFP powers host SoC.
// <i> Default: 1
#define SL_EFP_INSTANCE_POWERS_HOST             1

// <q SL_EFP_INSTANCE_RESET_TO_DEFAULT> Reset EFP to Default values during initialization.
// <i> Default: 0
#define SL_EFP_INSTANCE_RESET_TO_DEFAULT        0

// <q SL_EFP_INSTANCE_ADD_EFP_CALC> EFP Config parameters header is included in the project.
// <i> Set this if the header sl_efpdrv_calc.h generated by EFP Configurator is included in the project.
// <i> Default: 0
#define SL_EFP_INSTANCE_ADD_EFP_CALC            0

// </h> end EFP configuration

// <<< end of configuration section >>>

// <<< sl:start pin_tool >>>

// <gpio> SL_EFP_INSTANCE_IRQ
// $[GPIO_SL_EFP_INSTANCE_IRQ]
// #define SL_EFP_INSTANCE_IRQ_PORT           gpioPortA
// #define SL_EFP_INSTANCE_IRQ_PIN            0
// [GPIO_SL_EFP_INSTANCE_IRQ]$

// <i2c signal=SDA,SCL> SL_EFP_INSTANCE_I2C
// $[I2C_SL_EFP_INSTANCE_I2C]
#warning "EFP I2C peripheral not configured"
// #define SL_EFP_INSTANCE_I2C_PERIPHERAL     I2C0
// #define SL_EFP_INSTANCE_I2C_PERIPHERAL_NO  0

// #define SL_EFP_INSTANCE_I2C_SDA_PORT       gpioPortC
// #define SL_EFP_INSTANCE_I2C_SDA_PIN        1

// #define SL_EFP_INSTANCE_I2C_SCL_PORT       gpioPortC
// #define SL_EFP_INSTANCE_I2C_SCL_PIN        0
// [I2C_SL_EFP_INSTANCE_I2C]$
// <<< sl:end pin_tool >>>

#ifdef __cplusplus
}
#endif

#endif /* SL_EFP_INST_CONFIG_H */
