/***************************************************************************//**
 * @file
 * @brief Module Configuration Header
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/
 
#ifndef SL_MODULE_H
#define SL_MODULE_H

#if defined(BGM111A256V2)
#include "sl_module_bgm111a256v2.h"

#elif defined(BGM111E256V2)
#include "sl_module_bgm111e256v2.h"

#elif defined(BGM113A256V2)
#include "sl_module_bgm113a256v2.h"

#elif defined(BGM11S12F256GA)
#include "sl_module_bgm11s12f256ga.h"

#elif defined(BGM11S22F256GA)
#include "sl_module_bgm11s22f256ga.h"

#elif defined(MGM111A256V2)
#include "sl_module_mgm111a256v2.h"

#elif defined(MGM111E256V2)
#include "sl_module_mgm111e256v2.h"

#elif defined(BGM121A256V2)
#include "sl_module_bgm121a256v2.h"

#elif defined(BGM121N256V2)
#include "sl_module_bgm121n256v2.h"

#elif defined(BGM123A256V2)
#include "sl_module_bgm123a256v2.h"

#elif defined(BGM123N256V2)
#include "sl_module_bgm123n256v2.h"

#elif defined(MGM12P02F1024GA)
#include "sl_module_mgm12p02f1024ga.h"

#elif defined(MGM12P02F1024GE)
#include "sl_module_mgm12p02f1024ge.h"

#elif defined(MGM12P22F1024GA)
#include "sl_module_mgm12p22f1024ga.h"

#elif defined(MGM12P22F1024GE)
#include "sl_module_mgm12p22f1024ge.h"

#elif defined(MGM12P32F1024GA)
#include "sl_module_mgm12p32f1024ga.h"

#elif defined(MGM12P32F1024GE)
#include "sl_module_mgm12p32f1024ge.h"

#elif defined(BGM13P22F512GA)
#include "sl_module_bgm13p22f512ga.h"

#elif defined(BGM13P22F512GE)
#include "sl_module_bgm13p22f512ge.h"

#elif defined(BGM13P32F512GA)
#include "sl_module_bgm13p32f512ga.h"

#elif defined(BGM13P32F512GE)
#include "sl_module_bgm13p32f512ge.h"

#elif defined(MGM13P02F512GA)
#include "sl_module_mgm13p02f512ga.h"

#elif defined(MGM13P02F512GE)
#include "sl_module_mgm13p02f512ge.h"

#elif defined(MGM13P12F512GA)
#include "sl_module_mgm13p12f512ga.h"

#elif defined(MGM13P12F512GE)
#include "sl_module_mgm13p12f512ge.h"

#elif defined(BGM13S22F512GA)
#include "sl_module_bgm13s22f512ga.h"

#elif defined(BGM13S22F512GN)
#include "sl_module_bgm13s22f512gn.h"

#elif defined(BGM13S32F512GA)
#include "sl_module_bgm13s32f512ga.h"

#elif defined(BGM13S32F512GN)
#include "sl_module_bgm13s32f512gn.h"

#elif defined(MGM13S02F512GA)
#include "sl_module_mgm13s02f512ga.h"

#elif defined(MGM13S02F512GN)
#include "sl_module_mgm13s02f512gn.h"

#elif defined(MGM13S12F512GA)
#include "sl_module_mgm13s12f512ga.h"

#elif defined(MGM13S12F512GN)
#include "sl_module_mgm13s12f512gn.h"

#elif defined(ZGM130S037HGN1)
#include "sl_module_zgm130s037hgn1.h"

#elif defined(ZGM130S037HGN)
#include "sl_module_zgm130s037hgn.h"

#elif defined(MGM210P022JNA)
#include "sl_module_mgm210p022jna.h"

#elif defined(MGM210P032JNA)
#include "sl_module_mgm210p032jna.h"

#elif defined(MGM210PA22JNA)
#include "sl_module_mgm210pa22jna.h"

#elif defined(MGM210PA32JNA)
#include "sl_module_mgm210pa32jna.h"

#elif defined(BGM210P022JNA)
#include "sl_module_bgm210p022jna.h"

#elif defined(BGM210P032JNA)
#include "sl_module_bgm210p032jna.h"

#elif defined(BGM210PA22JNA)
#include "sl_module_bgm210pa22jna.h"

#elif defined(BGM210PA32JNA)
#include "sl_module_bgm210pa32jna.h"

#elif defined(MGM210P022JIA)
#include "sl_module_mgm210p022jia.h"

#elif defined(MGM210P032JIA)
#include "sl_module_mgm210p032jia.h"

#elif defined(MGM210PA22JIA)
#include "sl_module_mgm210pa22jia.h"

#elif defined(MGM210PA32JIA)
#include "sl_module_mgm210pa32jia.h"

#elif defined(MGM210PB22JIA)
#include "sl_module_mgm210pb22jia.h"

#elif defined(MGM210PB32JIA)
#include "sl_module_mgm210pb32jia.h"

#elif defined(BGM210P022JIA)
#include "sl_module_bgm210p022jia.h"

#elif defined(BGM210P032JIA)
#include "sl_module_bgm210p032jia.h"

#elif defined(BGM210PA22JIA)
#include "sl_module_bgm210pa22jia.h"

#elif defined(BGM210PA32JIA)
#include "sl_module_bgm210pa32jia.h"

#elif defined(BGM210PB22JIA)
#include "sl_module_bgm210pb22jia.h"

#elif defined(BGM210PB32JIA)
#include "sl_module_bgm210pb32jia.h"

#elif defined(MGM210L022JIF)
#include "sl_module_mgm210l022jif.h"

#elif defined(MGM210L022JNF)
#include "sl_module_mgm210l022jnf.h"

#elif defined(MGM210LA22JIF)
#include "sl_module_mgm210la22jif.h"

#elif defined(MGM210LA22JNF)
#include "sl_module_mgm210la22jnf.h"

#elif defined(BGM210L022JIF)
#include "sl_module_bgm210l022jif.h"

#elif defined(BGM210L022JNF)
#include "sl_module_bgm210l022jnf.h"

#elif defined(BGM210LA22JIF)
#include "sl_module_bgm210la22jif.h"

#elif defined(BGM210LA22JNF)
#include "sl_module_bgm210la22jnf.h"

#elif defined(BGM220PC22HNA)
#include "sl_module_bgm220pc22hna.h"

#elif defined(BGM220PC22WGA)
#include "sl_module_bgm220pc22wga.h"

#elif defined(BGM220SC12WGA)
#include "sl_module_bgm220sc12wga.h"

#elif defined(BGM220SC22HNA)
#include "sl_module_bgm220sc22hna.h"

#elif defined(BGM220SC22WGA)
#include "sl_module_bgm220sc22wga.h"

#elif defined(MGM220PC22HNA)
#include "sl_module_mgm220pc22hna.h"

#elif defined(MGM220SC22HNA)
#include "sl_module_mgm220sc22hna.h"

#else
#error "Module part number not defined, or unknown."
#endif

#endif // SL_MODULE_H
