/***************************************************************************//**
 * @file
 * @brief Common - RTOS Types
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc.  Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.  This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

/****************************************************************************************************//**
 * @defgroup COMMON_TYPES Types API
 * @ingroup  COMMON
 * @brief      Types API
 *
 * @addtogroup COMMON_TYPES
 * @{
 *******************************************************************************************************/

/********************************************************************************************************
 ********************************************************************************************************
 *                                               MODULE
 ********************************************************************************************************
 *******************************************************************************************************/

#ifndef  _RTOS_TYPES_H_
#define  _RTOS_TYPES_H_

/********************************************************************************************************
 ********************************************************************************************************
 *                                               INCLUDE FILES
 ********************************************************************************************************
 *******************************************************************************************************/

#include  <common/include/kal.h>
#include  <cpu/include/cpu.h>

/********************************************************************************************************
 ********************************************************************************************************
 *                                               DATA TYPES
 ********************************************************************************************************
 *******************************************************************************************************/

/****************************************************************************************************//**
 *                                           RTOS TASK DATA TYPE
 * @{
 *******************************************************************************************************/

typedef KAL_TASK_PRIO RTOS_TASK_PRIO;

typedef struct rtos_task_cfg {
  RTOS_TASK_PRIO Prio;                                          ///< Task priority.
  CPU_STK_SIZE   StkSizeElements;                               ///< Size of the stack, in CPU_STK elements.
  CPU_STK        *StkPtr;                                       ///< Pointer to base of the stack .
} RTOS_TASK_CFG;

///< @}

/****************************************************************************************************//**
 ********************************************************************************************************
 * @}                                          MODULE END
 ********************************************************************************************************
 *******************************************************************************************************/

#endif // End of rtos types module include.
