/***************************************************************************//**
 * @file
 * @brief Common - Map Interface
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc.  Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.  This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

/********************************************************************************************************
 ********************************************************************************************************
 *                                               MODULE
 ********************************************************************************************************
 *******************************************************************************************************/

#ifndef  _MAP_PRIV_H_
#define  _MAP_PRIV_H_

/********************************************************************************************************
 ********************************************************************************************************
 *                                               INCLUDE FILES
 ********************************************************************************************************
 *******************************************************************************************************/

#include  <cpu/include/cpu.h>

#include  <common/source/collections/slist_priv.h>

#include  <common/include/rtos_err.h>
#include  <common/include/lib_mem.h>

/********************************************************************************************************
 ********************************************************************************************************
 *                                               DATA TYPES
 ********************************************************************************************************
 *******************************************************************************************************/

typedef SLIST_MEMBER *MAP_INSTANCE;

typedef struct map_item {
  SLIST_MEMBER ListNode;
  CPU_CHAR     *Key;
  void         *Value;
} MAP_ITEM;

/********************************************************************************************************
 ********************************************************************************************************
 *                                           FUNCTION PROTOTYPES
 ********************************************************************************************************
 *******************************************************************************************************/

void MapInit(MAP_INSTANCE *p_map_instance);

void MapItemAdd(MAP_INSTANCE *p_map_instance,
                MAP_ITEM     *p_map_item,
                RTOS_ERR     *p_err);

void MapItemRemove(MAP_INSTANCE *p_map_instance,
                   MAP_ITEM     *p_map_item,
                   RTOS_ERR     *p_err);

void MapKeyRemove(MAP_INSTANCE *p_map_instance,
                  CPU_CHAR     *key,
                  RTOS_ERR     *p_err);

MAP_ITEM *MapKeyItemGet(MAP_INSTANCE *p_map_instance,
                        CPU_CHAR     *key,
                        RTOS_ERR     *p_err);

void *MapKeyValueGet(MAP_INSTANCE *p_map_instance,
                     CPU_CHAR     *key,
                     RTOS_ERR     *p_err);

/********************************************************************************************************
 ********************************************************************************************************
 *                                               MODULE END
 ********************************************************************************************************
 *******************************************************************************************************/

#endif // End of map module include.
