/***************************************************************************//**
 * @file
 * @brief Common - Ascii String Management
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc.  Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.  This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

/********************************************************************************************************
 ********************************************************************************************************
 *                                               MODULE
 ********************************************************************************************************
 *******************************************************************************************************/

#ifndef  _LIB_STR_PRIV_H_
#define  _LIB_STR_PRIV_H_

/********************************************************************************************************
 ********************************************************************************************************
 *                                               INCLUDE FILES
 ********************************************************************************************************
 *******************************************************************************************************/

#include  <cpu/include/cpu.h>

/********************************************************************************************************
 ********************************************************************************************************
 *                                               DATA TYPES
 ********************************************************************************************************
 *******************************************************************************************************/

typedef int (*STR_PRINTF_OUT_CB)(int, void *);

/********************************************************************************************************
 ********************************************************************************************************
 *                                           FUNCTION PROTOTYPES
 ********************************************************************************************************
 *******************************************************************************************************/

CPU_INT16U Str_Printf(STR_PRINTF_OUT_CB out_cb,
                      void              *p_out_cb_arg,
                      const CPU_CHAR    *format,
                      ...);

CPU_INT16U Str_Sprintf(CPU_CHAR       *p_str,
                       const CPU_CHAR *format,
                       ...);

CPU_INT16U Str_Snprintf(CPU_CHAR       *p_str,
                        CPU_INT16U     size,
                        const CPU_CHAR *format,
                        ...);

/********************************************************************************************************
 ********************************************************************************************************
 *                                               MODULE
 ********************************************************************************************************
 *******************************************************************************************************/

#endif // End of lib str module include.
