/***************************************************************************//**
 * @file
 * @brief Common - Platform Manager
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc.  Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.  This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

/********************************************************************************************************
 ********************************************************************************************************
 *                                               MODULE
 ********************************************************************************************************
 *******************************************************************************************************/

#ifndef  _PLATFORM_MGR_PRIV_H_
#define  _PLATFORM_MGR_PRIV_H_

/********************************************************************************************************
 ********************************************************************************************************
 *                                               INCLUDE FILES
 ********************************************************************************************************
 *******************************************************************************************************/

#include  <common/include/rtos_err.h>
#include  <common/include/lib_mem.h>
#include  <common/include/platform_mgr.h>

/********************************************************************************************************
 ********************************************************************************************************
 *                                               DATA TYPES
 ********************************************************************************************************
 *******************************************************************************************************/

typedef CPU_BOOLEAN (*PLATFORM_MGR_PREDICATE)(const PLATFORM_MGR_ITEM *p_item,
                                              void                    *p_arg);

/********************************************************************************************************
 ********************************************************************************************************
 *                                           FUNCTION PROTOTYPES
 ********************************************************************************************************
 *******************************************************************************************************/

void PlatformMgrInit(RTOS_ERR *p_err);

PLATFORM_MGR_ITEM *PlatformMgrItemAlloc(CPU_INT32U item_size,
                                        RTOS_ERR   *p_err);

void PlatformMgrItemAdd(const PLATFORM_MGR_ITEM *p_item,
                        RTOS_ERR                *p_err);

PLATFORM_MGR_ITEM *PlatformMgrItemGet(PLATFORM_MGR_PREDICATE predicate_fnct,
                                      void                   *p_predicate_data,
                                      RTOS_ERR               *p_err);

void PlatformMgrItemRem(const PLATFORM_MGR_ITEM *p_item,
                        RTOS_ERR                *p_err);

/********************************************************************************************************
 ********************************************************************************************************
 *                                               MODULE END
 ********************************************************************************************************
 *******************************************************************************************************/

#endif // End of platform mgr module include.
