/***************************************************************************//**
 * @file
 * @brief CPU Cache Module
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc.  Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement.  This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/
/****************************************************************************************************//**
 * @defgroup CPU_CACHE CPU Cache Management API
 * @ingroup CPU
 * @brief      CPU Cache Management API
 *
 * @addtogroup CPU_CACHE
 * @{
 *******************************************************************************************************/

/********************************************************************************************************
 ********************************************************************************************************
 *                                                   MODULE
 ********************************************************************************************************
 *******************************************************************************************************/

#ifndef  _CPU_CACHE_H_
#define  _CPU_CACHE_H_

/********************************************************************************************************
 ********************************************************************************************************
 *                                                   EXTERNS
 ********************************************************************************************************
 *******************************************************************************************************/

#ifdef   CPU_CACHE_MODULE
#define  CPU_CACHE_EXT
#else
#define  CPU_CACHE_EXT  extern
#endif

/********************************************************************************************************
 ********************************************************************************************************
 *                                               INCLUDE FILES
 ********************************************************************************************************
 *******************************************************************************************************/

#include  "cpu.h"

#include  <common/include/rtos_path.h>
#include  <cpu_cfg.h>

/********************************************************************************************************
 ********************************************************************************************************
 *                                                   DEFINES
 ********************************************************************************************************
 *******************************************************************************************************/

/********************************************************************************************************
 *                                           CACHE CONFIGURATION
 *******************************************************************************************************/

#ifndef CPU_CFG_CACHE_MGMT_EN
#define CPU_CFG_CACHE_MGMT_EN  DEF_DISABLED
#endif

/********************************************************************************************************
 *                                       CACHE OPERATIONS DEFINES
 *******************************************************************************************************/

#if (CPU_CFG_CACHE_MGMT_EN == DEF_ENABLED)
#ifndef  CPU_DCACHE_RANGE_FLUSH
#define  CPU_DCACHE_RANGE_FLUSH(addr_start, len)  CPU_DCache_RangeFlush(addr_start, len)
#endif // CPU_DCACHE_RANGE_FLUSH
#else
#define  CPU_DCACHE_RANGE_FLUSH(addr_start, len)
#endif // CPU_CFG_CACHE_MGMT_EN

#if (CPU_CFG_CACHE_MGMT_EN == DEF_ENABLED)
#ifndef  CPU_DCACHE_RANGE_INV
#define  CPU_DCACHE_RANGE_INV(addr_start, len)  CPU_DCache_RangeInv(addr_start, len)
#endif // CPU_DCACHE_RANGE_INV
#else
#define  CPU_DCACHE_RANGE_INV(addr_start, len)
#endif // CPU_CFG_CACHE_MGMT_EN

/********************************************************************************************************
 ********************************************************************************************************
 *                                           FUNCTION PROTOTYPES
 ********************************************************************************************************
 *******************************************************************************************************/

#if (CPU_CFG_CACHE_MGMT_EN == DEF_ENABLED)

#ifdef __cplusplus
extern  "C" {
#endif

void CPU_Cache_Init(void);

void CPU_DCache_RangeFlush(void     *addr_start,
                           CPU_ADDR len);

void CPU_DCache_RangeInv(void     *addr_start,
                         CPU_ADDR len);

#ifdef __cplusplus
}
#endif

#endif

/****************************************************************************************************//**
 ********************************************************************************************************
 * @}                                           MODULE END
 ********************************************************************************************************
 *******************************************************************************************************/

#endif // End of CPU cache module include.
