#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Feb 23 14:49:58 2023 by generateDS.py version 2.12d.
#
# Command line options:
#   ('-o', '../Bindings.py')
#   ('--super', 'Bindings')
#   ('-s', '../Template.py')
#   ('--subclass-suffix', '')
#   ('--member-specs', 'list')
#   ('--external-encoding', 'ascii')
#   ('-m', '')
#   ('-f', '')
#   ('--silence', '')
#
# Command line arguments:
#   ./multi_phy_configuration_model.xsd
#
# Command line:
#   C:\validation\host_py_radio_config\Package\pylib_multi_phy_model\multi_phy_configuration_model\xsd\generateDS_custom.py -o "../Bindings.py" --super="Bindings" -s "../Template.py" --subclass-suffix --member-specs="list" --external-encoding="ascii" -m -f --silence ./multi_phy_configuration_model.xsd
#
# Current working directory (os.getcwd()):
#   xsd
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

from py_2_and_3_compatibility import *

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if inStr is None:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class multi_phy_configuration(GeneratedsSuper):
    """Root of the mutli-phy dataVersion of this XSD fileThe party family.
    (e.g "dumbo")The part revision. (e.g. "A0")RAIL adapter version
    to use (e.g. rail_api_1.x).A plain text description of this
    model instance.Return status codeReturn status messageReadable
    name or label of this configurationpart number(e.g. IC,
    Simulation, FPGA, etc...) Defaults to 'IC", if not provided."""
    member_data_items_ = [
        MemberSpec_('xsd_version', 'xs:string', 0),
        MemberSpec_('part_family', 'xs:string', 0),
        MemberSpec_('part_revision', 'xs:string', 0),
        MemberSpec_('rail_adapter_version', 'xs:string', 0),
        MemberSpec_('desc', 'xs:string', 0),
        MemberSpec_('status_code', 'xs:string', 0),
        MemberSpec_('status_message', 'xs:string', 0),
        MemberSpec_('readable_name', 'xs:string', 0),
        MemberSpec_('part_opn', 'xs:string', 0),
        MemberSpec_('target', 'xs:string', 0),
        MemberSpec_('base_channel_configurations', 'base_channel_configurationsType', 0),
        MemberSpec_('output_files', 'output_filesType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, xsd_version=None, part_family=None, part_revision=None, rail_adapter_version=None, desc=None, status_code=None, status_message=None, readable_name=None, part_opn=None, target='IC', base_channel_configurations=None, output_files=None):
        self.original_tagname_ = None
        self.xsd_version = _cast(None, xsd_version)
        self.part_family = _cast(None, part_family)
        self.part_revision = _cast(None, part_revision)
        self.rail_adapter_version = _cast(None, rail_adapter_version)
        self.desc = _cast(None, desc)
        self.status_code = _cast(None, status_code)
        self.status_message = _cast(None, status_message)
        self.readable_name = _cast(None, readable_name)
        self.part_opn = _cast(None, part_opn)
        self.target = _cast(None, target)
        if base_channel_configurations is None:
            self.base_channel_configurations = base_channel_configurationsType()
        else:
            self.base_channel_configurations = base_channel_configurations
        if output_files is None:
            self.output_files = output_filesType()
        else:
            self.output_files = output_files
    def factory(*args_, **kwargs_):
        if multi_phy_configuration.subclass:
            return multi_phy_configuration.subclass(*args_, **kwargs_)
        else:
            return multi_phy_configuration(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_base_channel_configurations(self): return self.base_channel_configurations
    def set_base_channel_configurations(self, base_channel_configurations): self.base_channel_configurations = base_channel_configurations
    base_channel_configurationsProp = property(get_base_channel_configurations, set_base_channel_configurations)
    def get_output_files(self): return self.output_files
    def set_output_files(self, output_files): self.output_files = output_files
    output_filesProp = property(get_output_files, set_output_files)
    def get_xsd_version(self): return self.xsd_version
    def set_xsd_version(self, xsd_version): self.xsd_version = xsd_version
    xsd_versionProp = property(get_xsd_version, set_xsd_version)
    def get_part_family(self): return self.part_family
    def set_part_family(self, part_family): self.part_family = part_family
    part_familyProp = property(get_part_family, set_part_family)
    def get_part_revision(self): return self.part_revision
    def set_part_revision(self, part_revision): self.part_revision = part_revision
    part_revisionProp = property(get_part_revision, set_part_revision)
    def get_rail_adapter_version(self): return self.rail_adapter_version
    def set_rail_adapter_version(self, rail_adapter_version): self.rail_adapter_version = rail_adapter_version
    rail_adapter_versionProp = property(get_rail_adapter_version, set_rail_adapter_version)
    def get_desc(self): return self.desc
    def set_desc(self, desc): self.desc = desc
    descProp = property(get_desc, set_desc)
    def get_status_code(self): return self.status_code
    def set_status_code(self, status_code): self.status_code = status_code
    status_codeProp = property(get_status_code, set_status_code)
    def get_status_message(self): return self.status_message
    def set_status_message(self, status_message): self.status_message = status_message
    status_messageProp = property(get_status_message, set_status_message)
    def get_readable_name(self): return self.readable_name
    def set_readable_name(self, readable_name): self.readable_name = readable_name
    readable_nameProp = property(get_readable_name, set_readable_name)
    def get_part_opn(self): return self.part_opn
    def set_part_opn(self, part_opn): self.part_opn = part_opn
    part_opnProp = property(get_part_opn, set_part_opn)
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    targetProp = property(get_target, set_target)
    def hasContent_(self):
        if (
            self.base_channel_configurations is not None or
            self.output_files is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='multi_phy_configuration', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='multi_phy_configuration')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='multi_phy_configuration', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='multi_phy_configuration'):
        if self.xsd_version is not None and 'xsd_version' not in already_processed:
            already_processed.add('xsd_version')
            outfile.write(' xsd_version=%s' % (self.gds_format_string(quote_attrib(self.xsd_version), input_name='xsd_version'), ))
        if self.part_family is not None and 'part_family' not in already_processed:
            already_processed.add('part_family')
            outfile.write(' part_family=%s' % (self.gds_format_string(quote_attrib(self.part_family), input_name='part_family'), ))
        if self.part_revision is not None and 'part_revision' not in already_processed:
            already_processed.add('part_revision')
            outfile.write(' part_revision=%s' % (self.gds_format_string(quote_attrib(self.part_revision), input_name='part_revision'), ))
        if self.rail_adapter_version is not None and 'rail_adapter_version' not in already_processed:
            already_processed.add('rail_adapter_version')
            outfile.write(' rail_adapter_version=%s' % (self.gds_format_string(quote_attrib(self.rail_adapter_version), input_name='rail_adapter_version'), ))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(' desc=%s' % (self.gds_format_string(quote_attrib(self.desc), input_name='desc'), ))
        if self.status_code is not None and 'status_code' not in already_processed:
            already_processed.add('status_code')
            outfile.write(' status_code=%s' % (self.gds_format_string(quote_attrib(self.status_code), input_name='status_code'), ))
        if self.status_message is not None and 'status_message' not in already_processed:
            already_processed.add('status_message')
            outfile.write(' status_message=%s' % (self.gds_format_string(quote_attrib(self.status_message), input_name='status_message'), ))
        if self.readable_name is not None and 'readable_name' not in already_processed:
            already_processed.add('readable_name')
            outfile.write(' readable_name=%s' % (self.gds_format_string(quote_attrib(self.readable_name), input_name='readable_name'), ))
        if self.part_opn is not None and 'part_opn' not in already_processed:
            already_processed.add('part_opn')
            outfile.write(' part_opn=%s' % (self.gds_format_string(quote_attrib(self.part_opn), input_name='part_opn'), ))
        if self.target is not None and 'target' not in already_processed:
            already_processed.add('target')
            outfile.write(' target=%s' % (self.gds_format_string(quote_attrib(self.target), input_name='target'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='multi_phy_configuration', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.base_channel_configurations is not None:
            self.base_channel_configurations.export(outfile, level, namespace_, name_='base_channel_configurations', pretty_print=pretty_print)
        if self.output_files is not None:
            self.output_files.export(outfile, level, namespace_, name_='output_files', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='multi_phy_configuration'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.xsd_version is not None and 'xsd_version' not in already_processed:
            already_processed.add('xsd_version')
            showIndent(outfile, level)
            outfile.write('xsd_version="%s",\n' % (self.xsd_version,))
        if self.part_family is not None and 'part_family' not in already_processed:
            already_processed.add('part_family')
            showIndent(outfile, level)
            outfile.write('part_family="%s",\n' % (self.part_family,))
        if self.part_revision is not None and 'part_revision' not in already_processed:
            already_processed.add('part_revision')
            showIndent(outfile, level)
            outfile.write('part_revision="%s",\n' % (self.part_revision,))
        if self.rail_adapter_version is not None and 'rail_adapter_version' not in already_processed:
            already_processed.add('rail_adapter_version')
            showIndent(outfile, level)
            outfile.write('rail_adapter_version="%s",\n' % (self.rail_adapter_version,))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            showIndent(outfile, level)
            outfile.write('desc="%s",\n' % (self.desc,))
        if self.status_code is not None and 'status_code' not in already_processed:
            already_processed.add('status_code')
            showIndent(outfile, level)
            outfile.write('status_code="%s",\n' % (self.status_code,))
        if self.status_message is not None and 'status_message' not in already_processed:
            already_processed.add('status_message')
            showIndent(outfile, level)
            outfile.write('status_message="%s",\n' % (self.status_message,))
        if self.readable_name is not None and 'readable_name' not in already_processed:
            already_processed.add('readable_name')
            showIndent(outfile, level)
            outfile.write('readable_name="%s",\n' % (self.readable_name,))
        if self.part_opn is not None and 'part_opn' not in already_processed:
            already_processed.add('part_opn')
            showIndent(outfile, level)
            outfile.write('part_opn="%s",\n' % (self.part_opn,))
        if self.target is not None and 'target' not in already_processed:
            already_processed.add('target')
            showIndent(outfile, level)
            outfile.write('target="%s",\n' % (self.target,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.base_channel_configurations is not None:
            showIndent(outfile, level)
            outfile.write('base_channel_configurations=model_.base_channel_configurationsType(\n')
            self.base_channel_configurations.exportLiteral(outfile, level, name_='base_channel_configurations')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.output_files is not None:
            showIndent(outfile, level)
            outfile.write('output_files=model_.output_filesType(\n')
            self.output_files.exportLiteral(outfile, level, name_='output_files')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsd_version', node)
        if value is not None and 'xsd_version' not in already_processed:
            already_processed.add('xsd_version')
            self.xsd_version = value
        value = find_attr_value_('part_family', node)
        if value is not None and 'part_family' not in already_processed:
            already_processed.add('part_family')
            self.part_family = value
        value = find_attr_value_('part_revision', node)
        if value is not None and 'part_revision' not in already_processed:
            already_processed.add('part_revision')
            self.part_revision = value
        value = find_attr_value_('rail_adapter_version', node)
        if value is not None and 'rail_adapter_version' not in already_processed:
            already_processed.add('rail_adapter_version')
            self.rail_adapter_version = value
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('status_code', node)
        if value is not None and 'status_code' not in already_processed:
            already_processed.add('status_code')
            self.status_code = value
        value = find_attr_value_('status_message', node)
        if value is not None and 'status_message' not in already_processed:
            already_processed.add('status_message')
            self.status_message = value
        value = find_attr_value_('readable_name', node)
        if value is not None and 'readable_name' not in already_processed:
            already_processed.add('readable_name')
            self.readable_name = value
        value = find_attr_value_('part_opn', node)
        if value is not None and 'part_opn' not in already_processed:
            already_processed.add('part_opn')
            self.part_opn = value
        value = find_attr_value_('target', node)
        if value is not None and 'target' not in already_processed:
            already_processed.add('target')
            self.target = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'base_channel_configurations':
            obj_ = base_channel_configurationsType.factory()
            obj_.build(child_)
            self.base_channel_configurations = obj_
            obj_.original_tagname_ = 'base_channel_configurations'
        elif nodeName_ == 'output_files':
            obj_ = output_filesType.factory()
            obj_.build(child_)
            self.output_files = obj_
            obj_.original_tagname_ = 'output_files'
# end class multi_phy_configuration


class base_channel_configurationsType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('base_channel_configuration', 'base_channel_configurationType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, base_channel_configuration=None):
        self.original_tagname_ = None
        if base_channel_configuration is None:
            self.base_channel_configuration = []
        else:
            self.base_channel_configuration = base_channel_configuration
    def factory(*args_, **kwargs_):
        if base_channel_configurationsType.subclass:
            return base_channel_configurationsType.subclass(*args_, **kwargs_)
        else:
            return base_channel_configurationsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_base_channel_configuration(self): return self.base_channel_configuration
    def set_base_channel_configuration(self, base_channel_configuration): self.base_channel_configuration = base_channel_configuration
    def add_base_channel_configuration(self, value): self.base_channel_configuration.append(value)
    def insert_base_channel_configuration(self, index, value): self.base_channel_configuration[index] = value
    base_channel_configurationProp = property(get_base_channel_configuration, set_base_channel_configuration)
    def hasContent_(self):
        if (
            self.base_channel_configuration
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='base_channel_configurationsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='base_channel_configurationsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='base_channel_configurationsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='base_channel_configurationsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='base_channel_configurationsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for base_channel_configuration_ in self.base_channel_configuration:
            base_channel_configuration_.export(outfile, level, namespace_, name_='base_channel_configuration', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='base_channel_configurationsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('base_channel_configuration=[\n')
        level += 1
        for base_channel_configuration_ in self.base_channel_configuration:
            showIndent(outfile, level)
            outfile.write('model_.base_channel_configurationType(\n')
            base_channel_configuration_.exportLiteral(outfile, level, name_='base_channel_configurationType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'base_channel_configuration':
            obj_ = base_channel_configurationType.factory()
            obj_.build(child_)
            self.base_channel_configuration.append(obj_)
            obj_.original_tagname_ = 'base_channel_configuration'
# end class base_channel_configurationsType


class base_channel_configurationType(GeneratedsSuper):
    """Readable name of channel config. (e.g. "802.15.4")Name of Profile
    user selected. (example: Base_Profile)(Default=false) When true,
    copy all missing values back into "add" dictionary. And then
    empty out "subtract" dictionary. This is used as a speed
    optimization, at the cost of a larger "add" size. Remove
    registers from "baseline" that already exist in the "add"
    collection.if force_empty_phy_config_delta_subtract is True, and
    base_channel_reference is not an empty string.. then this name
    is the reference regsiter set used to optimize space across
    multiple base_channel_configs"""
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('profile', 'xs:string', 0),
        MemberSpec_('force_empty_phy_config_delta_subtract', 'xs:boolean', 0),
        MemberSpec_('base_channel_reference', 'xs:string', 0),
        MemberSpec_('profile_inputs', 'profile_inputsType', 0),
        MemberSpec_('phy', 'phyType', 0),
        MemberSpec_('profile_output_overrides', 'profile_output_overridesType', 0),
        MemberSpec_('metadata', 'xs:string', 0),
        MemberSpec_('channel_config_entries', 'channel_config_entriesType', 0),
        MemberSpec_('phy_config_base', 'phy_config_baseType', 0),
        MemberSpec_('phy_config_delta_subtract', 'phy_config_delta_subtractType', 0),
        MemberSpec_('link_layer_config', 'link_layer_configType', 0),
        MemberSpec_('optional_arguments', 'optional_argumentsType11', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, profile=None, force_empty_phy_config_delta_subtract=True, base_channel_reference=None, profile_inputs=None, phy=None, profile_output_overrides=None, metadata=None, channel_config_entries=None, phy_config_base=None, phy_config_delta_subtract=None, link_layer_config=None, optional_arguments=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.profile = _cast(None, profile)
        self.force_empty_phy_config_delta_subtract = _cast(bool, force_empty_phy_config_delta_subtract)
        self.base_channel_reference = _cast(None, base_channel_reference)
        if profile_inputs is None:
            self.profile_inputs = profile_inputsType()
        else:
            self.profile_inputs = profile_inputs
        if phy is None:
            self.phy = phyType()
        else:
            self.phy = phy
        if profile_output_overrides is None:
            self.profile_output_overrides = profile_output_overridesType()
        else:
            self.profile_output_overrides = profile_output_overrides
        self.metadata = metadata
        if channel_config_entries is None:
            self.channel_config_entries = channel_config_entriesType()
        else:
            self.channel_config_entries = channel_config_entries
        if phy_config_base is None:
            self.phy_config_base = phy_config_baseType()
        else:
            self.phy_config_base = phy_config_base
        if phy_config_delta_subtract is None:
            self.phy_config_delta_subtract = phy_config_delta_subtractType()
        else:
            self.phy_config_delta_subtract = phy_config_delta_subtract
        if link_layer_config is None:
            self.link_layer_config = link_layer_configType()
        else:
            self.link_layer_config = link_layer_config
        if optional_arguments is None:
            self.optional_arguments = optional_argumentsType11()
        else:
            self.optional_arguments = optional_arguments
    def factory(*args_, **kwargs_):
        if base_channel_configurationType.subclass:
            return base_channel_configurationType.subclass(*args_, **kwargs_)
        else:
            return base_channel_configurationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_profile_inputs(self): return self.profile_inputs
    def set_profile_inputs(self, profile_inputs): self.profile_inputs = profile_inputs
    profile_inputsProp = property(get_profile_inputs, set_profile_inputs)
    def get_phy(self): return self.phy
    def set_phy(self, phy): self.phy = phy
    phyProp = property(get_phy, set_phy)
    def get_profile_output_overrides(self): return self.profile_output_overrides
    def set_profile_output_overrides(self, profile_output_overrides): self.profile_output_overrides = profile_output_overrides
    profile_output_overridesProp = property(get_profile_output_overrides, set_profile_output_overrides)
    def get_metadata(self): return self.metadata
    def set_metadata(self, metadata): self.metadata = metadata
    metadataProp = property(get_metadata, set_metadata)
    def get_channel_config_entries(self): return self.channel_config_entries
    def set_channel_config_entries(self, channel_config_entries): self.channel_config_entries = channel_config_entries
    channel_config_entriesProp = property(get_channel_config_entries, set_channel_config_entries)
    def get_phy_config_base(self): return self.phy_config_base
    def set_phy_config_base(self, phy_config_base): self.phy_config_base = phy_config_base
    phy_config_baseProp = property(get_phy_config_base, set_phy_config_base)
    def get_phy_config_delta_subtract(self): return self.phy_config_delta_subtract
    def set_phy_config_delta_subtract(self, phy_config_delta_subtract): self.phy_config_delta_subtract = phy_config_delta_subtract
    phy_config_delta_subtractProp = property(get_phy_config_delta_subtract, set_phy_config_delta_subtract)
    def get_link_layer_config(self): return self.link_layer_config
    def set_link_layer_config(self, link_layer_config): self.link_layer_config = link_layer_config
    link_layer_configProp = property(get_link_layer_config, set_link_layer_config)
    def get_optional_arguments(self): return self.optional_arguments
    def set_optional_arguments(self, optional_arguments): self.optional_arguments = optional_arguments
    optional_argumentsProp = property(get_optional_arguments, set_optional_arguments)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_profile(self): return self.profile
    def set_profile(self, profile): self.profile = profile
    profileProp = property(get_profile, set_profile)
    def get_force_empty_phy_config_delta_subtract(self): return self.force_empty_phy_config_delta_subtract
    def set_force_empty_phy_config_delta_subtract(self, force_empty_phy_config_delta_subtract): self.force_empty_phy_config_delta_subtract = force_empty_phy_config_delta_subtract
    force_empty_phy_config_delta_subtractProp = property(get_force_empty_phy_config_delta_subtract, set_force_empty_phy_config_delta_subtract)
    def get_base_channel_reference(self): return self.base_channel_reference
    def set_base_channel_reference(self, base_channel_reference): self.base_channel_reference = base_channel_reference
    base_channel_referenceProp = property(get_base_channel_reference, set_base_channel_reference)
    def hasContent_(self):
        if (
            self.profile_inputs is not None or
            self.phy is not None or
            self.profile_output_overrides is not None or
            self.metadata is not None or
            self.channel_config_entries is not None or
            self.phy_config_base is not None or
            self.phy_config_delta_subtract is not None or
            self.link_layer_config is not None or
            self.optional_arguments is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='base_channel_configurationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='base_channel_configurationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='base_channel_configurationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='base_channel_configurationType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name), input_name='name'), ))
        if self.profile is not None and 'profile' not in already_processed:
            already_processed.add('profile')
            outfile.write(' profile=%s' % (self.gds_format_string(quote_attrib(self.profile), input_name='profile'), ))
        if self.force_empty_phy_config_delta_subtract is not None and 'force_empty_phy_config_delta_subtract' not in already_processed:
            already_processed.add('force_empty_phy_config_delta_subtract')
            outfile.write(' force_empty_phy_config_delta_subtract="%s"' % self.gds_format_boolean(self.force_empty_phy_config_delta_subtract, input_name='force_empty_phy_config_delta_subtract'))
        if self.base_channel_reference is not None and 'base_channel_reference' not in already_processed:
            already_processed.add('base_channel_reference')
            outfile.write(' base_channel_reference=%s' % (self.gds_format_string(quote_attrib(self.base_channel_reference), input_name='base_channel_reference'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='base_channel_configurationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.profile_inputs is not None:
            self.profile_inputs.export(outfile, level, namespace_, name_='profile_inputs', pretty_print=pretty_print)
        if self.phy is not None:
            self.phy.export(outfile, level, namespace_, name_='phy', pretty_print=pretty_print)
        if self.profile_output_overrides is not None:
            self.profile_output_overrides.export(outfile, level, namespace_, name_='profile_output_overrides', pretty_print=pretty_print)
        if self.metadata is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smetadata>%s</%smetadata>%s' % (namespace_, self.gds_format_string(quote_xml(self.metadata), input_name='metadata'), namespace_, eol_))
        if self.channel_config_entries is not None:
            self.channel_config_entries.export(outfile, level, namespace_, name_='channel_config_entries', pretty_print=pretty_print)
        if self.phy_config_base is not None:
            self.phy_config_base.export(outfile, level, namespace_, name_='phy_config_base', pretty_print=pretty_print)
        if self.phy_config_delta_subtract is not None:
            self.phy_config_delta_subtract.export(outfile, level, namespace_, name_='phy_config_delta_subtract', pretty_print=pretty_print)
        if self.link_layer_config is not None:
            self.link_layer_config.export(outfile, level, namespace_, name_='link_layer_config', pretty_print=pretty_print)
        if self.optional_arguments is not None:
            self.optional_arguments.export(outfile, level, namespace_, name_='optional_arguments', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='base_channel_configurationType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.profile is not None and 'profile' not in already_processed:
            already_processed.add('profile')
            showIndent(outfile, level)
            outfile.write('profile="%s",\n' % (self.profile,))
        if self.force_empty_phy_config_delta_subtract is not None and 'force_empty_phy_config_delta_subtract' not in already_processed:
            already_processed.add('force_empty_phy_config_delta_subtract')
            showIndent(outfile, level)
            outfile.write('force_empty_phy_config_delta_subtract=%s,\n' % (self.force_empty_phy_config_delta_subtract,))
        if self.base_channel_reference is not None and 'base_channel_reference' not in already_processed:
            already_processed.add('base_channel_reference')
            showIndent(outfile, level)
            outfile.write('base_channel_reference="%s",\n' % (self.base_channel_reference,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.profile_inputs is not None:
            showIndent(outfile, level)
            outfile.write('profile_inputs=model_.profile_inputsType(\n')
            self.profile_inputs.exportLiteral(outfile, level, name_='profile_inputs')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.phy is not None:
            showIndent(outfile, level)
            outfile.write('phy=model_.phyType(\n')
            self.phy.exportLiteral(outfile, level, name_='phy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.profile_output_overrides is not None:
            showIndent(outfile, level)
            outfile.write('profile_output_overrides=model_.profile_output_overridesType(\n')
            self.profile_output_overrides.exportLiteral(outfile, level, name_='profile_output_overrides')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.metadata is not None:
            showIndent(outfile, level)
            outfile.write('metadata=%s,\n' % quote_python(self.metadata))
        if self.channel_config_entries is not None:
            showIndent(outfile, level)
            outfile.write('channel_config_entries=model_.channel_config_entriesType(\n')
            self.channel_config_entries.exportLiteral(outfile, level, name_='channel_config_entries')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.phy_config_base is not None:
            showIndent(outfile, level)
            outfile.write('phy_config_base=model_.phy_config_baseType(\n')
            self.phy_config_base.exportLiteral(outfile, level, name_='phy_config_base')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.phy_config_delta_subtract is not None:
            showIndent(outfile, level)
            outfile.write('phy_config_delta_subtract=model_.phy_config_delta_subtractType(\n')
            self.phy_config_delta_subtract.exportLiteral(outfile, level, name_='phy_config_delta_subtract')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.link_layer_config is not None:
            showIndent(outfile, level)
            outfile.write('link_layer_config=model_.link_layer_configType(\n')
            self.link_layer_config.exportLiteral(outfile, level, name_='link_layer_config')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.optional_arguments is not None:
            showIndent(outfile, level)
            outfile.write('optional_arguments=model_.optional_argumentsType11(\n')
            self.optional_arguments.exportLiteral(outfile, level, name_='optional_arguments')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('profile', node)
        if value is not None and 'profile' not in already_processed:
            already_processed.add('profile')
            self.profile = value
        value = find_attr_value_('force_empty_phy_config_delta_subtract', node)
        if value is not None and 'force_empty_phy_config_delta_subtract' not in already_processed:
            already_processed.add('force_empty_phy_config_delta_subtract')
            if value in ('true', '1'):
                self.force_empty_phy_config_delta_subtract = True
            elif value in ('false', '0'):
                self.force_empty_phy_config_delta_subtract = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('base_channel_reference', node)
        if value is not None and 'base_channel_reference' not in already_processed:
            already_processed.add('base_channel_reference')
            self.base_channel_reference = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'profile_inputs':
            obj_ = profile_inputsType.factory()
            obj_.build(child_)
            self.profile_inputs = obj_
            obj_.original_tagname_ = 'profile_inputs'
        elif nodeName_ == 'phy':
            obj_ = phyType.factory()
            obj_.build(child_)
            self.phy = obj_
            obj_.original_tagname_ = 'phy'
        elif nodeName_ == 'profile_output_overrides':
            obj_ = profile_output_overridesType.factory()
            obj_.build(child_)
            self.profile_output_overrides = obj_
            obj_.original_tagname_ = 'profile_output_overrides'
        elif nodeName_ == 'metadata':
            metadata_ = child_.text
            metadata_ = self.gds_validate_string(metadata_, node, 'metadata')
            self.metadata = metadata_
        elif nodeName_ == 'channel_config_entries':
            obj_ = channel_config_entriesType.factory()
            obj_.build(child_)
            self.channel_config_entries = obj_
            obj_.original_tagname_ = 'channel_config_entries'
        elif nodeName_ == 'phy_config_base':
            obj_ = phy_config_baseType.factory()
            obj_.build(child_)
            self.phy_config_base = obj_
            obj_.original_tagname_ = 'phy_config_base'
        elif nodeName_ == 'phy_config_delta_subtract':
            obj_ = phy_config_delta_subtractType.factory()
            obj_.build(child_)
            self.phy_config_delta_subtract = obj_
            obj_.original_tagname_ = 'phy_config_delta_subtract'
        elif nodeName_ == 'link_layer_config':
            obj_ = link_layer_configType.factory()
            obj_.build(child_)
            self.link_layer_config = obj_
            obj_.original_tagname_ = 'link_layer_config'
        elif nodeName_ == 'optional_arguments':
            obj_ = optional_argumentsType11.factory()
            obj_.build(child_)
            self.optional_arguments = obj_
            obj_.original_tagname_ = 'optional_arguments'
# end class base_channel_configurationType


class profile_inputsType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('input', 'inputType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, input=None):
        self.original_tagname_ = None
        if input is None:
            self.input = []
        else:
            self.input = input
    def factory(*args_, **kwargs_):
        if profile_inputsType.subclass:
            return profile_inputsType.subclass(*args_, **kwargs_)
        else:
            return profile_inputsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_input(self): return self.input
    def set_input(self, input): self.input = input
    def add_input(self, value): self.input.append(value)
    def insert_input(self, index, value): self.input[index] = value
    inputProp = property(get_input, set_input)
    def hasContent_(self):
        if (
            self.input
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='profile_inputsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='profile_inputsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='profile_inputsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='profile_inputsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='profile_inputsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for input_ in self.input:
            input_.export(outfile, level, namespace_, name_='input', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='profile_inputsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('input=[\n')
        level += 1
        for input_ in self.input:
            showIndent(outfile, level)
            outfile.write('model_.inputType(\n')
            input_.exportLiteral(outfile, level, name_='inputType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'input':
            obj_ = inputType.factory()
            obj_.build(child_)
            self.input.append(obj_)
            obj_.original_tagname_ = 'input'
# end class profile_inputsType


class inputType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('key', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.original_tagname_ = None
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if inputType.subclass:
            return inputType.subclass(*args_, **kwargs_)
        else:
            return inputType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    keyProp = property(get_key, set_key)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='inputType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='inputType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='inputType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='inputType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='inputType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key), input_name='key'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='inputType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class inputType


class phyType(GeneratedsSuper):
    """Name of PHY user selected. (example: PHY_2450M_2GFSK 250Kbps_125K)"""
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('profile_input_overrides', 'profile_input_overridesType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, profile_input_overrides=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        if profile_input_overrides is None:
            self.profile_input_overrides = profile_input_overridesType()
        else:
            self.profile_input_overrides = profile_input_overrides
    def factory(*args_, **kwargs_):
        if phyType.subclass:
            return phyType.subclass(*args_, **kwargs_)
        else:
            return phyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_profile_input_overrides(self): return self.profile_input_overrides
    def set_profile_input_overrides(self, profile_input_overrides): self.profile_input_overrides = profile_input_overrides
    profile_input_overridesProp = property(get_profile_input_overrides, set_profile_input_overrides)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def hasContent_(self):
        if (
            self.profile_input_overrides is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='phyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='phyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='phyType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='phyType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='phyType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.profile_input_overrides is not None:
            self.profile_input_overrides.export(outfile, level, namespace_, name_='profile_input_overrides', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='phyType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.profile_input_overrides is not None:
            showIndent(outfile, level)
            outfile.write('profile_input_overrides=model_.profile_input_overridesType(\n')
            self.profile_input_overrides.exportLiteral(outfile, level, name_='profile_input_overrides')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'profile_input_overrides':
            obj_ = profile_input_overridesType.factory()
            obj_.build(child_)
            self.profile_input_overrides = obj_
            obj_.original_tagname_ = 'profile_input_overrides'
# end class phyType


class profile_input_overridesType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('override', 'overrideType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, override=None):
        self.original_tagname_ = None
        if override is None:
            self.override = []
        else:
            self.override = override
    def factory(*args_, **kwargs_):
        if profile_input_overridesType.subclass:
            return profile_input_overridesType.subclass(*args_, **kwargs_)
        else:
            return profile_input_overridesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_override(self): return self.override
    def set_override(self, override): self.override = override
    def add_override(self, value): self.override.append(value)
    def insert_override(self, index, value): self.override[index] = value
    overrideProp = property(get_override, set_override)
    def hasContent_(self):
        if (
            self.override
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='profile_input_overridesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='profile_input_overridesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='profile_input_overridesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='profile_input_overridesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='profile_input_overridesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for override_ in self.override:
            override_.export(outfile, level, namespace_, name_='override', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='profile_input_overridesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('override=[\n')
        level += 1
        for override_ in self.override:
            showIndent(outfile, level)
            outfile.write('model_.overrideType(\n')
            override_.exportLiteral(outfile, level, name_='overrideType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'override':
            obj_ = overrideType.factory()
            obj_.build(child_)
            self.override.append(obj_)
            obj_.original_tagname_ = 'override'
# end class profile_input_overridesType


class overrideType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('key', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.original_tagname_ = None
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if overrideType.subclass:
            return overrideType.subclass(*args_, **kwargs_)
        else:
            return overrideType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    keyProp = property(get_key, set_key)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='overrideType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='overrideType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='overrideType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='overrideType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='overrideType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key), input_name='key'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='overrideType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class overrideType


class profile_output_overridesType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('override', 'overrideType1', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, override=None):
        self.original_tagname_ = None
        if override is None:
            self.override = []
        else:
            self.override = override
    def factory(*args_, **kwargs_):
        if profile_output_overridesType.subclass:
            return profile_output_overridesType.subclass(*args_, **kwargs_)
        else:
            return profile_output_overridesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_override(self): return self.override
    def set_override(self, override): self.override = override
    def add_override(self, value): self.override.append(value)
    def insert_override(self, index, value): self.override[index] = value
    overrideProp = property(get_override, set_override)
    def hasContent_(self):
        if (
            self.override
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='profile_output_overridesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='profile_output_overridesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='profile_output_overridesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='profile_output_overridesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='profile_output_overridesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for override_ in self.override:
            override_.export(outfile, level, namespace_, name_='override', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='profile_output_overridesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('override=[\n')
        level += 1
        for override_ in self.override:
            showIndent(outfile, level)
            outfile.write('model_.overrideType1(\n')
            override_.exportLiteral(outfile, level, name_='overrideType1')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'override':
            obj_ = overrideType1.factory()
            obj_.build(child_)
            self.override.append(obj_)
            obj_.original_tagname_ = 'override'
# end class profile_output_overridesType


class overrideType1(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('key', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.original_tagname_ = None
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if overrideType1.subclass:
            return overrideType1.subclass(*args_, **kwargs_)
        else:
            return overrideType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    keyProp = property(get_key, set_key)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='overrideType1', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='overrideType1')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='overrideType1', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='overrideType1'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='overrideType1', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key), input_name='key'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='overrideType1'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class overrideType1


class channel_config_entriesType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('channel_config_entry', 'channel_config_entryType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, channel_config_entry=None):
        self.original_tagname_ = None
        if channel_config_entry is None:
            self.channel_config_entry = []
        else:
            self.channel_config_entry = channel_config_entry
    def factory(*args_, **kwargs_):
        if channel_config_entriesType.subclass:
            return channel_config_entriesType.subclass(*args_, **kwargs_)
        else:
            return channel_config_entriesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_channel_config_entry(self): return self.channel_config_entry
    def set_channel_config_entry(self, channel_config_entry): self.channel_config_entry = channel_config_entry
    def add_channel_config_entry(self, value): self.channel_config_entry.append(value)
    def insert_channel_config_entry(self, index, value): self.channel_config_entry[index] = value
    channel_config_entryProp = property(get_channel_config_entry, set_channel_config_entry)
    def hasContent_(self):
        if (
            self.channel_config_entry
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='channel_config_entriesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='channel_config_entriesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='channel_config_entriesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='channel_config_entriesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='channel_config_entriesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for channel_config_entry_ in self.channel_config_entry:
            channel_config_entry_.export(outfile, level, namespace_, name_='channel_config_entry', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='channel_config_entriesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('channel_config_entry=[\n')
        level += 1
        for channel_config_entry_ in self.channel_config_entry:
            showIndent(outfile, level)
            outfile.write('model_.channel_config_entryType(\n')
            channel_config_entry_.exportLiteral(outfile, level, name_='channel_config_entryType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'channel_config_entry':
            obj_ = channel_config_entryType.factory()
            obj_.build(child_)
            self.channel_config_entry.append(obj_)
            obj_.original_tagname_ = 'channel_config_entry'
# end class channel_config_entriesType


class channel_config_entryType(GeneratedsSuper):
    """Name of channel. (e.g. "902MHz, 2FSK, 50kbps")"""
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('base_frequency', 'xs:decimal', 0),
        MemberSpec_('channel_spacing', 'xs:decimal', 0),
        MemberSpec_('physical_channel_offset', 'xs:string', 0),
        MemberSpec_('channel_number_start', 'xs:decimal', 0),
        MemberSpec_('channel_number_end', 'xs:decimal', 0),
        MemberSpec_('max_power', 'xs:string', 0),
        MemberSpec_('profile_input_overrides', 'profile_input_overridesType2', 0),
        MemberSpec_('profile_output_overrides', 'profile_output_overridesType4', 0),
        MemberSpec_('phy_name_override', 'xs:string', 0),
        MemberSpec_('phy_config_delta_add', 'phy_config_delta_addType', 0),
        MemberSpec_('radio_configurator_output_model', 'xs:string', 0),
        MemberSpec_('full_register_model', 'xs:string', 0),
        MemberSpec_('optional_arguments', 'optional_argumentsType', 0),
        MemberSpec_('metadata', 'xs:string', 0),
        MemberSpec_('alternate_phy', 'alternate_phyType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, base_frequency=None, channel_spacing=None, physical_channel_offset=None, channel_number_start=None, channel_number_end=None, max_power=None, profile_input_overrides=None, profile_output_overrides=None, phy_name_override=None, phy_config_delta_add=None, radio_configurator_output_model=None, full_register_model=None, optional_arguments=None, metadata=None, alternate_phy=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.base_frequency = base_frequency
        self.channel_spacing = channel_spacing
        self.physical_channel_offset = physical_channel_offset
        self.channel_number_start = channel_number_start
        self.channel_number_end = channel_number_end
        self.max_power = max_power
        if profile_input_overrides is None:
            self.profile_input_overrides = profile_input_overridesType2()
        else:
            self.profile_input_overrides = profile_input_overrides
        if profile_output_overrides is None:
            self.profile_output_overrides = profile_output_overridesType4()
        else:
            self.profile_output_overrides = profile_output_overrides
        self.phy_name_override = phy_name_override
        if phy_config_delta_add is None:
            self.phy_config_delta_add = phy_config_delta_addType()
        else:
            self.phy_config_delta_add = phy_config_delta_add
        self.radio_configurator_output_model = radio_configurator_output_model
        self.full_register_model = full_register_model
        if optional_arguments is None:
            self.optional_arguments = optional_argumentsType()
        else:
            self.optional_arguments = optional_arguments
        self.metadata = metadata
        if alternate_phy is None:
            self.alternate_phy = alternate_phyType()
        else:
            self.alternate_phy = alternate_phy
    def factory(*args_, **kwargs_):
        if channel_config_entryType.subclass:
            return channel_config_entryType.subclass(*args_, **kwargs_)
        else:
            return channel_config_entryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_base_frequency(self): return self.base_frequency
    def set_base_frequency(self, base_frequency): self.base_frequency = base_frequency
    base_frequencyProp = property(get_base_frequency, set_base_frequency)
    def get_channel_spacing(self): return self.channel_spacing
    def set_channel_spacing(self, channel_spacing): self.channel_spacing = channel_spacing
    channel_spacingProp = property(get_channel_spacing, set_channel_spacing)
    def get_physical_channel_offset(self): return self.physical_channel_offset
    def set_physical_channel_offset(self, physical_channel_offset): self.physical_channel_offset = physical_channel_offset
    physical_channel_offsetProp = property(get_physical_channel_offset, set_physical_channel_offset)
    def get_channel_number_start(self): return self.channel_number_start
    def set_channel_number_start(self, channel_number_start): self.channel_number_start = channel_number_start
    channel_number_startProp = property(get_channel_number_start, set_channel_number_start)
    def get_channel_number_end(self): return self.channel_number_end
    def set_channel_number_end(self, channel_number_end): self.channel_number_end = channel_number_end
    channel_number_endProp = property(get_channel_number_end, set_channel_number_end)
    def get_max_power(self): return self.max_power
    def set_max_power(self, max_power): self.max_power = max_power
    max_powerProp = property(get_max_power, set_max_power)
    def get_profile_input_overrides(self): return self.profile_input_overrides
    def set_profile_input_overrides(self, profile_input_overrides): self.profile_input_overrides = profile_input_overrides
    profile_input_overridesProp = property(get_profile_input_overrides, set_profile_input_overrides)
    def get_profile_output_overrides(self): return self.profile_output_overrides
    def set_profile_output_overrides(self, profile_output_overrides): self.profile_output_overrides = profile_output_overrides
    profile_output_overridesProp = property(get_profile_output_overrides, set_profile_output_overrides)
    def get_phy_name_override(self): return self.phy_name_override
    def set_phy_name_override(self, phy_name_override): self.phy_name_override = phy_name_override
    phy_name_overrideProp = property(get_phy_name_override, set_phy_name_override)
    def get_phy_config_delta_add(self): return self.phy_config_delta_add
    def set_phy_config_delta_add(self, phy_config_delta_add): self.phy_config_delta_add = phy_config_delta_add
    phy_config_delta_addProp = property(get_phy_config_delta_add, set_phy_config_delta_add)
    def get_radio_configurator_output_model(self): return self.radio_configurator_output_model
    def set_radio_configurator_output_model(self, radio_configurator_output_model): self.radio_configurator_output_model = radio_configurator_output_model
    radio_configurator_output_modelProp = property(get_radio_configurator_output_model, set_radio_configurator_output_model)
    def get_full_register_model(self): return self.full_register_model
    def set_full_register_model(self, full_register_model): self.full_register_model = full_register_model
    full_register_modelProp = property(get_full_register_model, set_full_register_model)
    def get_optional_arguments(self): return self.optional_arguments
    def set_optional_arguments(self, optional_arguments): self.optional_arguments = optional_arguments
    optional_argumentsProp = property(get_optional_arguments, set_optional_arguments)
    def get_metadata(self): return self.metadata
    def set_metadata(self, metadata): self.metadata = metadata
    metadataProp = property(get_metadata, set_metadata)
    def get_alternate_phy(self): return self.alternate_phy
    def set_alternate_phy(self, alternate_phy): self.alternate_phy = alternate_phy
    alternate_phyProp = property(get_alternate_phy, set_alternate_phy)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def hasContent_(self):
        if (
            self.base_frequency is not None or
            self.channel_spacing is not None or
            self.physical_channel_offset is not None or
            self.channel_number_start is not None or
            self.channel_number_end is not None or
            self.max_power is not None or
            self.profile_input_overrides is not None or
            self.profile_output_overrides is not None or
            self.phy_name_override is not None or
            self.phy_config_delta_add is not None or
            self.radio_configurator_output_model is not None or
            self.full_register_model is not None or
            self.optional_arguments is not None or
            self.metadata is not None or
            self.alternate_phy is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='channel_config_entryType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='channel_config_entryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='channel_config_entryType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='channel_config_entryType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='channel_config_entryType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.base_frequency is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbase_frequency>%s</%sbase_frequency>%s' % (namespace_, self.gds_format_float(self.base_frequency, input_name='base_frequency'), namespace_, eol_))
        if self.channel_spacing is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schannel_spacing>%s</%schannel_spacing>%s' % (namespace_, self.gds_format_float(self.channel_spacing, input_name='channel_spacing'), namespace_, eol_))
        if self.physical_channel_offset is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sphysical_channel_offset>%s</%sphysical_channel_offset>%s' % (namespace_, self.gds_format_string(quote_xml(self.physical_channel_offset), input_name='physical_channel_offset'), namespace_, eol_))
        if self.channel_number_start is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schannel_number_start>%s</%schannel_number_start>%s' % (namespace_, self.gds_format_float(self.channel_number_start, input_name='channel_number_start'), namespace_, eol_))
        if self.channel_number_end is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schannel_number_end>%s</%schannel_number_end>%s' % (namespace_, self.gds_format_float(self.channel_number_end, input_name='channel_number_end'), namespace_, eol_))
        if self.max_power is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smax_power>%s</%smax_power>%s' % (namespace_, self.gds_format_string(quote_xml(self.max_power), input_name='max_power'), namespace_, eol_))
        if self.profile_input_overrides is not None:
            self.profile_input_overrides.export(outfile, level, namespace_, name_='profile_input_overrides', pretty_print=pretty_print)
        if self.profile_output_overrides is not None:
            self.profile_output_overrides.export(outfile, level, namespace_, name_='profile_output_overrides', pretty_print=pretty_print)
        if self.phy_name_override is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sphy_name_override>%s</%sphy_name_override>%s' % (namespace_, self.gds_format_string(quote_xml(self.phy_name_override), input_name='phy_name_override'), namespace_, eol_))
        if self.phy_config_delta_add is not None:
            self.phy_config_delta_add.export(outfile, level, namespace_, name_='phy_config_delta_add', pretty_print=pretty_print)
        if self.radio_configurator_output_model is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sradio_configurator_output_model>%s</%sradio_configurator_output_model>%s' % (namespace_, self.gds_format_string(quote_xml(self.radio_configurator_output_model), input_name='radio_configurator_output_model'), namespace_, eol_))
        if self.full_register_model is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfull_register_model>%s</%sfull_register_model>%s' % (namespace_, self.gds_format_string(quote_xml(self.full_register_model), input_name='full_register_model'), namespace_, eol_))
        if self.optional_arguments is not None:
            self.optional_arguments.export(outfile, level, namespace_, name_='optional_arguments', pretty_print=pretty_print)
        if self.metadata is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smetadata>%s</%smetadata>%s' % (namespace_, self.gds_format_string(quote_xml(self.metadata), input_name='metadata'), namespace_, eol_))
        if self.alternate_phy is not None:
            self.alternate_phy.export(outfile, level, namespace_, name_='alternate_phy', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='channel_config_entryType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.base_frequency is not None:
            showIndent(outfile, level)
            outfile.write('base_frequency=%f,\n' % self.base_frequency)
        if self.channel_spacing is not None:
            showIndent(outfile, level)
            outfile.write('channel_spacing=%f,\n' % self.channel_spacing)
        if self.physical_channel_offset is not None:
            showIndent(outfile, level)
            outfile.write('physical_channel_offset=%s,\n' % quote_python(self.physical_channel_offset))
        if self.channel_number_start is not None:
            showIndent(outfile, level)
            outfile.write('channel_number_start=%f,\n' % self.channel_number_start)
        if self.channel_number_end is not None:
            showIndent(outfile, level)
            outfile.write('channel_number_end=%f,\n' % self.channel_number_end)
        if self.max_power is not None:
            showIndent(outfile, level)
            outfile.write('max_power=%s,\n' % quote_python(self.max_power))
        if self.profile_input_overrides is not None:
            showIndent(outfile, level)
            outfile.write('profile_input_overrides=model_.profile_input_overridesType2(\n')
            self.profile_input_overrides.exportLiteral(outfile, level, name_='profile_input_overrides')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.profile_output_overrides is not None:
            showIndent(outfile, level)
            outfile.write('profile_output_overrides=model_.profile_output_overridesType4(\n')
            self.profile_output_overrides.exportLiteral(outfile, level, name_='profile_output_overrides')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.phy_name_override is not None:
            showIndent(outfile, level)
            outfile.write('phy_name_override=%s,\n' % quote_python(self.phy_name_override))
        if self.phy_config_delta_add is not None:
            showIndent(outfile, level)
            outfile.write('phy_config_delta_add=model_.phy_config_delta_addType(\n')
            self.phy_config_delta_add.exportLiteral(outfile, level, name_='phy_config_delta_add')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.radio_configurator_output_model is not None:
            showIndent(outfile, level)
            outfile.write('radio_configurator_output_model=%s,\n' % quote_python(self.radio_configurator_output_model))
        if self.full_register_model is not None:
            showIndent(outfile, level)
            outfile.write('full_register_model=%s,\n' % quote_python(self.full_register_model))
        if self.optional_arguments is not None:
            showIndent(outfile, level)
            outfile.write('optional_arguments=model_.optional_argumentsType(\n')
            self.optional_arguments.exportLiteral(outfile, level, name_='optional_arguments')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.metadata is not None:
            showIndent(outfile, level)
            outfile.write('metadata=%s,\n' % quote_python(self.metadata))
        if self.alternate_phy is not None:
            showIndent(outfile, level)
            outfile.write('alternate_phy=model_.alternate_phyType(\n')
            self.alternate_phy.exportLiteral(outfile, level, name_='alternate_phy')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'base_frequency':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'base_frequency')
            self.base_frequency = fval_
        elif nodeName_ == 'channel_spacing':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'channel_spacing')
            self.channel_spacing = fval_
        elif nodeName_ == 'physical_channel_offset':
            physical_channel_offset_ = child_.text
            physical_channel_offset_ = self.gds_validate_string(physical_channel_offset_, node, 'physical_channel_offset')
            self.physical_channel_offset = physical_channel_offset_
        elif nodeName_ == 'channel_number_start':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'channel_number_start')
            self.channel_number_start = fval_
        elif nodeName_ == 'channel_number_end':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'channel_number_end')
            self.channel_number_end = fval_
        elif nodeName_ == 'max_power':
            max_power_ = child_.text
            max_power_ = self.gds_validate_string(max_power_, node, 'max_power')
            self.max_power = max_power_
        elif nodeName_ == 'profile_input_overrides':
            obj_ = profile_input_overridesType2.factory()
            obj_.build(child_)
            self.profile_input_overrides = obj_
            obj_.original_tagname_ = 'profile_input_overrides'
        elif nodeName_ == 'profile_output_overrides':
            obj_ = profile_output_overridesType4.factory()
            obj_.build(child_)
            self.profile_output_overrides = obj_
            obj_.original_tagname_ = 'profile_output_overrides'
        elif nodeName_ == 'phy_name_override':
            phy_name_override_ = child_.text
            phy_name_override_ = self.gds_validate_string(phy_name_override_, node, 'phy_name_override')
            self.phy_name_override = phy_name_override_
        elif nodeName_ == 'phy_config_delta_add':
            obj_ = phy_config_delta_addType.factory()
            obj_.build(child_)
            self.phy_config_delta_add = obj_
            obj_.original_tagname_ = 'phy_config_delta_add'
        elif nodeName_ == 'radio_configurator_output_model':
            radio_configurator_output_model_ = child_.text
            radio_configurator_output_model_ = self.gds_validate_string(radio_configurator_output_model_, node, 'radio_configurator_output_model')
            self.radio_configurator_output_model = radio_configurator_output_model_
        elif nodeName_ == 'full_register_model':
            full_register_model_ = child_.text
            full_register_model_ = self.gds_validate_string(full_register_model_, node, 'full_register_model')
            self.full_register_model = full_register_model_
        elif nodeName_ == 'optional_arguments':
            obj_ = optional_argumentsType.factory()
            obj_.build(child_)
            self.optional_arguments = obj_
            obj_.original_tagname_ = 'optional_arguments'
        elif nodeName_ == 'metadata':
            metadata_ = child_.text
            metadata_ = self.gds_validate_string(metadata_, node, 'metadata')
            self.metadata = metadata_
        elif nodeName_ == 'alternate_phy':
            obj_ = alternate_phyType.factory()
            obj_.build(child_)
            self.alternate_phy = obj_
            obj_.original_tagname_ = 'alternate_phy'
# end class channel_config_entryType


class phy_name_override(GeneratedsSuper):
    """This overrides the PHY specified in the base_channel_config"""
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if phy_name_override.subclass:
            return phy_name_override.subclass(*args_, **kwargs_)
        else:
            return phy_name_override(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='phy_name_override', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='phy_name_override')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='phy_name_override', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='phy_name_override'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='phy_name_override', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='phy_name_override'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class phy_name_override


class radio_configurator_output_model(GeneratedsSuper):
    """Radio Configurator data model output. XSD defined in another file"""
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if radio_configurator_output_model.subclass:
            return radio_configurator_output_model.subclass(*args_, **kwargs_)
        else:
            return radio_configurator_output_model(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='radio_configurator_output_model', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='radio_configurator_output_model')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='radio_configurator_output_model', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='radio_configurator_output_model'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='radio_configurator_output_model', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='radio_configurator_output_model'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class radio_configurator_output_model


class full_register_model(GeneratedsSuper):
    """Register model XSD defined in another file"""
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if full_register_model.subclass:
            return full_register_model.subclass(*args_, **kwargs_)
        else:
            return full_register_model(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='full_register_model', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='full_register_model')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='full_register_model', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='full_register_model'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='full_register_model', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='full_register_model'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class full_register_model


class profile_input_overridesType2(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('override', 'overrideType3', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, override=None):
        self.original_tagname_ = None
        if override is None:
            self.override = []
        else:
            self.override = override
    def factory(*args_, **kwargs_):
        if profile_input_overridesType2.subclass:
            return profile_input_overridesType2.subclass(*args_, **kwargs_)
        else:
            return profile_input_overridesType2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_override(self): return self.override
    def set_override(self, override): self.override = override
    def add_override(self, value): self.override.append(value)
    def insert_override(self, index, value): self.override[index] = value
    overrideProp = property(get_override, set_override)
    def hasContent_(self):
        if (
            self.override
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='profile_input_overridesType2', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='profile_input_overridesType2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='profile_input_overridesType2', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='profile_input_overridesType2'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='profile_input_overridesType2', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for override_ in self.override:
            override_.export(outfile, level, namespace_, name_='override', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='profile_input_overridesType2'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('override=[\n')
        level += 1
        for override_ in self.override:
            showIndent(outfile, level)
            outfile.write('model_.overrideType3(\n')
            override_.exportLiteral(outfile, level, name_='overrideType3')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'override':
            obj_ = overrideType3.factory()
            obj_.build(child_)
            self.override.append(obj_)
            obj_.original_tagname_ = 'override'
# end class profile_input_overridesType2


class overrideType3(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('key', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.original_tagname_ = None
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if overrideType3.subclass:
            return overrideType3.subclass(*args_, **kwargs_)
        else:
            return overrideType3(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    keyProp = property(get_key, set_key)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='overrideType3', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='overrideType3')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='overrideType3', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='overrideType3'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='overrideType3', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key), input_name='key'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='overrideType3'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class overrideType3


class profile_output_overridesType4(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('override', 'overrideType5', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, override=None):
        self.original_tagname_ = None
        if override is None:
            self.override = []
        else:
            self.override = override
    def factory(*args_, **kwargs_):
        if profile_output_overridesType4.subclass:
            return profile_output_overridesType4.subclass(*args_, **kwargs_)
        else:
            return profile_output_overridesType4(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_override(self): return self.override
    def set_override(self, override): self.override = override
    def add_override(self, value): self.override.append(value)
    def insert_override(self, index, value): self.override[index] = value
    overrideProp = property(get_override, set_override)
    def hasContent_(self):
        if (
            self.override
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='profile_output_overridesType4', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='profile_output_overridesType4')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='profile_output_overridesType4', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='profile_output_overridesType4'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='profile_output_overridesType4', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for override_ in self.override:
            override_.export(outfile, level, namespace_, name_='override', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='profile_output_overridesType4'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('override=[\n')
        level += 1
        for override_ in self.override:
            showIndent(outfile, level)
            outfile.write('model_.overrideType5(\n')
            override_.exportLiteral(outfile, level, name_='overrideType5')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'override':
            obj_ = overrideType5.factory()
            obj_.build(child_)
            self.override.append(obj_)
            obj_.original_tagname_ = 'override'
# end class profile_output_overridesType4


class overrideType5(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('key', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.original_tagname_ = None
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if overrideType5.subclass:
            return overrideType5.subclass(*args_, **kwargs_)
        else:
            return overrideType5(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    keyProp = property(get_key, set_key)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='overrideType5', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='overrideType5')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='overrideType5', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='overrideType5'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='overrideType5', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key), input_name='key'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='overrideType5'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class overrideType5


class phy_config_delta_addType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('register', 'registerType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, register=None):
        self.original_tagname_ = None
        if register is None:
            self.register = []
        else:
            self.register = register
    def factory(*args_, **kwargs_):
        if phy_config_delta_addType.subclass:
            return phy_config_delta_addType.subclass(*args_, **kwargs_)
        else:
            return phy_config_delta_addType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_register(self): return self.register
    def set_register(self, register): self.register = register
    def add_register(self, value): self.register.append(value)
    def insert_register(self, index, value): self.register[index] = value
    registerProp = property(get_register, set_register)
    def hasContent_(self):
        if (
            self.register
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='phy_config_delta_addType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='phy_config_delta_addType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='phy_config_delta_addType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='phy_config_delta_addType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='phy_config_delta_addType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for register_ in self.register:
            register_.export(outfile, level, namespace_, name_='register', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='phy_config_delta_addType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('register=[\n')
        level += 1
        for register_ in self.register:
            showIndent(outfile, level)
            outfile.write('model_.registerType(\n')
            register_.exportLiteral(outfile, level, name_='registerType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'register':
            obj_ = registerType.factory()
            obj_.build(child_)
            self.register.append(obj_)
            obj_.original_tagname_ = 'register'
# end class phy_config_delta_addType


class registerType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
        MemberSpec_('baseAddress', 'xs:string', 0),
        MemberSpec_('addressOffset', 'xs:string', 0),
        MemberSpec_('fullname', 'xs:string', 0),
        MemberSpec_('access', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('resetValue', 'xs:string', 0),
        MemberSpec_('resetMask', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, value=None, baseAddress=None, addressOffset=None, fullname=None, access=None, description=None, resetValue=None, resetMask=None):
        self.original_tagname_ = None
        self.name = name
        self.value = value
        self.baseAddress = baseAddress
        self.addressOffset = addressOffset
        self.fullname = fullname
        self.access = access
        self.description = description
        self.resetValue = resetValue
        self.resetMask = resetMask
    def factory(*args_, **kwargs_):
        if registerType.subclass:
            return registerType.subclass(*args_, **kwargs_)
        else:
            return registerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def get_baseAddress(self): return self.baseAddress
    def set_baseAddress(self, baseAddress): self.baseAddress = baseAddress
    baseAddressProp = property(get_baseAddress, set_baseAddress)
    def get_addressOffset(self): return self.addressOffset
    def set_addressOffset(self, addressOffset): self.addressOffset = addressOffset
    addressOffsetProp = property(get_addressOffset, set_addressOffset)
    def get_fullname(self): return self.fullname
    def set_fullname(self, fullname): self.fullname = fullname
    fullnameProp = property(get_fullname, set_fullname)
    def get_access(self): return self.access
    def set_access(self, access): self.access = access
    accessProp = property(get_access, set_access)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    descriptionProp = property(get_description, set_description)
    def get_resetValue(self): return self.resetValue
    def set_resetValue(self, resetValue): self.resetValue = resetValue
    resetValueProp = property(get_resetValue, set_resetValue)
    def get_resetMask(self): return self.resetMask
    def set_resetMask(self, resetMask): self.resetMask = resetMask
    resetMaskProp = property(get_resetMask, set_resetMask)
    def hasContent_(self):
        if (
            self.name is not None or
            self.value is not None or
            self.baseAddress is not None or
            self.addressOffset is not None or
            self.fullname is not None or
            self.access is not None or
            self.description is not None or
            self.resetValue is not None or
            self.resetMask is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='registerType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='registerType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='registerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='registerType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='registerType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name), input_name='name'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
        if self.baseAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseAddress>%s</%sbaseAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseAddress), input_name='baseAddress'), namespace_, eol_))
        if self.addressOffset is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddressOffset>%s</%saddressOffset>%s' % (namespace_, self.gds_format_string(quote_xml(self.addressOffset), input_name='addressOffset'), namespace_, eol_))
        if self.fullname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfullname>%s</%sfullname>%s' % (namespace_, self.gds_format_string(quote_xml(self.fullname), input_name='fullname'), namespace_, eol_))
        if self.access is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccess>%s</%saccess>%s' % (namespace_, self.gds_format_string(quote_xml(self.access), input_name='access'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description), input_name='description'), namespace_, eol_))
        if self.resetValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetValue>%s</%sresetValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetValue), input_name='resetValue'), namespace_, eol_))
        if self.resetMask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetMask>%s</%sresetMask>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetMask), input_name='resetMask'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='registerType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
        if self.baseAddress is not None:
            showIndent(outfile, level)
            outfile.write('baseAddress=%s,\n' % quote_python(self.baseAddress))
        if self.addressOffset is not None:
            showIndent(outfile, level)
            outfile.write('addressOffset=%s,\n' % quote_python(self.addressOffset))
        if self.fullname is not None:
            showIndent(outfile, level)
            outfile.write('fullname=%s,\n' % quote_python(self.fullname))
        if self.access is not None:
            showIndent(outfile, level)
            outfile.write('access=%s,\n' % quote_python(self.access))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description))
        if self.resetValue is not None:
            showIndent(outfile, level)
            outfile.write('resetValue=%s,\n' % quote_python(self.resetValue))
        if self.resetMask is not None:
            showIndent(outfile, level)
            outfile.write('resetMask=%s,\n' % quote_python(self.resetMask))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
        elif nodeName_ == 'baseAddress':
            baseAddress_ = child_.text
            baseAddress_ = self.gds_validate_string(baseAddress_, node, 'baseAddress')
            self.baseAddress = baseAddress_
        elif nodeName_ == 'addressOffset':
            addressOffset_ = child_.text
            addressOffset_ = self.gds_validate_string(addressOffset_, node, 'addressOffset')
            self.addressOffset = addressOffset_
        elif nodeName_ == 'fullname':
            fullname_ = child_.text
            fullname_ = self.gds_validate_string(fullname_, node, 'fullname')
            self.fullname = fullname_
        elif nodeName_ == 'access':
            access_ = child_.text
            access_ = self.gds_validate_string(access_, node, 'access')
            self.access = access_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'resetValue':
            resetValue_ = child_.text
            resetValue_ = self.gds_validate_string(resetValue_, node, 'resetValue')
            self.resetValue = resetValue_
        elif nodeName_ == 'resetMask':
            resetMask_ = child_.text
            resetMask_ = self.gds_validate_string(resetMask_, node, 'resetMask')
            self.resetMask = resetMask_
# end class registerType


class value(GeneratedsSuper):
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if value.subclass:
            return value.subclass(*args_, **kwargs_)
        else:
            return value(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='value', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='value')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='value', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='value'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='value', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='value'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class value


class baseAddress(GeneratedsSuper):
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if baseAddress.subclass:
            return baseAddress.subclass(*args_, **kwargs_)
        else:
            return baseAddress(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='baseAddress', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='baseAddress')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='baseAddress', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='baseAddress'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='baseAddress', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='baseAddress'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class baseAddress


class addressOffset(GeneratedsSuper):
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if addressOffset.subclass:
            return addressOffset.subclass(*args_, **kwargs_)
        else:
            return addressOffset(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='addressOffset', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='addressOffset')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='addressOffset', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='addressOffset'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='addressOffset', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='addressOffset'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class addressOffset


class fullname(GeneratedsSuper):
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if fullname.subclass:
            return fullname.subclass(*args_, **kwargs_)
        else:
            return fullname(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fullname', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fullname')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fullname', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fullname'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='fullname', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='fullname'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class fullname


class access(GeneratedsSuper):
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if access.subclass:
            return access.subclass(*args_, **kwargs_)
        else:
            return access(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='access', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='access')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='access', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='access'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='access', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='access'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class access


class description(GeneratedsSuper):
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if description.subclass:
            return description.subclass(*args_, **kwargs_)
        else:
            return description(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='description', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='description')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='description', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='description'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='description', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='description'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class description


class resetValue(GeneratedsSuper):
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if resetValue.subclass:
            return resetValue.subclass(*args_, **kwargs_)
        else:
            return resetValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='resetValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='resetValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='resetValue', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='resetValue'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='resetValue', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='resetValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class resetValue


class resetMask(GeneratedsSuper):
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if resetMask.subclass:
            return resetMask.subclass(*args_, **kwargs_)
        else:
            return resetMask(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='resetMask', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='resetMask')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='resetMask', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='resetMask'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='resetMask', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='resetMask'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class resetMask


class optional_argumentsType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('argument', 'argumentType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, argument=None):
        self.original_tagname_ = None
        if argument is None:
            self.argument = []
        else:
            self.argument = argument
    def factory(*args_, **kwargs_):
        if optional_argumentsType.subclass:
            return optional_argumentsType.subclass(*args_, **kwargs_)
        else:
            return optional_argumentsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_argument(self): return self.argument
    def set_argument(self, argument): self.argument = argument
    def add_argument(self, value): self.argument.append(value)
    def insert_argument(self, index, value): self.argument[index] = value
    argumentProp = property(get_argument, set_argument)
    def hasContent_(self):
        if (
            self.argument
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='optional_argumentsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='optional_argumentsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='optional_argumentsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='optional_argumentsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='optional_argumentsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for argument_ in self.argument:
            argument_.export(outfile, level, namespace_, name_='argument', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='optional_argumentsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('argument=[\n')
        level += 1
        for argument_ in self.argument:
            showIndent(outfile, level)
            outfile.write('model_.argumentType(\n')
            argument_.exportLiteral(outfile, level, name_='argumentType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'argument':
            obj_ = argumentType.factory()
            obj_.build(child_)
            self.argument.append(obj_)
            obj_.original_tagname_ = 'argument'
# end class optional_argumentsType


class argumentType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('key', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.original_tagname_ = None
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if argumentType.subclass:
            return argumentType.subclass(*args_, **kwargs_)
        else:
            return argumentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    keyProp = property(get_key, set_key)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='argumentType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='argumentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='argumentType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='argumentType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='argumentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key), input_name='key'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='argumentType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class argumentType


class alternate_phyType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('base_frequency', 'xs:decimal', 0),
        MemberSpec_('channel_spacing', 'xs:decimal', 0),
        MemberSpec_('number_of_channels', 'xs:decimal', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, base_frequency=None, channel_spacing=None, number_of_channels=None):
        self.original_tagname_ = None
        self.base_frequency = base_frequency
        self.channel_spacing = channel_spacing
        self.number_of_channels = number_of_channels
    def factory(*args_, **kwargs_):
        if alternate_phyType.subclass:
            return alternate_phyType.subclass(*args_, **kwargs_)
        else:
            return alternate_phyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_base_frequency(self): return self.base_frequency
    def set_base_frequency(self, base_frequency): self.base_frequency = base_frequency
    base_frequencyProp = property(get_base_frequency, set_base_frequency)
    def get_channel_spacing(self): return self.channel_spacing
    def set_channel_spacing(self, channel_spacing): self.channel_spacing = channel_spacing
    channel_spacingProp = property(get_channel_spacing, set_channel_spacing)
    def get_number_of_channels(self): return self.number_of_channels
    def set_number_of_channels(self, number_of_channels): self.number_of_channels = number_of_channels
    number_of_channelsProp = property(get_number_of_channels, set_number_of_channels)
    def hasContent_(self):
        if (
            self.base_frequency is not None or
            self.channel_spacing is not None or
            self.number_of_channels is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='alternate_phyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='alternate_phyType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='alternate_phyType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='alternate_phyType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='alternate_phyType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.base_frequency is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbase_frequency>%s</%sbase_frequency>%s' % (namespace_, self.gds_format_float(self.base_frequency, input_name='base_frequency'), namespace_, eol_))
        if self.channel_spacing is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%schannel_spacing>%s</%schannel_spacing>%s' % (namespace_, self.gds_format_float(self.channel_spacing, input_name='channel_spacing'), namespace_, eol_))
        if self.number_of_channels is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumber_of_channels>%s</%snumber_of_channels>%s' % (namespace_, self.gds_format_float(self.number_of_channels, input_name='number_of_channels'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='alternate_phyType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.base_frequency is not None:
            showIndent(outfile, level)
            outfile.write('base_frequency=%f,\n' % self.base_frequency)
        if self.channel_spacing is not None:
            showIndent(outfile, level)
            outfile.write('channel_spacing=%f,\n' % self.channel_spacing)
        if self.number_of_channels is not None:
            showIndent(outfile, level)
            outfile.write('number_of_channels=%f,\n' % self.number_of_channels)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'base_frequency':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'base_frequency')
            self.base_frequency = fval_
        elif nodeName_ == 'channel_spacing':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'channel_spacing')
            self.channel_spacing = fval_
        elif nodeName_ == 'number_of_channels':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'number_of_channels')
            self.number_of_channels = fval_
# end class alternate_phyType


class phy_config_baseType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('register', 'registerType6', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, register=None):
        self.original_tagname_ = None
        if register is None:
            self.register = []
        else:
            self.register = register
    def factory(*args_, **kwargs_):
        if phy_config_baseType.subclass:
            return phy_config_baseType.subclass(*args_, **kwargs_)
        else:
            return phy_config_baseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_register(self): return self.register
    def set_register(self, register): self.register = register
    def add_register(self, value): self.register.append(value)
    def insert_register(self, index, value): self.register[index] = value
    registerProp = property(get_register, set_register)
    def hasContent_(self):
        if (
            self.register
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='phy_config_baseType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='phy_config_baseType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='phy_config_baseType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='phy_config_baseType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='phy_config_baseType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for register_ in self.register:
            register_.export(outfile, level, namespace_, name_='register', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='phy_config_baseType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('register=[\n')
        level += 1
        for register_ in self.register:
            showIndent(outfile, level)
            outfile.write('model_.registerType6(\n')
            register_.exportLiteral(outfile, level, name_='registerType6')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'register':
            obj_ = registerType6.factory()
            obj_.build(child_)
            self.register.append(obj_)
            obj_.original_tagname_ = 'register'
# end class phy_config_baseType


class registerType6(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
        MemberSpec_('baseAddress', 'xs:string', 0),
        MemberSpec_('addressOffset', 'xs:string', 0),
        MemberSpec_('fullname', 'xs:string', 0),
        MemberSpec_('access', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('resetValue', 'xs:string', 0),
        MemberSpec_('resetMask', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, value=None, baseAddress=None, addressOffset=None, fullname=None, access=None, description=None, resetValue=None, resetMask=None):
        self.original_tagname_ = None
        self.name = name
        self.value = value
        self.baseAddress = baseAddress
        self.addressOffset = addressOffset
        self.fullname = fullname
        self.access = access
        self.description = description
        self.resetValue = resetValue
        self.resetMask = resetMask
    def factory(*args_, **kwargs_):
        if registerType6.subclass:
            return registerType6.subclass(*args_, **kwargs_)
        else:
            return registerType6(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def get_baseAddress(self): return self.baseAddress
    def set_baseAddress(self, baseAddress): self.baseAddress = baseAddress
    baseAddressProp = property(get_baseAddress, set_baseAddress)
    def get_addressOffset(self): return self.addressOffset
    def set_addressOffset(self, addressOffset): self.addressOffset = addressOffset
    addressOffsetProp = property(get_addressOffset, set_addressOffset)
    def get_fullname(self): return self.fullname
    def set_fullname(self, fullname): self.fullname = fullname
    fullnameProp = property(get_fullname, set_fullname)
    def get_access(self): return self.access
    def set_access(self, access): self.access = access
    accessProp = property(get_access, set_access)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    descriptionProp = property(get_description, set_description)
    def get_resetValue(self): return self.resetValue
    def set_resetValue(self, resetValue): self.resetValue = resetValue
    resetValueProp = property(get_resetValue, set_resetValue)
    def get_resetMask(self): return self.resetMask
    def set_resetMask(self, resetMask): self.resetMask = resetMask
    resetMaskProp = property(get_resetMask, set_resetMask)
    def hasContent_(self):
        if (
            self.name is not None or
            self.value is not None or
            self.baseAddress is not None or
            self.addressOffset is not None or
            self.fullname is not None or
            self.access is not None or
            self.description is not None or
            self.resetValue is not None or
            self.resetMask is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='registerType6', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='registerType6')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='registerType6', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='registerType6'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='registerType6', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name), input_name='name'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
        if self.baseAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseAddress>%s</%sbaseAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseAddress), input_name='baseAddress'), namespace_, eol_))
        if self.addressOffset is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddressOffset>%s</%saddressOffset>%s' % (namespace_, self.gds_format_string(quote_xml(self.addressOffset), input_name='addressOffset'), namespace_, eol_))
        if self.fullname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfullname>%s</%sfullname>%s' % (namespace_, self.gds_format_string(quote_xml(self.fullname), input_name='fullname'), namespace_, eol_))
        if self.access is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccess>%s</%saccess>%s' % (namespace_, self.gds_format_string(quote_xml(self.access), input_name='access'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description), input_name='description'), namespace_, eol_))
        if self.resetValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetValue>%s</%sresetValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetValue), input_name='resetValue'), namespace_, eol_))
        if self.resetMask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetMask>%s</%sresetMask>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetMask), input_name='resetMask'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='registerType6'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
        if self.baseAddress is not None:
            showIndent(outfile, level)
            outfile.write('baseAddress=%s,\n' % quote_python(self.baseAddress))
        if self.addressOffset is not None:
            showIndent(outfile, level)
            outfile.write('addressOffset=%s,\n' % quote_python(self.addressOffset))
        if self.fullname is not None:
            showIndent(outfile, level)
            outfile.write('fullname=%s,\n' % quote_python(self.fullname))
        if self.access is not None:
            showIndent(outfile, level)
            outfile.write('access=%s,\n' % quote_python(self.access))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description))
        if self.resetValue is not None:
            showIndent(outfile, level)
            outfile.write('resetValue=%s,\n' % quote_python(self.resetValue))
        if self.resetMask is not None:
            showIndent(outfile, level)
            outfile.write('resetMask=%s,\n' % quote_python(self.resetMask))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
        elif nodeName_ == 'baseAddress':
            baseAddress_ = child_.text
            baseAddress_ = self.gds_validate_string(baseAddress_, node, 'baseAddress')
            self.baseAddress = baseAddress_
        elif nodeName_ == 'addressOffset':
            addressOffset_ = child_.text
            addressOffset_ = self.gds_validate_string(addressOffset_, node, 'addressOffset')
            self.addressOffset = addressOffset_
        elif nodeName_ == 'fullname':
            fullname_ = child_.text
            fullname_ = self.gds_validate_string(fullname_, node, 'fullname')
            self.fullname = fullname_
        elif nodeName_ == 'access':
            access_ = child_.text
            access_ = self.gds_validate_string(access_, node, 'access')
            self.access = access_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'resetValue':
            resetValue_ = child_.text
            resetValue_ = self.gds_validate_string(resetValue_, node, 'resetValue')
            self.resetValue = resetValue_
        elif nodeName_ == 'resetMask':
            resetMask_ = child_.text
            resetMask_ = self.gds_validate_string(resetMask_, node, 'resetMask')
            self.resetMask = resetMask_
# end class registerType6


class phy_config_delta_subtractType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('register', 'registerType7', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, register=None):
        self.original_tagname_ = None
        if register is None:
            self.register = []
        else:
            self.register = register
    def factory(*args_, **kwargs_):
        if phy_config_delta_subtractType.subclass:
            return phy_config_delta_subtractType.subclass(*args_, **kwargs_)
        else:
            return phy_config_delta_subtractType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_register(self): return self.register
    def set_register(self, register): self.register = register
    def add_register(self, value): self.register.append(value)
    def insert_register(self, index, value): self.register[index] = value
    registerProp = property(get_register, set_register)
    def hasContent_(self):
        if (
            self.register
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='phy_config_delta_subtractType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='phy_config_delta_subtractType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='phy_config_delta_subtractType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='phy_config_delta_subtractType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='phy_config_delta_subtractType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for register_ in self.register:
            register_.export(outfile, level, namespace_, name_='register', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='phy_config_delta_subtractType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('register=[\n')
        level += 1
        for register_ in self.register:
            showIndent(outfile, level)
            outfile.write('model_.registerType7(\n')
            register_.exportLiteral(outfile, level, name_='registerType7')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'register':
            obj_ = registerType7.factory()
            obj_.build(child_)
            self.register.append(obj_)
            obj_.original_tagname_ = 'register'
# end class phy_config_delta_subtractType


class registerType7(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
        MemberSpec_('baseAddress', 'xs:string', 0),
        MemberSpec_('addressOffset', 'xs:string', 0),
        MemberSpec_('fullname', 'xs:string', 0),
        MemberSpec_('access', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('resetValue', 'xs:string', 0),
        MemberSpec_('resetMask', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, value=None, baseAddress=None, addressOffset=None, fullname=None, access=None, description=None, resetValue=None, resetMask=None):
        self.original_tagname_ = None
        self.name = name
        self.value = value
        self.baseAddress = baseAddress
        self.addressOffset = addressOffset
        self.fullname = fullname
        self.access = access
        self.description = description
        self.resetValue = resetValue
        self.resetMask = resetMask
    def factory(*args_, **kwargs_):
        if registerType7.subclass:
            return registerType7.subclass(*args_, **kwargs_)
        else:
            return registerType7(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def get_baseAddress(self): return self.baseAddress
    def set_baseAddress(self, baseAddress): self.baseAddress = baseAddress
    baseAddressProp = property(get_baseAddress, set_baseAddress)
    def get_addressOffset(self): return self.addressOffset
    def set_addressOffset(self, addressOffset): self.addressOffset = addressOffset
    addressOffsetProp = property(get_addressOffset, set_addressOffset)
    def get_fullname(self): return self.fullname
    def set_fullname(self, fullname): self.fullname = fullname
    fullnameProp = property(get_fullname, set_fullname)
    def get_access(self): return self.access
    def set_access(self, access): self.access = access
    accessProp = property(get_access, set_access)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    descriptionProp = property(get_description, set_description)
    def get_resetValue(self): return self.resetValue
    def set_resetValue(self, resetValue): self.resetValue = resetValue
    resetValueProp = property(get_resetValue, set_resetValue)
    def get_resetMask(self): return self.resetMask
    def set_resetMask(self, resetMask): self.resetMask = resetMask
    resetMaskProp = property(get_resetMask, set_resetMask)
    def hasContent_(self):
        if (
            self.name is not None or
            self.value is not None or
            self.baseAddress is not None or
            self.addressOffset is not None or
            self.fullname is not None or
            self.access is not None or
            self.description is not None or
            self.resetValue is not None or
            self.resetMask is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='registerType7', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='registerType7')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='registerType7', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='registerType7'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='registerType7', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_format_string(quote_xml(self.name), input_name='name'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
        if self.baseAddress is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbaseAddress>%s</%sbaseAddress>%s' % (namespace_, self.gds_format_string(quote_xml(self.baseAddress), input_name='baseAddress'), namespace_, eol_))
        if self.addressOffset is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddressOffset>%s</%saddressOffset>%s' % (namespace_, self.gds_format_string(quote_xml(self.addressOffset), input_name='addressOffset'), namespace_, eol_))
        if self.fullname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfullname>%s</%sfullname>%s' % (namespace_, self.gds_format_string(quote_xml(self.fullname), input_name='fullname'), namespace_, eol_))
        if self.access is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saccess>%s</%saccess>%s' % (namespace_, self.gds_format_string(quote_xml(self.access), input_name='access'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description), input_name='description'), namespace_, eol_))
        if self.resetValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetValue>%s</%sresetValue>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetValue), input_name='resetValue'), namespace_, eol_))
        if self.resetMask is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sresetMask>%s</%sresetMask>%s' % (namespace_, self.gds_format_string(quote_xml(self.resetMask), input_name='resetMask'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='registerType7'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.name is not None:
            showIndent(outfile, level)
            outfile.write('name=%s,\n' % quote_python(self.name))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
        if self.baseAddress is not None:
            showIndent(outfile, level)
            outfile.write('baseAddress=%s,\n' % quote_python(self.baseAddress))
        if self.addressOffset is not None:
            showIndent(outfile, level)
            outfile.write('addressOffset=%s,\n' % quote_python(self.addressOffset))
        if self.fullname is not None:
            showIndent(outfile, level)
            outfile.write('fullname=%s,\n' % quote_python(self.fullname))
        if self.access is not None:
            showIndent(outfile, level)
            outfile.write('access=%s,\n' % quote_python(self.access))
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('description=%s,\n' % quote_python(self.description))
        if self.resetValue is not None:
            showIndent(outfile, level)
            outfile.write('resetValue=%s,\n' % quote_python(self.resetValue))
        if self.resetMask is not None:
            showIndent(outfile, level)
            outfile.write('resetMask=%s,\n' % quote_python(self.resetMask))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
        elif nodeName_ == 'baseAddress':
            baseAddress_ = child_.text
            baseAddress_ = self.gds_validate_string(baseAddress_, node, 'baseAddress')
            self.baseAddress = baseAddress_
        elif nodeName_ == 'addressOffset':
            addressOffset_ = child_.text
            addressOffset_ = self.gds_validate_string(addressOffset_, node, 'addressOffset')
            self.addressOffset = addressOffset_
        elif nodeName_ == 'fullname':
            fullname_ = child_.text
            fullname_ = self.gds_validate_string(fullname_, node, 'fullname')
            self.fullname = fullname_
        elif nodeName_ == 'access':
            access_ = child_.text
            access_ = self.gds_validate_string(access_, node, 'access')
            self.access = access_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'resetValue':
            resetValue_ = child_.text
            resetValue_ = self.gds_validate_string(resetValue_, node, 'resetValue')
            self.resetValue = resetValue_
        elif nodeName_ == 'resetMask':
            resetMask_ = child_.text
            resetMask_ = self.gds_validate_string(resetMask_, node, 'resetMask')
            self.resetMask = resetMask_
# end class registerType7


class link_layer_configType(GeneratedsSuper):
    """Name of Link Layer profile - TBD"""
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('inputs', 'inputsType', 0),
        MemberSpec_('phy', 'phyType9', 0),
        MemberSpec_('link_layer_model', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, inputs=None, phy=None, link_layer_model=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        if inputs is None:
            self.inputs = inputsType()
        else:
            self.inputs = inputs
        if phy is None:
            self.phy = phyType9()
        else:
            self.phy = phy
        self.link_layer_model = link_layer_model
    def factory(*args_, **kwargs_):
        if link_layer_configType.subclass:
            return link_layer_configType.subclass(*args_, **kwargs_)
        else:
            return link_layer_configType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_inputs(self): return self.inputs
    def set_inputs(self, inputs): self.inputs = inputs
    inputsProp = property(get_inputs, set_inputs)
    def get_phy(self): return self.phy
    def set_phy(self, phy): self.phy = phy
    phyProp = property(get_phy, set_phy)
    def get_link_layer_model(self): return self.link_layer_model
    def set_link_layer_model(self, link_layer_model): self.link_layer_model = link_layer_model
    link_layer_modelProp = property(get_link_layer_model, set_link_layer_model)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def hasContent_(self):
        if (
            self.inputs is not None or
            self.phy is not None or
            self.link_layer_model is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='link_layer_configType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='link_layer_configType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='link_layer_configType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='link_layer_configType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='link_layer_configType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.inputs is not None:
            self.inputs.export(outfile, level, namespace_, name_='inputs', pretty_print=pretty_print)
        if self.phy is not None:
            self.phy.export(outfile, level, namespace_, name_='phy', pretty_print=pretty_print)
        if self.link_layer_model is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slink_layer_model>%s</%slink_layer_model>%s' % (namespace_, self.gds_format_string(quote_xml(self.link_layer_model), input_name='link_layer_model'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='link_layer_configType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.inputs is not None:
            showIndent(outfile, level)
            outfile.write('inputs=model_.inputsType(\n')
            self.inputs.exportLiteral(outfile, level, name_='inputs')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.phy is not None:
            showIndent(outfile, level)
            outfile.write('phy=model_.phyType9(\n')
            self.phy.exportLiteral(outfile, level, name_='phy')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.link_layer_model is not None:
            showIndent(outfile, level)
            outfile.write('link_layer_model=%s,\n' % quote_python(self.link_layer_model))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'inputs':
            obj_ = inputsType.factory()
            obj_.build(child_)
            self.inputs = obj_
            obj_.original_tagname_ = 'inputs'
        elif nodeName_ == 'phy':
            obj_ = phyType9.factory()
            obj_.build(child_)
            self.phy = obj_
            obj_.original_tagname_ = 'phy'
        elif nodeName_ == 'link_layer_model':
            link_layer_model_ = child_.text
            link_layer_model_ = self.gds_validate_string(link_layer_model_, node, 'link_layer_model')
            self.link_layer_model = link_layer_model_
# end class link_layer_configType


class link_layer_model(GeneratedsSuper):
    """RAIL Configurator data model output. XSD defined in another file"""
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if link_layer_model.subclass:
            return link_layer_model.subclass(*args_, **kwargs_)
        else:
            return link_layer_model(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='link_layer_model', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='link_layer_model')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='link_layer_model', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='link_layer_model'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='link_layer_model', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='link_layer_model'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class link_layer_model


class inputsType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('input', 'inputType8', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, input=None):
        self.original_tagname_ = None
        if input is None:
            self.input = []
        else:
            self.input = input
    def factory(*args_, **kwargs_):
        if inputsType.subclass:
            return inputsType.subclass(*args_, **kwargs_)
        else:
            return inputsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_input(self): return self.input
    def set_input(self, input): self.input = input
    def add_input(self, value): self.input.append(value)
    def insert_input(self, index, value): self.input[index] = value
    inputProp = property(get_input, set_input)
    def hasContent_(self):
        if (
            self.input
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='inputsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='inputsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='inputsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='inputsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='inputsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for input_ in self.input:
            input_.export(outfile, level, namespace_, name_='input', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='inputsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('input=[\n')
        level += 1
        for input_ in self.input:
            showIndent(outfile, level)
            outfile.write('model_.inputType8(\n')
            input_.exportLiteral(outfile, level, name_='inputType8')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'input':
            obj_ = inputType8.factory()
            obj_.build(child_)
            self.input.append(obj_)
            obj_.original_tagname_ = 'input'
# end class inputsType


class inputType8(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('key', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.original_tagname_ = None
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if inputType8.subclass:
            return inputType8.subclass(*args_, **kwargs_)
        else:
            return inputType8(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    keyProp = property(get_key, set_key)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='inputType8', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='inputType8')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='inputType8', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='inputType8'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='inputType8', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key), input_name='key'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='inputType8'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class inputType8


class phyType9(GeneratedsSuper):
    """Name of PHY user selected."""
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('overrides', 'overridesType', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, overrides=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        if overrides is None:
            self.overrides = overridesType()
        else:
            self.overrides = overrides
    def factory(*args_, **kwargs_):
        if phyType9.subclass:
            return phyType9.subclass(*args_, **kwargs_)
        else:
            return phyType9(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_overrides(self): return self.overrides
    def set_overrides(self, overrides): self.overrides = overrides
    overridesProp = property(get_overrides, set_overrides)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def hasContent_(self):
        if (
            self.overrides is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='phyType9', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='phyType9')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='phyType9', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='phyType9'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='phyType9', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.overrides is not None:
            self.overrides.export(outfile, level, namespace_, name_='overrides', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='phyType9'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.overrides is not None:
            showIndent(outfile, level)
            outfile.write('overrides=model_.overridesType(\n')
            self.overrides.exportLiteral(outfile, level, name_='overrides')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'overrides':
            obj_ = overridesType.factory()
            obj_.build(child_)
            self.overrides = obj_
            obj_.original_tagname_ = 'overrides'
# end class phyType9


class overridesType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('override', 'overrideType10', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, override=None):
        self.original_tagname_ = None
        if override is None:
            self.override = []
        else:
            self.override = override
    def factory(*args_, **kwargs_):
        if overridesType.subclass:
            return overridesType.subclass(*args_, **kwargs_)
        else:
            return overridesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_override(self): return self.override
    def set_override(self, override): self.override = override
    def add_override(self, value): self.override.append(value)
    def insert_override(self, index, value): self.override[index] = value
    overrideProp = property(get_override, set_override)
    def hasContent_(self):
        if (
            self.override
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='overridesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='overridesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='overridesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='overridesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='overridesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for override_ in self.override:
            override_.export(outfile, level, namespace_, name_='override', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='overridesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('override=[\n')
        level += 1
        for override_ in self.override:
            showIndent(outfile, level)
            outfile.write('model_.overrideType10(\n')
            override_.exportLiteral(outfile, level, name_='overrideType10')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'override':
            obj_ = overrideType10.factory()
            obj_.build(child_)
            self.override.append(obj_)
            obj_.original_tagname_ = 'override'
# end class overridesType


class overrideType10(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('key', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.original_tagname_ = None
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if overrideType10.subclass:
            return overrideType10.subclass(*args_, **kwargs_)
        else:
            return overrideType10(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    keyProp = property(get_key, set_key)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='overrideType10', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='overrideType10')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='overrideType10', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='overrideType10'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='overrideType10', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key), input_name='key'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='overrideType10'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class overrideType10


class optional_argumentsType11(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('argument', 'argumentType12', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, argument=None):
        self.original_tagname_ = None
        if argument is None:
            self.argument = []
        else:
            self.argument = argument
    def factory(*args_, **kwargs_):
        if optional_argumentsType11.subclass:
            return optional_argumentsType11.subclass(*args_, **kwargs_)
        else:
            return optional_argumentsType11(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_argument(self): return self.argument
    def set_argument(self, argument): self.argument = argument
    def add_argument(self, value): self.argument.append(value)
    def insert_argument(self, index, value): self.argument[index] = value
    argumentProp = property(get_argument, set_argument)
    def hasContent_(self):
        if (
            self.argument
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='optional_argumentsType11', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='optional_argumentsType11')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='optional_argumentsType11', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='optional_argumentsType11'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='optional_argumentsType11', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for argument_ in self.argument:
            argument_.export(outfile, level, namespace_, name_='argument', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='optional_argumentsType11'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('argument=[\n')
        level += 1
        for argument_ in self.argument:
            showIndent(outfile, level)
            outfile.write('model_.argumentType12(\n')
            argument_.exportLiteral(outfile, level, name_='argumentType12')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'argument':
            obj_ = argumentType12.factory()
            obj_.build(child_)
            self.argument.append(obj_)
            obj_.original_tagname_ = 'argument'
# end class optional_argumentsType11


class argumentType12(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('key', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, key=None, value=None):
        self.original_tagname_ = None
        self.key = key
        self.value = value
    def factory(*args_, **kwargs_):
        if argumentType12.subclass:
            return argumentType12.subclass(*args_, **kwargs_)
        else:
            return argumentType12(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_key(self): return self.key
    def set_key(self, key): self.key = key
    keyProp = property(get_key, set_key)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    valueProp = property(get_value, set_value)
    def hasContent_(self):
        if (
            self.key is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='argumentType12', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='argumentType12')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='argumentType12', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='argumentType12'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='argumentType12', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.key is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%skey>%s</%skey>%s' % (namespace_, self.gds_format_string(quote_xml(self.key), input_name='key'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_string(quote_xml(self.value), input_name='value'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='argumentType12'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.key is not None:
            showIndent(outfile, level)
            outfile.write('key=%s,\n' % quote_python(self.key))
        if self.value is not None:
            showIndent(outfile, level)
            outfile.write('value=%s,\n' % quote_python(self.value))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'key':
            key_ = child_.text
            key_ = self.gds_validate_string(key_, node, 'key')
            self.key = key_
        elif nodeName_ == 'value':
            value_ = child_.text
            value_ = self.gds_validate_string(value_, node, 'value')
            self.value = value_
# end class argumentType12


class output_filesType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('file', 'fileType', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, file=None):
        self.original_tagname_ = None
        if file is None:
            self.file = []
        else:
            self.file = file
    def factory(*args_, **kwargs_):
        if output_filesType.subclass:
            return output_filesType.subclass(*args_, **kwargs_)
        else:
            return output_filesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def add_file(self, value): self.file.append(value)
    def insert_file(self, index, value): self.file[index] = value
    fileProp = property(get_file, set_file)
    def hasContent_(self):
        if (
            self.file
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='output_filesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='output_filesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='output_filesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='output_filesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='output_filesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for file_ in self.file:
            file_.export(outfile, level, namespace_, name_='file', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='output_filesType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('file=[\n')
        level += 1
        for file_ in self.file:
            showIndent(outfile, level)
            outfile.write('model_.fileType(\n')
            file_.exportLiteral(outfile, level, name_='fileType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            obj_ = fileType.factory()
            obj_.build(child_)
            self.file.append(obj_)
            obj_.original_tagname_ = 'file'
# end class output_filesType


class fileType(GeneratedsSuper):
    """Filename (e.g. "rail_config.c, rail_config.h")"""
    member_data_items_ = [
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('source_code', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, name=None, source_code=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.source_code = source_code
    def factory(*args_, **kwargs_):
        if fileType.subclass:
            return fileType.subclass(*args_, **kwargs_)
        else:
            return fileType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_source_code(self): return self.source_code
    def set_source_code(self, source_code): self.source_code = source_code
    source_codeProp = property(get_source_code, set_source_code)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    nameProp = property(get_name, set_name)
    def hasContent_(self):
        if (
            self.source_code is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='fileType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='fileType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='fileType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='fileType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='fileType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.source_code is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssource_code>%s</%ssource_code>%s' % (namespace_, self.gds_format_string(quote_xml(self.source_code), input_name='source_code'), namespace_, eol_))
    def exportLiteral(self, outfile, level, name_='fileType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.source_code is not None:
            showIndent(outfile, level)
            outfile.write('source_code=%s,\n' % quote_python(self.source_code))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'source_code':
            source_code_ = child_.text
            source_code_ = self.gds_validate_string(source_code_, node, 'source_code')
            self.source_code = source_code_
# end class fileType


class source_code(GeneratedsSuper):
    """Text of C source code or header file"""
    member_data_items_ = [
    ]
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if source_code.subclass:
            return source_code.subclass(*args_, **kwargs_)
        else:
            return source_code(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='source_code', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='source_code')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='source_code', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='source_code'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='source_code', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='source_code'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            if isinstance(child.tag, str):
                nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
                self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class source_code


GDSClassesMapping = {
    'base_channel_configurations': base_channel_configurationsType,
    'output_files': output_filesType,
    'base_channel_configuration': base_channel_configurationType,
    'profile_inputs': profile_inputsType,
    'phy': phyType9,
    'profile_output_overrides': profile_output_overridesType4,
    'channel_config_entries': channel_config_entriesType,
    'phy_config_base': phy_config_baseType,
    'phy_config_delta_subtract': phy_config_delta_subtractType,
    'link_layer_config': link_layer_configType,
    'optional_arguments': optional_argumentsType,
    'input': inputType8,
    'profile_input_overrides': profile_input_overridesType2,
    'override': overrideType10,
    'channel_config_entry': channel_config_entryType,
    'phy_config_delta_add': phy_config_delta_addType,
    'alternate_phy': alternate_phyType,
    'register': registerType7,
    'argument': argumentType12,
    'inputs': inputsType,
    'overrides': overridesType,
    'file': fileType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName=None, silence=False, xml_string=None):
    if inFileName is not None:
        doc = parsexml_(inFileName)
        rootNode = doc.getroot()
    elif xml_string is not None:
        try:
            rootNode = etree_.fromstring(xml_string, parser=etree_.XMLParser(huge_tree=True))
        except TypeError as te:
            rootNode = etree_.fromstring(xml_string)
    else:
        raise Exception('Nothing to load supplied.')

    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'multi_phy_configuration'
        rootClass = multi_phy_configuration
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('<?xml version="1.0" ?>\n')
##         rootObj.export(
##             sys.stdout, 0, name_=rootTag,
##             namespacedef_='',
##             pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'multi_phy_configuration'
        rootClass = multi_phy_configuration
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
##     if not silence:
##         content = etree_.tostring(
##             rootElement, pretty_print=True,
##             xml_declaration=True, encoding="utf-8")
##         sys.stdout.write(content)
##         sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'multi_phy_configuration'
        rootClass = multi_phy_configuration
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('<?xml version="1.0" ?>\n')
##         rootObj.export(
##             sys.stdout, 0, name_=rootTag,
##             namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'multi_phy_configuration'
        rootClass = multi_phy_configuration
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     if not silence:
##         sys.stdout.write('#from Bindings import *\n\n')
##         sys.stdout.write('import Bindings as model_\n\n')
##         sys.stdout.write('rootObj = model_.rootClass(\n')
##         rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
##         sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "access",
    "addressOffset",
    "alternate_phyType",
    "argumentType",
    "argumentType12",
    "baseAddress",
    "base_channel_configurationType",
    "base_channel_configurationsType",
    "channel_config_entriesType",
    "channel_config_entryType",
    "description",
    "fileType",
    "full_register_model",
    "fullname",
    "inputType",
    "inputType8",
    "inputsType",
    "link_layer_configType",
    "link_layer_model",
    "multi_phy_configuration",
    "optional_argumentsType",
    "optional_argumentsType11",
    "output_filesType",
    "overrideType",
    "overrideType1",
    "overrideType10",
    "overrideType3",
    "overrideType5",
    "overridesType",
    "phyType",
    "phyType9",
    "phy_config_baseType",
    "phy_config_delta_addType",
    "phy_config_delta_subtractType",
    "phy_name_override",
    "profile_input_overridesType",
    "profile_input_overridesType2",
    "profile_inputsType",
    "profile_output_overridesType",
    "profile_output_overridesType4",
    "radio_configurator_output_model",
    "registerType",
    "registerType6",
    "registerType7",
    "resetMask",
    "resetValue",
    "source_code",
    "value"
]
