from pycalcmodel.core.output import ModelOutput, ModelOutputType
from pyradioconfig.parts.common.profiles.lynx_regs import build_modem_regs_panther_lynx_common_part1
from pyradioconfig.parts.common.profiles.lynx_regs import build_modem_regs_panther_lynx_common_part2
from pyradioconfig.parts.common.profiles.lynx_regs import build_modem_regs_lynx_only
from pyradioconfig.parts.common.profiles.sol_regs import build_modem_regs_sol_only

def build_modem_regs_ocelot(model,profile):


    # This function is too big for Jython, so had to split it up into multiple functions
    # NOTE: we are presuming the logical groups of Series 2 registers/fields fit into ONLY the 4 groups below:
        # Panther-only
        # Panther-and-Lynx (but also Ocelot)
        # Lynx-only (but also Ocelot)
        # Ocelot-only
    # otherwise, this logic needs to change to accommodate another logical grouping
    build_modem_regs_panther_lynx_common_part1(model, profile)
    build_modem_regs_panther_lynx_common_part2(model, profile)

    # ALso add Lynx-specific
    build_modem_regs_lynx_only(model, profile)

    # Sol-specific.
    if model.part_family.lower() in ["sol"]:
        build_modem_regs_sol_only(model, profile)

    # Ocelot-Sol-specific.
    if model.part_family.lower() in ["ocelot", "sol", "margay"]:
        build_modem_regs_ocelot_only(model, profile)

    # Ocelot shared
    if model.part_family.lower() in ["ocelot", "bobcat", "sol", "margay","caracal","rainier"]:
        build_modem_regs_ocelot_shared(model, profile)

def build_modem_regs_ocelot_shared(model, profile):
    # For now, presume Ocelot and Lynx register maps are identical.
    # If Ocelot later has regs/fields that Lynx does not have, defined those here

    # Right now, these are all writen here without specific details if these are PTE-owned, RAIL-owned, or otherwise
    # now-to-be-written by Radio Configurator. Other groups may weigh in if any fields should be removed from RC.

    # TODO: add new ocelot-only regs here based on 3/15 RM update
    profile.outputs.append(ModelOutput(model.vars.MODEM_PRE_PREWNDERRORS, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PRE.PREWNDERRORS' ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL3_TIMINGBASESGAIN, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL3.TIMINGBASESGAIN' ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHCHPWRRESTART, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHCHPWRRESTART' ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_LONGRANGE1_PREFILTLEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.LONGRANGE1.PREFILTLEN' ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PREFILTCOEFF_PREFILTCOEFF, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.PREFILTCOEFF.PREFILTCOEFF' ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_COHDSACMPLX, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.COHDSACMPLX' ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SYNCPROPERTIES_STATICSYNCTHRESHEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SYNCPROPERTIES.STATICSYNCTHRESHEN' ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SYNCPROPERTIES_STATICSYNCTHRESH, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SYNCPROPERTIES.STATICSYNCTHRESH' ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHCHPWRLOCK, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHCHPWRLOCK' ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_DSSSCTD, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.DSSSCTD'           ))
#    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_BBSS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.BBSS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_POEPER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.POEPER'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_FOEPREAVG, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.FOEPREAVG'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_LINCORR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.LINCORR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_TDREW, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.TDREW'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_PREBASES, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.PREBASES'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_PSTIMABORT0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.PSTIMABORT0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_PSTIMABORT1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.PSTIMABORT1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_PSTIMABORT2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.PSTIMABORT2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_PSTIMABORT3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.PSTIMABORT3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_ARW, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.ARW'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_TIMTHRESHGAIN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.TIMTHRESHGAIN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_CPLXCORREN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.CPLXCORREN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_DSSS3SYMBOLSYNCEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.DSSS3SYMBOLSYNCEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_TXDBPSKINV, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.TXDBPSKINV'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL6_TXDBPSKRAMPEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL6.TXDBPSKRAMPEN'           ))

    # These don't exist in Series 3 anymore
    if model.part_family.lower() not in ["rainier"]:
        profile.outputs.append(ModelOutput(model.vars.MODEM_ANARAMPCTRL_VMIDCTRL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.ANARAMPCTRL.VMIDCTRL'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_ANARAMPCTRL_MUTEDLY, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.ANARAMPCTRL.MUTEDLY'           ))

    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG4'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG5'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG6'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_INTAFC_FOEPREAVG7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.INTAFC.FOEPREAVG7'           ))
    # Read-only
    # profile.outputs.append(ModelOutput(model.vars.MODEM_POE_POEI, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.POE.POEI'           ))
    # profile.outputs.append(ModelOutput(model.vars.MODEM_POE_POEQ, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.POE.POEQ'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHDYNAMICBBSSEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHDYNAMICBBSSEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHDYNAMICSYNCTHRESH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHDYNAMICSYNCTHRESH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHDYNAMICPRETHRESH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHDYNAMICPRETHRESH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHDYNAMICPRETHRESHSEL, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHDYNAMICPRETHRESHSEL'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHCHPWRTH0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHCHPWRTH0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHCHPWRTH1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHCHPWRTH1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH0_COHCHPWRTH2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH0.COHCHPWRTH2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH1_SYNCTHRESH0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH1.SYNCTHRESH0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH1_SYNCTHRESH1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH1.SYNCTHRESH1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH1_SYNCTHRESH2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH1.SYNCTHRESH2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH1_SYNCTHRESH3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH1.SYNCTHRESH3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_SYNCTHRESHDELTA0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.SYNCTHRESHDELTA0'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_SYNCTHRESHDELTA1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.SYNCTHRESHDELTA1'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_SYNCTHRESHDELTA2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.SYNCTHRESHDELTA2'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_SYNCTHRESHDELTA3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.SYNCTHRESHDELTA3'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_DSAPEAKCHPWRTH, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.DSAPEAKCHPWRTH'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH2_FIXEDCDTHFORIIR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH2.FIXEDCDTHFORIIR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_COHDSAEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.COHDSAEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_COHDSAADDWNDSIZE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.COHDSAADDWNDSIZE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_CDSS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.CDSS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_DSAPEAKCHKEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.DSAPEAKCHKEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_DSAPEAKINDLEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.DSAPEAKINDLEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_DSAPEAKCHPWREN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.DSAPEAKCHPWREN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_LOGICBASEDCOHDEMODGATE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.LOGICBASEDCOHDEMODGATE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_DYNIIRCOEFOPTION, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.DYNIIRCOEFOPTION'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_ONEPEAKQUALEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.ONEPEAKQUALEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_PEAKCHKTIMOUT, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.PEAKCHKTIMOUT'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_COH3_COHDSADETDIS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.COH3.COHDSADETDIS'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTBLETIMING_DISDEMODOF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.VTBLETIMING.DISDEMODOF'           ))
    # profile.outputs.append(ModelOutput(model.vars.MODEM_IF_SOFTRESETDONE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.IF.SOFTRESETDONE'           ))
    # profile.outputs.append(ModelOutput(model.vars.MODEM_IEN_SOFTRESETDONE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.IEN.SOFTRESETDONE'           ))
    # profile.outputs.append(ModelOutput(model.vars.MODEM_STATUS3_COHDSALIVE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.STATUS3.COHDSALIVE'           ))
    # profile.outputs.append(ModelOutput(model.vars.MODEM_STATUS3_COHDSADET, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.STATUS3.COHDSADET'           ))
    # profile.outputs.append(ModelOutput(model.vars.MODEM_STATUS3_SOFTRSTDONE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.STATUS3.SOFTRSTDONE'           ))
    # profile.outputs.append(ModelOutput(model.vars.MODEM_SEQIF_SOFTRESETDONE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SEQIF.SOFTRESETDONE'           ))
    # profile.outputs.append(ModelOutput(model.vars.MODEM_SEQIEN_SOFTRESETDONE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SEQIEN.SOFTRESETDONE'           ))

    profile.outputs.append(ModelOutput(model.vars.MODEM_RXRESTART_FLTRSTEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.RXRESTART.FLTRSTEN'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_RXRESTART_ANTSWRSTFLTTDIS, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.RXRESTART.ANTSWRSTFLTTDIS'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_RXRESTART_RXRESTARTB4PREDET, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.RXRESTART.RXRESTARTB4PREDET'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_RXRESTART_RXRESTARTUPONMARSSI, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.RXRESTART.RXRESTARTUPONMARSSI'))

    if model.part_family.lower() != 'sol':
        #These were removed in Sol
        profile.outputs.append(ModelOutput(model.vars.MODEM_RXRESTART_RXRESTARTMATAP, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.RXRESTART.RXRESTARTMATAP'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_RXRESTART_RXRESTARTMALATCHSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.RXRESTART.RXRESTARTMALATCHSEL'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_RXRESTART_RXRESTARTMACOMPENSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.RXRESTART.RXRESTARTMACOMPENSEL'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_RXRESTART_RXRESTARTMATHRESHOLD, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.RXRESTART.RXRESTARTMATHRESHOLD'))

    profile.outputs.append(ModelOutput(model.vars.MODEM_AFC_AFCGEAR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFC.AFCGEAR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFCADJRX_AFCSCALEM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFCADJRX.AFCSCALEM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFCADJRX_AFCSCALEE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFCADJRX.AFCSCALEE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFCADJTX_AFCSCALEM, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFCADJTX.AFCSCALEM'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_AFCADJTX_AFCSCALEE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.AFCADJTX.AFCSCALEE'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TRECSCFG_TRECSOSR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TRECSCFG.TRECSOSR'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_TRECSCFG_PMOFFSET, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.TRECSCFG.PMOFFSET'           ))

    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING12_COEFF48, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING12.COEFF48'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING12_COEFF49, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING12.COEFF49'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING12_COEFF50, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING12.COEFF50'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING12_COEFF51, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING12.COEFF51'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING13_COEFF52, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING13.COEFF52'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING13_COEFF53, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING13.COEFF53'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING13_COEFF54, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING13.COEFF54'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING13_COEFF55, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING13.COEFF55'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING14_COEFF56, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING14.COEFF56'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING14_COEFF57, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING14.COEFF57'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING14_COEFF58, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING14.COEFF58'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING14_COEFF59, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING14.COEFF59'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING15_COEFF60, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING15.COEFF60'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING15_COEFF61, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING15.COEFF61'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING15_COEFF62, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING15.COEFF62'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SHAPING15_COEFF63, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.SHAPING15.COEFF63'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_FRMSCHTIME_FRMSCHTIME, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.FRMSCHTIME.FRMSCHTIME'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_FRMSCHTIME_PMENDSCHEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.FRMSCHTIME.PMENDSCHEN'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_FRMSCHTIME_PMRSTSYCNEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.FRMSCHTIME.PMRSTSYCNEN'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_FRMSCHTIME_DSARSTSYCNEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.FRMSCHTIME.DSARSTSYCNEN'))
    if model.part_family.lower() not in ["rainier"]: ### removed in Series 3
        profile.outputs.append(ModelOutput(model.vars.MODEM_REALTIMCFE_EXTENSCHBYP, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.REALTIMCFE.EXTENSCHBYP'))
        profile.outputs.append(ModelOutput(model.vars.RAC_IFADCTRIM0_IFADCCLKSEL, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.IFADCTRIM0.IFADCCLKSEL'))
        profile.outputs.append(ModelOutput(model.vars.RAC_LNAMIXTRIM4_LNAMIXRFPKDTHRESHSELHI, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.LNAMIXTRIM4.LNAMIXRFPKDTHRESHSELHI'))
        profile.outputs.append(ModelOutput(model.vars.RAC_LNAMIXTRIM4_LNAMIXRFPKDTHRESHSELLO, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.LNAMIXTRIM4.LNAMIXRFPKDTHRESHSELLO'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM1_SYLODIVLDOTRIMNDIORX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.SYTRIM1.SYLODIVLDOTRIMNDIORX'))
        profile.outputs.append(ModelOutput(model.vars.AGC_LNABOOST_BOOSTLNA, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.LNABOOST.BOOSTLNA'))
        profile.outputs.append(ModelOutput(model.vars.AGC_LNABOOST_LNABWADJBOOST, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.LNABOOST.LNABWADJBOOST'))
        profile.outputs.append(ModelOutput(model.vars.AGC_LNABOOST_LNABWADJ, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.LNABOOST.LNABWADJ'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYMMDCTRL_SYMMDMODERX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.SYMMDCTRL.SYMMDMODERX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_IFADCTRIM1_IFADCENNEGRES, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.IFADCTRIM1.IFADCENNEGRES'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYEN_SYCHPLPENRX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.SYEN.SYCHPLPENRX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM0_SYCHPREPLICACURRADJ, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.SYTRIM0.SYCHPREPLICACURRADJ'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM0_SYCHPSRCENRX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.SYTRIM0.SYCHPSRCENRX'))





    if model.part_family.lower() not in ["bobcat","caracal", "rainier"]:
        profile.outputs.append(ModelOutput(model.vars.RAC_SYNTHENCTRL_MMDPOWERBALANCEDISABLE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYNTHENCTRL.MMDPOWERBALANCEDISABLE'           ))

    if model.part_family.lower() not in ["bobcat","caracal", "rainier"]:
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM1_SYLODIVLDOTRIMCORERX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYTRIM1.SYLODIVLDOTRIMCORERX'           ))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM1_SYLODIVLDOTRIMCORETX, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYTRIM1.SYLODIVLDOTRIMCORETX'           ))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM1_SYLODIVLDOTRIMNDIOTX, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYTRIM1.SYLODIVLDOTRIMNDIOTX'))
    profile.outputs.append(ModelOutput(model.vars.AGC_AGCPERIOD0_PERIODHI, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.AGCPERIOD0.PERIODHI'))
    profile.outputs.append(ModelOutput(model.vars.AGC_AGCPERIOD1_PERIODLOW, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.AGCPERIOD1.PERIODLOW'))
    profile.outputs.append(ModelOutput(model.vars.AGC_AGCPERIOD0_MAXHICNTTHD, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.AGCPERIOD0.MAXHICNTTHD'))
    profile.outputs.append(ModelOutput(model.vars.AGC_AGCPERIOD0_SETTLETIMEIF, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.AGCPERIOD0.SETTLETIMEIF'))
    profile.outputs.append(ModelOutput(model.vars.AGC_AGCPERIOD0_SETTLETIMERF, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.AGCPERIOD0.SETTLETIMERF'))
    profile.outputs.append(ModelOutput(model.vars.AGC_HICNTREGION0_HICNTREGION0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.HICNTREGION0.HICNTREGION0'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_HICNTREGION0_HICNTREGION1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.HICNTREGION0.HICNTREGION1'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_HICNTREGION0_HICNTREGION2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.HICNTREGION0.HICNTREGION2'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_HICNTREGION0_HICNTREGION3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.HICNTREGION0.HICNTREGION3'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_HICNTREGION1_HICNTREGION4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='AGC.HICNTREGION1.HICNTREGION4'           ))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINSTEPLIM0_CFLOOPDEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINSTEPLIM0.CFLOOPDEL'))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINSTEPLIM0_CFLOOPSTEPMAX, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINSTEPLIM0.CFLOOPSTEPMAX'))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINSTEPLIM0_HYST, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINSTEPLIM0.HYST'))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINSTEPLIM0_MAXPWRVAR, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINSTEPLIM0.MAXPWRVAR'))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINSTEPLIM0_TRANRSTAGC, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINSTEPLIM0.TRANRSTAGC'))
    profile.outputs.append(ModelOutput(model.vars.AGC_GAINSTEPLIM1_PNINDEXMAX, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.GAINSTEPLIM1.PNINDEXMAX'))
    #profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT0_LNAMIXRFATT1, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT0.LNAMIXRFATT1'))
    #profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT0_LNAMIXRFATT2, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT0.LNAMIXRFATT2'))
    profile.outputs.append(ModelOutput(model.vars.FRC_TRAILTXDATACTRL_POSTAMBLEEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='FRC.TRAILTXDATACTRL.POSTAMBLEEN'))
    profile.outputs.append(ModelOutput(model.vars.AGC_ANTDIV_GAINMODE, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.ANTDIV.GAINMODE'))
    profile.outputs.append(ModelOutput(model.vars.AGC_ANTDIV_DEBOUNCECNTTHD, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.ANTDIV.DEBOUNCECNTTHD'))

    # Not in Sol.
    if model.part_family.lower() in ["ocelot", "bobcat", "margay","caracal", "rainier"]:
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE00_SET0COEFF0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE00.SET0COEFF0'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE00_SET0COEFF1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE00.SET0COEFF1'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE00_SET0COEFF2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE00.SET0COEFF2'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE01_SET0COEFF3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE01.SET0COEFF3'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE01_SET0COEFF4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE01.SET0COEFF4'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE02_SET0COEFF5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE02.SET0COEFF5'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE02_SET0COEFF6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE02.SET0COEFF6'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE03_SET0COEFF7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE03.SET0COEFF7'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE03_SET0COEFF8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE03.SET0COEFF8'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE04_SET0COEFF9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE04.SET0COEFF9'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE04_SET0COEFF10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE04.SET0COEFF10'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE05_SET0COEFF11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE05.SET0COEFF11'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE05_SET0COEFF12, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE05.SET0COEFF12'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE06_SET0COEFF13, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE06.SET0COEFF13'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE06_SET0COEFF14, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE06.SET0COEFF14'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE10_SET1COEFF0, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE10.SET1COEFF0'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE10_SET1COEFF1, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE10.SET1COEFF1'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE10_SET1COEFF2, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE10.SET1COEFF2'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE11_SET1COEFF3, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE11.SET1COEFF3'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE11_SET1COEFF4, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE11.SET1COEFF4'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE12_SET1COEFF5, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE12.SET1COEFF5'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE12_SET1COEFF6, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE12.SET1COEFF6'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE13_SET1COEFF7, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE13.SET1COEFF7'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE13_SET1COEFF8, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE13.SET1COEFF8'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE14_SET1COEFF9, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE14.SET1COEFF9'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE14_SET1COEFF10, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE14.SET1COEFF10'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE15_SET1COEFF11, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE15.SET1COEFF11'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE15_SET1COEFF12, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE15.SET1COEFF12'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE16_SET1COEFF13, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE16.SET1COEFF13'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCOE16_SET1COEFF14, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCOE16.SET1COEFF14'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCTRL_FWSWCOEFFEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCTRL.FWSWCOEFFEN'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCTRL_FWSELCOEFF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCTRL.FWSELCOEFF'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFCTRL_SWCOEFFEN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CHFCTRL.SWCOEFFEN'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CHFLATENCYCTRL_CHFLATENCY, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.CHFLATENCYCTRL.CHFLATENCY'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMP_DCGAINGEAREN, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMP.DCGAINGEAREN'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMP_DCGAINGEAR, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMP.DCGAINGEAR'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_DCCOMP_DCGAINGEARSMPS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.DCCOMP.DCGAINGEARSMPS'           ))
        profile.outputs.append(ModelOutput(model.vars.MODEM_CTRL5_BBSS, '',         ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.CTRL5.BBSS'           ))

    # Not in Bobcat.
    if model.part_family.lower() in ["ocelot", "sol", "margay"]:
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_BCRDEMODEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.BCRDEMODEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_DIRECTMODE, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.DIRECTMODE'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_RAWSYN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.RAWSYN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_PH0SIZE, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.PH0SIZE'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_LOCKUPBYP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.LOCKUPBYP'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_RAWFASTMA, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.RAWFASTMA'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_SPIKEREMOV, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.SPIKEREMOV'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_RAWFLTSEL, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.RAWFLTSEL'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_PREATH, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.PREATH'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_SKIPSYN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.SKIPSYN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_PMPATTERN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.PMPATTERN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_NONSTDPK, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.NONSTDPK'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_SLICERFAST, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.SLICERFAST'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_DETECTORSEL, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.DETECTORSEL'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_PHSRCSEL, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.PHSRCSEL'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_BBPMDETEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.BBPMDETEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_CONSCHKBYP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.CONSCHKBYP'))
#        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_INVPREATH, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.INVPREATH'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_INVRXBIT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.INVRXBIT'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_MANCHPH, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.MANCHPH'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_PULCORRBYP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.PULCORRBYP'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_OOKFRZEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.OOKFRZEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_RAWGAIN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.RAWGAIN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_MAFREQDWN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.MAFREQDWN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_SQUELCLKEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.SQUELCLKEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_BWPK, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.BWPK'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_DECAYSWAL, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.DECAYSWAL'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_DECAY, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.DECAY'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_ATTACK, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.ATTACK'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_SQUELCH, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.SQUELCH'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_RAWNDEC, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.RAWNDEC'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_BCRDEMODOOK, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.BCRDEMODOOK'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_PKTRUNK, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.PKTRUNK'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL0_BCRNCOFF, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL0.BCRNCOFF'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL0_BCRALIGN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL0.BCRALIGN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL0_DISTOGG, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL0.DISTOGG'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL0_CRSLOW, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL0.CRSLOW'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL0_CRFAST, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL0.CRFAST'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL0_BCRERRRSTEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL0.BCRERRRSTEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL0_BCRFBBYP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL0.BCRFBBYP'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL1_CRGAIN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL1.CRGAIN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL1_CGAINX2, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL1.CRGAINX2'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL1_RXNCOCOMP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL1.RXNCOCOMP'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL1_RXCOMPLAT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL1.RXCOMPLAT'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL1_ESCMIDPT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL1.ESCMIDPT'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL1_DISMIDPT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL1.DISMIDPT'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL1_BCROSR, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL1.BCROSR'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL1_ESTOSREN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL1.ESTOSREN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL1_BCRSWSYCW, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL1.BCRSWSYCW'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL1_PHCOMP2FSK, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL1.PHCOMP2FSK'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRCTRL1_SLICEFBBYP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRCTRL1.SLICEFBBYP'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC0_LARGEFREQERR, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC0.LARGEFREQERR'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC0_AFCGAINOVRFLW, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC0.AFCGAINOVRFLW'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC0_EN2TBEST, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC0.EN2TBEST'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC0_ENAFCCLKSW, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC0.ENAFCCLKSW'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_LGWAIT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.LGWAIT'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_SHWAIT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.SHWAIT'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_GEARSW, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.GEARSW'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_AFCMAEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.AFCMAEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_ENFZPMEND, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.ENFZPMEND'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_NONFRZEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.NONFRZEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_ONESHOTWAITCNT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.ONESHOTWAITCNT'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_ONESHOTAFCEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.ONESHOTAFCEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_SKIPPMDET, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.SKIPPMDET'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_ENAFCFRZ, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.ENAFCFRZ'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_ENAFC, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.ENAFC'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_ENFBPLL, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.ENFBPLL'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_HALFPHCOMP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.HALFPHCOMP'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODAFC1_PMRSTEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODAFC1.PMRSTEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMOD4FSK0_THD4GFSK, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMOD4FSK0.THD4GFSK'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMOD4FSK0_CODE4GFSK, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMOD4FSK0.CODE4GFSK'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMOD4FSK0_PHCOMPBYP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMOD4FSK0.PHCOMPBYP'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMOD4FSK0_EN4GFSK, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMOD4FSK0.EN4GFSK'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMOD4FSK1_PHCOMP4FSK0, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMOD4FSK1.PHCOMP4FSK0'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMOD4FSK1_PHCOMP4FSK1, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMOD4FSK1.PHCOMP4FSK1'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMOD4FSK1_S2PMAP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMOD4FSK1.S2PMAP'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODANT_SKIP2PHTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODANT.SKIP2PHTHD'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODANT_ANWAIT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODANT.ANWAIT'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODANT_AGCGAINUPB, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODANT.AGCGAINUPB'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODANT_SKIP2PH, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODANT.SKIP2PH'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODANT_BYP1P5, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODANT.BYP1P5'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODANT_ANT2PMTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODANT.ANT2PMTHD'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODANT_SWANTTIMER, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODANT.SWANTTIMER'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODANT_BCRDEMODANTDIV, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODANT.BCRDEMODANTDIV'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODRSSI_RSSIARRTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODRSSI.RSSIARRTHD'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODRSSI_MUTERSSICNT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODRSSI.MUTERSSICNT'))
#        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODRSSI_MUTERSSISEL, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODRSSI.MUTERSSISEL'))
#        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODRSSI_RSSIJMPTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODRSSI.RSSIJMPTHD'))
#        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODRSSI_RSSIJMPUP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODRSSI.RSSIJMPUP'))
#        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODRSSI_ENJMPRX, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODRSSI.ENJMPRX'))
#        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODRSSI_ENRSSIJMP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODRSSI.ENRSSIJMP'))
#        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODRSSI_RSSIMASEL, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODRSSI.RSSIMASEL'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODRSSI_RSSIMATAP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODRSSI.RSSIMATAP'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_SCHPRDLO, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.SCHPRDLO'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_SCHPRDHI, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.SCHPRDHI'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_ARRRSTEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.ARRRSTEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_ARRTOLER, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.ARRTOLER'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_DIFF0RSTEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.DIFF0RSTEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_PHSPIKETHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.PHSPIKETHD'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_ARRDETTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.ARRDETTHD'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_SCHFRZEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.SCHFRZEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_EYEXESTEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.EYEXESTEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_EYEXESTFAST, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.EYEXESTFAST'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_ARRDETSRC, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.ARRDETSRC'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_ARRDETEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.ARRDETEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_ARRQPM, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.ARRQPM'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR0_EYEQUALEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR0.EYEQUALEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR1_ARREYEQUAL, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR1.ARREYEQUAL'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR1_EYEOPENTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR1.EYEOPENTHD'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR1_CFEQUALTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR1.CFEQUALTHD'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR1_SYMBWMAX, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR1.SYMBWMAX'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR1_SYMBWMIN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR1.SYMBWMIN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR1_BCRCFESRC, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR1.BCRCFESRC'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR1_ENCFEQUAL, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR1.ENCFEQUAL'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODKSI_BCRKSI1,  '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODKSI.BCRKSI1'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODKSI_BCRKSI2,  '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODKSI.BCRKSI2'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODKSI_BCRKSI3,  '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODKSI.BCRKSI3'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODPMEXP_BCRCFECOSTTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODPMEXP.BCRCFECOSTTHD'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODPMEXP_BCRPHSCALE, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODPMEXP.BCRPHSCALE'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODPMEXP_BCRCFESCHWIN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODPMEXP.BCRCFESCHWIN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODPMEXP_BCRPMACQWIN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODPMEXP.BCRPMACQWIN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODPMEXP_BCRPMEXP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODPMEXP.BCRPMEXP'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODCTRL_MANCHDLY, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODCTRL.MANCHDLY'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_ABPK, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.ABPK'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODOOK_NOISEFLEST, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODOOK.NOISEFLEST'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMOD4FSK1_FDEVCOMPEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMOD4FSK1.FDEVCOMPEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMOD4FSK1_FDEVCOMPRATIO, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMOD4FSK1.FDEVCOMPRATIO'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODRSSI_PRWOFFSET, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODRSSI.PRWOFFSET'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR1_KSICOMPEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR1.KSICOMPEN'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR2_RAWDCHKALWAYON, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR2.RAWDCHKALWAYON'))
        profile.outputs.append(ModelOutput(model.vars.MODEM_BCRDEMODARR2_CONSYMOL, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.BCRDEMODARR2.CONSYMOL'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYDIVCTRL_SYLODIVRADCDIV, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYDIVCTRL.SYLODIVRADCDIV'           ))
        profile.outputs.append(ModelOutput(model.vars.RAC_IFADCTRIM1_IFADCENSUBGMODE, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.IFADCTRIM1.IFADCENSUBGMODE'))
        profile.outputs.append(ModelOutput(model.vars.RAC_IFADCTRIM1_IFADCENXOBYPASS, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.IFADCTRIM1.IFADCENXOBYPASS'))
        profile.outputs.append(ModelOutput(model.vars.RAC_IFADCTRIM1_IFADCTZ, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.IFADCTRIM1.IFADCTZ'))
        profile.outputs.append(ModelOutput(model.vars.RAC_PATRIM3_TXTRIMDREGBLEED, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.PATRIM3.TXTRIMDREGBLEED'           ))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT10_LNAMIXRFATT21, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT10.LNAMIXRFATT21'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT10_LNAMIXRFATT22, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT10.LNAMIXRFATT22'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT11_LNAMIXRFATT23, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT11.LNAMIXRFATT23'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT1_LNAMIXRFATT3, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT1.LNAMIXRFATT3'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT1_LNAMIXRFATT4, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT1.LNAMIXRFATT4'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT2_LNAMIXRFATT5, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT2.LNAMIXRFATT5'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT2_LNAMIXRFATT6, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT2.LNAMIXRFATT6'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT3_LNAMIXRFATT7, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT3.LNAMIXRFATT7'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT3_LNAMIXRFATT8, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT3.LNAMIXRFATT8'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT4_LNAMIXRFATT10, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT4.LNAMIXRFATT10'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT4_LNAMIXRFATT9, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT4.LNAMIXRFATT9'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT5_LNAMIXRFATT11, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT5.LNAMIXRFATT11'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT5_LNAMIXRFATT12, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT5.LNAMIXRFATT12'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT6_LNAMIXRFATT13, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT6.LNAMIXRFATT13'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT6_LNAMIXRFATT14, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT6.LNAMIXRFATT14'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT7_LNAMIXRFATT15, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT7.LNAMIXRFATT15'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT7_LNAMIXRFATT16, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT7.LNAMIXRFATT16'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT8_LNAMIXRFATT17, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT8.LNAMIXRFATT17'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT8_LNAMIXRFATT18, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT8.LNAMIXRFATT18'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT9_LNAMIXRFATT19, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT9.LNAMIXRFATT19'))
        profile.outputs.append(ModelOutput(model.vars.AGC_PNRFATT9_LNAMIXRFATT20, '', ModelOutputType.SVD_REG_FIELD, readable_name='AGC.PNRFATT9.LNAMIXRFATT20'))

        profile.outputs.append(ModelOutput(model.vars.RAC_LNAMIXTRIM0_LNAMIXLNA0CAPSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.LNAMIXTRIM0.LNAMIXLNA0CAPSEL'           ))
        profile.outputs.append(ModelOutput(model.vars.RAC_LNAMIXTRIM1_LNAMIXLNA1CAPSEL, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.LNAMIXTRIM1.LNAMIXLNA1CAPSEL'           ))

     # Not in Bobcat and Sol
    if model.part_family.lower() in ["ocelot", "margay"]:
        profile.outputs.append(ModelOutput(model.vars.RAC_IFADCPLLDCO_IFADCPLLDCOBIASHALF, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.IFADCPLLDCO.IFADCPLLDCOBIASHALF'           ))
        profile.outputs.append(ModelOutput(model.vars.RAC_IFADCPLLDCO_IFADCPLLDCOFILTER, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.IFADCPLLDCO.IFADCPLLDCOFILTER'           ))
        profile.outputs.append(ModelOutput(model.vars.RAC_IFADCPLLDCO_IFADCPLLDCOFULLRATE, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.IFADCPLLDCO.IFADCPLLDCOFULLRATE'           ))
        profile.outputs.append(ModelOutput(model.vars.RAC_IFADCPLLEN_IFADCPLLENXOBYP, '',         ModelOutputType.SVD_REG_FIELD, readable_name='RAC.IFADCPLLEN.IFADCPLLENXOBYP'           ))
        profile.outputs.append(ModelOutput(model.vars.FRC_CTRL_SKIPTXTRAILDATAWHITEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='FRC.CTRL.SKIPTXTRAILDATAWHITEN'))
        profile.outputs.append(ModelOutput(model.vars.FRC_CTRL_SKIPRXSUPSTATEWHITEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='FRC.CTRL.SKIPRXSUPSTATEWHITEN'))
        profile.outputs.append(ModelOutput(model.vars.SEQ_MISC_DIG_RAMP_EN, '', ModelOutputType.SEQ_REG_FIELD,readable_name='SEQ.MISC.DIG_RAMP_EN'))


    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODANTDIV_ANTWAIT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODANTDIV.ANTWAIT'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODANTDIV_SKIP2ANT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODANTDIV.SKIP2ANT'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODANTDIV_SKIPCORRTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODANTDIV.SKIPCORRTHD'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODANTDIV_SKIPRSSITHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODANTDIV.SKIPRSSITHD'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHANTDECSION_RSSICORR0, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHANTDECSION.RSSICORR0'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHANTDECSION_RSSICORR1, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHANTDECSION.RSSICORR1'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHANTDECSION_RSSICORR2, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHANTDECSION.RSSICORR2'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHANTDECSION_RSSICORR3, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHANTDECSION.RSSICORR3'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHANTDECSION_RSSIANDDIVTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHANTDECSION.RSSIANDDIVTHD'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHANTDECSION_CORRANDDIVTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHANTDECSION.CORRANDDIVTHD'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_PMDETEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODCTRL.PMDETEN'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_PMDETTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODCTRL.PMDETTHD'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_REMODEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODCTRL.REMODEN'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_REMODOSR, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODCTRL.REMODOSR'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_REMODDWN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODCTRL.REMODDWN'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_PMTIMLOSEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODCTRL.PMTIMLOSEN'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_PMTIMLOSTHD, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODCTRL.PMTIMLOSTHD'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_RSSIFLTBYP, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM_PHDMODCTRL_RSSIFLTBYP'))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL6_DUALRFPKDDEC, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.CTRL6.DUALRFPKDDEC'))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL6_ENDUALRFPKD, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.CTRL6.ENDUALRFPKD'))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL0_CFLOOPNFADJ, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.CTRL0.CFLOOPNFADJ'))
    profile.outputs.append(ModelOutput(model.vars.AGC_DUALRFPKDTHD0_RFPKDLOWTHD0, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.DUALRFPKDTHD0.RFPKDLOWTHD0'))
    profile.outputs.append(ModelOutput(model.vars.AGC_DUALRFPKDTHD0_RFPKDLOWTHD1, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.DUALRFPKDTHD0.RFPKDLOWTHD1'))
    profile.outputs.append(ModelOutput(model.vars.AGC_DUALRFPKDTHD1_RFPKDHITHD0, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.DUALRFPKDTHD1.RFPKDHITHD0'))
    profile.outputs.append(ModelOutput(model.vars.AGC_DUALRFPKDTHD1_RFPKDHITHD1, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.DUALRFPKDTHD1.RFPKDHITHD1'))
    if model.part_family.lower() not in ["bobcat","caracal","rainier"]:
        profile.outputs.append(ModelOutput(model.vars.RAC_VCOCTRL_VCODETAMPLITUDERX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.VCOCTRL.VCODETAMPLITUDERX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_VCOCTRL_VCODETAMPLITUDETX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.VCOCTRL.VCODETAMPLITUDETX'))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL5_SEQPNUPALLOW, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.CTRL5.SEQPNUPALLOW'))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL5_SEQRFPKDEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.CTRL5.SEQRFPKDEN'))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL7_SUBDEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.CTRL7.SUBDEN'))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL7_SUBINT, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.CTRL7.SUBINT'))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL7_SUBNUM, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.CTRL7.SUBNUM'))
    profile.outputs.append(ModelOutput(model.vars.AGC_CTRL7_SUBPERIOD, '', ModelOutputType.SVD_REG_FIELD,readable_name='AGC.CTRL7.SUBPERIOD'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_REMODOUTSEL, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODCTRL.REMODOUTSEL'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTCORRCFG1_VITERBIKSI3WB, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.VTCORRCFG1.VITERBIKSI3WB'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_VTCORRCFG1_KSI3SWENABLE,  '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.VTCORRCFG1.KSI3SWENABLE'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_BCRTRECSCONC, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODCTRL.BCRTRECSCONC'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_BCRLEGACYCONC, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODCTRL.BCRLEGACYCONC'))

    profile.outputs.append(ModelOutput(model.vars.MODEM_PHDMODCTRL_BCRDETECTOR, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.PHDMODCTRL.BCRDETECTOR'))

    profile.outputs.append(ModelOutput(model.vars.MODEM_SQ_SQEN, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.SQ.SQEN'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SQ_SQTIMOUT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.SQ.SQTIMOUT'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SQEXT_SQSTG3TIMOUT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.SQEXT.SQSTG3TIMOUT'))
    profile.outputs.append(ModelOutput(model.vars.MODEM_SQEXT_SQSTG2TIMOUT, '', ModelOutputType.SVD_REG_FIELD,readable_name='MODEM.SQEXT.SQSTG2TIMOUT'))

    if model.part_family.lower() not in["rainier"]:
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM0_SYTRIMCHPREGAMPBIAS, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYTRIM0.SYTRIMCHPREGAMPBIAS'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM0_SYTRIMCHPREGAMPBW, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYTRIM0.SYTRIMCHPREGAMPBW'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM1_SYTRIMMMDREGAMPBIAS, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYTRIM1.SYTRIMMMDREGAMPBIAS'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM1_SYTRIMMMDREGAMPBW, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYTRIM1.SYTRIMMMDREGAMPBW'))

    if model.part_family.lower() not in ["bobcat","caracal","rainier"]:
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM0_SYCHPCURRRX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.SYTRIM0.SYCHPCURRRX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_RX_LNAMIXLDOLOWCUR, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.RX.LNAMIXLDOLOWCUR'))

    if model.part_family.lower() not in ["viper", "rainier"]:
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM0_SYCHPLEVPSRCRX, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYTRIM0.SYCHPLEVPSRCRX'))

    if model.part_family.lower() not in ["bobcat","caracal","rainier"]:
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM0_SYCHPSRCENTX, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYTRIM0.SYCHPSRCENTX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYEN_SYCHPLPENTX, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.SYEN.SYCHPLPENTX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_RX_SYCHPBIASTRIMBUFRX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.RX.SYCHPBIASTRIMBUFRX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_TX_SYCHPBIASTRIMBUFTX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.TX.SYCHPBIASTRIMBUFTX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM0_SYCHPLEVPSRCTX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.SYTRIM0.SYCHPLEVPSRCTX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_RX_SYPFDFPWENRX, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.RX.SYPFDFPWENRX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_TX_SYPFDFPWENTX, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.TX.SYPFDFPWENTX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_TX_SYPFDCHPLPENTX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.TX.SYPFDCHPLPENTX'))
        if model.part_family.lower() not in ["margay"]:
            #Now owned by PTE for Margay
            profile.outputs.append(ModelOutput(model.vars.RAC_RX_LNAMIXENRFPKDLOTHRESH, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.RX.LNAMIXENRFPKDLOTHRESH'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYTRIM0_SYCHPCURRTX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.SYTRIM0.SYCHPCURRTX'))
        profile.outputs.append(ModelOutput(model.vars.RAC_SYMMDCTRL_SYMMDMODETX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.SYMMDCTRL.SYMMDMODETX'))

    # Rainier only
    if model.part_family.lower() not in ["bobcat","caracal", "rainier"]:
        profile.outputs.append(ModelOutput(model.vars.RAC_RX_SYPFDCHPLPENRX, '', ModelOutputType.SVD_REG_FIELD,readable_name='RAC.RX.SYPFDCHPLPENRX'))

def build_modem_regs_ocelot_only(model, profile):
    profile.outputs.append(ModelOutput(model.vars.MODEM_OOKSHAPING_OOKSHAPINGEN, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.OOKSHAPING.OOKSHAPINGEN'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_OOKSHAPING_OOKSHAPINGSTEP, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.OOKSHAPING.OOKSHAPINGSTEP'           ))
    profile.outputs.append(ModelOutput(model.vars.MODEM_OOKSHAPING_OOKSHAPINGLUTSIZE, '', ModelOutputType.SVD_REG_FIELD, readable_name='MODEM.OOKSHAPING.OOKSHAPINGLUTSIZE'           ))
    profile.outputs.append(ModelOutput(model.vars.RAC_TXRAMP_TXMODEPHASEFLIP, '', ModelOutputType.SVD_REG_FIELD, readable_name='RAC.TXRAMP.TXMODEPHASEFLIP'))
