/***************************************************************************//**
 * @file
 * @brief DMP Tuning and Testing Profiles.
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

#ifndef _DMP_TUNING_PROFILES_H_
#define _DMP_TUNING_PROFILES_H_

#include "app/framework/include/af.h"
#include "dmp-tuning-config.h"

#if (SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_PROFILE == SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_PROFILE_BLE)
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_ZB_ACTIVE_TX_PRIORITY 100
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_ZB_ACTIVE_RX_PRIORITY 255
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_ZB_BACKGROUND_RX_PRIORIY 255
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_ADVERTISEMENT_PRIORITY_MIN 175
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_ADVERTISEMENT_PRIORITY_MAX 127
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_SCAN_PRIORITY_MIN 191
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_SCAN_PRIORITY_MAX 143
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_INIT_PRIORITY_MIN 55
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_INIT_PRIORITY_MAX 15
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_PRIORITY_MIN 135
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_PRIORITY_MAX 0
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_RAIL_MAPPING_OFFSET 16
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_RAIL_MAPPING_RANGE 16

#elif (SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_PROFILE == SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_PROFILE_ZIGBEE)
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_ZB_ACTIVE_TX_PRIORITY 75
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_ZB_ACTIVE_RX_PRIORITY 75
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_ZB_BACKGROUND_RX_PRIORIY 255
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_ADVERTISEMENT_PRIORITY_MIN 175
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_ADVERTISEMENT_PRIORITY_MAX 127
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_SCAN_PRIORITY_MIN 191
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_SCAN_PRIORITY_MAX 143
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_INIT_PRIORITY_MIN 55
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_INIT_PRIORITY_MAX 15
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_PRIORITY_MIN 135
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_PRIORITY_MAX 0
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_RAIL_MAPPING_OFFSET 100
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_RAIL_MAPPING_RANGE 16

#elif (SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_PROFILE == SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_PROFILE_BALANCED)
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_ZB_ACTIVE_TX_PRIORITY 75
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_ZB_ACTIVE_RX_PRIORITY 75
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_ZB_BACKGROUND_RX_PRIORIY 255
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_ADVERTISEMENT_PRIORITY_MIN 175
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_ADVERTISEMENT_PRIORITY_MAX 127
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_SCAN_PRIORITY_MIN 191
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_SCAN_PRIORITY_MAX 143
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_INIT_PRIORITY_MIN 55
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_INIT_PRIORITY_MAX 15
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_PRIORITY_MIN 135
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_CONNECTION_PRIORITY_MAX 0
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_RAIL_MAPPING_OFFSET 0
#define SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_BLE_RAIL_MAPPING_RANGE 255
#endif //SL_ZIGBEE_AF_PLUGIN_DMP_TUNING_PROFILE_BALANCED

#endif // _DMP_TUNING_PROFILES_H_
