/***************************************************************************//**
 * @file
 * @brief Internal APIs and defines for the Device Table plugin.
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

#ifndef SILABS_DEVICE_TABLE_INTERNAL_H
#define SILABS_DEVICE_TABLE_INTERNAL_H

uint8_t sli_zigbee_af_device_table_get_first_endpoint_from_index(uint16_t index);

// Internal APIs for printing device information to the CLI
void sli_zigbee_af_device_table_save(void);
void sli_zigbee_af_device_table_load(void);
void sli_zigbee_af_device_table_print_eui64(uint8_t *eui64);
void sli_zigbee_af_device_table_print_buffer(uint8_t *buffer, uint16_t bufLen);

// Internal APIs for route repair
void sli_zigbee_af_device_table_initiate_route_repair(sl_802154_short_addr_t nodeId);
bool sli_zigbee_af_device_table_should_device_leave(sl_802154_short_addr_t nodeId);

// Internal APIs for writing CIE address to new security sensor
void sli_zigbee_af_device_table_send_cie_address_write(sl_802154_short_addr_t nodeId, uint8_t endpoint);

uint16_t sli_zigbee_af_find_free_device_table_index(void);
void sli_zigbee_af_device_table_init(void);
void sli_zigbee_af_device_table_update_node_id_in_endpoints(sl_802154_short_addr_t oldId, sl_802154_short_addr_t newId);

void sli_zigbee_af_device_table_delete_entry(uint16_t index);

// Callbacks generated by device-table.
void sl_zigbee_af_device_table_state_change_cb(sl_802154_short_addr_t nodeId, uint8_t state);
void sl_zigbee_af_device_table_new_device_cb(sl_802154_long_addr_t eui64);
void sl_zigbee_af_device_table_rejoin_device_cb(sl_802154_long_addr_t newNodeEui64);
void sl_zigbee_af_device_table_device_left_cb(sl_802154_long_addr_t newNodeEui64);
void sl_zigbee_af_device_table_cleared_cb(void);

// new endpoint APIs
void sli_zigbee_af_device_table_copy_device_table_entry(uint16_t fromIndex, uint16_t toIndex);
uint8_t sli_zigbee_af_device_table_number_of_endpoints_from_index(uint16_t index);
sl_zigbee_af_status_t sli_zigbee_af_device_table_add_new_endpoint(uint16_t index, uint8_t newEndpoint);
uint16_t sli_zigbee_af_device_table_find_next_endpoint(uint16_t index);
void sli_zigbee_af_device_table_update_node_id(uint16_t currentNodeId, uint16_t newNodeId);
uint16_t sli_zigbee_af_device_table_find_index_node_id_endpoint(uint16_t nodeId, uint8_t endpoint);
void sli_zigbee_af_device_table_update_device_state(uint16_t index, uint8_t newState);
uint16_t sli_zigbee_af_device_table_find_free_device_table_index(void);
uint16_t sli_zigbee_af_device_table_find_first_endpoint_node_id(uint16_t nodeId);
uint16_t sli_zigbee_af_device_table_find_first_endpoint_ieee(sl_802154_long_addr_t eui64);

#define DEVICE_TABLE_UNKNOWN_ENDPOINT 0

#endif //__DEVICE_TABLE_H
