/***************************************************************************//**
 * @brief Zigbee Network Find (Sub-GHz) component configuration header.
 *\n*******************************************************************************
 * # License
 * <b>Copyright 2020 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

// TODO: EMZIGBEE-6962

// <<< Use Configuration Wizard in Context Menu >>>

// <h>Zigbee Network Find (Sub-GHz) configuration

// <o SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_CUT_OFF_VALUE> Cut-off value (dBm) <-128..127>
// <i> Default: -48
// <i> The maximum noise allowed on a channel to consider for forming a network. For more details, see the "Cut-off value" and "Enable scanning all channels" options in the Network Find plugin.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_CUT_OFF_VALUE   -48

// <o SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_RADIO_TX_POWER> Sub-GHz radio output power <-30..20>
// <i> Default: 3
// <i> The radio output power (in dBm) at which the node will operate. Enabling getting the power from a callback in the Network Find plugin overrides this option.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_RADIO_TX_POWER   3

// <e> Sub-GHz channel masks
// <i> Sub-GHz channels that the network find component will preferentially scan when forming and joining.
// <i> The channels are distributed in 4 pages and each page has certain number of channels as
// <i> Page 28 [26-0], Page 29 [8-0], Page 30 [26-0] and Page 31 [26-0]
// <i> Each channel in each page can be enabled or disabled by their following individual configurations.

// <e SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_CHANNEL_MASK_PAGE_28> Page 28
// <i> Default: 1
// <i> Sub-GHz Page 28 channel enable bit masks.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_CHANNEL_MASK_PAGE_28 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_0> 0
// <i> Default: 1
// <i> Page 28 Channel 0 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_0 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_1> 1
// <i> Default: 1
// <i> Page 28 Channel 1 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_1 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_2> 2
// <i> Default: 1
// <i> Page 28 Channel 2 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_2 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_3> 3
// <i> Default: 1
// <i> Page 28 Channel 3 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_3 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_4> 4
// <i> Default: 1
// <i> Page 28 Channel 4 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_4 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_5> 5
// <i> Default: 1
// <i> Page 28 Channel 5 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_5 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_6> 6
// <i> Default: 1
// <i> Page 28 Channel 6 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_6 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_7> 7
// <i> Default: 1
// <i> Page 28 Channel 7 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_7 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_8> 8
// <i> Default: 1
// <i> Page 28 Channel 8 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_8 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_9> 9
// <i> Default: 1
// <i> Page 28 Channel 9 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_9 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_10> 10
// <i> Default: 1
// <i> Page 28 Channel 10 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_10 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_11> 11
// <i> Default: 1
// <i> Page 28 Channel 11 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_11 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_12> 12
// <i> Default: 1
// <i> Page 28 Channel 12 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_12 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_13> 13
// <i> Default: 1
// <i> Page 28 Channel 13 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_13 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_14> 14
// <i> Default: 1
// <i> Page 28 Channel 14 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_14 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_15> 15
// <i> Default: 1
// <i> Page 28 Channel 15 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_15 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_16> 16
// <i> Default: 1
// <i> Page 28 Channel 16 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_16 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_17> 17
// <i> Default: 1
// <i> Page 28 Channel 17 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_17 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_18> 18
// <i> Default: 1
// <i> Page 28 Channel 18 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_18 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_19> 19
// <i> Default: 1
// <i> Page 28 Channel 19 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_19 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_20> 20
// <i> Default: 1
// <i> Page 28 Channel 20 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_20 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_21> 21
// <i> Default: 1
// <i> Page 28 Channel 21 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_21 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_22> 22
// <i> Default: 1
// <i> Page 28 Channel 22 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_22 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_23> 23
// <i> Default: 1
// <i> Page 28 Channel 23 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_23 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_24> 24
// <i> Default: 1
// <i> Page 28 Channel 24 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_24 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_25> 25
// <i> Default: 1
// <i> Page 28 Channel 25 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_25 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_26> 26
// <i> Default: 1
// <i> Page 28 Channel 26 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_26 1

// </e>

// <e SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_CHANNEL_MASK_PAGE_29> Page 29
// <i> Default: 1
// <i> Sub-GHz Page 29 channel enable bit masks.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_CHANNEL_MASK_PAGE_29 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_0> 0
// <i> Default: 1
// <i> Page 29 Channel 0 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_0 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_1> 1
// <i> Default: 1
// <i> Page 29 Channel 1 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_1 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_2> 2
// <i> Default: 1
// <i> Page 29 Channel 2 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_2 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_3> 3
// <i> Default: 1
// <i> Page 29 Channel 3 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_3 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_4> 4
// <i> Default: 1
// <i> Page 29 Channel 4 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_4 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_5> 5
// <i> Default: 1
// <i> Page 29 Channel 5 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_5 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_6> 6
// <i> Default: 1
// <i> Page 29 Channel 6 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_6 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_7> 7
// <i> Default: 1
// <i> Page 29 Channel 7 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_7 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_8> 8
// <i> Default: 0
// <i> Page 29 Channel 8 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_8 0

// </e>

// <e SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_CHANNEL_MASK_PAGE_30> Page 30
// <i> Default: 1
// <i> Sub-GHz Page 30 channel enable bit masks.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_CHANNEL_MASK_PAGE_30 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_0> 0
// <i> Default: 1
// <i> Page 30 Channel 0 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_0 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_1> 1
// <i> Default: 1
// <i> Page 30 Channel 1 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_1 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_2> 2
// <i> Default: 1
// <i> Page 30 Channel 2 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_2 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_3> 3
// <i> Default: 1
// <i> Page 30 Channel 3 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_3 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_4> 4
// <i> Default: 1
// <i> Page 30 Channel 4 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_4 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_5> 5
// <i> Default: 1
// <i> Page 30 Channel 5 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_5 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_6> 6
// <i> Default: 1
// <i> Page 30 Channel 6 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_6 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_7> 7
// <i> Default: 1
// <i> Page 30 Channel 7 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_7 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_8> 8
// <i> Default: 1
// <i> Page 30 Channel 8 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_8 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_9> 9
// <i> Default: 1
// <i> Page 30 Channel 9 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_9 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_10> 10
// <i> Default: 1
// <i> Page 30 Channel 10 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_10 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_11> 11
// <i> Default: 1
// <i> Page 30 Channel 11 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_11 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_12> 12
// <i> Default: 1
// <i> Page 30 Channel 12 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_12 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_13> 13
// <i> Default: 1
// <i> Page 30 Channel 13 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_13 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_14> 14
// <i> Default: 0
// <i> Page 30 Channel 14 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_14 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_15> 15
// <i> Default: 0
// <i> Page 30 Channel 15 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_15 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_16> 16
// <i> Default: 0
// <i> Page 30 Channel 16 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_16 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_17> 17
// <i> Default: 0
// <i> Page 30 Channel 17 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_17 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_18> 18
// <i> Default: 0
// <i> Page 30 Channel 18 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_18 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_19> 19
// <i> Default: 0
// <i> Page 30 Channel 19 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_19 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_20> 20
// <i> Default: 0
// <i> Page 30 Channel 20 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_20 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_21> 21
// <i> Default: 0
// <i> Page 30 Channel 21 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_21 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_22> 22
// <i> Default: 0
// <i> Page 30 Channel 22 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_22 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_23> 23
// <i> Default: 0
// <i> Page 30 Channel 23 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_23 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_24> 24
// <i> Default: 0
// <i> Page 30 Channel 24 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_24 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_25> 25
// <i> Default: 0
// <i> Page 30 Channel 25 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_25 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_26> 26
// <i> Default: 0
// <i> Page 30 Channel 26 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_26 0

// </e>

// <e SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_CHANNEL_MASK_PAGE_31> Page 31
// <i> Default: 1
// <i> Sub-GHz Page 31 channel enable bit masks.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_CHANNEL_MASK_PAGE_31 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_0> 0
// <i> Default: 1
// <i> Page 31 Channel 0 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_0 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_1> 1
// <i> Default: 1
// <i> Page 31 Channel 1 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_1 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_2> 2
// <i> Default: 1
// <i> Page 31 Channel 2 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_2 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_3> 3
// <i> Default: 1
// <i> Page 31 Channel 3 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_3 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_4> 4
// <i> Default: 1
// <i> Page 31 Channel 4 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_4 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_5> 5
// <i> Default: 1
// <i> Page 31 Channel 5 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_5 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_6> 6
// <i> Default: 1
// <i> Page 31 Channel 6 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_6 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_7> 7
// <i> Default: 1
// <i> Page 31 Channel 7 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_7 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_8> 8
// <i> Default: 1
// <i> Page 31 Channel 8 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_8 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_9> 9
// <i> Default: 1
// <i> Page 31 Channel 9 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_9 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_10> 10
// <i> Default: 1
// <i> Page 31 Channel 10 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_10 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_11> 11
// <i> Default: 1
// <i> Page 31 Channel 11 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_11 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_12> 12
// <i> Default: 1
// <i> Page 31 Channel 12 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_12 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_13> 13
// <i> Default: 0
// <i> Page 31 Channel 13 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_13 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_14> 14
// <i> Default: 0
// <i> Page 31 Channel 14 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_14 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_15> 15
// <i> Default: 0
// <i> Page 31 Channel 15 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_15 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_16> 16
// <i> Default: 0
// <i> Page 31 Channel 16 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_16 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_17> 17
// <i> Default: 0
// <i> Page 31 Channel 17 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_17 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_18> 18
// <i> Default: 0
// <i> Page 31 Channel 18 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_18 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_19> 19
// <i> Default: 0
// <i> Page 31 Channel 19 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_19 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_20> 20
// <i> Default: 0
// <i> Page 31 Channel 20 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_20 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_21> 21
// <i> Default: 0
// <i> Page 31 Channel 21 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_21 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_22> 22
// <i> Default: 0
// <i> Page 31 Channel 22 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_22 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_23> 23
// <i> Default: 0
// <i> Page 31 Channel 23 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_23 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_24> 24
// <i> Default: 0
// <i> Page 31 Channel 24 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_24 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_25> 25
// <i> Default: 0
// <i> Page 31 Channel 25 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_25 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_26> 26
// <i> Default: 0
// <i> Page 31 Channel 26 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_26 0

// </e>

// </e>
#define PAGE_28_CHANNEL_MASK ((SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_0 << 0) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_1 << 1)       \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_2 << 2) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_3 << 3)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_4 << 4) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_5 << 5)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_6 << 6) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_7 << 7)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_8 << 8) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_0 << 9)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_10 << 10) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_11 << 11) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_12 << 12) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_13 << 13) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_14 << 14) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_15 << 15) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_16 << 16) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_17 << 17) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_18 << 18) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_19 << 19) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_20 << 20) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_21 << 21) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_22 << 22) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_23 << 23) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_24 << 24) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_25 << 25) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_MASK_CHANNEL_26 << 26))

#define PAGE_29_CHANNEL_MASK ((SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_0 << 0) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_1 << 1)   \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_2 << 2) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_3 << 3) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_4 << 4) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_5 << 5) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_6 << 6) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_7 << 7) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_MASK_CHANNEL_8 << 8))

#define PAGE_30_CHANNEL_MASK ((SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_0 << 0) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_1 << 1)       \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_2 << 2) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_3 << 3)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_4 << 4) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_5 << 5)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_6 << 6) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_7 << 7)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_8 << 8) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_0 << 9)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_10 << 10) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_11 << 11) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_12 << 12) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_13 << 13) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_14 << 14) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_15 << 15) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_16 << 16) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_17 << 17) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_18 << 18) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_19 << 19) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_20 << 20) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_21 << 21) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_22 << 22) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_23 << 23) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_24 << 24) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_25 << 25) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_MASK_CHANNEL_26 << 26))

#define PAGE_31_CHANNEL_MASK ((SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_0 << 0) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_1 << 1)       \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_2 << 2) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_3 << 3)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_4 << 4) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_5 << 5)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_6 << 6) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_7 << 7)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_8 << 8) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_0 << 9)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_10 << 10) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_11 << 11) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_12 << 12) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_13 << 13) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_14 << 14) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_15 << 15) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_16 << 16) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_17 << 17) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_18 << 18) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_19 << 19) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_20 << 20) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_21 << 21) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_22 << 22) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_23 << 23) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_24 << 24) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_25 << 25) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_MASK_CHANNEL_26 << 26))

#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_CHANNEL_MASK     { PAGE_28_CHANNEL_MASK, PAGE_29_CHANNEL_MASK, PAGE_30_CHANNEL_MASK, PAGE_31_CHANNEL_MASK }

// <e> All Sub-GHz channels
// <i> All usable Sub-GHz channels.
// <i> The channels are distributed in 4 pages and each page has certain number of channels as
// <i> Page 28 [26-0], Page 29 [8-0], Page 30 [26-0] and Page 31 [26-0]
// <i> Please note that the usable set depends on the locale (see the R22 specification). The default set is for the GB market.
// <i> To enable the set for a different locale, each of the channels can be enabled/disabled using the folowing configuration.
// <e SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_ALL_CHANNELS_PAGE_28> Page 28
// <i> Default: 1
// <i> All Sub-GHz channels page 28 bits masks.
// <i> Based on the locale, use the following individual bit masks to enable disable creating the set.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_ALL_CHANNELS_PAGE_28 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_0> 0
// <i> Default: 1
// <i> Page 28 Channel 0 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_0 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_1> 1
// <i> Default: 1
// <i> Page 28 Channel 1 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_1 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_2> 2
// <i> Default: 1
// <i> Page 28 Channel 2 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_2 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_3> 3
// <i> Default: 1
// <i> Page 28 Channel 3 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_3 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_4> 4
// <i> Default: 1
// <i> Page 28 Channel 4 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_4 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_5> 5
// <i> Default: 1
// <i> Page 28 Channel 5 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_5 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_6> 6
// <i> Default: 1
// <i> Page 28 Channel 6 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_6 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_7> 7
// <i> Default: 1
// <i> Page 28 Channel 7 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_7 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_8> 8
// <i> Default: 1
// <i> Page 28 Channel 8 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_8 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_9> 9
// <i> Default: 1
// <i> Page 28 Channel 9 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_9 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_10> 10
// <i> Default: 1
// <i> Page 28 Channel 10 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_10 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_11> 11
// <i> Default: 1
// <i> Page 28 Channel 11 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_11 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_12> 12
// <i> Default: 1
// <i> Page 28 Channel 12 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_12 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_13> 13
// <i> Default: 1
// <i> Page 28 Channel 13 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_13 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_14> 14
// <i> Default: 1
// <i> Page 28 Channel 14 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_14 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_15> 15
// <i> Default: 1
// <i> Page 28 Channel 15 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_15 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_16> 16
// <i> Default: 1
// <i> Page 28 Channel 16 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_16 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_17> 17
// <i> Default: 1
// <i> Page 28 Channel 17 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_17 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_18> 18
// <i> Default: 1
// <i> Page 28 Channel 18 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_18 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_19> 19
// <i> Default: 1
// <i> Page 28 Channel 19 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_19 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_20> 20
// <i> Default: 1
// <i> Page 28 Channel 20 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_20 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_21> 21
// <i> Default: 1
// <i> Page 28 Channel 21 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_21 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_22> 22
// <i> Default: 1
// <i> Page 28 Channel 22 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_22 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_23> 23
// <i> Default: 1
// <i> Page 28 Channel 23 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_23 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_24> 24
// <i> Default: 1
// <i> Page 28 Channel 24 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_24 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_25> 25
// <i> Default: 1
// <i> Page 28 Channel 25 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_25 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_26> 26
// <i> Default: 1
// <i> Page 28 Channel 26 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_26 1

// </e>

// <e SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_ALL_CHANNELS_PAGE_29> Page 29
// <i> Default: 1
// <i> All Sub-GHz channels page 29 bits masks.
// <i> Based on the locale, use the following individual bit masks to enable or disable creating the required channel set.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_ALL_CHANNELS_PAGE_29 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_0> 0
// <i> Default: 1
// <i> Page 29 channel 0 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_0 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_1> 1
// <i> Default: 1
// <i> Page 29 channel 1 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_1 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_2> 2
// <i> Default: 1
// <i> Page 29 channel 2 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_2 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_3> 3
// <i> Default: 1
// <i> Page 29 channel 3 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_3 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_4> 4
// <i> Default: 1
// <i> Page 29 channel 4 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_4 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_5> 5
// <i> Default: 1
// <i> Page 29 channel 5 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_5 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_6> 6
// <i> Default: 1
// <i> Page 29 channel 6 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_6 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_7> 7
// <i> Default: 1
// <i> Page 29 channel 7 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_7 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_8> 8
// <i> Default: 0
// <i> Page 29 channel 8 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_8 0

// </e>

// <e SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_ALL_CHANNELS_PAGE_30> Page 30
// <i> Default: 1
// <i> All Sub-GHz channels page 30 bits masks.
// <i> Based on the locale, use the following individual bit masks to enable or disable creating the required channel set.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_ALL_CHANNELS_PAGE_30 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_0> 0
// <i> Default: 1
// <i> Page 30 channel 0 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_0 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_1> 1
// <i> Default: 1
// <i> Page 30 channel 1 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_1 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_2> 2
// <i> Default: 1
// <i> Page 30 channel 2 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_2 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_3> 3
// <i> Default: 1
// <i> Page 30 channel 3 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_3 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_4> 4
// <i> Default: 1
// <i> Page 30 channel 4 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_4 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_5> 5
// <i> Default: 1
// <i> Page 30 channel 5 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_5 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_6> 6
// <i> Default: 1
// <i> Page 30 channel 6 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_6 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_7> 7
// <i> Default: 1
// <i> Page 30 channel 7 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_7 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_8> 8
// <i> Default: 1
// <i> Page 30 channel 8 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_8 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_9> 9
// <i> Default: 1
// <i> Page 30 channel 9 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_9 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_10> 10
// <i> Default: 1
// <i> Page 30 channel 10 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_10 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_11> 11
// <i> Default: 1
// <i> Page 30 channel 11 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_11 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_12> 12
// <i> Default: 1
// <i> Page 30 channel 12 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_12 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_13> 13
// <i> Default: 1
// <i> Page 30 channel 13 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_13 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_14> 14
// <i> Default: 0
// <i> Page 30 channel 14 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_14 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_15> 15
// <i> Default: 0
// <i> Page 30 channel 15 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_15 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_16> 16
// <i> Default: 0
// <i> Page 30 channel 16 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_16 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_17> 17
// <i> Default: 0
// <i> Page 30 channel 17 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_17 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_18> 18
// <i> Default: 0
// <i> Page 30 channel 18 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_18 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_19> 19
// <i> Default: 0
// <i> Page 30 channel 19 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_19 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_20> 20
// <i> Default: 0
// <i> Page 30 channel 20 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_20 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_21> 21
// <i> Default: 0
// <i> Page 30 channel 21 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_21 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_22> 22
// <i> Default: 0
// <i> Page 30 channel 22 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_22 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_23> 23
// <i> Default: 0
// <i> Page 30 channel 23 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_23 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_24> 24
// <i> Default: 0
// <i> Page 30 channel 24 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_24 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_25> 25
// <i> Default: 0
// <i> Page 30 channel 25 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_25 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_26> 26
// <i> Default: 0
// <i> Page 30 channel 26 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_26 0

// </e>

// <e SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_ALL_CHANNEL_PAGE_31> Page 31
// <i> Default: 1
// <i> All Sub-GHz channels page 31 bits masks.
// <i> Based on the locale, use the following individual bit masks to enable or disable creating the required channel set.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_ALL_CHANNEL_PAGE_31 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_0> 0
// <i> Default: 1
// <i> Page 31 channel 0 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_0 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_1> 1
// <i> Default: 1
// <i> Page 31 channel 1 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_1 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_2> 2
// <i> Default: 1
// <i> Page 31 channel 2 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_2 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_3> 3
// <i> Default: 1
// <i> Page 31 channel 3 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_3 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_4> 4
// <i> Default: 1
// <i> Page 31 channel 4 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_4 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_5> 5
// <i> Default: 1
// <i> Page 31 channel 5 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_5 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_6> 6
// <i> Default: 1
// <i> Page 31 channel 6 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_6 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_7> 7
// <i> Default: 1
// <i> Page 31 channel 7 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_7 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_8> 8
// <i> Default: 1
// <i> Page 31 channel 8 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_8 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_9> 9
// <i> Default: 1
// <i> Page 31 channel 9 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_9 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_10> 10
// <i> Default: 1
// <i> Page 31 channel 10 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_10 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_11> 11
// <i> Default: 1
// <i> Page 31 channel 11 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_11 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_12> 12
// <i> Default: 1
// <i> Page 31 channel 12 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_12 1

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_13> 13
// <i> Default: 0
// <i> Page 31 channel 13 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_13 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_14> 14
// <i> Default: 0
// <i> Page 31 channel 14 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_14 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_15> 15
// <i> Default: 0
// <i> Page 31 channel 15 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_15 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_16> 16
// <i> Default: 0
// <i> Page 31 channel 16 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_16 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_17> 17
// <i> Default: 0
// <i> Page 31 channel 17 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_17 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_18> 18
// <i> Default: 0
// <i> Page 31 channel 18 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_18 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_19> 19
// <i> Default: 0
// <i> Page 31 channel 19 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_19 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_20> 20
// <i> Default: 0
// <i> Page 31 channel 20 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_20 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_21> 21
// <i> Default: 0
// <i> Page 31 channel 21 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_21 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_22> 22
// <i> Default: 0
// <i> Page 31 channel 22 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_22 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_23> 23
// <i> Default: 0
// <i> Page 31 channel 23 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_23 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_24> 24
// <i> Default: 0
// <i> Page 31 channel 24 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_24 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_25> 25
// <i> Default: 0
// <i> Page 31 channel 25 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_25 0

// <q SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_26> 26
// <i> Default: 0
// <i> Page 31 channel 26 enable mask.
#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_26 0

// </e>

// </e>

#define PAGE_28_ALL_CHANNELS ((SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_0 << 0) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_1 << 1)       \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_2 << 2) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_3 << 3)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_4 << 4) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_5 << 5)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_6 << 6) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_7 << 7)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_8 << 8) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_0 << 9)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_10 << 10) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_11 << 11) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_12 << 12) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_13 << 13) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_14 << 14) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_15 << 15) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_16 << 16) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_17 << 17) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_18 << 18) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_19 << 19) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_20 << 20) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_21 << 21) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_22 << 22) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_23 << 23) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_24 << 24) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_25 << 25) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_28_CHANNEL_26 << 26))

#define PAGE_29_ALL_CHANNELS ((SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_0 << 0) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_1 << 1)   \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_2 << 2) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_3 << 3) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_4 << 4) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_5 << 5) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_6 << 6) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_7 << 7) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_29_CHANNEL_8 << 8))

#define PAGE_30_ALL_CHANNELS ((SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_0 << 0) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_1 << 1)       \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_2 << 2) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_3 << 3)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_4 << 4) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_5 << 5)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_6 << 6) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_7 << 7)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_8 << 8) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_0 << 9)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_10 << 10) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_11 << 11) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_12 << 12) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_13 << 13) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_14 << 14) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_15 << 15) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_16 << 16) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_17 << 17) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_18 << 18) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_19 << 19) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_20 << 20) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_21 << 21) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_22 << 22) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_23 << 23) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_24 << 24) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_25 << 25) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_30_CHANNEL_26 << 26))

#define PAGE_31_ALL_CHANNELS ((SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_0 << 0) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_1 << 1)       \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_2 << 2) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_3 << 3)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_4 << 4) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_5 << 5)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_6 << 6) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_7 << 7)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_8 << 8) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_0 << 9)     \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_10 << 10) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_11 << 11) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_12 << 12) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_13 << 13) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_14 << 14) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_15 << 15) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_16 << 16) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_17 << 17) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_18 << 18) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_19 << 19) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_20 << 20) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_21 << 21) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_22 << 22) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_23 << 23) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_24 << 24) | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_25 << 25) \
                              | (SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_PAGE_31_CHANNEL_26 << 26))

#define SL_ZIGBEE_AF_PLUGIN_NETWORK_FIND_SUB_GHZ_ALL_CHANNELS_MASK { PAGE_28_ALL_CHANNELS, PAGE_29_ALL_CHANNELS, PAGE_30_ALL_CHANNELS, PAGE_31_ALL_CHANNELS }

// </h>

// <<< end of configuration section >>>
