/***************************************************************************//**
 * @file
 * @brief Defines for the Zigbee Event Logger component, which describes various
 * events that can be recorded and retrieved for user inspection.
 *******************************************************************************
 * # License
 * <b>Copyright 2021 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/
//
// *** Generated file. Do not edit! ***
// Generated by: generate-zigbee-logger-files.py -y zigbee_logger.yaml

// This file provides weak definitions when the Zigbee
// Event Logger component is not included.

#include "stack/include/sl_zigbee.h"

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_boot_event(uint32_t bootCount, uint16_t resetType)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_join_network(sl_802154_pan_id_t panId, uint8_t channelNumber, uint8_t page, uint8_t *extendedPanId)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_trust_center_rejoin(uint32_t channelMask, sl_zigbee_rejoin_reason_t reason)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_secure_rejoin(uint32_t channelMask, sl_zigbee_rejoin_reason_t reason)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_leave_without_rejoin(sl_802154_short_addr_t sourceNode, sl_zigbee_leave_reason_t reason)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_leave_with_rejoin(sl_802154_short_addr_t sourceNode, sl_zigbee_leave_reason_t reason)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_trust_center_link_key_change(void)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_network_key_sequence_change(uint8_t sequence)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_reset(uint8_t resetCode, uint8_t extendedReason)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_channel_change(uint8_t page, uint8_t channel)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_parent_change(sl_802154_short_addr_t parentNodeId, sl_802154_long_addr_t parentEui64)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_duty_cycle_change(sl_zigbee_duty_cycle_state_t state, sl_zigbee_duty_cycle_hecto_pct_t limitThreshold, sl_zigbee_duty_cycle_hecto_pct_t criticalThreshold, sl_zigbee_duty_cycle_hecto_pct_t suspendedLimit)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_child_added(sl_802154_short_addr_t childNodeId, sl_802154_long_addr_t childEui64)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_child_removed(sl_802154_short_addr_t childNodeId, sl_802154_long_addr_t childEui64)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_child_timed_out(sl_802154_short_addr_t childNodeId, sl_802154_long_addr_t childEui64)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_stack_status(sl_status_t status)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_time_sync(uint32_t utcTime, uint32_t secondsSinceBoot)
     )
{
}

WEAK(void sl_zigbee_af_zig_bee_event_logger_add_trust_center_join_decision(sl_802154_short_addr_t nodeId, uint8_t decision)
     )
{
}
