/**
 * \file doc_rng.h
 *
 * \brief Random number generator (RNG) module documentation file.
 */
/*
 *
 *  Copyright The Mbed TLS Contributors
 *  SPDX-License-Identifier: Apache-2.0
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"); you may
 *  not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * @addtogroup rng_module Random number generator (RNG) module
 *
 * The Random number generator (RNG) module provides random number
 * generation, see \c mbedtls_ctr_drbg_random().
 *
 * The block-cipher counter-mode based deterministic random
 * bit generator (CTR_DBRG) as specified in NIST SP800-90. It needs an external
 * source of entropy. For these purposes \c mbedtls_entropy_func() can be used.
 * This is an implementation based on a simple entropy accumulator design.
 *
 * Meaning that there seems to be no practical algorithm that can guess
 * the next bit with a probability larger than 1/2 in an output sequence.
 *
 * This module can be used to generate random numbers.
 *
 * @section sl_entropy Silicon Labs Default Entropy Source Plugin
 * This plugin supports using the default entropy source(s) on Silicon Labs devices, and plugs
 * in to mbed TLS' entropy collector interface when enabled.
 *
 * This plugin can be enabled by selecting <b>Mbed TLS support for default hardware entropy source</b> component from Platform Security category.
 *
 * @subsection sl_rng Silicon Labs Hardware Entropy Source Plugins
 * These plugins support getting hardware-provided entropy, and provide an implementation
 * of \ref mbedtls_hardware_poll, which the mbed TLS DRBG entropy collector interfaces
 * with for collector updates.
 *
 * @subsubsection sl_trng_entropy True Random Number Generator (TRNG)
 * The TRNG peripheral collects data from from a dedicated NIST-800-90B compliant source. The TRNG peripheral may
 * either be stand-alone or integrated in the SE or CRYPTOACC peripheral depending on the target device. It is
 * used automatically on compatible devices for entropy collection through mbed TLS when
 * the \ref sl_entropy is enabled.
 *
 * @subsubsection sl_rail_entropy Radio (RAIL) Entropy Source
 * The RAIL (radio) entropy source is used as a fallback entropy source
 * for mbedTLS, which is used on devices that do not have a functional TRNG. This
 * would provide entropy for applications needing random numbers or applications
 * indirectly using mbedTLS modules that depend on the random number generation
 * interfaces of mbed TLS, even when a TRNG is not present or accessible.
 * It does, however, require that the part supports radio communications, and that
 * the Silicon Labs RAIL library is compiled in to and initialised by the application.
 *
 * Fallback mode is used automatically when the \ref sl_entropy is enabled and the
 * device has a radio module, but no functional TRNG.
 *
 * \note
 * The user is responsible for initializing the radio properly before calling
 * into mbedtls API functions that will use the RAIL entropy module. Normally
 * the radio initialization is performed by calling the RAIL API. The wireless
 * stacks from Silicon Labs perform radio initialization internally, in which
 * case the user should just make sure the wireless stacks initializes before
 * user code can call into mbedtls API functions that will use the RAIL entropy
 * module.
 *
 * @subsubsection sl_adc_entropy ADC Entropy Source Plugin
 * This plugin supports getting entropy from a Silicon Labs ADC peripheral, instead of
 * the default entropy source. ADC entropy collection is not automatically added to the
 * mbed TLS entropy collector upon inclusion of this plugin, so if this is to be used with
 * the mbed TLS DRBG collector, or for use in mbed TLS modules relying on entropy, the user
 * needs to take extra steps in order to correctly set up the plugin.
 *
 * This plugin currently only supports the ADC peripheral on Series-1 devices. See @ref sl_entropy_adc for more details.
 *
 * @subsection sl_nv_entropy Mbed TLS Support for non-volatile entropy seed
 * In absence of one of the hardware entropy sources, the default entropy source plugin
 * falls back to generating entropy based off of a non-volatile seed.
 *
 * This functionality is dependent on having a NVM3 default instance included in the
 * application, since that is where the seed gets stored. On first boot, a seed gets
 * generated by hashing device-unique information. On subsequent cycles, the seed gets
 * rolled over and mixed with potential other entropy sources, meaning that the amount
 * of reboot cycles and reinitialisations of the entropy collector becomes part of the entropy.
 *
 * \warning The seed generated at first boot is considered low quality. If high quality
 *          entropy is required, but the device does not support any of the
 *          \ref sl_rng then the application developer is strongly encouraged to write
 *          a high-quality seed during factory production by calling `mbedtls_nv_seed_write`
 *          and providing a true-random seed of size #MBEDTLS_ENTROPY_BLOCK_SIZE
 *
 * \warning Users are strongly encouraged to look into using ADC entropy if at all
 *          possible for their application. See \ref sl_adc_entropy and AN1311.
 */
