/*
 *  Copyright (c) 2020, The OpenThread Authors.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the copyright holder nor the
 *     names of its contributors may be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @file
 * @brief
 *  This file defines the Doxygen group structure for OpenThread documentation.
 */

/**
 * @defgroup api                      API
 * @brief
 *   This module includes the application programming interface to the OpenThread stack.
 *
 * @{
 *
 * @defgroup api-error                Error
 *
 * @defgroup api-execution            Execution
 *
 * @{
 *
 * @defgroup api-instance             Instance
 * @defgroup api-tasklets             Tasklets
 *
 * @}
 *
 * @defgroup api-net                  IPv6 Networking
 * @{
 *
 * @defgroup api-ble-secure           BLE Secure
 * @defgroup api-dns                  DNS
 * @defgroup api-dnssd-server         DNS-SD Server
 * @defgroup api-icmp6                ICMPv6
 * @defgroup api-ip6                  IPv6
 * @defgroup api-mdns                 Multicast DNS
 * @defgroup api-nat64                NAT64
 * @defgroup api-srp                  SRP
 * @defgroup api-ping-sender          Ping Sender
 *
 * @defgroup api-tcp-group            TCP
 *
 * @{
 *
 * @defgroup api-tcp                  TCP
 * @defgroup api-tcp-ext              TCP Abstractions
 *
 * @}
 *
 * @defgroup api-udp-group            UDP
 *
 * @{
 *
 * @defgroup api-udp                  UDP
 * @defgroup api-udp-forward          UDP Forward
 *
 * @}
 *
 * @}
 *
 * @defgroup api-link                 Link
 *
 * @{
 *
 * @defgroup api-link-link            Link
 * @defgroup api-link-metrics         Link Metrics
 * @defgroup api-link-raw             Raw Link
 *
 * @}
 *
 * @defgroup api-message              Message
 *
 * @defgroup api-multi-radio          Multi Radio Link
 * @defgroup api-trel                 TREL - Thread Stack
 *
 * @defgroup api-thread               Thread
 *
 * @{
 *
 * @defgroup api-backbone-router      Backbone Router
 * @defgroup api-border-agent         Border Agent
 * @defgroup api-border-router        Border Router
 * @defgroup api-border-routing       Border Routing Manager
 * @defgroup api-commissioner         Commissioner
 * @defgroup api-thread-general       General
 * @brief This module includes functions for all Thread roles.
 * @defgroup api-joiner               Joiner
 * @defgroup api-operational-dataset  Operational Dataset
 * @brief Includes functions for the Operational Dataset API.
 * @defgroup api-thread-router        Router/Leader
 * @brief This module includes functions for Thread Routers and Leaders.
 * @defgroup api-server               Server
 *
 * @}
 *
 * @defgroup api-addons               Add-Ons
 *
 * @{
 *
 * @defgroup api-channel-manager      Channel Manager
 * @defgroup api-channel-monitor      Channel Monitoring
 * @defgroup api-child-supervision    Child Supervision
 * @defgroup api-coap-group           CoAP
 *
 * @{
 *
 * @defgroup api-coap                 CoAP
 * @defgroup api-coap-secure          CoAP Secure
 *
 * @}
 *
 * @defgroup api-cli                  Command Line Interface
 * @defgroup api-crypto               Crypto - Thread Stack
 * @defgroup api-factory-diagnostics  Factory Diagnostics - Thread Stack
 * @defgroup api-heap                 Heap
 * @defgroup api-history-tracker      History Tracker
 * @defgroup api-jam-detection        Jam Detection
 * @defgroup api-logging              Logging - Thread Stack
 * @defgroup api-mesh-diag            Mesh Diagnostics
 * @defgroup api-ncp                  Network Co-Processor
 * @defgroup api-network-time         Network Time Synchronization
 * @defgroup api-radio                Radio Statistics
 * @defgroup api-random-group         Random Number Generator
 *
 * @{
 *
 * @defgroup api-random-crypto        RNG Cryptographic
 * @defgroup api-random-non-crypto    RNG Non-cryptographic
 *
 * @}
 *
 * @defgroup api-sntp                 SNTP
 * @defgroup api-verhoeff-checksum    Verhoeff Checksum
 *
 * @}
 *
 * @}
 *
 */

/**
 * @defgroup platform                 Platform Abstraction
 * @brief
 *   This module includes the platform abstraction used by the OpenThread stack.
 *
 * @{
 *
 * @defgroup plat-alarm               Alarm
 * @defgroup plat-ble                 BLE
 * @defgroup plat-crypto              Crypto - Platform
 * @defgroup plat-dns                 DNS - Platform
 * @defgroup plat-dns-sd              DNS-SD (mDNS)
 * @defgroup plat-entropy             Entropy
 * @defgroup plat-factory-diagnostics Factory Diagnostics - Platform
 * @defgroup plat-infra-if            Infrastructure Interface
 * @defgroup plat-logging             Logging - Platform
 * @defgroup plat-memory              Memory
 * @defgroup plat-messagepool         Message Pool
 * @defgroup plat-misc                Miscellaneous
 * @defgroup plat-mdns                Multicast DNS
 * @defgroup plat-multipan            Multipan
 * @defgroup plat-otns                Network Simulator
 * @defgroup plat-radio               Radio
 * @defgroup plat-settings            Settings
 * @defgroup plat-spi-slave           SPI Slave
 * @defgroup plat-time                Time Service
 * @defgroup plat-toolchain           Toolchain
 * @defgroup plat-trel                TREL - Platform
 *
 * @}
 *
 */
