/*
 *  Copyright (c) 2017-2019, The OpenThread Authors.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the copyright holder nor the
 *     names of its contributors may be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @file
 *   This file includes definitions locator getter methods.
 *
 */

#ifndef LOCATOR_GETTERS_HPP_
#define LOCATOR_GETTERS_HPP_

#include "openthread-core-config.h"

#include "common/locator.hpp"
#include "common/tasklet.hpp"
#include "instance/instance.hpp"

namespace ot {

template <typename InstanceGetProvider>
template <typename Type>
inline Type &GetProvider<InstanceGetProvider>::Get(void) const
{
    return static_cast<const InstanceGetProvider *>(this)->GetInstance().template Get<Type>();
}

template <typename Owner, void (Owner::*HandleTaskletPtr)(void)>
void TaskletIn<Owner, HandleTaskletPtr>::HandleTasklet(Tasklet &aTasklet)
{
    (aTasklet.Get<Owner>().*HandleTaskletPtr)();
}

template <typename Owner, void (Owner::*HandleTimertPtr)(void)>
void TimerMilliIn<Owner, HandleTimertPtr>::HandleTimer(Timer &aTimer)
{
    (aTimer.Get<Owner>().*HandleTimertPtr)();
}

#if OPENTHREAD_CONFIG_PLATFORM_USEC_TIMER_ENABLE
template <typename Owner, void (Owner::*HandleTimertPtr)(void)>
void TimerMicroIn<Owner, HandleTimertPtr>::HandleTimer(Timer &aTimer)
{
    (aTimer.Get<Owner>().*HandleTimertPtr)();
}
#endif

} // namespace ot

#endif // LOCATOR_GETTERS_HPP_
