/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.api.lua;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.silabs.java.utils.Either;
import com.silabs.java.utils.Result;
import com.silabs.ss.support.api.lua.ILuaApiLibrary;
import com.silabs.ss.support.api.lua.LuaException;
import com.silabs.ss.support.api.lua.LuaStudio;
import com.silabs.ss.support.api.lua.util.LuaValueUtils;
import com.silabs.ss.support.internal.lua.LuaLibraryConverter;
import com.silabs.ss.support.internal.lua.LuaSupportActivator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.Bit32Lib;
import org.luaj.vm2.lib.DebugLib;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.ZeroArgFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseMathLib;
import org.luaj.vm2.lib.jse.JseStringLib;

public class LuaSandbox {
    private Globals globals;
    private final LuaValue setHook;
    private long maxInstructs = LuaSandbox.defaultMaxInstructs();
    private static final String LUA_FUNCTION_MISSING_EXCEPTION_MSG = "LuaFunction expected as an argument.";

    private LuaSandbox() {
        this.globals = new Globals();
        this.globals.load((LuaValue)new JseBaseLib());
        this.globals.set("dofile", LuaValue.NIL);
        this.globals.set("load", LuaValue.NIL);
        this.globals.set("loadfile", LuaValue.NIL);
        this.globals.set("print", LuaValue.NIL);
        this.globals.load((LuaValue)new JseStringLib());
        this.globals.load((LuaValue)new JseMathLib());
        this.globals.load((LuaValue)new Bit32Lib());
        this.globals.load((LuaValue)new TableLib());
        this.globals.load((LuaValue)new DebugLib());
        this.setHook = this.globals.get("debug").get("sethook");
        this.globals.set("debug", LuaValue.NIL);
    }

    private static long defaultMaxInstructs() {
        String maximumInstructions = System.getProperty("luaMaxInstructions", "10000");
        try {
            return Long.parseLong(maximumInstructions);
        }
        catch (NumberFormatException numberFormatException) {
            LuaSupportActivator.reporter.logError("luaMaxInstructions VM variable was given as " + maximumInstructions + " which is not a valid Long. Falling back to 10,000 instruction limit default.");
            return 10000L;
        }
    }

    public static LuaSandbox create() {
        return new LuaSandbox();
    }

    public void addLibrary(LuaValue library) {
        this.globals.load(library);
    }

    public void addCustomLuaLibrary(LuaValue library) {
        LuaValue table = library.call();
        LuaValueUtils.visitTable(table, (key, value) -> this.globals.set(key, value));
    }

    public void addCustomLuaLibrary(String name, LuaValue library) {
        if (name == null) {
            this.addCustomLuaLibrary(library);
        } else {
            LuaValue table = library.call();
            this.globals.set(name, table);
        }
    }

    public void addLibrary(String name, ILuaApiLibrary library) {
        LuaTable table = LuaLibraryConverter.convertLibrary(library);
        this.globals.set(name, (LuaValue)table);
    }

    public void addRootLibrary(ILuaApiLibrary library) {
        LuaTable table = LuaLibraryConverter.convertLibrary(library);
        LuaValueUtils.visitTable((LuaValue)table, (key, value) -> {
            if (!"lua_library_classname".equals(key.tojstring())) {
                this.globals.set(key, value);
            }
        });
    }

    public LuaValue load(Path script) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = Files.newInputStream(script, new OpenOption[0]);){
            return LuaStudio.compiler().load(is, script.getFileName().toString(), "t", (LuaValue)this.globals);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addTable(String name, LuaTable table) {
        this.globals.set(name, (LuaValue)table);
    }

    public void removeEntry(String name) {
        this.globals.set(name, LuaValue.NIL);
    }

    public void set(String name, LuaValue value) {
        this.globals.set(name, value);
    }

    public void setMaximumInstructions(long max) {
        Preconditions.checkArgument((max > 0L || max == -1L ? 1 : 0) != 0, (Object)"max instruction count must be positive or -1 to indicate no maximum.");
        this.maxInstructs = max;
    }

    public long maxInstructions() {
        return this.maxInstructs;
    }

    public Result<Object, LuaException> tryRun(String script) {
        return this.tryRun(script, "unnamed");
    }

    public Result<Object, LuaException> tryRun(String script, String chunkname) {
        return this.tryRun(new ByteArrayInputStream(script.getBytes(StandardCharsets.UTF_8)), chunkname);
    }

    public Result<Object, LuaException> tryRun(InputStream source, String chunkname) {
        try {
            return this.runChunk(LuaStudio.compiler().load(source, chunkname, "t", (LuaValue)this.globals));
        }
        catch (LuaError le) {
            return Result.err((Object)new LuaException(le));
        }
    }

    public Result<Object, Either<LuaException, IOException>> tryRun(Path source) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream input = Files.newInputStream(source, new OpenOption[0]);){
                return this.tryRun(input, source.getFileName().toString()).transformError(Either::ofLeft);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return Result.err((Object)Either.ofRight((Object)e));
        }
    }

    public Object run(String script) throws LuaException {
        return this.tryRun(script).unwrapOrThrow(e -> e);
    }

    public Object run(String script, String name) throws LuaException {
        return this.tryRun(script, name).unwrapOrThrow(e -> e);
    }

    public Object run(InputStream source, String chunkname) throws LuaException {
        return this.tryRun(source, chunkname).unwrapOrThrow(e -> e);
    }

    public Object run(Path source) throws LuaException, IOException {
        Result<Object, Either<LuaException, IOException>> result = this.tryRun(source);
        if (result.isOK()) {
            return result.okValue();
        }
        Either error = (Either)result.error();
        if (error.isLeft()) {
            throw (LuaException)error.left();
        }
        throw (IOException)error.right();
    }

    public boolean runBooleanFunction(Object closure) throws LuaException {
        return this.runBooleanFunctionWithArgs(closure, new Object[0]);
    }

    public boolean runBooleanFunctionWithArgs(Object closure, Object ... args) throws LuaException {
        try {
            if (closure instanceof LuaFunction) {
                LuaFunction f = (LuaFunction)closure;
                LuaValue[] luaArgs = this.coerceObjToLuaValue(args);
                Varargs x = f.invoke(LuaValue.varargsOf((LuaValue[])luaArgs));
                if (x instanceof LuaBoolean) {
                    return ((LuaBoolean)x).booleanValue();
                }
                throw new LuaException("Lua function did not return boolean.");
            }
            throw new LuaException(LUA_FUNCTION_MISSING_EXCEPTION_MSG);
        }
        catch (LuaError er) {
            throw new LuaException(er);
        }
    }

    public int runIntegerFunction(Object closure) throws LuaException {
        return this.runIntegerFunctionWithArgs(closure, new Object[0]);
    }

    public int runIntegerFunctionWithArgs(Object closure, Object ... args) throws LuaException {
        try {
            if (closure instanceof LuaFunction) {
                LuaFunction f = (LuaFunction)closure;
                LuaValue[] luaArgs = this.coerceObjToLuaValue(args);
                Varargs x = f.invoke(LuaValue.varargsOf((LuaValue[])luaArgs));
                if (x instanceof LuaInteger) {
                    return ((LuaInteger)x).v;
                }
                throw new LuaException("Lua function did not return an integer.");
            }
            throw new LuaException(LUA_FUNCTION_MISSING_EXCEPTION_MSG);
        }
        catch (LuaError er) {
            throw new LuaException(er);
        }
    }

    public String runStringFunction(Object closure) throws LuaException {
        return this.runStringFunctionWithArgs(closure, new Object[0]);
    }

    public String runStringFunctionWithArgs(Object closure, Object ... args) throws LuaException {
        try {
            if (closure instanceof LuaFunction) {
                LuaFunction f = (LuaFunction)closure;
                LuaValue[] luaArgs = this.coerceObjToLuaValue(args);
                Varargs x = f.invoke(LuaValue.varargsOf((LuaValue[])luaArgs));
                if (x instanceof LuaString) {
                    return ((LuaString)x).tojstring();
                }
                throw new LuaException("Lua function did not return string.");
            }
            throw new LuaException(LUA_FUNCTION_MISSING_EXCEPTION_MSG);
        }
        catch (LuaError er) {
            throw new LuaException(er);
        }
    }

    public void runVoidFunction(Object closure) throws LuaException {
        this.runVoidFunctionWithArgs(closure, new Object[0]);
    }

    public void runVoidFunctionWithArgs(Object closure, Object ... args) throws LuaException {
        try {
            if (!(closure instanceof LuaFunction)) {
                throw new LuaException(LUA_FUNCTION_MISSING_EXCEPTION_MSG);
            }
            LuaFunction f = (LuaFunction)closure;
            LuaValue[] luaArgs = this.coerceObjToLuaValue(args);
            f.invoke(LuaValue.varargsOf((LuaValue[])luaArgs));
        }
        catch (LuaError er) {
            throw new LuaException(er);
        }
    }

    private LuaValue[] coerceObjToLuaValue(Object ... args) {
        ArrayList<LuaValue> luaArgs = new ArrayList<LuaValue>();
        if (args != null) {
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof LuaValue) {
                    luaArgs.add((LuaValue)o);
                } else {
                    luaArgs.add(CoerceJavaToLua.coerce((Object)o));
                }
                ++n2;
            }
        }
        return luaArgs.toArray(new LuaValue[0]);
    }

    private Result<Object, LuaException> runChunk(LuaValue chunk) {
        LuaThread thread = new LuaThread(this.globals, chunk);
        if (this.maxInstructs != -1L) {
            this.setHook.invoke(LuaValue.varargsOf((LuaValue[])new LuaValue[]{thread, LuaSandbox.makeMaxInstructionHookFunction(this.maxInstructs), LuaValue.EMPTYSTRING, LuaValue.valueOf((double)this.maxInstructs)}));
        }
        try {
            Varargs result = thread.resume((Varargs)LuaValue.NIL);
            if (result.arg1().equals((Object)LuaValue.FALSE)) {
                return Result.err((Object)new LuaException(result.arg(2).tojstring(), null));
            }
            Varargs justTheResults = result.subargs(2);
            if (justTheResults.narg() > 1) {
                ImmutableList.Builder returnBuilder = new ImmutableList.Builder();
                int i = 0;
                while (i < justTheResults.narg()) {
                    returnBuilder.add(LuaLibraryConverter.convertValue(justTheResults.arg(i + 1)));
                    ++i;
                }
                return Result.ok((Object)returnBuilder.build());
            }
            return Result.ok((Object)LuaLibraryConverter.convertValue(justTheResults.arg1()));
        }
        catch (LuaError luaErr) {
            return Result.err((Object)new LuaException(luaErr));
        }
    }

    private static LuaValue makeMaxInstructionHookFunction(final long max) {
        return new ZeroArgFunction(){

            public LuaValue call() {
                throw new LuaError("Script overran resource limits: maximum allowed instructions is " + max);
            }
        };
    }

    public void setStderr(PrintStream stderr) {
        this.globals.STDERR = stderr;
    }
}

