/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.internal.jep;

import com.silabs.ss.platform.api.rcp.core.MultiBundleClassLoader;
import com.silabs.ss.platform.api.scripting.core.ISLSScriptAPI;
import com.silabs.ss.platform.api.scripting.core.ScriptEngineContext;
import com.silabs.ss.platform.internal.api.scripting.core.ScriptModule;
import com.silabs.ss.support.internal.jep.StudioClassEnquirer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;

public class StudioClassLoader
extends MultiBundleClassLoader {
    private static StudioClassLoader _loader = null;
    private ScriptEngineContext context = null;

    private StudioClassLoader() {
        super(StudioClassLoader.class.getClassLoader());
    }

    void setContext(ScriptEngineContext scriptContext) {
        this.context = scriptContext;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        ISLSScriptAPI api;
        if (this.context != null && name.startsWith("Studio") && (api = ScriptModule.createScriptAPI((ScriptEngineContext)this.context)) != null) {
            String moduleName;
            Object module;
            if ("Studio".equals(name)) {
                Collection c = api.getModuleNames();
                if (c == null) {
                    return null;
                }
                return StudioClassEnquirer.class;
            }
            String[] split = name.split("\\.");
            int len = split.length;
            if (len > 1 && (module = api.getModule(moduleName = split[1])) != null) {
                Method[] methods;
                if (len == 2) {
                    return module.getClass();
                }
                Method[] methodArray = methods = module.getClass().getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (m.getName().equals(split[2])) {
                        return m.getClass();
                    }
                    ++n2;
                }
            }
        }
        return super.loadClass(name);
    }

    public synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    protected String findLibrary(String libname) {
        return super.findLibrary(libname);
    }

    protected URL findResource(String name) {
        return super.findResource(name);
    }

    protected Enumeration<URL> findResources(String name) throws IOException {
        return super.findResources(name);
    }

    protected Object getClassLoadingLock(String className) {
        return super.getClassLoadingLock(className);
    }

    protected Package getPackage(String name) {
        return super.getPackage(name);
    }

    protected Package[] getPackages() {
        return super.getPackages();
    }

    public URL getResource(String name) {
        return super.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return super.getResourceAsStream(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return super.getResources(name);
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    public void setClassAssertionStatus(String className, boolean enabled) {
        super.setClassAssertionStatus(className, enabled);
    }

    public void setDefaultAssertionStatus(boolean enabled) {
        super.setDefaultAssertionStatus(enabled);
    }

    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        super.setPackageAssertionStatus(packageName, enabled);
    }

    static StudioClassLoader getInstance() {
        if (_loader == null) {
            _loader = new StudioClassLoader();
        }
        return _loader;
    }
}

