/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static Exception newMinimalStackException() {
        Exception e = new Exception();
        return ExceptionUtils.minimizeException(e);
    }

    public static Exception newMinimalStackException(String message) {
        Exception e = new Exception(message);
        return ExceptionUtils.minimizeException(e);
    }

    protected static Exception minimizeException(Exception e) {
        StackTraceElement[] ste = e.getStackTrace();
        int COUNT = 10;
        if (ste.length < 10) {
            return e;
        }
        ste = Arrays.copyOf(ste, Math.min(ste.length, 10));
        ste[ste.length - 1] = new StackTraceElement("... extra clipped...", "", null, 0);
        e.setStackTrace(ste);
        return e;
    }

    public static String exceptionToString(Throwable t) {
        if (t == null) {
            return "";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(bos);){
            t.printStackTrace(pw);
        }
        String[] lines = new String(bos.toByteArray()).split("\r?\n", -1);
        ArrayList<String> considered = new ArrayList<String>(lines.length);
        boolean include = true;
        for (String line : lines) {
            if (line.contains("fillInStackTrace")) {
                include = false;
                continue;
            }
            if (line.contains("Caused by:")) {
                include = true;
            }
            if (!include) continue;
            considered.add(line);
        }
        return TextUtils.catenateStrings(considered, "\n");
    }

    private static String printStackTraceElement(int n) {
        StackTraceElement[] ste = new Exception().getStackTrace();
        if (ste.length < n + 1) {
            return "<unknown code location>";
        }
        return ste[n].toString();
    }

    public static String whereAmINow() {
        return ExceptionUtils.printStackTraceElement(2);
    }

    public static String whereAmICalledFrom() {
        return ExceptionUtils.whereAmICalledFrom(1);
    }

    public static String whereAmICalledFrom(int upLevel) {
        return ExceptionUtils.printStackTraceElement(3 + upLevel);
    }
}

