/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class OnOffRule {
    private boolean globalRule = true;
    private final List<String> includes = new ArrayList<String>();
    private final List<String> excludes = new ArrayList<String>();

    public static OnOffRule createDefault(boolean on) {
        OnOffRule oor = new OnOffRule();
        oor.globalRule = on;
        return oor;
    }

    public static OnOffRule read(File f) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(new FileReader(f));){
            OnOffRule onOffRule = OnOffRule.read(lnr);
            return onOffRule;
        }
    }

    public static OnOffRule read(LineNumberReader lnr) throws IOException {
        String line;
        OnOffRule rules = new OnOffRule();
        while ((line = lnr.readLine()) != null) {
            rules.addLine(line);
        }
        return rules;
    }

    public static OnOffRule read(String ... lines) {
        OnOffRule rules = OnOffRule.createDefault(true);
        if (lines != null) {
            for (String line : lines) {
                rules.addLine(line);
            }
        }
        return rules;
    }

    public static OnOffRule concatenate(OnOffRule ... rules) {
        OnOffRule oor = OnOffRule.createDefault(true);
        for (OnOffRule r : rules) {
            if (r == null) continue;
            oor.globalRule = r.globalRule;
            for (String inc : r.includes) {
                if (!oor.includes.contains(inc)) {
                    oor.includes.add(inc);
                }
                if (!oor.excludes.contains(inc)) continue;
                oor.excludes.remove(inc);
            }
            for (String exc : r.excludes) {
                if (!oor.excludes.contains(exc)) {
                    oor.excludes.add(exc);
                }
                if (!oor.includes.contains(exc)) continue;
                oor.includes.remove(exc);
            }
        }
        return oor;
    }

    private OnOffRule() {
    }

    private void addLine(String line) {
        if ((line = line.trim()).startsWith("+")) {
            if (line.length() == 1) {
                this.globalRule = true;
            } else {
                String s = line.substring(1);
                if (this.excludes.contains(s)) {
                    this.excludes.remove(s);
                }
                this.includes.add(s);
            }
        } else if (line.startsWith("-")) {
            if (line.length() == 1) {
                this.globalRule = false;
            } else {
                String s = line.substring(1);
                if (this.includes.contains(s)) {
                    this.includes.remove(s);
                }
                this.excludes.add(s);
            }
        }
    }

    public boolean globalRule() {
        return this.globalRule;
    }

    public String[] includes() {
        return this.includes.toArray(new String[this.includes.size()]);
    }

    public String[] excludes() {
        return this.excludes.toArray(new String[this.excludes.size()]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.globalRule ? (char)'+' : '-');
        for (String r : this.includes) {
            sb.append(";+" + r);
        }
        for (String r : this.excludes) {
            sb.append(";-" + r);
        }
        return sb.toString();
    }
}

