/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Time {
    public static String format(long time, Format format) {
        switch (format) {
            case MICROSECOND_LONG: {
                return Time.formatMicrosecondTime(time);
            }
            case MICROSECOND_SHORT: {
                return Time.formatShortMicrosecondTime(time);
            }
            case MICROSECOND_FRIENDLY: {
                return Time.formatFriendlyMicrosecondTime(time);
            }
            case MICROSECOND_DURATION: {
                return Time.formatMicrosecondDuration(time);
            }
            case MILLISECOND_DAYTIME: {
                return Time.formatMillisecondDayTime(time);
            }
            case MILLISECOND_SHORT: {
                return Time.formatRealTime(time);
            }
            case MILLISECOND_DURATION: {
                return Time.formatMillisecondDuration(time);
            }
            case MILLISECOND_FRIENDLY: {
                return Time.formatFriendlyMillisecondTime(time);
            }
        }
        return "";
    }

    public static String formatMillisecondDayTime(long millisecondTime) {
        return Time.preciseTimeFormatter().format(new Date(millisecondTime));
    }

    public static String formatRealTime(long systemTimeMillis) {
        return Time.realTimeFormatter().format(new Date(systemTimeMillis));
    }

    public static String formatPacketRate(double pps) {
        if (pps == Double.NaN) {
            return "? p/s";
        }
        return Time.packetRateFormatter().format(pps) + " p/s";
    }

    public static String formatMicrosecondTime(long microsecondTime) {
        if (microsecondTime == Long.MIN_VALUE) {
            return "-\u221e";
        }
        if (microsecondTime == Long.MAX_VALUE) {
            return "+\u221e";
        }
        return Time.timeFormatter().format((double)microsecondTime / 1000000.0);
    }

    public static String formatShortMicrosecondTime(long microsecondTime) {
        if (microsecondTime == Long.MIN_VALUE) {
            return "-\u221e";
        }
        if (microsecondTime == Long.MAX_VALUE) {
            return "+\u221e";
        }
        return Time.shortTimeFormatter().format((double)microsecondTime / 1000000.0);
    }

    public static String formatFriendlyMicrosecondTime(long microsecondTime) {
        if (microsecondTime == Long.MIN_VALUE) {
            return "-\u221e";
        }
        if (microsecondTime == Long.MAX_VALUE) {
            return "+\u221e";
        }
        if (microsecondTime > 60000000L) {
            long m = microsecondTime / 60000000L;
            long r = microsecondTime % 60000000L;
            return m + "m," + Time.shortTimeFormatter().format((double)r / 1000000.0);
        }
        return Time.shortTimeFormatter().format((double)microsecondTime / 1000000.0);
    }

    public static String formatMillisecondsToFrendlyRead(long duration) {
        long durationMsec = duration;
        int daysInYear = 365;
        int hoursInDay = 24;
        int minutesInHour = 60;
        int secondsInMinute = 60;
        int millisecondsInSeconds = 1000;
        long buffer = (long)daysInYear * (long)hoursInDay * (long)minutesInHour * (long)secondsInMinute * (long)millisecondsInSeconds;
        int mYear = (int)(durationMsec / buffer);
        durationMsec %= buffer;
        int mDay = (int)(durationMsec / (buffer /= (long)daysInYear));
        durationMsec %= buffer;
        int hr = (int)(durationMsec / (buffer /= (long)hoursInDay));
        durationMsec %= buffer;
        int min = (int)(durationMsec / (buffer /= (long)minutesInHour));
        durationMsec %= buffer;
        int sec = (int)(durationMsec / (buffer /= (long)secondsInMinute));
        durationMsec %= buffer;
        buffer /= (long)millisecondsInSeconds;
        StringBuilder timeStringBuilder = new StringBuilder();
        boolean timeBuildStarted = false;
        if (mYear > 0) {
            timeStringBuilder.append(mYear + " Year" + (mYear == 1 ? "" : "s") + " ");
            timeBuildStarted = true;
        }
        if (mDay > 0 || timeBuildStarted) {
            timeStringBuilder.append(mDay + " Day" + (mDay == 1 ? "" : "s") + " ");
            timeBuildStarted = true;
        }
        if (hr > 0 || timeBuildStarted) {
            timeStringBuilder.append(hr + " Hour" + (hr == 1 ? "" : "s") + " ");
            timeBuildStarted = true;
        }
        if (min > 0 || timeBuildStarted) {
            timeStringBuilder.append(min + " Minute" + (min == 1 ? "" : "s") + " ");
            timeBuildStarted = true;
        }
        if (sec > 0 || timeBuildStarted) {
            timeStringBuilder.append(sec + " Second" + (sec == 1 ? "" : "s") + " ");
            timeBuildStarted = true;
        }
        timeStringBuilder.append(durationMsec + " Millisecond" + (durationMsec == 1L ? "" : "s") + " ");
        return timeStringBuilder.toString().trim();
    }

    public static String formatMicrosecondDuration(long duration) {
        return Time.durationFormatter().format((double)duration / 1000000.0);
    }

    public static String formatMillisecondDuration(long duration) {
        return Time.durationFormatter().format((double)duration / 1000.0);
    }

    public static long parseMicrosecondTime(String microsecondTime) throws ParseException {
        long t;
        if (microsecondTime.equals("-INF")) {
            return Long.MIN_VALUE;
        }
        if (microsecondTime.equals("-\u221e")) {
            return Long.MIN_VALUE;
        }
        if (microsecondTime.equals("+INF")) {
            return Long.MAX_VALUE;
        }
        if (microsecondTime.equals("+\u221e")) {
            return Long.MAX_VALUE;
        }
        Number o = Time.timeFormatter().parse(microsecondTime);
        if (o instanceof Long) {
            t = (Long)o * 1000000L;
        } else if (o instanceof Double) {
            t = (long)((Double)o * 1000000.0);
        } else {
            throw new ParseException("Parsed into neither long nor double", 0);
        }
        return t;
    }

    public static String formatFriendlyMillisecondDate(long realMillisecondTime) {
        Calendar resultTime = Calendar.getInstance();
        resultTime.setTime(new Date(realMillisecondTime));
        Calendar now = Calendar.getInstance();
        Calendar midnight = Calendar.getInstance();
        midnight.set(11, 0);
        midnight.set(12, 0);
        midnight.set(13, 0);
        Calendar yesterdayMidnight = Calendar.getInstance();
        yesterdayMidnight.set(11, 0);
        yesterdayMidnight.set(12, 0);
        yesterdayMidnight.set(13, 0);
        yesterdayMidnight.add(6, -1);
        StringBuffer sb = new StringBuffer();
        if (resultTime.after(midnight)) {
            sb.append("Today");
        } else if (resultTime.after(yesterdayMidnight)) {
            sb.append("Yesterday");
        } else if (resultTime.get(1) == now.get(1)) {
            sb.append(Time.yearlessDateOnlyFormat().format(resultTime.getTime()));
        } else {
            sb.append(Time.dateOnlyFormat().format(resultTime.getTime()));
        }
        return sb.toString();
    }

    public static String formatFriendlyMillisecondTime(long realMillisecondTime) {
        Calendar resultTime = Calendar.getInstance();
        resultTime.setTime(new Date(realMillisecondTime));
        Calendar now = Calendar.getInstance();
        Calendar midnight = Calendar.getInstance();
        midnight.set(11, 0);
        midnight.set(12, 0);
        midnight.set(13, 0);
        Calendar yesterdayMidnight = Calendar.getInstance();
        yesterdayMidnight.set(11, 0);
        yesterdayMidnight.set(12, 0);
        yesterdayMidnight.set(13, 0);
        yesterdayMidnight.add(6, -1);
        StringBuffer sb = new StringBuffer();
        if (resultTime.after(midnight)) {
            sb.append("Today, ");
            sb.append(Time.datelessFormat().format(resultTime.getTime()));
        } else if (resultTime.after(yesterdayMidnight)) {
            sb.append("Yesterday, ");
            sb.append(Time.datelessFormat().format(resultTime.getTime()));
        } else if (resultTime.get(1) == now.get(1)) {
            sb.append(Time.yearlessFormat().format(resultTime.getTime()));
        }
        return sb.toString();
    }

    public static int year() {
        Calendar c = Calendar.getInstance();
        return c.get(1);
    }

    private static DateFormat realTimeFormatter() {
        return DateFormat.getDateTimeInstance(3, 3);
    }

    private static NumberFormat timeFormatter() {
        NumberFormat timeFormatter = NumberFormat.getInstance();
        timeFormatter.setMaximumFractionDigits(6);
        timeFormatter.setMinimumFractionDigits(6);
        timeFormatter.setParseIntegerOnly(false);
        return timeFormatter;
    }

    private static NumberFormat shortTimeFormatter() {
        NumberFormat shortTimeFormatter = NumberFormat.getInstance();
        shortTimeFormatter.setMaximumFractionDigits(3);
        shortTimeFormatter.setMinimumFractionDigits(3);
        shortTimeFormatter.setParseIntegerOnly(false);
        return shortTimeFormatter;
    }

    private static NumberFormat durationFormatter() {
        NumberFormat durationFormatter = NumberFormat.getInstance();
        durationFormatter.setMaximumFractionDigits(3);
        durationFormatter.setMinimumFractionDigits(3);
        durationFormatter.setParseIntegerOnly(false);
        return durationFormatter;
    }

    private static DateFormat preciseTimeFormatter() {
        return new SimpleDateFormat("HH:mm:ss.SSS");
    }

    private static SimpleDateFormat yearlessFormat() {
        return new SimpleDateFormat("MMM d, HH:mm:ss");
    }

    private static SimpleDateFormat datelessFormat() {
        return new SimpleDateFormat("HH:mm:ss");
    }

    private static NumberFormat packetRateFormatter() {
        NumberFormat packetRateFormatter = NumberFormat.getInstance();
        packetRateFormatter.setMinimumFractionDigits(2);
        return packetRateFormatter;
    }

    private static SimpleDateFormat dateOnlyFormat() {
        return new SimpleDateFormat("MMM d, yyyy");
    }

    private static SimpleDateFormat yearlessDateOnlyFormat() {
        return new SimpleDateFormat("MMM d");
    }

    public static enum Format {
        MICROSECOND_LONG(false),
        MICROSECOND_SHORT(false),
        MICROSECOND_DURATION(false),
        MICROSECOND_FRIENDLY(false),
        MILLISECOND_DAYTIME(true),
        MILLISECOND_SHORT(true),
        MILLISECOND_DURATION(false),
        MILLISECOND_FRIENDLY(true);

        private final boolean realTime;

        private Format(boolean realTime) {
            this.realTime = realTime;
        }

        public boolean isRealTime() {
            return this.realTime;
        }
    }
}

