/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.TextUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class XmlHtmlUtils {
    private XmlHtmlUtils() {
    }

    public static String cleanUpXMLText(String text) {
        if (text == null) {
            return null;
        }
        Pattern patt = Pattern.compile("\\s+", 8);
        Matcher matcher = patt.matcher(text);
        text = matcher.replaceAll(" ");
        return text.trim();
    }

    public static String escapeXML(String s) {
        StringBuilder result = new StringBuilder();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block7;
                }
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    public static String escapeHTML(String s) {
        StringBuilder result = new StringBuilder();
        int len = s != null ? s.length() : 0;
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    public static String formatHTML(String s_, boolean properParagraphs) {
        String s = XmlHtmlUtils.escapeHTML(s_);
        StringBuilder result = new StringBuilder();
        String[] paras = s.split("\r?\n\r?\n");
        if (properParagraphs) {
            for (String para : paras) {
                result.append("<p>");
                result.append(para);
                result.append("</p>\n");
            }
        } else {
            boolean first = true;
            for (String para : paras) {
                if (first) {
                    first = false;
                } else {
                    result.append("<p/>\n");
                }
                result.append(para);
            }
        }
        return result.toString();
    }

    public static String convertHTMLToText(String html) {
        String expandBrs;
        if (TextUtils.isEmpty(html)) {
            return html;
        }
        String expandParas = html.replaceAll("(?i)<\\s*(/\\s*p|p\\s/)\\s*>", "\n\n");
        if (expandParas.equals(html)) {
            expandParas = html.replaceAll("(?i)<\\s*p\\s*>", "\n\n");
        }
        if ((expandBrs = expandParas.replaceAll("(?i)<\\s*(/\\s*br|br\\s*/)\\s*>", "\n")).equals(expandParas)) {
            expandBrs = expandParas.replaceAll("(?i)<\\s*br\\s*>", "\n");
        }
        String text = expandBrs.replaceAll("(?is)(\\<head\\>.*\\</head\\>)", "");
        text = text.replaceAll("(?is)(\\<style[^>]*\\>.*\\</style\\>)", "");
        text = text.replaceAll("(?is)(\\<script[^>]*\\>.*\\</script\\>)", "");
        text = text.replaceAll("(?i)<\\s*(li|tr|blockquote).*?>", "\n\n\t");
        text = text.replaceAll("(?i)<\\s*(div|h\\d|ul|ol|table|tr|th).*?>", "\n\n");
        text = text.replaceAll("(?i)<\\s*/\\s*(div|h\\d|ul|ol|li|table|tr|th).*?>", "\n");
        text = text.replaceAll("<.*?>", "");
        text = text.replaceAll("\n\n+", "\n\n");
        text = text.replaceAll("(?s)^\n+", "").replaceAll("(?s)\n+$", "\n");
        return text;
    }
}

