/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.log;

import com.silabs.java.utils.enums.Severity;
import com.silabs.java.utils.log.DefaultLogger;
import com.silabs.java.utils.log.ILogger;
import com.silabs.java.utils.log.IStatusLineHandler;
import com.silabs.java.utils.log.StatusLineHandlerManager;

public class Log {
    private static final StatusLineHandlerManager manager = new StatusLineHandlerManager();
    private static ILogger logger = new DefaultLogger();

    private Log() {
    }

    public static void setLogger(ILogger loggerInstance) {
        logger = loggerInstance;
    }

    public static ILogger logger() {
        return logger;
    }

    public static StatusLineHandlerManager statusLineHandlerManager() {
        return manager;
    }

    public static void info(String message) {
        Log.info(message, null);
    }

    public static void info(String message, Throwable throwable) {
        Log.logger().log(Severity.INFO, message, throwable);
    }

    public static void error(String message) {
        Log.error(message, null);
    }

    public static void error(Throwable throwable) {
        Log.error(null, throwable);
    }

    public static void error(String message, Throwable throwable) {
        Log.logger().log(Severity.ERROR, message, throwable);
    }

    public static void warning(String message) {
        Log.warning(message, null);
    }

    public static void warning(String message, Throwable throwable) {
        Log.logger().log(Severity.WARNING, message, throwable);
    }

    public static void message(Severity severity, String message, Throwable t) {
        switch (severity) {
            case ERROR: 
            case INFO: 
            case WARNING: {
                logger.log(severity, message, t);
                break;
            }
        }
    }

    public static void clearErrorMessage() {
        if (manager != null) {
            manager.clearErrorMessage();
        }
    }

    public static void statusLine(String message, boolean isError) {
        if (manager != null) {
            manager.statusLine(message, isError);
        }
    }

    public static void addStatusLineManager(IStatusLineHandler slm) {
        if (manager != null) {
            manager.addStatusLineManager(slm);
        }
    }

    public static void removeStatusLineManager(IStatusLineHandler slm) {
        if (manager != null) {
            manager.removeStatusLineManager(slm);
        }
    }
}

