/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.runtime;

import com.silabs.java.utils.extension.Extension;
import com.silabs.java.utils.function.Caster;
import com.silabs.java.utils.runtime.IRuntimeProvider;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public final class RuntimeUtils {
    public static final String VARIABLE_IS_PDE_LAUNCH = "isPdeLaunch";
    public static final String ALWAYS_LOAD_METADATA = "ALWAYS_LOAD_METADATA";
    private static final String BUNDLE_INFO_PROPERTY = "org.eclipse.equinox.simpleconfigurator.configUrl";
    private static final String RUNTIME_EXTENSION = "com.silabs.java.utils.runtimeProvider";
    private static final String EXTENSION_ATTR_PROVIDER = "provider";
    private static IRuntimeProvider provider = null;
    private static Boolean isPDELaunch = null;
    private static Boolean isAlwaysLoadMetadataValue = null;
    private static Boolean jUnitState = null;
    private static Boolean isHeadless = null;
    private static Path installPath = null;

    private RuntimeUtils() {
    }

    public static boolean isPlatformPDELaunch() {
        if (isPDELaunch == null) {
            String configUrl = System.getProperty(BUNDLE_INFO_PROPERTY);
            isPDELaunch = configUrl != null && configUrl.contains("org.eclipse.pde.core");
        }
        return isPDELaunch;
    }

    public static boolean isAlwaysLoadMetadata() {
        if (isAlwaysLoadMetadataValue == null) {
            String loadMetadata = System.getProperty(ALWAYS_LOAD_METADATA, Boolean.FALSE.toString());
            isAlwaysLoadMetadataValue = Boolean.TRUE.toString().equals(loadMetadata);
        }
        return isAlwaysLoadMetadataValue;
    }

    public static void setAlwaysLoadMetadata(boolean alwaysLoad) {
        System.setProperty(ALWAYS_LOAD_METADATA, String.valueOf(alwaysLoad));
        isAlwaysLoadMetadataValue = alwaysLoad;
    }

    public static boolean isJUnitRunning() {
        String sqaSalesforceProdOverride = System.getProperty("sqaSalesforceProd");
        if ("true".equals(sqaSalesforceProdOverride)) {
            return false;
        }
        if (jUnitState == null && "true".equalsIgnoreCase(System.getProperty("studio.unittest"))) {
            jUnitState = true;
        }
        if (jUnitState == null) {
            Map<Thread, StackTraceElement[]> traceMap = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> ent : traceMap.entrySet()) {
                boolean hasJunit = false;
                boolean hasSwtBot = false;
                for (StackTraceElement el : ent.getValue()) {
                    String className = el.getClassName();
                    if (className.startsWith("org.junit.") || className.startsWith("junit.framework") || className.startsWith("org.eclipse.pde.internal.junit") || className.startsWith("org.eclipse.test.CoreTestApplication") || className.startsWith("org.eclipse.test.UITestApplication") || className.startsWith("com.ember.workbench.test.harness")) {
                        hasJunit = true;
                        jUnitState = true;
                    }
                    if (!className.startsWith("org.eclipse.swtbot.")) continue;
                    hasSwtBot = true;
                }
                if (hasSwtBot) {
                    return false;
                }
                if (!hasJunit) continue;
                return true;
            }
            if (jUnitState == null) {
                jUnitState = false;
            }
        }
        return jUnitState;
    }

    public static boolean isStudioRunning() {
        return false == RuntimeUtils.provider() instanceof DefaultProvider;
    }

    public static boolean isHeadless() {
        if (isHeadless != null) {
            return isHeadless;
        }
        isHeadless = RuntimeUtils.provider().getDefaultIsHeadless() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return isHeadless;
    }

    public static void setHeadless(boolean isHeadless) {
        RuntimeUtils.isHeadless = isHeadless;
    }

    public static Path getInstallPath() {
        if (installPath == null && (installPath = RuntimeUtils.provider().getInstallPath()) == null) {
            installPath = Paths.get(RuntimeUtils.class.getProtectionDomain().getCodeSource().getLocation().getFile(), new String[0]);
        }
        return installPath;
    }

    private static IRuntimeProvider provider() {
        if (provider == null) {
            provider = Extension.instance().extensions(RUNTIME_EXTENSION, e -> e.createExecutableExtension(EXTENSION_ATTR_PROVIDER)).map(Caster.with(IRuntimeProvider.class)::cast).findFirst().orElse(null);
            if (provider == null) {
                provider = new DefaultProvider();
            }
        }
        return provider;
    }

    public static boolean isSQATestRunning() {
        Map<Thread, StackTraceElement[]> traceMap = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> ent : traceMap.entrySet()) {
            for (StackTraceElement el : ent.getValue()) {
                if (!el.getClassName().startsWith("org.eclipse.swtbot.")) continue;
                return true;
            }
        }
        return false;
    }

    private static final class DefaultProvider
    implements IRuntimeProvider {
        private DefaultProvider() {
        }

        @Override
        public boolean getDefaultIsHeadless() {
            return false;
        }

        @Override
        public Path getInstallPath() {
            return null;
        }
    }
}

