/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher.cli;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.EnvironmentVariableUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import slc.launcher.ISlcLauncher;
import slc.launcher.SlcDaemonLauncher;
import slc.launcher.SlcDirectLauncher;
import slc.launcher.context.SlcCliArgs;
import slc.launcher.context.SlcCliContext;
import slc.launcher.utils.ISlcExitCode;
import slc.launcher.utils.SlcCmdUtils;
import slc.launcher.utils.SlcExitCodes;

@CommandLine.Command(name="launcher")
public class CliLauncherArgs
implements Callable<Integer> {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    private final SlcCliContext context;
    @CommandLine.Option(names={"-h", "--help"}, description={"Show this help message and exit."})
    private boolean usageHelp;
    @CommandLine.Option(names={"-version", "--version"}, description={"Print the current SLC CLI version."})
    private boolean version;
    @CommandLine.Option(names={"-exportLogs", "--exportLogs", "--export-logs"}, paramLabel="output_location", description={"Export the error logs to the specified location"})
    private String exportLogs;
    @CommandLine.Option(names={"--no-verify"}, description={"Do not run any of the standard validation of system runtime like the JVM version."})
    private boolean noVerify;
    @CommandLine.ArgGroup(exclusive=false, heading="Daemon Launcher Args%n")
    public DaemonArgs daemonArgs = new DaemonArgs();
    private static final String DAEMON_ENV = "SLC_USE_DAEMON";
    private boolean noColorArg;
    @CommandLine.Option(names={"-slc-location", "--slc-location"}, description={"Override the location for the SLC executable to launch."})
    private String slcCliLocation;
    @CommandLine.Option(names={"--java-location"}, description={"Specify the specific Java to use for launching the SLC executable."})
    private String slcJavaLocation;
    @CommandLine.Option(names={"-debug"}, hidden=true, description={"Enable specialized debugging information. This will print information from the CLI Launcher and some commands may print debugging specific information."})
    private boolean debug;
    @CommandLine.Option(names={"-time"}, hidden=true, description={"Enable the timing print statements."})
    private boolean time;
    @CommandLine.Option(names={"-devTest", "--dev-test"}, hidden=true, description={"No version checking will be done clientside when attempting to connect to a daemon. This is primarily for connecting to an Eclipse-launched Simplicity Studio or Daemon process (that process will also have to be started with '-Dslc_cli_dev_testing=true'"})
    private boolean devTest;
    @CommandLine.Option(names={"-simplicityStudio", "--simplicity-studio"}, hidden=true, description={"Will allow the daemon to connect to a full version of Simplicity Studio (without '-devTest', the versions will still have to match). This is disabled by default as there can be some minor formatting changes in how a full installation generations a project even if the ultimate result is semantically the same."})
    private boolean simplicityStudio;
    @CommandLine.Option(names={"-data"}, hidden=true, description={"The eclipse launcher argument that specifies where the workspace should be. The launcher needs to parse this so it can tell where to grab the Eclipse logs from."})
    private String workspaceLoc;
    @CommandLine.Option(names={"--socket-timeout"}, hidden=true, defaultValue="10", description={"Specifies how much time, in seconds, ANY individual web socket connection should take before it decides that the daemon is being unresponsive. This does not take into account the fact the system may choose to retry the connection a few times. By default, this is ${DEFAULT-VALUE} (seconds)"})
    private long socketTimeout;
    @CommandLine.Option(names={"--daemon-only"}, description={"This run will ONLY use the daemon. Under normal circumstances, a failure to connect will try to service the call anyway by directly launching SLC. In this mode, the call will just fail if the daemon cannot be used for any reason."})
    private boolean daemonOnly;
    @CommandLine.Option(names={"--generate-version"}, hidden=true, description={"Generate the version file into the install and exit."})
    private boolean generateVersion;

    public CliLauncherArgs(SlcCliContext context) {
        this.context = context;
    }

    public boolean isRunningDebug() {
        return this.debug;
    }

    @CommandLine.Option(names={"-noColour", "--no-colour"}, hidden=true)
    public void setColour(boolean noColour) {
        this.setColor(noColour);
    }

    @CommandLine.Option(names={"--noColor", "--no-color"}, description={"Force disable color. If not specified then this will use the default ansi compatibility for the running shell."})
    public void setColor(boolean noColor) {
        this.noColorArg = noColor;
    }

    @Override
    public Integer call() throws Exception {
        this.setupArgs();
        ISlcExitCode exitCode = this.doRunCmd();
        if (exitCode == null) {
            return SlcExitCodes.ASSERTION_ERROR.exitCode();
        }
        return exitCode.exitCode();
    }

    protected ISlcExitCode doRunCmd() {
        if (TextUtils.hasContent(this.exportLogs)) {
            return SlcCmdUtils.exportLogs(this.context, this.exportLogs);
        }
        if (this.version) {
            return SlcCmdUtils.printVersion(this.context);
        }
        if (this.generateVersion) {
            return SlcDaemonLauncher.generateVersion(this.context);
        }
        this.daemonArgs.validate(this.spec.commandLine());
        ISlcExitCode returnVal = this.getLauncher().launch();
        return returnVal;
    }

    protected ISlcLauncher getLauncher() {
        if (this.daemonArgs.isDaemon()) {
            return new SlcDaemonLauncher(this.context);
        }
        return new SlcDirectLauncher(this.context);
    }

    private void setupArgs() {
        boolean isColor;
        ArrayList<String> slcMainCmds = new ArrayList<String>(this.spec.commandLine().getUnmatchedArguments());
        if (this.noColorArg) {
            this.spec.commandLine().setColorScheme(CommandLine.Help.defaultColorScheme(CommandLine.Help.Ansi.OFF));
        }
        if (this.debug) {
            slcMainCmds.add("-debug");
        }
        if (this.daemonArgs.shutdownDaemon) {
            slcMainCmds.add("daemon-shutdown");
        }
        if (this.usageHelp) {
            this.context.print(this.spec.commandLine().getUsageMessage());
            slcMainCmds.add("--help");
        }
        boolean bl = isColor = !this.noColorArg;
        if (isColor) {
            isColor = this.spec.commandLine().getHelp().ansi().enabled();
        }
        SlcCliArgs args2 = new SlcCliArgs(slcMainCmds, this.time, this.debug, this.daemonArgs.isDaemon(), this.daemonArgs.shutdownDaemon, this.daemonArgs.doNotLaunchDaemon, this.daemonArgs.daemonTimeout, isColor, this.slcCliLocation, this.slcJavaLocation, this.devTest, this.simplicityStudio, this.noVerify, this.workspaceLoc, false, this.socketTimeout, this.daemonOnly);
        this.context.setupArgs(args2);
    }

    static class DaemonArgs {
        @CommandLine.Option(names={"-daemon", "--daemon"}, description={"Will attempt to connect to a running Studio if one already exists, or spin up the command line as a daemon and connect to it"})
        private boolean daemon;
        @CommandLine.Option(names={"daemon-shutdown"}, description={"Will attempt to shutdown the running daemon process."})
        private boolean shutdownDaemon;
        @CommandLine.Option(names={"--do-not-launch-daemon", "--doNotLaunchDaemon", "-doNotLaunchDaemon"}, description={"If using '-daemon', will attempt to connect to an existing daemon, but will fail if none is present (in other words, it won't attempt to start up a daemon if one is not available)."})
        private boolean doNotLaunchDaemon;
        @CommandLine.Option(names={"--daemon-timeout", "-daemonTimeout", "--daemonTimeout"}, description={"Set the timeout for the launched daemon."}, defaultValue="-1")
        private int daemonTimeout;

        DaemonArgs() {
        }

        public boolean isDaemon() {
            if (this.daemon) {
                return this.daemon;
            }
            return TextUtils.hasContent(EnvironmentVariableUtils.getValue(CliLauncherArgs.DAEMON_ENV));
        }

        private void validate(CommandLine cmdLine) {
            if (!this.isDaemon() && (this.shutdownDaemon || this.doNotLaunchDaemon || this.daemonTimeout != -1)) {
                throw new CommandLine.ParameterException(cmdLine, "Daemon mode is required if setting any daemon options. Please specify '--daemon' on the command line or set the 'SLC_USE_DAEMON' environment variable.");
            }
            if (this.daemonTimeout != -1 && this.doNotLaunchDaemon) {
                throw new CommandLine.ParameterException(cmdLine, "Cannot specify both a timeout and a request not to launch the daemon: timeout effects only matter when launching the daemon.");
            }
            if (this.daemonTimeout < -1) {
                throw new CommandLine.ParameterException(cmdLine, "Daemon timeout cannot be less than 0.");
            }
        }
    }
}

