/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher.utils;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.HostUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.api.ICanceler;
import com.silabs.java.utils.zip.ZipFileGroup;
import com.silabs.java.utils.zip.ZipUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import slc.launcher.context.SlcCliContext;
import slc.launcher.utils.ISlcExitCode;
import slc.launcher.utils.SlcExitCodes;

public final class SlcCmdUtils {
    public static final String UC_LOG_LOC = ".uc/uc.core.log";
    public static final String STUDIO_WORKSPACE_LOC = "SimplicityStudio/uc_workspace/";

    private SlcCmdUtils() {
    }

    public static ISlcExitCode exportLogs(SlcCliContext context, String exportLogs) {
        ArrayList<Path> logFiles = new ArrayList<Path>();
        Path userHome = HostUtils.userHomeFile().toPath();
        Path ucLog = userHome.resolve(UC_LOG_LOC);
        if (Files.isRegularFile(ucLog, new LinkOption[0])) {
            logFiles.add(ucLog);
        }
        Path eclipseWorkspaceLoc = userHome.resolve(STUDIO_WORKSPACE_LOC);
        if (TextUtils.hasContent(context.args().workspaceLoc)) {
            eclipseWorkspaceLoc = context.resolvePath(context.args().workspaceLoc);
        }
        Path eclipseLogFolder = eclipseWorkspaceLoc.resolve(".metadata/");
        try (Stream<Path> files = Files.list(eclipseLogFolder);){
            files.filter(p -> p.getFileName().toString().endsWith(".log")).forEachOrdered(logFiles::add);
        }
        catch (IOException e) {
            context.printErr("Failed to find application log files!", e);
        }
        if (logFiles.isEmpty()) {
            context.print("No logs to export.");
            return SlcExitCodes.EXIT_OK;
        }
        ZipFileGroup zipGroup = new ZipFileGroup(userHome.toFile(), "");
        logFiles.forEach(p -> zipGroup.addFile(p.toFile(), p.getFileName().toString()));
        Path exportPath = context.resolvePath(exportLogs).resolve("uc_log.zip");
        try {
            Files.createDirectories(exportPath.getParent(), new FileAttribute[0]);
            ZipUtils.zipFiles(exportPath.toFile(), List.of(zipGroup), ICanceler.NEVER_CANCEL);
        }
        catch (IOException e) {
            context.printErr("Failed to export logs!", e);
            return SlcExitCodes.GENERAL_ERROR;
        }
        return SlcExitCodes.EXIT_OK;
    }

    public static ISlcExitCode printVersion(SlcCliContext context) {
        Path versionFile = SlcCmdUtils.sourceLoc().resolve("changelog");
        try {
            Predicate<String> versionMatcher = Pattern.compile("\\d(?:\\.\\d)*").asPredicate();
            List<String> lines = FileUtils.readLines(versionFile.toFile());
            for (String line : lines) {
                String trimmedLine = line.trim();
                if (!versionMatcher.test(trimmedLine)) continue;
                context.print(trimmedLine);
                return SlcExitCodes.EXIT_OK;
            }
        }
        catch (IOException e) {
            context.printErr("Failed to read changelog", e);
            return SlcExitCodes.GENERAL_ERROR;
        }
        context.printErr("Changelog file is incorrectly formatted. Cannot determine version.");
        return SlcExitCodes.INVALID_FORMAT;
    }

    public static Path sourceLoc() {
        try {
            return Path.of(SlcCmdUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

