/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.silabs.ss.platform.api.descriptor.core.IDescribable;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum ImportMode implements IDescribable
{
    LINK("Link to sources", "The new project is created in the workspace, linking to the original sources.  This allows you to build the project with the original IDE."),
    LINK_LIBRARIES("Link sdk and copy project sources", "The new project is created in the workspace. It will link any library files from the SDK and copy any source files directly into the project."),
    LINK_PROJECT("Link project and copy SDK sources", "The new project is created in the workspace. It will link any library files from the SDK and copy any source files directly into the project."),
    COPY("Copy contents", "All the project contents and metadata are copied."),
    IN_PLACE("In-place", "The new project is created on top of the original project.  If the original IDE is based on Eclipse, the project may no longer build in that IDE.");

    private String label;
    private String descr;

    private ImportMode(String label, String description) {
        this.label = label;
        this.descr = description;
    }

    @JsonGetter
    public String getId() {
        return this.toString();
    }

    @JsonGetter
    public String getName() {
        return this.toString();
    }

    @JsonGetter
    public String getLabel() {
        return this.label;
    }

    @JsonGetter
    public String getDescription() {
        return this.descr;
    }
}

