/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core;

import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.api.core.model.MLibraryFile;
import com.silabs.ss.framework.project.api.core.model.MLibraryPath;
import com.silabs.ss.framework.project.api.core.model.util.ProjectModelSwitch;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import org.eclipse.emf.ecore.EObject;

public class MProjectCanonicalizer
extends ProjectModelSwitch<Object> {
    private IProjectModel projectModel;
    private IDescriptor buildConfiguration;
    private boolean allowRelative;
    private final boolean relativizeEntries;
    private final boolean removeGeneratedUris;

    public MProjectCanonicalizer(IProjectModel projectModel, IDescriptor buildConfiguration, boolean allowRelative) {
        this(projectModel, buildConfiguration, allowRelative, false);
    }

    public MProjectCanonicalizer(IProjectModel projectModel, IDescriptor buildConfiguration, boolean allowRelative, boolean relativizeEntries) {
        this(projectModel, buildConfiguration, allowRelative, relativizeEntries, false);
    }

    public MProjectCanonicalizer(IProjectModel projectModel, IDescriptor buildConfiguration, boolean allowRelative, boolean relativizeEntries, boolean removeGeneratedUris) {
        this.projectModel = projectModel;
        this.allowRelative = allowRelative;
        this.relativizeEntries = relativizeEntries;
        assert (buildConfiguration == null || buildConfiguration instanceof IBuildConfigurationDescriptor || buildConfiguration instanceof IBuildConfiguration || buildConfiguration instanceof IProjectDescriptor || buildConfiguration instanceof IProjectEntity);
        this.buildConfiguration = buildConfiguration;
        this.removeGeneratedUris = removeGeneratedUris;
    }

    public Object defaultCase(EObject object) {
        for (EObject obj : object.eContents()) {
            this.doSwitch(obj);
        }
        return this;
    }

    public Object caseMEntry(MEntry entry) {
        if (entry instanceof MContent) {
            MContent content = (MContent)entry;
            if (this.removeGeneratedUris && content instanceof MFileContent && ((MFileContent)content).isGenerated()) {
                content.setUri(null);
            } else if (content.getUri() != null) {
                String uri = ProjectModelUtils.getProjectModelURI(this.projectModel, this.relativizeEntries ? this.buildConfiguration : null, content, content.getUri(), this.allowRelative);
                content.setUri(uri);
            }
        }
        return null;
    }

    public Object caseMIncludePath(MIncludePath incl) {
        String uri = ProjectModelUtils.getProjectModelURI(this.projectModel, this.buildConfiguration, null, incl.getUri(), this.allowRelative);
        incl.setUri(uri);
        return this;
    }

    public Object caseMLibraryPath(MLibraryPath lib) {
        String uri = ProjectModelUtils.getProjectModelURI(this.projectModel, this.buildConfiguration, null, lib.getUri(), this.allowRelative);
        lib.setUri(uri);
        return this;
    }

    public Object caseMLibraryFile(MLibraryFile lib) {
        String uri = ProjectModelUtils.getProjectModelURI(this.projectModel, this.buildConfiguration, null, lib.getUri(), this.allowRelative);
        lib.setUri(uri);
        return this;
    }
}

