/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.function.Caster;
import com.silabs.ss.framework.project.api.core.BuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.IWriteableProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectCommonProperties;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.modules.IModuleManager;
import com.silabs.ss.framework.project.api.core.modules.Module;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.api.core.type.NoneProjectType;
import com.silabs.ss.framework.project.api.core.type.ProjectType;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainManager;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfiguration;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationManager;
import com.silabs.ss.framework.project.api.toolchain.core.configs.StockConfiguration;
import com.silabs.ss.framework.project.internal.core.entity.IProjectPathResolver;
import com.silabs.ss.platform.api.content.board.core.Board;
import com.silabs.ss.platform.api.content.board.core.BoardUtils;
import com.silabs.ss.platform.api.content.board.core.IBoardManager;
import com.silabs.ss.platform.api.content.part.core.IPartManager;
import com.silabs.ss.platform.api.content.part.core.Part;
import com.silabs.ss.platform.api.descriptor.core.BaseDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.DescriptorPropertyMapper;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyMapper;
import com.silabs.ss.platform.api.descriptor.core.type.IType;
import com.silabs.ss.platform.api.idemanager.core.IDEPreferenceManager;
import com.silabs.ss.platform.api.idemanager.core.IIDE;
import com.silabs.ss.platform.api.sdk.core.ISDKManager;
import com.silabs.ss.platform.api.sdk.core.SDK;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ProjectDescriptor
extends BaseDescriptor
implements IWriteableProjectDescriptor {
    private IAdaptable parentAdapter;
    protected IProjectType projectType;
    protected IBuildConfigurationDescriptor initialConfiguration;
    protected Collection<IBuildConfigurationDescriptor> buildConfigDescs = new ArrayList<IBuildConfigurationDescriptor>();
    protected URI projectLocationURI;
    private int uniqueId = ++gUniqueId;
    private static int gUniqueId;

    public ProjectDescriptor(String projectName) {
        this.getModel().setName(projectName);
    }

    public ProjectDescriptor(String projectName, IAdaptable parentAdapter) {
        this(projectName);
        this.parentAdapter = parentAdapter;
    }

    public ProjectDescriptor(String projectName, MDescriptor desc) {
        this(desc);
        desc.setName(projectName);
    }

    public ProjectDescriptor(MDescriptor desc) {
        super(desc);
    }

    @Override
    public ProjectDescriptor copy() {
        ProjectDescriptor desc = (ProjectDescriptor)super.copy();
        desc.parentAdapter = this.parentAdapter;
        desc.projectType = this.projectType;
        List<IBuildConfigurationDescriptor> newBConfs = this.buildConfigDescs.stream().map(IBuildConfigurationDescriptor::copy).map(arg_0 -> ((Caster)Caster.with(IBuildConfigurationDescriptor.class)).cast(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        desc.setBuildConfigurationDescriptors(newBConfs);
        if (this.initialConfiguration != null) {
            desc.initialConfiguration = desc.findBuildConfigurationDescriptor(this.initialConfiguration.getId());
        }
        return desc;
    }

    public int hashCode() {
        return this.uniqueId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectDescriptor other = (ProjectDescriptor)obj;
        return this.uniqueId == other.uniqueId;
    }

    @Override
    public IProjectDescriptor.BuildArtifactType getBuildArtifactType() {
        return (IProjectDescriptor.BuildArtifactType)((Object)this.getProperty(ProjectCommonProperties.BUILD_ARTIFACT_TYPE));
    }

    @Override
    public void setParentAdapter(IAdaptable adapter) {
        this.parentAdapter = adapter;
    }

    protected String getDefaultPropertyScope() {
        return this.projectType != null ? this.projectType.getPropertyScope() : "project";
    }

    @Override
    public IProjectType getProjectType() {
        if (this.projectType == null) {
            this.projectType = new NoneProjectType();
        }
        return this.projectType;
    }

    @Override
    public IBuildConfigurationDescriptor getCurrentConfigurationDescriptor() {
        if (this.initialConfiguration == null && !this.buildConfigDescs.isEmpty()) {
            this.setCurrentConfigurationDescriptor(this.buildConfigDescs.iterator().next());
        }
        return this.initialConfiguration;
    }

    @Override
    public IBuildConfigurationDescriptor[] getBuildConfigurationDescriptors() {
        return this.buildConfigDescs.toArray(new IBuildConfigurationDescriptor[this.buildConfigDescs.size()]);
    }

    @Override
    public IBuildConfigurationDescriptor findBuildConfigurationDescriptor(String id) {
        for (IBuildConfigurationDescriptor descr : this.buildConfigDescs) {
            if (!descr.getId().equals(id)) continue;
            return descr;
        }
        return null;
    }

    @Override
    public IBuildConfigurationDescriptor findBuildConfigurationDescriptorByName(String name) {
        for (IBuildConfigurationDescriptor descr : this.buildConfigDescs) {
            if (!descr.getName().equals(name)) continue;
            return descr;
        }
        return null;
    }

    @Override
    public URI getProjectDescriptionLocationURI() {
        if (this.projectLocationURI == null) {
            this.projectLocationURI = this.getDefaultProjectLocation().toFile().toURI();
        }
        return this.projectLocationURI;
    }

    @Override
    public IPath getDefaultProjectLocation() {
        IIDE ide;
        String ideId;
        IPath installPath = null;
        IProjectPathResolver resolver = (IProjectPathResolver)this.getProjectType().getAdapter(IProjectPathResolver.class);
        if (resolver != null) {
            installPath = resolver.resolveProjectPath(this);
        }
        if (installPath == null || installPath.isEmpty()) {
            try {
                installPath = this.getInstallationPath();
            }
            catch (IOException iOException) {}
        }
        if ((installPath == null || installPath.isEmpty()) && TextUtils.hasContent((String)(ideId = (String)this.getProperty(ProjectProperties.IDE_ID))) && (ide = IDEPreferenceManager.getIDEByID((String)ideId)) != null) {
            installPath = ide.getDefaultProjectLocation(this.getName());
        }
        if (installPath == null || installPath.isEmpty()) {
            installPath = IDEPreferenceManager.getPreferredIDE().getDefaultProjectLocation(this.getName());
        }
        return installPath == null ? Path.EMPTY : installPath;
    }

    @Override
    public String[] getBoardIds() {
        return ((Collection)this.getProperty(ProjectProperties.BOARD_IDS)).toArray(new String[0]);
    }

    @Override
    public String getPartId() {
        String partId = (String)this.getProperty(ProjectProperties.PART_ID);
        if (partId.isEmpty()) {
            return null;
        }
        return partId;
    }

    @Override
    public String getSdkId() {
        String sdkId = (String)this.getProperty(ProjectProperties.SDK_ID);
        if (TextUtils.isEmpty((String)sdkId)) {
            return null;
        }
        return sdkId;
    }

    @Override
    public String getToolchainId() {
        return (String)this.getProperty(ProjectProperties.TOOLCHAIN_ID);
    }

    @Override
    public String getKitId() {
        return (String)this.getProperty(ProjectProperties.KIT_ID);
    }

    @Override
    public void setKitId(String kitId) {
        this.setProperty(ProjectProperties.KIT_ID, kitId);
    }

    protected IPropertyMapper<IProperty, IType> createPropertyMapper() {
        return new DescriptorPropertyMapper(this.getPropertyScope(), this.getClass().getName()){

            protected String getPropertyScope() {
                return ProjectDescriptor.this.getPropertyScope();
            }
        };
    }

    @Override
    public void setProjectTypeId(String projectTypeId) {
        this.projectType = ProjectType.manager().findProjectType(projectTypeId);
        this.setPropertyScope(this.getDefaultPropertyScope());
    }

    @Override
    public void setProjectType(IProjectType projectType) {
        this.projectType = projectType;
        this.setPropertyScope(this.getDefaultPropertyScope());
    }

    @Override
    public void setCurrentConfigurationDescriptor(IBuildConfigurationDescriptor data) {
        this.initialConfiguration = data;
    }

    @Override
    public Collection<IBuildConfigurationDescriptor> buildConfigurationDescriptors() {
        return this.buildConfigDescs;
    }

    @Override
    public void setBuildConfigurationDescriptors(Collection<IBuildConfigurationDescriptor> configurations) {
        this.buildConfigDescs = configurations;
        this.updateBuildConfigParent();
    }

    private void updateBuildConfigParent() {
        if (this.buildConfigDescs == null) {
            return;
        }
        this.buildConfigDescs.stream().map(arg_0 -> ((Caster)Caster.with(BuildConfigurationDescriptor.class)).cast(arg_0)).filter(Objects::nonNull).forEach(b -> b.setParent(this));
    }

    @Override
    public void setProjectDescriptionLocationURI(URI uri) {
        this.projectLocationURI = uri;
    }

    @Override
    public void setBoardIds(String[] boardIds) {
        this.setProperty(ProjectProperties.BOARD_IDS, BoardUtils.toBoardIdList((String[])boardIds));
    }

    @Override
    public void setPartId(String partId) {
        this.setProperty(ProjectProperties.PART_ID, partId);
    }

    @Override
    public void setSdkId(String sdkId) {
        this.setProperty(ProjectProperties.SDK_ID, sdkId);
    }

    @Override
    public void setToolchainId(String toolchainId) {
        this.setProperty(ProjectProperties.TOOLCHAIN_ID, toolchainId);
    }

    @Override
    public IBuildConfigurationDescriptor createBuildConfiguration() {
        return this.getProjectType().createBuildConfigurationDescriptor(this);
    }

    @Override
    public IBuildConfigurationDescriptor createBuildConfigurationDescriptor(IStockConfiguration stock) {
        IStockConfigurationDescriptor stockDesc = (IStockConfigurationDescriptor)stock.getDescriptor();
        return this.getProjectType().createBuildConfigurationDescriptor((IProjectDescriptor)this, stockDesc);
    }

    @Override
    public IBuildConfigurationDescriptor createBuildConfigurationDescriptor(IStockConfigurationDescriptor stock) {
        return this.getProjectType().createBuildConfigurationDescriptor((IProjectDescriptor)this, stock);
    }

    @Override
    public void setBuildArtifactType(IProjectDescriptor.BuildArtifactType type) {
        this.setProperty(ProjectCommonProperties.BUILD_ARTIFACT_TYPE, (Object)type);
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object adapted;
        if (this.parentAdapter != null && (adapted = this.parentAdapter.getAdapter(adapter)) != null) {
            return (T)adapted;
        }
        if (adapter == IBoardManager.class) {
            return adapter.cast(Board.manager());
        }
        if (adapter == IPartManager.class) {
            return adapter.cast(Part.manager());
        }
        if (adapter == ISDKManager.class) {
            return adapter.cast(SDK.manager());
        }
        if (adapter == IToolchainManager.class) {
            return adapter.cast(Toolchain.manager());
        }
        if (adapter == IStockConfigurationManager.class) {
            return adapter.cast(StockConfiguration.manager());
        }
        if (adapter == IModuleManager.class) {
            return adapter.cast(Module.manager());
        }
        return (T)super.getAdapter(adapter);
    }
}

