/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.builtin;

import com.silabs.ss.framework.project.api.core.builtin.ProjectBuiltInHandler;
import com.silabs.ss.framework.project.api.core.builtin.ProjectBuiltInState;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;

public abstract class BaseBuiltinController<T extends ProjectBuiltInHandler> {
    private Map<String, ProjectBuiltInState> builtinStates;

    protected abstract Collection<ProjectBuiltInState> loadState();

    protected Map<String, ProjectBuiltInState> builtinStates() {
        if (this.builtinStates == null) {
            this.builtinStates = this.loadState().stream().collect(Collectors.toMap(ProjectBuiltInState::getId, s -> s));
        }
        return this.builtinStates;
    }

    public T getFor(IPath projPath) {
        String id = projPath == null ? "" : projPath.toString();
        ProjectBuiltInState state = this.builtinStates().computeIfAbsent(id, ProjectBuiltInState::new);
        return this.createHandler(state);
    }

    protected abstract T createHandler(ProjectBuiltInState var1);

    public abstract void apply();

    public void resetLanguageSettings() {
        this.builtinStates().values().forEach(ProjectBuiltInState::resetLanguageSettings);
        this.apply();
    }
}

