/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.builtin;

import com.google.common.collect.Multimap;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.builtin.BaseBuiltinController;
import com.silabs.ss.framework.project.api.core.builtin.ProjectBuiltInHandler;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelSwitchRecurser;
import java.util.Collection;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IPath;

public class MProjectBuiltinApplier
extends ProjectModelSwitchRecurser<Object> {
    private BaseBuiltinController<?> builtinController;
    private Multimap<String, String> toolOptionReplacements;

    public MProjectBuiltinApplier(BaseBuiltinController<?> builtinController) {
        this.builtinController = builtinController;
    }

    public MProjectBuiltinApplier setToolOptionReplacements(Multimap<String, String> toolOptionReplacements) {
        this.toolOptionReplacements = toolOptionReplacements;
        return this;
    }

    protected boolean recursePdms() {
        return false;
    }

    public Object caseMEntry(MEntry entry) {
        IPath projPath = ProjectModelUtils.getProjectPathFor(entry);
        ProjectBuiltInHandler builtins = ((ProjectBuiltInHandler)this.builtinController.getFor(projPath)).setToolOptionReplacements(this.toolOptionReplacements);
        this.runForSettingSite((MSettingsSite)entry, builtins);
        if (entry instanceof MProject) {
            ((MProject)entry).getConfigurations().forEach(c -> this.runForSettingSite((MSettingsSite)c, builtins));
        }
        return null;
    }

    private void runForSettingSite(MSettingsSite site, ProjectBuiltInHandler builtins) {
        this.update((Collection)site.getIncludePaths(), s -> builtins.isIncludeBuiltin(s.getUri()));
        this.update((Collection)site.getLibraryFiles(), s -> {
            if (TextUtils.hasContent((String)s.getName())) {
                return builtins.isLibraryFileBuiltin(s.getName());
            }
            return builtins.isLibraryFileUriBuiltin(s.getUri());
        });
        this.update((Collection)site.getLibraryPaths(), s -> builtins.isLibraryPathBuiltin(s.getUri()));
        this.update((Collection)site.getMacroDefinitions(), s -> builtins.isMacroBuiltin(s.getName(), s.getValue()));
        site.getToolOptions().forEach(builtins::updateBuiltinState);
    }

    private <T extends MBuildSetting> void update(Collection<T> settings, Predicate<T> pred) {
        settings.forEach(setting -> setting.setBuiltin(pred.test(setting)));
    }
}

