/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.builtin;

import com.silabs.ss.framework.project.api.toolchain.core.IResolvedToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.configs.StockConfigurationProperties;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class ProjectBuiltInState {
    private String id;
    private Map<String, String> builtinMacrosMap;
    private Collection<URI> builtinIncludes;
    private Collection<URI> builtinLibraryFiles;
    private Collection<String> builtinLibraryNames;
    private Collection<URI> builtinLibraryPaths;
    private Collection<URI> builtinLibraryObjects;
    private Collection<IResolvedToolOption> resolvedOptions;

    public ProjectBuiltInState(String id) {
        this.id = id;
        this.builtinIncludes = new ArrayList<URI>();
        this.builtinLibraryFiles = new ArrayList<URI>();
        this.builtinLibraryNames = new ArrayList<String>();
        this.builtinLibraryObjects = new ArrayList<URI>();
        this.builtinLibraryPaths = new ArrayList<URI>();
        this.builtinMacrosMap = new LinkedHashMap<String, String>();
        this.resolvedOptions = new LinkedHashSet<IResolvedToolOption>();
    }

    public void resetLanguageSettings() {
        this.builtinIncludes = new ArrayList<URI>();
        this.builtinMacrosMap = new LinkedHashMap<String, String>();
        this.builtinLibraryFiles = new ArrayList<URI>();
        this.builtinLibraryNames = new ArrayList<String>();
        this.builtinLibraryPaths = new ArrayList<URI>();
        this.builtinLibraryObjects = new ArrayList<URI>();
    }

    public void resetResourceBuiltins() {
        this.resolvedOptions = new LinkedHashSet<IResolvedToolOption>();
    }

    public Map<String, String> macrosMap() {
        return this.builtinMacrosMap;
    }

    public Collection<URI> includes() {
        return this.builtinIncludes;
    }

    public Collection<URI> libraryFiles() {
        return this.builtinLibraryFiles;
    }

    public Collection<String> libraryNames() {
        return this.builtinLibraryNames;
    }

    public Collection<URI> libraryPaths() {
        return this.builtinLibraryPaths;
    }

    public Collection<URI> libraryObjects() {
        return this.builtinLibraryObjects;
    }

    public Collection<IResolvedToolOption> resolvedOptions() {
        return this.resolvedOptions;
    }

    public ProjectBuiltInState() {
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getBuiltinMacrosMap() {
        return this.builtinMacrosMap;
    }

    public Collection<String> getBuiltinLibraryNames() {
        return this.builtinLibraryNames;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBuiltinMacrosMap(Map<String, String> builtinMacrosMap) {
        this.builtinMacrosMap = new LinkedHashMap<String, String>(builtinMacrosMap);
    }

    public void setBuiltinLibraryNames(Collection<String> builtinLibraryNames) {
        this.builtinLibraryNames = new ArrayList<String>(builtinLibraryNames);
    }

    public String getBuiltinIncludesStr() {
        return CoreTypes.URI_LIST.stringize(this.builtinIncludes);
    }

    public String getBuiltinLibraryFilesStr() {
        return CoreTypes.URI_LIST.stringize(this.builtinLibraryFiles);
    }

    public String getBuiltinLibraryPathsStr() {
        return CoreTypes.URI_LIST.stringize(this.builtinLibraryPaths);
    }

    public String getBuiltinLibraryObjectsStr() {
        return CoreTypes.URI_LIST.stringize(this.builtinLibraryObjects);
    }

    public void setBuiltinIncludesStr(String builtinIncludes) {
        this.builtinIncludes = (Collection)CoreTypes.URI_LIST.convert(builtinIncludes);
    }

    public void setBuiltinLibraryFilesStr(String builtinLibraryFiles) {
        this.builtinLibraryFiles = (Collection)CoreTypes.URI_LIST.convert(builtinLibraryFiles);
    }

    public void setBuiltinLibraryPathsStr(String builtinLibraryPaths) {
        this.builtinLibraryPaths = (Collection)CoreTypes.URI_LIST.convert(builtinLibraryPaths);
    }

    public void setBuiltinLibraryObjectsStr(String builtinLibraryObjects) {
        this.builtinLibraryObjects = (Collection)CoreTypes.URI_LIST.convert(builtinLibraryObjects);
    }

    public String getResolvedOptionsStr() {
        return StockConfigurationProperties.TYPE.RESOLVED_TOOL_OPTION_LIST.stringize(this.resolvedOptions);
    }

    public void setResolvedOptionsStr(String resolvedOptionsStr) {
        this.resolvedOptions = new LinkedHashSet<IResolvedToolOption>((Collection)StockConfigurationProperties.TYPE.RESOLVED_TOOL_OPTION_LIST.convert(resolvedOptionsStr));
    }
}

