/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.BaseProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.operations.CopyProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.CreateProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ILinkIntoProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.LinkProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.LinkProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IPath;

public class CreateInPlaceOperationFactory
extends BaseProjectEngineOperationFactory {
    protected boolean exists(IProjectEngineSession session, IPath projectPath, MEntry candidate) {
        if (candidate == null) {
            return false;
        }
        boolean overwriteSources = (Boolean)session.getProjectDescriptor().getProperty(ProjectProperties.OVERWRITE_COPIED_SOURCES);
        if (overwriteSources) {
            return false;
        }
        IProjectType projType = session.getProjectDescriptor().getProjectType();
        return projType != null && projType.projectFileExists(session.getProjectDescriptor(), projectPath);
    }

    protected boolean identityInProject(IProjectEngineSession session, IPath projectPath, MEntry candidate) {
        if (candidate == null) {
            return false;
        }
        if (!(candidate instanceof MContent)) {
            return true;
        }
        try {
            return this.isInProject(session, projectPath, candidate);
        }
        catch (IOException | IllegalArgumentException exception) {
            return false;
        }
    }

    private boolean isInProject(IProjectEngineSession session, IPath projectPath, MEntry candidate) throws IOException {
        URI uri = session.getProjectModel().resolveURI(((MContent)candidate).getUri(), candidate instanceof MFolderContent);
        IPath contentPath = URIUtils.resolveURIToPath((URI)uri);
        IPath root = session.getProjectDescriptor().getInstallationPath();
        if (root != null && root.toFile().isFile()) {
            root = root.removeLastSegments(1);
        }
        if (root != null && root.isPrefixOf(contentPath)) {
            IPath expProjectPath = contentPath.removeFirstSegments(root.segmentCount()).setDevice(null);
            return expProjectPath.equals((Object)projectPath.makeRelative());
        }
        return false;
    }

    protected boolean shouldLink(IProjectEngineSession session, IPath projectPath, MEntry entry) {
        boolean isModuleFile;
        boolean bl = isModuleFile = entry != null && entry.isBuiltin();
        boolean shouldLink = entry instanceof MContent && ((MContent)entry).getLinked() != null ? ((MContent)entry).getLinked() : (!isModuleFile ? !this.identityInProject(session, projectPath, entry) : entry instanceof MContent && !Boolean.FALSE.equals(((MContent)entry).getLinked()));
        return shouldLink;
    }

    @Override
    public boolean shouldEnter(IProjectEngineSession session, MFolderEntry entry, IAddToProjectEngineOperation folderOperation) {
        if (!(folderOperation instanceof ILinkIntoProjectEngineOperation)) {
            return true;
        }
        return entry != null && !(entry instanceof MContent);
    }

    @Override
    public IAddToProjectEngineOperation createAddProjectFolderOperation(IProjectEngineSession session, File containerFile, IPath projectPath, File contentFolder, MFolderEntry entry, MSelectable selector) {
        if (this.exists(session, projectPath, (MEntry)entry)) {
            return null;
        }
        if (this.shouldLink(session, projectPath, (MEntry)entry)) {
            return new LinkProjectFolderOperation(session, containerFile, projectPath, contentFolder, (MContent)entry, selector);
        }
        return new CreateProjectFolderOperation(session, projectPath, contentFolder, entry, selector);
    }

    @Override
    public IAddToProjectEngineOperation createAddProjectFileOperation(IProjectEngineSession session, File containerFile, IPath projectPath, File contentFile, MFileEntry entry, MSelectable selector) throws IOException {
        IAddToProjectEngineOperation parentOp = super.createAddProjectFileOperation(session, containerFile, projectPath, contentFile, entry, selector);
        if (parentOp != null) {
            return parentOp;
        }
        if (this.exists(session, projectPath, (MEntry)entry)) {
            return null;
        }
        if (this.shouldLink(session, projectPath, (MEntry)entry)) {
            return new LinkProjectFileOperation(session, containerFile, projectPath, contentFile, (MContent)entry, selector);
        }
        return new CopyProjectFileOperation(session, projectPath, contentFile, entry, selector);
    }
}

