/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.engine.CoreOperatorHandler;
import com.silabs.java.utils.variables.engine.IOperatorHandler;
import com.silabs.java.utils.variables.engine.VariableSubstitutionEngine;
import com.silabs.ss.framework.project.api.core.BuildConfigProperties;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectLanguageSettingOperation;
import com.silabs.ss.framework.project.api.core.model.ELanguage;
import com.silabs.ss.framework.project.api.core.model.MConfigSettings;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MEquivalence;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFileReference;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderReference;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MReference;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.utils.ProjectCompatUtils;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainManager;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelMergeUtils;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModuleHandlerUtils;
import com.silabs.ss.platform.api.content.board.core.BoardCompatibility;
import com.silabs.ss.platform.api.content.board.core.IBoard;
import com.silabs.ss.platform.api.content.part.core.IPart;
import com.silabs.ss.platform.api.content.part.core.PartCompatibility;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IDescriptorEntity;
import com.silabs.ss.platform.api.descriptor.core.manager.IManager;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.type.EcoreTypeUtils;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import com.silabs.ss.platform.api.sdk.core.ISDKManager;
import com.silabs.ss.platform.api.sdk.core.SDK;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;

public class ProjectModelUtils {
    private static VariableSubstitutionEngine substEngine = new VariableSubstitutionEngine('(');

    static {
        substEngine.allowRecursion(true);
        substEngine.setOperatorHandler((IOperatorHandler)CoreOperatorHandler.INSTANCE);
    }

    private ProjectModelUtils() {
    }

    public static boolean isEquivalent(Object obj1, Object obj2) {
        if (obj1 instanceof MEquivalence && obj2 instanceof MEquivalence) {
            return ((MEquivalence)obj1).isEquivalent(obj2);
        }
        return Objects.equals(obj1, obj2);
    }

    public static List<ELanguage> getLanguagesFor(IProjectLanguageSettingOperation operation) {
        String[] langNames;
        String langCompat = operation.getLanguageCompatibility();
        if (TextUtils.isEmpty((String)langCompat) || ".*".equals(langCompat) || "ALL".equals(langCompat)) {
            return Arrays.asList(ELanguage.values());
        }
        ArrayList<ELanguage> matches = new ArrayList<ELanguage>(1);
        String[] stringArray = langNames = langCompat.split("\\s+");
        int n = langNames.length;
        int n2 = 0;
        while (n2 < n) {
            String langName = stringArray[n2];
            ELanguage lang = ELanguage.get((String)langName);
            if (lang == null) {
                Activator.reporter.logError("unknown ELanguage literal: " + langName);
            } else {
                matches.add(lang);
            }
            ++n2;
        }
        if (!matches.isEmpty()) {
            return matches;
        }
        return Arrays.asList(ELanguage.values());
    }

    public static <Desc extends IDescriptor> String getProjectModelURI(IProjectModel project, Desc conf, MContent content, String uriStr_, boolean allowRelative) {
        String parentURI;
        if (uriStr_ == null) {
            return null;
        }
        Object uriStr = uriStr_;
        if (((String)uriStr).startsWith("unresolved:") || ((String)uriStr).startsWith("virtual:")) {
            return uriStr;
        }
        if (((String)uriStr).contains("$(") && conf != null) {
            uriStr = ProjectModelUtils.replaceUriWithStudioVariable((String)uriStr, "$(projectLocation)", "project");
            uriStr = ProjectModelUtils.replaceUriWithStudioVariable((String)uriStr, "file:$(projectLocation)", "project");
            uriStr = ProjectModelUtils.replaceUriWithStudioVariable((String)uriStr, "platform:/resource/$(projectName)", "project");
            uriStr = ProjectModelUtils.replaceUriWithStudioVariable((String)uriStr, "$(sdkInstallationPath)", "sdk");
            uriStr = ProjectModelUtils.replaceUriWithStudioVariable((String)uriStr, "$(toolchainInstallationPath)", "toolchain");
        }
        uriStr = project.resolveString((String)uriStr);
        URI origExpandedURI = URIUtils.createAbsoluteURI((String)uriStr);
        URI contentRoot = null;
        if (content != null && content.eContainer() instanceof MContent && (parentURI = ((MContent)content.eContainer()).getUri()) != null && !parentURI.startsWith("virtual:")) {
            try {
                contentRoot = URI.create(parentURI);
            }
            catch (Exception exception) {
                parentURI = ProjectModelUtils.getProjectModelURI(project, conf, (MContent)content.eContainer(), parentURI, allowRelative);
                contentRoot = URI.create(parentURI);
            }
        }
        if (contentRoot == null) {
            contentRoot = project.getContentRootURI();
        }
        String contentRootStr = contentRoot.toString();
        URI resolvedURI = origExpandedURI;
        try {
            resolvedURI = URIUtils.resolveURIFrom((URI)contentRoot, (URI)origExpandedURI);
            uriStr = resolvedURI.toString();
        }
        catch (Exception exception) {
            uriStr = origExpandedURI.toString();
        }
        String absUriStr = uriStr;
        if (!absUriStr.startsWith("file:")) {
            try {
                absUriStr = URIUtils.resolveURIToPath((URI)URI.create((String)uriStr)).toFile().toURI().toString();
            }
            catch (IOException iOException) {}
        }
        if (absUriStr.startsWith("file:") && conf != null) {
            IPath projPath;
            String tcPathUriStr;
            String sdkPathUriStr = ProjectModelUtils.getPathForEntry(project, conf, ISDKManager.class, SDK.manager(), (PropertyReference<String>)ProjectProperties.SDK_ID, "sdkInstallationPath");
            if (sdkPathUriStr != null) {
                absUriStr = ProjectModelUtils.replaceUriWithStudioVariable(absUriStr, sdkPathUriStr, "sdk");
                uriStr = absUriStr;
            }
            if ((tcPathUriStr = ProjectModelUtils.getPathForEntry(project, conf, IToolchainManager.class, Toolchain.manager(), (PropertyReference<String>)ProjectProperties.TOOLCHAIN_ID, "toolchainInstallationPath")) != null) {
                absUriStr = ProjectModelUtils.replaceUriWithStudioVariable(absUriStr, tcPathUriStr, "toolchain");
                uriStr = absUriStr;
            }
            if ((projPath = ProjectModelUtils.lookupProjectPath(project, conf)) != null) {
                String pathUriStr = projPath.toFile().toURI().toString();
                absUriStr = ProjectModelUtils.replaceUriWithStudioVariable(absUriStr, pathUriStr, "project");
                uriStr = absUriStr;
            }
        }
        if (((String)uriStr).length() == contentRootStr.length() - 1 && ((String)uriStr).equals(contentRootStr.substring(0, ((String)uriStr).length()))) {
            uriStr = (String)uriStr + "/";
        }
        if (allowRelative) {
            if (((String)uriStr).startsWith(contentRootStr)) {
                if (((String)(uriStr = ((String)uriStr).substring(contentRootStr.length()))).startsWith("/")) {
                    uriStr = ((String)uriStr).substring(1);
                }
                if (((String)uriStr).isEmpty()) {
                    uriStr = ".";
                }
            }
            return uriStr;
        }
        return uriStr;
    }

    private static IPath lookupProjectPath(IProjectModel project, IDescriptor conf) {
        IPath projPath = null;
        try {
            String projLoc = (String)project.getVariableLookup().getValue("projectLocation");
            if (TextUtils.hasContent((String)projLoc)) {
                projPath = URIUtils.resolveURIToPath((URI)URI.create(projLoc));
            }
            return projPath;
        }
        catch (IOException | IllegalArgumentException exception) {
            try {
                projPath = conf.getInstallationPath();
                return projPath != Path.EMPTY ? projPath : null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    private static <M extends IManager<?, ?>> String getPathForEntry(IProjectModel model, IDescriptor conf, Class<M> mgrClazz, IManager<?, ?> defMgr, PropertyReference<String> prop, String varProp) {
        IManager<?, ?> mgr = (IManager<?, ?>)conf.getAdapter(mgrClazz);
        IDescriptorEntity desc = (mgr != null ? mgr : defMgr).findCompatible((String)conf.getProperty(prop));
        try {
            IPath path = null;
            if (desc != null && (path = desc.getInstallationPath()) != Path.EMPTY) {
                return path.toFile().toURI().toString();
            }
            if (model.getVariableLookup() != null) {
                return (String)model.getVariableLookup().getValue(varProp);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static String replaceUriWithStudioVariable(String inUri, String inRepl, String type) {
        if (TextUtils.isEmpty((String)inRepl)) {
            return inUri;
        }
        String repl = inRepl.replaceFirst("file:[/]+", "file:/");
        Object uri = inUri.replaceFirst("file:[/]+", "file:/");
        int subStr = -1;
        if (((String)uri).startsWith(repl)) {
            subStr = repl.length();
        } else if (((String)uri + "/").startsWith(repl)) {
            subStr = repl.length() - 1;
        }
        if (subStr > -1) {
            if (((String)(uri = ((String)uri).substring(subStr))).startsWith("/")) {
                uri = ((String)uri).substring(1);
            }
            uri = "studio:/" + type + "/" + (String)uri;
        }
        return uri;
    }

    public static String replaceWithVariable(IProjectModel model, String source, String varName, String varValue) {
        int idx = source.indexOf(varValue);
        if (idx < 0) {
            return source;
        }
        Object wrappedVar = model != null ? model.wrapReference(varName) : "$(" + varName + ")";
        return source.substring(0, idx) + (String)wrappedVar + source.substring(idx + varValue.length());
    }

    public static MConfiguration findOrAddNewConfigurationFor(MProject project, IBuildConfigurationDescriptor desc) {
        return ProjectModelUtils.findOrAddNewConfigurationFor(project, desc, null);
    }

    public static MConfiguration findOrAddNewConfigurationFor(MProject project, IBuildConfigurationDescriptor desc, MConfiguration existingConfig) {
        boolean shouldMove;
        MConfiguration exist = project.findConfigurationByName(desc.getName());
        if (exist != null) {
            return exist;
        }
        String cloneId = (String)desc.getProperty(BuildConfigProperties.CLONE_CONFIG_ID);
        MConfiguration parent = existingConfig;
        if (parent == null) {
            parent = ProjectModuleHandlerUtils.findMatchingStockConfig(project, desc);
        }
        if (!TextUtils.isEmpty((String)cloneId)) {
            parent = project.findConfigurationByName(cloneId);
        } else if (parent == null && (shouldMove = Boolean.parseBoolean((String)project.getProperties().get((Object)"READ_FROM_EXISTING"))) && project.getConfigurations().size() > 0) {
            ProjectModelMergeUtils.moveSettingsIntoConfigs(project);
        }
        MConfiguration conf = parent != null ? (MConfiguration)EcoreTypeUtils.copy((EObject)parent) : ProjectModelFactory.eINSTANCE.createMConfiguration();
        conf.setName(desc.getName());
        conf.setLabel(desc.getLabel());
        conf.setDescription(desc.getDescription());
        conf.setBoardCompatibility(desc.getPropertyAccess().getValueString(ProjectProperties.BOARD_IDS));
        conf.setPartCompatibility(desc.getPartId());
        conf.setSdkCompatibility(desc.getSdkId());
        conf.setToolchainCompatibility(desc.getToolchainId());
        conf.setCompatibility(desc.getPropertyAccess().getValueString(CoreProperties.COMPATIBILITY.id()));
        project.getConfigurations().add((Object)conf);
        return conf;
    }

    public static void templatizeProject(MProject project, MConfiguration conf) {
        if (conf != null) {
            ProjectModelMergeUtils.copySettingsSite((MSettingsSite)project, (MSettingsSite)conf);
            ProjectModelMergeUtils.copyConfigSettings((MConfigSettings)project, (MConfigSettings)conf);
        }
        project.getConfigurations().clear();
    }

    public static boolean isCompatibleWith(MSelectable selectable, IBoard board) {
        if (board == null || selectable == null) {
            return true;
        }
        if (!TextUtils.isEmpty((String)selectable.getCompatibility())) {
            return ProjectCompatUtils.isCompatible(selectable, new IDescriptor[]{board});
        }
        String boardCompatibility = selectable.getBoardCompatibility();
        if (TextUtils.isEmpty((String)boardCompatibility)) {
            return true;
        }
        boolean compat = BoardCompatibility.fromGrammarString((String)boardCompatibility).isCompatibleWith((IDescriptor)board);
        return compat;
    }

    public static boolean isCompatibleWith(MSelectable selectable, IPart part) {
        boolean compat;
        if (part == null || selectable == null) {
            return true;
        }
        if (!TextUtils.isEmpty((String)selectable.getCompatibility())) {
            return ProjectCompatUtils.isCompatible(selectable, new IDescriptor[]{part});
        }
        String partCompatibility = selectable.getPartCompatibility();
        return partCompatibility == null || (compat = PartCompatibility.fromGrammarString((String)partCompatibility).isCompatibleWith((IDescriptor)part));
    }

    public static boolean isCompatibleWith(MProject project, IBoard board) {
        if (board == null || project == null) {
            return true;
        }
        if (!ProjectModelUtils.isCompatibleWith((MSelectable)project, board)) {
            return false;
        }
        if (!project.getConfigurations().isEmpty()) {
            boolean allIncompat = true;
            for (MConfiguration config : project.getConfigurations()) {
                allIncompat &= !ProjectModelUtils.isCompatibleWith((MSelectable)config, board);
            }
            return !allIncompat;
        }
        return true;
    }

    public static boolean isCompatibleWith(MProject project, IPart part) {
        if (part == null || project == null) {
            return true;
        }
        if (!ProjectModelUtils.isCompatibleWith((MSelectable)project, part)) {
            return false;
        }
        if (!project.getConfigurations().isEmpty()) {
            boolean allIncompat = true;
            for (MConfiguration config : project.getConfigurations()) {
                allIncompat &= !ProjectModelUtils.isCompatibleWith((MSelectable)config, part);
            }
            return !allIncompat;
        }
        return true;
    }

    public static MFolderEntry findSourceFolder(IProjectModel model, MProject pmodel) {
        String srcDirVar = null;
        if (model != null) {
            srcDirVar = model.wrapReference("sourceDir");
        }
        for (MFolderEntry folder : pmodel.getFolders()) {
            String name;
            if (folder.getName().equals(srcDirVar)) {
                return folder;
            }
            if (model == null || !(name = model.resolveString(folder.getName())).equals("src") && !name.equals(".")) continue;
            return folder;
        }
        return null;
    }

    public static IPath getProjectPathFor(MEntry entry) {
        Path parentPath = Path.EMPTY;
        if (entry instanceof MProject) {
            return parentPath;
        }
        if (!(entry.eContainer() instanceof MProject) && entry.eContainer() instanceof MFolderEntry) {
            parentPath = ProjectModelUtils.getProjectPathFor((MEntry)entry.eContainer());
        }
        return parentPath.append(entry.getName());
    }

    public static MFolderEntry findOrCreateFolder(IProjectModel model, MFolderEntry parent, String dirName) {
        MFolderEntry entry = ProjectModelUtils.findFolder(model, parent, dirName);
        if (entry != null) {
            return entry;
        }
        entry = ProjectModelFactory.eINSTANCE.createMFolderEntry();
        entry.setName(dirName);
        parent.getFolders().add((Object)entry);
        return entry;
    }

    public static MEntry findEntry(IProjectModel model, MFolderEntry parent, String entryName) {
        for (MFolderEntry folder : parent.getFolders()) {
            if (!entryName.equalsIgnoreCase(folder.getName())) continue;
            return folder;
        }
        for (MFileEntry file : parent.getFiles()) {
            if (!entryName.equalsIgnoreCase(file.getName())) continue;
            return file;
        }
        if (model != null) {
            String name;
            for (MFolderEntry folder : parent.getFolders()) {
                name = model.resolveString(folder.getName());
                if (!name.equalsIgnoreCase(entryName)) continue;
                return folder;
            }
            for (MFileEntry file : parent.getFiles()) {
                name = model.resolveString(file.getName());
                if (!name.equalsIgnoreCase(entryName)) continue;
                return file;
            }
        }
        return null;
    }

    public static MEntry findEntry(IProjectModel model, MFolderEntry parent, IPath path) {
        if (Path.EMPTY.equals((Object)path) || path == null) {
            return parent;
        }
        int seg = 0;
        while (seg < path.segmentCount()) {
            MEntry ent = ProjectModelUtils.findEntry(model, parent, path.segment(seg));
            if (ent == null) {
                return null;
            }
            if (seg == path.segmentCount() - 1) {
                return ent;
            }
            if (!(ent instanceof MFolderEntry)) {
                return null;
            }
            parent = (MFolderEntry)ent;
            ++seg;
        }
        return null;
    }

    public static MEntry findEntry(IVariableLookup variableLookup, MFolderEntry parent, IPath path) {
        if (Path.EMPTY.equals((Object)path) || path == null) {
            return parent;
        }
        int seg = 0;
        while (seg < path.segmentCount()) {
            MEntry ent = ProjectModelUtils.findEntry(variableLookup, parent, path.segment(seg));
            if (ent == null) {
                return null;
            }
            if (seg == path.segmentCount() - 1) {
                return ent;
            }
            if (!(ent instanceof MFolderEntry)) {
                return null;
            }
            parent = (MFolderEntry)ent;
            ++seg;
        }
        return null;
    }

    public static MEntry findEntry(IVariableLookup variableLookup, MFolderEntry parent, String entryName) {
        for (MFolderEntry folder : parent.getFolders()) {
            if (!entryName.equalsIgnoreCase(folder.getName())) continue;
            return folder;
        }
        for (MFileEntry file : parent.getFiles()) {
            if (!entryName.equalsIgnoreCase(file.getName())) continue;
            return file;
        }
        if (variableLookup != null) {
            String name;
            for (MFolderEntry folder : parent.getFolders()) {
                name = substEngine.substitute(folder.getName(), variableLookup);
                if (!name.equalsIgnoreCase(entryName)) continue;
                return folder;
            }
            for (MFileEntry file : parent.getFiles()) {
                name = substEngine.substitute(file.getName(), variableLookup);
                if (!name.equalsIgnoreCase(entryName)) continue;
                return file;
            }
        }
        return null;
    }

    public static MReference findReference(MFolderReference parent, IPath path) {
        if (path.segmentCount() == 0) {
            return parent;
        }
        String seg = path.segment(0);
        for (MFolderReference f : parent.getFolders()) {
            if (!f.getRef().getName().equalsIgnoreCase(seg)) continue;
            return ProjectModelUtils.findReference(f, path.removeFirstSegments(1));
        }
        for (MFolderReference f : parent.getFiles()) {
            if (!f.getRef().getName().equals(seg)) continue;
            if (path.segmentCount() > 1) {
                return null;
            }
            return f;
        }
        return null;
    }

    public static Collection<MReference> findAllReferences(MFolderReference parent, IPath path) {
        if (path.segmentCount() == 0) {
            return Arrays.asList(parent);
        }
        ArrayList<MReference> refs = new ArrayList<MReference>();
        String seg = path.segment(0);
        for (MFolderReference f : parent.getFolders()) {
            if (!f.getRef().getName().equalsIgnoreCase(seg)) continue;
            refs.addAll(ProjectModelUtils.findAllReferences(f, path.removeFirstSegments(1)));
        }
        for (MFolderReference f : parent.getFiles()) {
            if (!f.getRef().getName().equals(seg) || path.segmentCount() > 1) continue;
            refs.add((MReference)f);
        }
        return refs;
    }

    public static MReference findReference(MFolderReference parent, String refName) {
        for (MFolderReference folder : parent.getFolders()) {
            if (!refName.equalsIgnoreCase(folder.getRef().getName())) continue;
            return folder;
        }
        for (MFileReference file : parent.getFiles()) {
            if (!refName.equalsIgnoreCase(file.getRef().getName())) continue;
            return file;
        }
        return null;
    }

    public static MFolderEntry findFolder(IProjectModel model, MFolderEntry parent, String dirName) {
        MEntry ent = ProjectModelUtils.findEntry(model, parent, dirName);
        if (ent instanceof MFolderEntry) {
            return (MFolderEntry)ent;
        }
        return null;
    }

    public static MFileEntry findFile(IProjectModel model, MFolderEntry parent, String fileName) {
        MEntry ent = ProjectModelUtils.findEntry(model, parent, fileName);
        if (ent instanceof MFileEntry) {
            return (MFileEntry)ent;
        }
        return null;
    }

    public static MFileEntry findFile(IProjectModel model, MFolderEntry parent, IPath filePath) {
        MEntry ent = ProjectModelUtils.findEntry(model, parent, filePath);
        if (ent instanceof MFileEntry) {
            return (MFileEntry)ent;
        }
        return null;
    }

    public static MFolderContent findOrCreateFolderContent(IProjectModel model, MProject project, MFolderEntry parent, String dirName, String contentUri) {
        MFolderEntry match = ProjectModelUtils.findOrCreateFolder(model, parent, dirName);
        if (match instanceof MFolderContent) {
            return (MFolderContent)match;
        }
        MFolderContent content = ProjectModelFactory.eINSTANCE.createMFolderContent();
        content.setIncludeAllFolders(false);
        content.setIncludeAllFiles(false);
        content.setUri(contentUri);
        content.setName(dirName);
        if (match != null) {
            content.getFolders().addAll((Collection)match.getFolders());
            content.getFiles().addAll((Collection)match.getFiles());
            content.setBoardCompatibility(match.getBoardCompatibility());
            content.setPartCompatibility(match.getPartCompatibility());
            content.setSdkCompatibility(match.getSdkCompatibility());
            content.setToolchainCompatibility(match.getToolchainCompatibility());
            content.setCompatibility(match.getCompatibility());
            parent.getFolders().remove((Object)match);
        }
        parent.getFolders().add((Object)content);
        return content;
    }

    public static MFileContent findOrCreateFileContent(IProjectModel model, MFolderEntry parent, String fileName, String contentUri) {
        MFileEntry match = ProjectModelUtils.findFile(model, parent, fileName);
        MFileContent content = null;
        if (match instanceof MFileContent) {
            content = (MFileContent)match;
        }
        if (content == null) {
            content = ProjectModelFactory.eINSTANCE.createMFileContent();
            content.setUri(contentUri);
            content.setName(fileName);
            if (match != null) {
                content.setBoardCompatibility(match.getBoardCompatibility());
                content.setPartCompatibility(match.getPartCompatibility());
                content.setSdkCompatibility(match.getSdkCompatibility());
                content.setToolchainCompatibility(match.getToolchainCompatibility());
                content.setCompatibility(match.getCompatibility());
                parent.getFiles().remove((Object)match);
            }
            parent.getFiles().add((Object)content);
        }
        return content;
    }

    public static MFolderEntry findFolder(IProjectModel model, MFolderEntry parent, IPath dirPath) {
        MFolderEntry entry = parent;
        int i = 0;
        while (i < dirPath.segmentCount()) {
            if ((entry = ProjectModelUtils.findFolder(model, entry, dirPath.segment(i))) == null) {
                return null;
            }
            ++i;
        }
        return entry;
    }

    public static MFolderEntry findOrCreateFolder(IProjectModel model, MFolderEntry parent, IPath dirPath) {
        MFolderEntry entry = parent;
        int i = 0;
        while (i < dirPath.segmentCount()) {
            entry = ProjectModelUtils.findOrCreateFolder(model, entry, dirPath.segment(i));
            ++i;
        }
        return entry;
    }

    public static MFolderContent findOrCreateFolderContent(IProjectModel model, MProject project, IPath dirPath, String contentUri) {
        MFolderEntry parent = ProjectModelUtils.findOrCreateFolder(model, (MFolderEntry)project, dirPath.removeLastSegments(1));
        MFolderContent content = ProjectModelUtils.findOrCreateFolderContent(model, project, parent, dirPath.lastSegment(), contentUri);
        return content;
    }

    public static MFolderContent findOrCreateVirtualFolder(IProjectModel model, MFolderEntry parent, String groupName) {
        MFolderEntry match = ProjectModelUtils.findOrCreateFolder(model, parent, groupName);
        if (match instanceof MFolderContent) {
            return (MFolderContent)match;
        }
        MFolderContent content = ProjectModelFactory.eINSTANCE.createMFolderContent();
        content.setIncludeAllFolders(false);
        content.setIncludeAllFiles(false);
        content.setVirtual(true);
        content.setName(groupName);
        if (match != null) {
            content.getFolders().addAll((Collection)match.getFolders());
            content.getFiles().addAll((Collection)match.getFiles());
            content.setBoardCompatibility(match.getBoardCompatibility());
            content.setPartCompatibility(match.getPartCompatibility());
            content.setSdkCompatibility(match.getSdkCompatibility());
            content.setToolchainCompatibility(match.getToolchainCompatibility());
            content.setCompatibility(match.getCompatibility());
            parent.getFolders().remove((Object)match);
        }
        parent.getFolders().add((Object)content);
        return content;
    }

    public static MFileEntry findOrCreateFile(IProjectModel model, MProject project, IPath dirPath) {
        MFolderEntry parent = ProjectModelUtils.findOrCreateFolder(model, (MFolderEntry)project, dirPath.removeLastSegments(1));
        MFileEntry entry = ProjectModelUtils.findOrCreateFile(model, parent, dirPath.lastSegment());
        return entry;
    }

    public static MFileEntry findOrCreateFile(IProjectModel model, MFolderEntry parent, String fileName) {
        MFileEntry entry = ProjectModelUtils.findFile(model, parent, fileName);
        if (entry == null) {
            entry = ProjectModelFactory.eINSTANCE.createMFileEntry();
            entry.setName(fileName);
            parent.getFiles().add((Object)entry);
        }
        return entry;
    }

    public static MFileContent findOrCreateFileContent(IProjectModel model, MProject project, IPath dirPath, String contentUri) {
        MFolderEntry parent = ProjectModelUtils.findOrCreateFolder(model, (MFolderEntry)project, dirPath.removeLastSegments(1));
        MFileContent content = ProjectModelUtils.findOrCreateFileContent(model, parent, dirPath.lastSegment(), contentUri);
        return content;
    }
}

