/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine.operations;

import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.operations.BaseLanguageAwareProjectSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectLanguageSettingOperation;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MToolListOption;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddToolOptionOperation
extends BaseLanguageAwareProjectSettingOperation
implements IProjectLanguageSettingOperation {
    private MToolOption toolOption;
    private String value;
    private Collection<AddToolListOptionOperation> listOptions;

    public AddToolOptionOperation(IProjectEngineSession session, String buildConfig, MToolOption option, List<MToolListOption> listOptions, IPath projectPath) {
        super(session, buildConfig, projectPath, (MBuildSetting)option);
        this.toolOption = option;
        this.value = this.toolOption.getValue();
        if (this.shouldResolve(this.value)) {
            this.value = session.getProjectModel().resolveString(this.toolOption.getValue());
        }
        this.listOptions = this.createListOptions(session, listOptions);
    }

    private boolean shouldResolve(String optValue) {
        if (this.value == null) {
            return true;
        }
        return !this.value.contains("$(OUTPUT_DIR)") && !this.value.contains("$(PROJECTNAME)");
    }

    @Override
    public final void executeProcess(IProjectEngineOperationHandler handler, IProgressMonitor monitor) throws CoreException {
        handler.handleAddToolOptionOperation(this, monitor);
    }

    private Collection<AddToolListOptionOperation> createListOptions(IProjectEngineSession session, List<MToolListOption> listOptions) {
        if (listOptions == null) {
            return Collections.emptyList();
        }
        List listOpts = listOptions.stream().map(mToolListOption -> new AddToolListOptionOperation((MToolListOption)mToolListOption)).collect(Collectors.toList());
        return Collections.unmodifiableCollection(listOpts);
    }

    @Override
    public String toString() {
        return "AddToolOptionOperation [toolId=" + this.getToolId() + ", optionId=" + this.getOptionId() + ", value=" + this.getValue() + ", listValue=" + Arrays.toString(this.getListValues()) + "]";
    }

    public String getToolId() {
        return this.toolOption.getToolId();
    }

    public String getOptionId() {
        return this.toolOption.getOptionId();
    }

    public String getValue() {
        return this.value;
    }

    public String[] getListValues() {
        return (String[])this.listOptions.stream().map(AddToolListOptionOperation::getValue).toArray(String[]::new);
    }

    public Collection<AddToolListOptionOperation> getListOperatons() {
        return this.listOptions;
    }

    public final class AddToolListOptionOperation
    extends BaseLanguageAwareProjectSettingOperation
    implements IProjectLanguageSettingOperation {
        private MToolListOption listOpt;

        private AddToolListOptionOperation(MToolListOption listOpt) {
            super(AddToolOptionOperation.this.getSession(), AddToolOptionOperation.this.getBuildConfiguration(), AddToolOptionOperation.this.getProjectPath(), (MBuildSetting)listOpt);
            this.listOpt = listOpt;
        }

        public String getValue() {
            return this.listOpt.getValue();
        }

        @Override
        public void executeProcess(IProjectEngineOperationHandler handler, IProgressMonitor monitor) throws CoreException {
        }
    }
}

