/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IImportProjectEngine;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.api.core.model.MGenericOption;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MSpecificOption;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingEngine;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelSwitchRecurser;
import com.silabs.ss.framework.project.api.core.templates.IProjectModelTemplate;
import com.silabs.ss.framework.project.api.core.templates.ProjectModelTemplateFactory;
import com.silabs.ss.framework.project.api.templates.ITemplate;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.TemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.TemplateProperties;
import com.silabs.ss.framework.project.api.toolchain.core.IToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchain;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainManager;
import com.silabs.ss.framework.project.api.toolchain.core.ToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.api.toolchain.core.adapters.IToolchainOptionAdapter;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfiguration;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationManager;
import com.silabs.ss.framework.project.api.toolchain.core.configs.StockConfiguration;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.compatibility.Compatibility;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;
import com.silabs.ss.platform.api.descriptor.core.property.model.PropertyConversionUtils;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.descriptor.core.type.EcoreTypeUtils;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;

public class ImportProjectModelEngine
implements IImportProjectEngine {
    public static final String IMPORTED_PROJECT_REPORT_HTML = "imported_project_report.html";

    @Override
    public void setupImportDescriptor(IImportProjectDescriptor descr, IProgressMonitor monitor) throws CoreException {
        this.doUpdateFromExistingProject(descr, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
    }

    protected void doUpdateFromExistingProject(IImportProjectDescriptor descr, IProgressMonitor monitor) throws CoreException {
        MProject mproject = descr.getProjectModel();
        if (mproject != null) {
            descr.getReport().setProject(mproject);
            mproject.setName(descr.getName());
            this.setupBuildConfigs(descr, mproject);
            this.importOptions(descr, mproject);
            this.reportImportedOptions(descr, mproject);
            this.tryMigrateOptions(descr, mproject);
            this.convertGenericOptions(descr, mproject);
            this.reportSettingConversions(descr, mproject);
            this.finalizeSettingConversions(descr, mproject);
            if (descr.getTemplate() == null) {
                descr.setTemplate(this.createImportModelTemplate(mproject));
            }
        }
        monitor.done();
    }

    protected void setupBuildConfigs(IImportProjectDescriptor descr, MProject mproject) throws CoreException {
        if (!descr.isRecreateConfigurations() && !mproject.getConfigurations().isEmpty()) {
            String fallbackToolchain = null;
            fallbackToolchain = descr.getToolchainId();
            boolean warnedToolchainCompatibility = false;
            IStockConfigurationDescriptor[] stockDescs = StockConfiguration.manager().getStockConfigurationDescriptors(fallbackToolchain);
            ArrayList<IBuildConfigurationDescriptor> buildConfigs = new ArrayList<IBuildConfigurationDescriptor>();
            for (MConfiguration config : mproject.getConfigurations()) {
                String impToolchainId;
                boolean createNew;
                IBuildConfigurationDescriptor conf = descr.findBuildConfigurationDescriptor(config.getName());
                boolean bl = createNew = conf == null;
                if (createNew) {
                    if (!TextUtils.isEmpty((String)config.getStockConfigCompatibility())) {
                        boolean foundMatch = false;
                        IStockConfigurationDescriptor[] iStockConfigurationDescriptorArray = stockDescs;
                        int n = stockDescs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStockConfigurationManager stockConfigurationManager;
                            boolean compat;
                            IStockConfigurationDescriptor stockDesc = iStockConfigurationDescriptorArray[n2];
                            String stockCompat = config.getStockConfigCompatibility();
                            if (!TextUtils.isEmpty((String)stockCompat) && (compat = Compatibility.fromGrammarString((IRegistry)(stockConfigurationManager = StockConfiguration.manager()), (String)stockCompat).isCompatibleWith((IDescriptor)stockDesc))) {
                                try {
                                    IStockConfiguration stock = (IStockConfiguration)StockConfiguration.manager().get((IDescriptor)stockDesc);
                                    conf = descr.createBuildConfigurationDescriptor(stock);
                                    foundMatch = true;
                                    break;
                                }
                                catch (CoreException e) {
                                    Activator.reporter.logError("could not make stock config from " + String.valueOf(config), (Throwable)e);
                                }
                            }
                            ++n2;
                        }
                        if (!foundMatch) {
                            continue;
                        }
                    } else {
                        conf = descr.createBuildConfiguration();
                    }
                    conf.setName(config.getName());
                    conf.setLabel(config.getLabel());
                    conf.setDescription(config.getDescription());
                }
                conf.getPropertyAccess().copyFrom(config.getProperties().map());
                for (MToolOption toolOpt : config.getToolOptions()) {
                    conf.getAdditionalStockOptions().add((IToolOption)new ToolOption(toolOpt.getToolId(), toolOpt.getOptionId(), toolOpt.getValue(), new String[0]));
                }
                if (TextUtils.isEmpty((String)conf.getToolchainId())) {
                    if (fallbackToolchain == null) {
                        throw Activator.reporter.newCoreException("importer did not assign a toolchain for " + conf.getLabel());
                    }
                    conf.setToolchainId(fallbackToolchain);
                }
                if (TextUtils.isEmpty((String)(impToolchainId = config.getToolchainCompatibility()))) {
                    impToolchainId = mproject.getToolchainCompatibility();
                }
                if (!(warnedToolchainCompatibility || TextUtils.isEmpty((String)impToolchainId) || Compatibility.fromGrammarString((IRegistry)Toolchain.manager(), (String)impToolchainId).isCompatibleWith(conf.getToolchainId()))) {
                    descr.getReport().addMessage(2, "The imported project uses a different toolchain from the target Studio toolchain. Validate that the runtime entry points (if needed) are adapted properly, that linker scripts have been migrated, etc. before linking.");
                    warnedToolchainCompatibility = true;
                }
                buildConfigs.add(conf);
            }
            descr.buildConfigurationDescriptors().clear();
            descr.buildConfigurationDescriptors().addAll(buildConfigs);
            if (descr.getCurrentConfigurationDescriptor() == null && !descr.buildConfigurationDescriptors().isEmpty()) {
                descr.setCurrentConfigurationDescriptor(descr.buildConfigurationDescriptors().iterator().next());
            }
        } else {
            mproject.getConfigurations().clear();
        }
    }

    protected void importOptions(IImportProjectDescriptor descr, MProject mproject) {
        ImportProjectModelEngine.runOptionsImport(descr, mproject);
    }

    public static void runOptionsImport(IImportProjectDescriptor descr, MProject mproject) {
        final ArrayList<IOptionMappingEngine> engines = new ArrayList<IOptionMappingEngine>(1);
        for (IOptionMappingRegistry<?, ?, ?> registry : descr.getOptionMappingRegistries()) {
            IOptionMappingEngine engine = registry.createOptionMappingEngine();
            engines.add(engine);
        }
        new BaseSettingsSiteSwitch(descr){

            @Override
            protected void doHandleSettingsSite(MSettingsSite site) {
                for (IOptionMappingEngine engine : engines) {
                    engine.importOptions(site);
                }
            }
        }.doSwitch((EObject)mproject);
    }

    protected void reportImportedOptions(IImportProjectDescriptor descr, MProject mproject) {
        new BaseSettingsSiteSwitch(descr){

            @Override
            protected void doHandleSettingsSite(MSettingsSite site) {
                for (MConvertedOption option : site.getConvertedOptions()) {
                    if (!(option instanceof MSpecificOption)) continue;
                    MSpecificOption spec = (MSpecificOption)option;
                    this.descr.getReport().reportImportedOption(site, spec);
                }
            }
        }.doSwitch((EObject)mproject);
    }

    protected void tryMigrateOptions(IImportProjectDescriptor descr, MProject mproject) {
        new BaseSettingsSiteSwitch(descr){

            @Override
            protected void doHandleSettingsSite(MSettingsSite site) {
                if (this.toolchain == null) {
                    return;
                }
                IToolchainOptionAdapter adapter = (IToolchainOptionAdapter)this.toolchain.getAdapter(IToolchainOptionAdapter.class);
                if (adapter == null) {
                    return;
                }
                Iterator iter = site.getConvertedOptions().iterator();
                while (iter.hasNext()) {
                    MSpecificOption spec;
                    MSpecificOption toolSpec;
                    MConvertedOption option = (MConvertedOption)iter.next();
                    if (!(option instanceof MSpecificOption) || (toolSpec = adapter.tryMigrateOption(spec = (MSpecificOption)option)) == null) continue;
                    MToolOption opt = ImportProjectModelEngine.this.convertToToolOption(toolSpec);
                    adapter.expandToolOption(opt);
                    site.getToolOptions().add((Object)opt);
                    MSpecificOption importedFrom = spec.getImportedOption() != null ? spec.getImportedOption() : spec;
                    this.descr.getReport().reportMigratedOption(site, importedFrom, opt);
                    iter.remove();
                }
                for (MToolOption option : site.getToolOptions()) {
                    adapter.expandToolOption(option);
                }
            }
        }.doSwitch((EObject)mproject);
    }

    protected MToolOption convertToToolOption(MSpecificOption spec) {
        IProperty specOpt = (IProperty)Property.registry().findDescriptor(spec.getOptionId());
        MToolOption opt = ProjectModelFactory.eINSTANCE.createMToolOption();
        opt.setToolId(spec.getToolId());
        opt.setOptionId(spec.getOptionId());
        if (specOpt != null) {
            opt.setValue(PropertyConversionUtils.stringizeValue((IProperty)specOpt, (Object)spec.getValue()));
        } else {
            opt.setValue(String.valueOf(spec.getValue()));
        }
        return opt;
    }

    protected void convertGenericOptions(IImportProjectDescriptor descr, MProject mproject) {
        for (MConvertedOption option : mproject.getConvertedOptions()) {
            for (MConfiguration config : mproject.getConfigurations()) {
                boolean found = false;
                for (MConvertedOption coption : config.getConvertedOptions()) {
                    if (!coption.getToolId().equals(option.getToolId()) || !coption.getOptionId().equals(option.getOptionId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                config.getConvertedOptions().add((Object)((MConvertedOption)EcoreTypeUtils.copy((EObject)option)));
            }
        }
        mproject.getConvertedOptions().clear();
        new BaseSettingsSiteSwitch(descr){

            @Override
            protected void doHandleSettingsSite(MSettingsSite site) {
                if (this.toolchainOptionMapper != null) {
                    MSpecificOption[] specifics;
                    MSpecificOption[] mSpecificOptionArray = specifics = this.toolchainOptionMapper.exportOptions(site);
                    int n = specifics.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MSpecificOption specific = mSpecificOptionArray[n2];
                        for (MGenericOption generic : specific.getGenericMappings()) {
                            site.getConvertedOptions().remove((Object)generic);
                            site.getConvertedOptions().removeAll((Collection)generic.getSpecificMappings());
                        }
                        site.getConvertedOptions().add((Object)specific);
                        ++n2;
                    }
                }
            }
        }.doSwitch((EObject)mproject);
    }

    protected void reportSettingConversions(IImportProjectDescriptor descr, MProject mproject) {
        new BaseSettingsSiteSwitch(descr){

            @Override
            protected void doHandleSettingsSite(MSettingsSite site) {
                this.descr.getReport().reportSettingConversions(site);
            }
        }.doSwitch((EObject)mproject);
    }

    protected void finalizeSettingConversions(IImportProjectDescriptor descr, MProject mproject) {
        new BaseSettingsSiteSwitch(descr){

            @Override
            protected void doHandleSettingsSite(MSettingsSite site) {
                for (MConvertedOption cnv : site.getConvertedOptions()) {
                    if (!(cnv instanceof MSpecificOption) || ((MSpecificOption)cnv).getImportedOption() == null) continue;
                    MToolOption opt = ImportProjectModelEngine.this.convertToToolOption((MSpecificOption)cnv);
                    site.getToolOptions().add((Object)opt);
                }
                site.getConvertedOptions().clear();
            }
        }.doSwitch((EObject)mproject);
    }

    protected ITemplate createImportModelTemplate(MProject project) throws CoreException {
        TemplateDescriptor importedTemplateDesc = new TemplateDescriptor();
        importedTemplateDesc.setName("imported." + project.getName());
        importedTemplateDesc.setProperty(CoreProperties.PART_COMPATIBILITY.id(), (Object)".*");
        importedTemplateDesc.setProperty(CoreProperties.HIDDEN, (Object)true);
        importedTemplateDesc.setProperty(TemplateProperties.COPY_ORIGINAL_CONTENT, (Object)true);
        IProjectModelTemplate importedTemplate = ProjectModelTemplateFactory.createProjectModelTemplate((ITemplateDescriptor)importedTemplateDesc);
        importedTemplate.setMProject(project);
        return importedTemplate;
    }

    @Override
    public void writeImportReport(IImportProjectDescriptor descr) throws CoreException {
        String report = descr.getReport().createReport();
        try {
            File file;
            IPath projLoc = URIUtils.resolveURIToPath((URI)descr.getProjectDescriptionLocationURI());
            if (projLoc.toFile().isFile()) {
                projLoc = projLoc.removeLastSegments(1);
            }
            if ((file = projLoc.append(IMPORTED_PROJECT_REPORT_HTML).toFile()).isFile()) {
                file.delete();
            }
            file.getParentFile().mkdirs();
            FileUtils.writeFileContents((File)file, (String)report);
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("Failed to create import report", (Throwable)e);
        }
    }

    static abstract class BaseSettingsSiteSwitch
    extends ProjectModelSwitchRecurser<Object> {
        protected IImportProjectDescriptor descr;
        protected IBuildConfigurationDescriptor config;
        protected IToolchain toolchain;
        protected IOptionMappingEngine toolchainOptionMapper;

        public BaseSettingsSiteSwitch(IImportProjectDescriptor descr) {
            this.descr = descr;
        }

        public Object caseMConfiguration(MConfiguration mconf) {
            this.setupGlobals(mconf);
            this.caseMSettingsSite((MSettingsSite)mconf);
            for (Map.Entry entry : mconf.getEntrySettings()) {
                this.caseMSettingsSite((MSettingsSite)entry.getValue());
                this.doSwitch((EObject)entry.getValue());
            }
            return this;
        }

        private void setupGlobals(MConfiguration mconf) {
            this.config = this.descr.findBuildConfigurationDescriptor(mconf.getName());
            if (this.config == null) {
                return;
            }
            this.toolchain = (IToolchain)((IToolchainManager)this.descr.getAdapter(IToolchainManager.class)).find(this.config.getToolchainId());
            if (this.toolchain == null) {
                return;
            }
            IToolchainOptionAdapter adapter = (IToolchainOptionAdapter)this.toolchain.getAdapter(IToolchainOptionAdapter.class);
            if (adapter == null) {
                return;
            }
            this.toolchainOptionMapper = adapter.getGenericOptionMappingRegistry().createOptionMappingEngine();
        }

        public Object caseMSettingsSite(MSettingsSite site) {
            this.doHandleSettingsSite(site);
            return null;
        }

        protected abstract void doHandleSettingsSite(MSettingsSite var1);
    }
}

