/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external;

import com.silabs.ss.framework.project.api.core.external.TimeLimit;
import java.util.Calendar;

public class TimeLimitingInfo {
    private Calendar today = Calendar.getInstance();
    private Calendar pastWeek;
    private Calendar twoWeeks;
    private Calendar thisMonth;
    private Calendar threeMonths;
    private Calendar aYear;
    private Calendar anytime;
    private TimeLimit todayLimit;
    private TimeLimit pastWeekLimit;
    private TimeLimit twoWeeksLimit;
    private TimeLimit thisMonthLimit;
    private TimeLimit threeMonthLimit;
    private TimeLimit thisYearLimit;
    private TimeLimit anytimeLimit;
    public final TimeLimit[] stockTimeRanges;

    public TimeLimitingInfo() {
        this.today.set(11, 0);
        this.today.set(12, 0);
        this.today.set(13, 0);
        this.today.set(14, 0);
        this.pastWeek = Calendar.getInstance();
        this.pastWeek.setTime(this.today.getTime());
        this.pastWeek.add(6, -7);
        this.twoWeeks = Calendar.getInstance();
        this.twoWeeks.setTime(this.pastWeek.getTime());
        this.twoWeeks.add(6, -7);
        this.thisMonth = Calendar.getInstance();
        this.thisMonth.setTime(this.pastWeek.getTime());
        this.thisMonth.set(5, 1);
        this.threeMonths = Calendar.getInstance();
        this.threeMonths.setTime(this.thisMonth.getTime());
        this.threeMonths.add(2, -3);
        this.aYear = Calendar.getInstance();
        this.aYear.setTime(this.thisMonth.getTime());
        this.aYear.add(1, -1);
        this.anytime = Calendar.getInstance();
        this.anytime.clear();
        this.todayLimit = new TimeLimit("today", this.today);
        this.pastWeekLimit = new TimeLimit("within the past week", this.pastWeek);
        this.twoWeeksLimit = new TimeLimit("within the past two weeks", this.twoWeeks);
        this.thisMonthLimit = new TimeLimit("within the past month", this.thisMonth);
        this.threeMonthLimit = new TimeLimit("within the past three months", this.threeMonths);
        this.thisYearLimit = new TimeLimit("within the past year", this.aYear);
        this.anytimeLimit = new TimeLimit("at any time", this.anytime);
        this.stockTimeRanges = new TimeLimit[]{this.todayLimit, this.pastWeekLimit, this.twoWeeksLimit, this.thisMonthLimit, this.threeMonthLimit, this.thisYearLimit, this.anytimeLimit};
    }

    public TimeLimit getThisMonth() {
        return this.thisMonthLimit;
    }

    public TimeLimit getAnytimeLimit() {
        return this.anytimeLimit;
    }
}

