/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.solution;

import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.ss.framework.project.api.core.solution.SolutionProperties;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionConfig;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionDefinition;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModule;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModuleReferenceContainer;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionProject;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionSettings;
import com.silabs.ss.framework.project.api.core.solution.model.SolutionModelFactory;
import com.silabs.ss.framework.project.api.core.utils.SolutionUpdateUtils;
import com.silabs.ss.framework.project.internal.core.solution.SolutionModelUtils;
import com.silabs.ss.platform.api.descriptor.core.model.MDescribable;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptorProperties;
import com.silabs.ss.platform.api.descriptor.core.property.DescriptorPropertyMapper;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyMapper;
import com.silabs.ss.platform.api.descriptor.core.type.EcoreTypeUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;

public final class BaseSolutionFactory {
    public static final String DEFAULT_DEBUG_GROUP_NAME = "Default";

    public static <T> void setProperty(IPropertyMapper<IProperty, ?> mapper, MDescriptorProperties props, PropertyReference<T> key, T value, boolean builtin) {
        if (key == null) {
            return;
        }
        props.putPropertyEntry(BaseSolutionFactory.getPropId(mapper, key), key.type().stringize(value), builtin);
    }

    public static <T> T getProperty(IPropertyMapper<IProperty, ?> mapper, Map<String, String> map, PropertyReference<T> key) {
        if (key == null) {
            return null;
        }
        return (T)key.type().convert(map.get(BaseSolutionFactory.getPropId(mapper, key)));
    }

    public static String getPropId(IPropertyMapper<IProperty, ?> mapper, PropertyReference<?> key) {
        IProperty prop = (IProperty)mapper.findProperty(key.id());
        if (prop != null) {
            return prop.getId();
        }
        return key.id();
    }

    public static class BaseCreateGeneralProject<CProj extends BaseCreateGeneralProject<CProj>>
    extends SolutionProjectCreator {
        private MSolutionSettings parentModel;
        private BaseSolutionObjCreator<?> parent;

        protected BaseCreateGeneralProject(BaseSolutionObjCreator<?> parent, MSolutionSettings parentModel, String projectName) {
            super(projectName);
            this.parent = parent;
            this.parentModel = parentModel;
            super.findOrApply(parentModel);
        }

        public CProj setProject(String projectName) {
            super.setProject(projectName);
            return (CProj)this.retThis();
        }

        public CProj setConfiguration(String configName) {
            super.setConfiguration(configName);
            return (CProj)this.retThis();
        }

        public CProj setBinary(String binaryPath) {
            super.setBinary(binaryPath);
            return (CProj)this.retThis();
        }

        public CProj setLocation(String location) {
            super.setLocation(location);
            return (CProj)this.retThis();
        }

        public CProj setBuiltin(boolean isBuiltin) {
            super.setBuiltin(isBuiltin);
            return (CProj)this.retThis();
        }

        public Object remove() {
            this.validate();
            this.removeFrom(this.parentModel);
            return null;
        }

        public Object commit() {
            this.validate();
            return null;
        }

        @Override
        protected void validate() {
            this.parent.validate();
        }

        @Override
        protected CProj retThis() {
            return (CProj)this;
        }
    }

    public static abstract class BaseCreateSolution<CSln extends BaseCreateSolution<CSln>>
    extends BaseCreateSolutionDefinition<CSln> {
        protected BaseCreateSolution(MSolution model) {
            super((MSolutionDefinition)model);
        }

        protected BaseCreateSolution(String name) {
            this(SolutionModelFactory.eINSTANCE.createMSolution());
            this.setName(name);
        }

        public CSln setName(String name) {
            this.validate();
            this.model().setName(name);
            this.model().setLabel(name);
            return (CSln)((BaseCreateSolution)this.retThis());
        }

        public String getName() {
            return this.model().getName();
        }

        public MSolution createSolution() {
            this.ensureValid();
            this.isDestroyed = true;
            return this.model();
        }

        protected void ensureValid() {
            if (this.isDestroyed) {
                return;
            }
            if (this.configurations().isEmpty()) {
                BaseCreateSolutionConfiguration<?> config = this.configuration(BaseSolutionFactory.DEFAULT_DEBUG_GROUP_NAME);
                config.commit();
            }
            if (!this.configurations().contains(this.getActiveConfiguration())) {
                this.setActiveConfiguration(this.configurations().iterator().next());
            }
        }

        public MSolution model() {
            return (MSolution)super.model();
        }
    }

    public static class BaseCreateSolutionConfigProject<CProj extends BaseCreateSolutionConfigProject<CProj>>
    extends BaseCreateGeneralProject<CProj> {
        private BaseCreateSolutionConfiguration<?> parent;

        protected BaseCreateSolutionConfigProject(BaseCreateSolutionConfiguration<?> parent, String projectName) {
            super(parent, (MSolutionSettings)parent.model(), projectName);
            this.parent = parent;
        }

        @Override
        public BaseCreateSolutionConfiguration<?> remove() {
            super.remove();
            return this.parent;
        }

        @Override
        public BaseCreateSolutionConfiguration<?> commit() {
            super.commit();
            return this.parent;
        }
    }

    public static abstract class BaseCreateSolutionConfiguration<CConfig extends BaseCreateSolutionConfiguration<CConfig>>
    extends BaseSolutionCreateSolutionSettings<CConfig> {
        private BaseCreateSolutionDefinition<?> parent;
        private boolean isExistingModel = false;

        protected BaseCreateSolutionConfiguration(BaseCreateSolutionDefinition<?> parent, String groupName) {
            super((MSolutionSettings)SolutionModelFactory.eINSTANCE.createMSolutionConfig());
            this.parent = parent;
            parent.validate();
            this.model().setName(groupName);
            parent.model().getConfigs().stream().filter(this.filter(groupName)).findFirst().ifPresent(this::setModel);
        }

        @Override
        protected void setModel(EObject model) {
            this.isExistingModel = true;
            super.setModel(model);
        }

        private Predicate<? super MSolutionConfig> filter(String groupName) {
            return d -> Objects.equals(d.getName(), groupName);
        }

        public CConfig ifNew(Consumer<CConfig> runner) {
            if (!this.isExistingModel) {
                runner.accept(this.retThis());
            }
            return (CConfig)this.retThis();
        }

        public CConfig ifExisting(Consumer<CConfig> runner) {
            if (this.isExistingModel) {
                runner.accept(this.retThis());
            }
            return (CConfig)this.retThis();
        }

        public CConfig setName(String name) {
            this.validate();
            this.model().setName(name);
            return (CConfig)this.retThis();
        }

        public String getName() {
            return this.model().getName();
        }

        public CConfig setBuiltin(boolean builtin) {
            this.model().setBuiltin(builtin);
            return (CConfig)this.retThis();
        }

        @Override
        public <P> CConfig setProperty(PropertyReference<P> key, P value) {
            return (CConfig)((BaseCreateSolutionConfiguration)this.setProperty(key, value, false));
        }

        public BaseCreateSolutionDefinition<?> remove() {
            this.validate();
            this.parent.model().getConfigs().removeIf(this.filter(this.model().getName()));
            return this.parent;
        }

        public BaseCreateSolutionDefinition<?> commit() {
            this.validate();
            if (!this.isExistingModel) {
                this.parent.model().getConfigs().add((Object)this.model());
            }
            return this.parent;
        }

        public MSolutionConfig model() {
            return (MSolutionConfig)super.model();
        }

        protected BaseCreateSolutionDefinition<?> parent() {
            return this.parent;
        }

        @Override
        protected void validate() {
            this.parent.validate();
        }

        @Override
        protected CConfig retThis() {
            return (CConfig)this;
        }
    }

    public static abstract class BaseCreateSolutionDefinition<CSln extends BaseCreateSolutionDefinition<CSln>>
    extends BaseSolutionCreateSolutionSettings<CSln> {
        protected boolean isDestroyed = false;

        protected BaseCreateSolutionDefinition(MSolutionDefinition model) {
            super((MSolutionSettings)model);
        }

        public CSln setProjectNames(Collection<String> projectNames) {
            List<MSolutionProject> projects = projectNames.stream().map(n -> {
                MSolutionProject proj = SolutionModelFactory.eINSTANCE.createMSolutionProject();
                proj.setName(n);
                return proj;
            }).collect(Collectors.toList());
            return this.setProjects(projects);
        }

        public CSln setProjects(Collection<MSolutionProject> projects) {
            this.validate();
            this.model().getProjects().clear();
            if (projects != null) {
                this.model().getProjects().addAll(EcoreTypeUtils.copyAll(projects));
            }
            return (CSln)this.retThis();
        }

        public Collection<String> getProjectNames() {
            return this.model().getProjects().stream().map(MSolutionProject::getName).collect(Collectors.toList());
        }

        public CSln setActiveConfiguration(String group) {
            return (CSln)((BaseCreateSolutionDefinition)this.setProperty(SolutionProperties.ACTIVE_CONFIGURATION, group));
        }

        public String getActiveConfiguration() {
            return this.getProperty(SolutionProperties.ACTIVE_CONFIGURATION);
        }

        public CSln removeConfiguration(String configName) {
            this.validate();
            this.configuration(configName).remove();
            return (CSln)this.retThis();
        }

        public CSln clearConfigurations() {
            this.validate();
            this.model().getConfigs().clear();
            return (CSln)this.retThis();
        }

        public Collection<String> configurations() {
            this.validate();
            return this.model().getConfigs().stream().map(MDescribable::getName).collect(Collectors.toSet());
        }

        public boolean isReadOnly() {
            return this.isDestroyed;
        }

        public abstract BaseCreateSolutionConfiguration<?> configuration(String var1);

        public MSolutionDefinition model() {
            return (MSolutionDefinition)super.model();
        }

        @Override
        protected void validate() {
            if (this.isDestroyed) {
                throw new IllegalStateException("This factory has already been used to create a Solution! Please create a new one to modify settings!");
            }
        }

        @Override
        protected CSln retThis() {
            return (CSln)this;
        }
    }

    public static abstract class BaseCreateSolutionModule<CSln extends BaseCreateSolutionModule<CSln>>
    extends BaseCreateSolutionDefinition<CSln> {
        protected BaseCreateSolutionModule(MSolutionModule model) {
            super((MSolutionDefinition)model);
        }

        protected BaseCreateSolutionModule(String id) {
            this(SolutionModelFactory.eINSTANCE.createMSolutionModule());
            this.setId(id);
        }

        public CSln setId(String id) {
            this.validate();
            this.model().setId(id);
            return (CSln)((BaseCreateSolutionModule)this.retThis());
        }

        public String getId() {
            return this.model().getId();
        }

        public CSln applyTo(MSolution solution) {
            return this.applyTo(solution, (MSolutionModuleReferenceContainer)solution);
        }

        public CSln applyTo(MSolution solution, MSolutionModuleReferenceContainer applyTo) {
            SolutionUpdateUtils.updateToolContribution(solution, applyTo, this.getId(), this.model());
            return (CSln)((BaseCreateSolutionModule)this.retThis());
        }

        public MSolutionModule createModule() {
            this.isDestroyed = true;
            return this.model();
        }

        public MSolutionModule model() {
            return (MSolutionModule)super.model();
        }
    }

    public static class BaseCreateSolutionProject<CProj extends BaseCreateSolutionProject<CProj>>
    extends BaseCreateGeneralProject<CProj> {
        private BaseCreateSolutionDefinition<?> parent;

        protected BaseCreateSolutionProject(BaseCreateSolutionDefinition<?> parent, String projectName) {
            super(parent, (MSolutionSettings)parent.model(), projectName);
            this.parent = parent;
        }

        @Override
        public BaseCreateSolutionDefinition<?> remove() {
            super.remove();
            return this.parent;
        }

        @Override
        public BaseCreateSolutionDefinition<?> commit() {
            super.commit();
            return this.parent;
        }
    }

    public static abstract class BaseSolutionCreateSolutionSettings<E extends BaseSolutionCreateSolutionSettings<E>>
    extends BaseSolutionObjCreator<E> {
        protected final DescriptorPropertyMapper mapper = new DescriptorPropertyMapper(this.getPropertyScope(), this.getClass().getName());

        BaseSolutionCreateSolutionSettings(MSolutionSettings model) {
            super((EObject)model);
        }

        protected String getPropertyScope() {
            return "solution";
        }

        public abstract BaseCreateGeneralProject<?> project(String var1);

        public E setPostBuild(String postBuild) {
            this.model().setPostbuildStep(SolutionModelUtils.createBuildStep(postBuild));
            return (E)((BaseSolutionCreateSolutionSettings)this.retThis());
        }

        public E setPreBuild(String preBuild) {
            this.model().setPrebuildStep(SolutionModelUtils.createBuildStep(preBuild));
            return (E)((BaseSolutionCreateSolutionSettings)this.retThis());
        }

        public E clearProjects() {
            this.validate();
            this.model().getProjects().clear();
            return (E)((BaseSolutionCreateSolutionSettings)this.retThis());
        }

        public E removeProject(String projectName) {
            this.validate();
            this.project(projectName).remove();
            return (E)((BaseSolutionCreateSolutionSettings)this.retThis());
        }

        public List<String> projects() {
            this.validate();
            return this.model().getProjects().stream().map(MSolutionProject::getName).collect(Collectors.toList());
        }

        public <P> E setProperty(PropertyReference<P> key, P value) {
            this.setProperty(key, value, false);
            this.postSetProperty(BaseSolutionFactory.getPropId(this.mapper, key));
            return (E)((BaseSolutionCreateSolutionSettings)this.retThis());
        }

        public <P> E setProperty(PropertyReference<P> key, P value, boolean builtin) {
            this.validate();
            BaseSolutionFactory.setProperty(this.mapper, (MDescriptorProperties)this.model(), key, value, builtin);
            return (E)((BaseSolutionCreateSolutionSettings)this.retThis());
        }

        public E setPropertyStr(String key, String value) {
            this.validate();
            this.model().getProperties().put((Object)key, (Object)value);
            this.postSetProperty(key);
            return (E)((BaseSolutionCreateSolutionSettings)this.retThis());
        }

        protected void postSetProperty(String key) {
        }

        public E removeProperty(String key) {
            this.model().getProperties().removeKey((Object)key);
            return (E)((BaseSolutionCreateSolutionSettings)this.retThis());
        }

        public <P> P getProperty(PropertyReference<P> key) {
            return BaseSolutionFactory.getProperty(this.mapper, this.model().getProperties().map(), key);
        }

        protected MSolutionSettings model() {
            return (MSolutionSettings)super.model();
        }
    }

    public static abstract class BaseSolutionObjCreator<E extends BaseSolutionObjCreator<E>> {
        private EObject model;

        BaseSolutionObjCreator(EObject model) {
            this.model = model;
        }

        public <T> T run(Function<E, T> runner) {
            return runner.apply(this.retThis());
        }

        protected void validate() {
        }

        protected EObject model() {
            return this.model;
        }

        protected void setModel(EObject model) {
            this.model = model;
        }

        protected E retThis() {
            return (E)this;
        }
    }

    public static class SolutionProjectCreator
    extends BaseSolutionObjCreator<SolutionProjectCreator> {
        protected SolutionProjectCreator(String projectName) {
            super((EObject)SolutionModelFactory.eINSTANCE.createMSolutionProject());
            this.model().setName(projectName);
        }

        private Predicate<? super MSolutionProject> filter(String groupName) {
            return d -> Objects.equals(d.getName(), groupName);
        }

        public SolutionProjectCreator setProject(String projectName) {
            this.validate();
            this.model().setName(projectName);
            return this;
        }

        public SolutionProjectCreator setConfiguration(String configName) {
            this.validate();
            this.model().setConfiguration(configName);
            return this;
        }

        public String getConfiguration() {
            return this.model().getConfiguration();
        }

        public String getBinary() {
            return this.model().getBinary();
        }

        public SolutionProjectCreator setBinary(String binaryPath) {
            this.validate();
            this.model().setBinary(binaryPath);
            return this;
        }

        public String getLocation() {
            return this.model().getLocation();
        }

        public SolutionProjectCreator setLocation(String location) {
            this.validate();
            this.model().setLocation(location);
            return this;
        }

        public SolutionProjectCreator setBuiltin(boolean isBuiltin) {
            this.model().setBuiltin(isBuiltin);
            return this;
        }

        public MSolutionProject getModel() {
            return this.model();
        }

        public SolutionProjectCreator removeFrom(MSolutionSettings parent) {
            Set projs = this.findFrom(parent).collect(Collectors.toSet());
            parent.getProjects().removeAll(projs);
            return this;
        }

        public SolutionProjectCreator apply(MSolutionSettings parent) {
            parent.getProjects().add((Object)this.model());
            return this;
        }

        public SolutionProjectCreator findOrApply(MSolutionSettings parent) {
            MSolutionProject lclModel = this.findFrom(parent).findFirst().orElse(null);
            if (lclModel == null) {
                return this.apply(parent);
            }
            if (this.model().getBinary() != null) {
                lclModel.setBinary(this.model().getBinary());
            }
            if (this.model().getConfiguration() != null) {
                lclModel.setConfiguration(this.model().getConfiguration());
            }
            if (this.model().getLocation() != null) {
                lclModel.setLocation(this.model().getLocation());
            }
            this.setModel((EObject)lclModel);
            return this;
        }

        private Stream<MSolutionProject> findFrom(MSolutionSettings parent) {
            return parent.getProjects().stream().filter(this.filter(this.model().getName()));
        }

        protected MSolutionProject model() {
            return (MSolutionProject)super.model();
        }
    }
}

