/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.type;

import com.silabs.ss.framework.project.api.core.BuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.IWriteableProjectDescriptor;
import com.silabs.ss.framework.project.api.core.creator.BaseProjectHandler;
import com.silabs.ss.framework.project.api.core.creator.IProjectHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.NullProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.solution.ISolutionDescriptor;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.engine.ISolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.solution.engine.NullSolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.type.BaseProjectType;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.internal.api.core.external.impl.NoneExternalProjectType;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.entity.ExternalProjectEntity;
import com.silabs.ss.framework.project.internal.core.solution.ExternalSolutionEntity;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public final class NoneProjectType
extends BaseProjectType
implements IProjectType {
    public static final String ID = Activator.id() + ".projectType.none";
    private static final String PROJECT_TYPE_KEYWORD = "none";

    public NoneProjectType() {
        super(ID, "No project type", "No-op project type for testing");
        this.setName(PROJECT_TYPE_KEYWORD);
    }

    @Override
    public IBuildConfigurationDescriptor createBuildConfigurationDescriptor(IProjectDescriptor projectDesc) {
        return new BuildConfigurationDescriptor(projectDesc);
    }

    @Override
    public IProjectHandler createProjectHandler(IWriteableProjectDescriptor projectDesc) {
        return new BaseProjectHandler(projectDesc){

            @Override
            public void createOrConvertProject(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
            }
        };
    }

    public void establishProjectType(IWriteableProjectDescriptor projectDesc, IProgressMonitor monitor) throws CoreException {
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Null";
    }

    @Override
    public String getPropertyScope() {
        return "project";
    }

    @Override
    public IProjectEngineOperationHandler createProjectEngineOperationHandler(IProjectEntity entity) {
        return new NullProjectEngineOperationHandler(entity);
    }

    @Override
    public ISolutionEngineOperationHandler createSolutionEngineOperationHandler(ISolutionEntity solution) {
        return new NullSolutionEngineOperationHandler(solution);
    }

    @Override
    public double getApplicability(IPath projectLocation) throws CoreException {
        return -1.0;
    }

    @Override
    public boolean toolchainSupportsProject(IToolchainDescriptor toolchain, IProjectDescriptor desc) {
        return false;
    }

    @Override
    public IExternalType getExternalType() {
        return new NoneExternalProjectType();
    }

    @Override
    public IProjectEntity createProjectEntity(IProjectDescriptor desc, File filePath) {
        return new ExternalProjectEntity(desc, this);
    }

    @Override
    public ISolutionEntity createSolutionEntity(ISolutionDescriptor desc, File filePath) {
        return new ExternalSolutionEntity(desc, this);
    }
}

