/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.utils;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.function.Caster;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.api.core.model.MGenericOption;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.api.core.model.MLibraryFile;
import com.silabs.ss.framework.project.api.core.model.MMacroDefinition;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MSpecificOption;
import com.silabs.ss.framework.project.api.core.model.MToolListOption;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.model.MToolchainOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.platform.api.descriptor.core.model.util.EcoreIdentityCopier;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.PropertyConversionUtils;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;

public final class ProjectModelObjFactory {
    public static CreateMToolOption forMToolOption(String toolId, String optionId) {
        return new CreateMToolOption(toolId, optionId);
    }

    public static CreateMSpecificOption forMSpecificOption(IProperty prop) {
        return new CreateMSpecificOption(prop);
    }

    public static CreateMGenericOption forMGenericOption(IProperty prop) {
        return new CreateMGenericOption(prop);
    }

    public static CreateMToolOption forMToolOption(MToolOption toolOpt) {
        return new CreateMToolOption(toolOpt);
    }

    public static CreateMIncludePath forMIncludePath(String path) {
        return new CreateMIncludePath(path);
    }

    public static CreateMMacroDefinition forMMacroDefinition(String name, String value) {
        return new CreateMMacroDefinition(name, value);
    }

    public static CreateMLibraryFile forMLibraryFile() {
        return new CreateMLibraryFile();
    }

    private ProjectModelObjFactory() {
    }

    public static abstract class BaseCreateEObject<T extends BaseCreateEObject<T, MOption>, MOption extends EObject> {
        protected MOption option;
        private Function<MSettingsSite, List<? super MOption>> accessor;

        protected BaseCreateEObject(MOption opt, Function<MSettingsSite, List<? super MOption>> accessor) {
            this.option = opt;
            this.accessor = accessor;
        }

        public T apply(MSettingsSite site) {
            this.accessor.apply(site).add(this.option);
            return (T)this;
        }

        public T insert(int loc, MSettingsSite site) {
            this.accessor.apply(site).add(loc, this.option);
            return (T)this;
        }

        public MOption get() {
            return this.option;
        }

        public T set(Consumer<MOption> op) {
            op.accept(this.option);
            return (T)this;
        }

        public abstract T setValue(String var1);

        public T ifPresent(MSettingsSite site, Consumer<MOption> cons) {
            this.filteredStream(site).findAny().ifPresent(cons);
            return (T)this;
        }

        public T ifNotPresent(MSettingsSite site, Runnable run) {
            boolean present = this.filteredStream(site).findAny().isPresent();
            if (!present) {
                run.run();
            }
            return (T)this;
        }

        public T findOrApply(MSettingsSite site) {
            Optional<MOption> matchingOpt = this.filteredStream(site).findAny();
            if (matchingOpt.isPresent()) {
                this.option = (EObject)matchingOpt.get();
            } else {
                this.apply(site);
            }
            return (T)this;
        }

        public T removeFrom(MSettingsSite site) {
            Set matchingOpts = this.filteredStream(site).collect(Collectors.toSet());
            this.accessor.apply(site).removeAll(matchingOpts);
            return (T)this;
        }

        public T copy() {
            EcoreIdentityCopier copier = new EcoreIdentityCopier();
            this.option = copier.copy(this.option);
            copier.copyReferences();
            return (T)this;
        }

        private Stream<MOption> filteredStream(MSettingsSite site) {
            return this.accessor.apply(site).stream().map(arg_0 -> ((Caster)Caster.with(this.option.getClass())).cast(arg_0)).filter(Objects::nonNull).map(m -> m).filter(this.getFilter());
        }

        protected abstract Predicate<MOption> getFilter();

        public String toString() {
            return this.option.toString();
        }
    }

    public static abstract class BaseCreateMToolchainOption<T extends BaseCreateMToolchainOption<T, MOption>, MOption extends MToolchainOption>
    extends BaseCreateObject<T, MOption> {
        protected BaseCreateMToolchainOption(MOption opt, Function<MSettingsSite, List<? super MOption>> accessor) {
            super(opt, accessor);
        }
    }

    public static abstract class BaseCreateObject<T extends BaseCreateObject<T, MOption>, MOption extends MBuildSetting>
    extends BaseCreateEObject<T, MOption> {
        protected BaseCreateObject(MOption opt, Function<MSettingsSite, List<? super MOption>> accessor) {
            super(opt, accessor);
        }

        public T applySelectable(MSelectable select) {
            ((MBuildSetting)this.option).applySelectable(select);
            return (T)this;
        }

        public T appendSelectable(MSelectable select) {
            ((MBuildSetting)this.option).appendSelectable(select);
            return (T)this;
        }

        public T setBuiltin(boolean builtin) {
            ((MBuildSetting)this.option).setBuiltin(builtin);
            return (T)this;
        }
    }

    public static abstract class CreateMConvertedOption<T extends CreateMConvertedOption<T, MOption>, MOption extends MConvertedOption>
    extends BaseCreateMToolchainOption<T, MOption> {
        private IProperty prop;

        private CreateMConvertedOption(MOption opt, IProperty prop) {
            super(opt, MSettingsSite::getConvertedOptions);
            this.prop = prop;
            ((MConvertedOption)this.option).updateFrom(prop, null);
        }

        public T updateProperty(IProperty prop) {
            this.prop = prop;
            ((MConvertedOption)this.option).updateFrom(prop, null);
            return (T)this;
        }

        @Override
        public T setValue(String value) {
            ((MConvertedOption)this.option).updateFrom(this.prop, (Object)value);
            return (T)this;
        }

        public T validateValue() {
            if (((MConvertedOption)this.option).getValue() != null) {
                PropertyConversionUtils.stringizeValue((IProperty)this.prop, (Object)((MConvertedOption)this.option).getValue());
            }
            return (T)this;
        }

        @Override
        protected Predicate<MOption> getFilter() {
            return opt -> Objects.equals(opt.getToolId(), ((MConvertedOption)this.option).getToolId()) && Objects.equals(opt.getOptionId(), ((MConvertedOption)this.option).getOptionId());
        }
    }

    public static final class CreateMGenericOption
    extends CreateMConvertedOption<CreateMGenericOption, MGenericOption> {
        private CreateMGenericOption(IProperty prop) {
            super(ProjectModelFactory.eINSTANCE.createMGenericOption(), prop);
        }
    }

    public static final class CreateMIncludePath
    extends BaseCreateObject<CreateMIncludePath, MIncludePath> {
        private CreateMIncludePath(String pathUri) {
            super(ProjectModelFactory.eINSTANCE.createMIncludePath(), MSettingsSite::getIncludePaths);
            ((MIncludePath)this.option).setUri(pathUri);
        }

        public CreateMIncludePath setPath(String path) {
            ((MIncludePath)this.option).setUri(path);
            return this;
        }

        @Override
        public CreateMIncludePath setValue(String path) {
            return this.setPath(path);
        }

        @Override
        protected Predicate<MIncludePath> getFilter() {
            return inc -> Objects.equals(inc.getUri(), ((MIncludePath)this.option).getUri());
        }
    }

    public static final class CreateMLibraryFile
    extends BaseCreateObject<CreateMLibraryFile, MLibraryFile> {
        private CreateMLibraryFile() {
            super(ProjectModelFactory.eINSTANCE.createMLibraryFile(), MSettingsSite::getLibraryFiles);
        }

        public CreateMLibraryFile setName(String name) {
            ((MLibraryFile)this.option).setName(name);
            return this;
        }

        public CreateMLibraryFile setUri(String uri) {
            ((MLibraryFile)this.option).setUri(uri);
            return this;
        }

        @Override
        public CreateMLibraryFile setValue(String val) {
            return this.setUri(val);
        }

        @Override
        protected Predicate<MLibraryFile> getFilter() {
            return opt -> Objects.equals(opt.getUri(), ((MLibraryFile)this.option).getUri()) && Objects.equals(opt.getName(), ((MLibraryFile)this.option).getName());
        }
    }

    public static final class CreateMMacroDefinition
    extends BaseCreateObject<CreateMMacroDefinition, MMacroDefinition> {
        private CreateMMacroDefinition(String name, String value) {
            super(ProjectModelFactory.eINSTANCE.createMMacroDefinition(), MSettingsSite::getMacroDefinitions);
            ((MMacroDefinition)this.option).setName(name);
            ((MMacroDefinition)this.option).setValue(value);
        }

        public CreateMMacroDefinition setName(String name) {
            ((MMacroDefinition)this.option).setName(name);
            return this;
        }

        @Override
        public CreateMMacroDefinition setValue(String value) {
            ((MMacroDefinition)this.option).setValue(value);
            return this;
        }

        @Override
        protected Predicate<MMacroDefinition> getFilter() {
            return macro -> Objects.equals(macro.getName(), ((MMacroDefinition)this.option).getName());
        }
    }

    public static final class CreateMSpecificOption
    extends CreateMConvertedOption<CreateMSpecificOption, MSpecificOption> {
        private CreateMSpecificOption(IProperty prop) {
            super(ProjectModelFactory.eINSTANCE.createMSpecificOption(), prop);
        }
    }

    public static final class CreateMToolListOption {
        private CreateMToolOption parent;
        private MToolListOption listOpt;
        private boolean applied;

        private CreateMToolListOption(CreateMToolOption parent, String value) {
            this.parent = parent;
            this.listOpt = ProjectModelFactory.eINSTANCE.createMToolListOption();
            this.listOpt.setValue(value);
            this.applied = false;
        }

        public CreateMToolListOption setValue(String value) {
            this.listOpt.setValue(value);
            return this;
        }

        public CreateMToolListOption setBuiltin(boolean builtin) {
            this.listOpt.setBuiltin(builtin);
            return this;
        }

        public CreateMToolListOption set(Consumer<MToolListOption> op) {
            op.accept(this.listOpt);
            return this;
        }

        private CreateMToolListOption applyFromParent() {
            this.listOpt.setBoardCompatibility(((MToolOption)this.parent.option).getBoardCompatibility());
            this.listOpt.setBuiltin(((MToolOption)this.parent.option).isBuiltin());
            this.listOpt.setCompatibility(((MToolOption)this.parent.option).getCompatibility());
            this.listOpt.setLanguageCompatibility(((MToolOption)this.parent.option).getLanguageCompatibility());
            this.listOpt.setPartCompatibility(((MToolOption)this.parent.option).getPartCompatibility());
            this.listOpt.setSdkCompatibility(((MToolOption)this.parent.option).getSdkCompatibility());
            this.listOpt.setToolchainCompatibility(((MToolOption)this.parent.option).getToolchainCompatibility());
            return this;
        }

        public MToolListOption get() {
            return this.listOpt;
        }

        public CreateMToolListOption applySelectable(MSelectable select) {
            this.listOpt.applySelectable(select);
            return this;
        }

        public CreateMToolListOption appendSelectable(MSelectable select) {
            this.listOpt.appendSelectable(select);
            return this;
        }

        public CreateMToolListOption find() {
            Optional<MToolListOption> matchingOpt = this.getMatcherStream().findAny();
            if (matchingOpt.isPresent()) {
                this.listOpt = matchingOpt.get();
            } else {
                this.apply();
            }
            return this;
        }

        public CreateMToolListOption removeFrom() {
            Set matchingOpts = this.getMatcherStream().collect(Collectors.toSet());
            ((MToolOption)this.parent.option).getToolListOptions().removeAll(matchingOpts);
            return this;
        }

        private Stream<MToolListOption> getMatcherStream() {
            return ((MToolOption)this.parent.option).getToolListOptions().stream().filter(opt -> Objects.equals(opt.getValue(), this.listOpt.getValue()));
        }

        public CreateMToolOption apply() {
            if (!this.applied) {
                ((MToolOption)this.parent.option).getToolListOptions().add((Object)this.listOpt);
                this.applied = true;
            }
            return this.parent;
        }

        static /* synthetic */ CreateMToolListOption access$0(CreateMToolListOption createMToolListOption) {
            return createMToolListOption.applyFromParent();
        }
    }

    public static final class CreateMToolOption
    extends BaseCreateMToolchainOption<CreateMToolOption, MToolOption> {
        private CreateMToolOption(String toolId, String optionId) {
            super(ProjectModelFactory.eINSTANCE.createMToolOption(), MSettingsSite::getToolOptions);
            ((MToolOption)this.option).setToolId(toolId);
            ((MToolOption)this.option).setOptionId(optionId);
        }

        private CreateMToolOption(MToolOption toolOpt) {
            super(toolOpt, MSettingsSite::getToolOptions);
        }

        public CreateMToolListOption newListOption(String value) {
            return new CreateMToolListOption(this, value);
        }

        public CreateMToolOption addListOption(String value) {
            return this.newListOption(value).apply();
        }

        @Override
        public CreateMToolOption setValue(String value) {
            ((MToolOption)this.option).setValue(value);
            return this;
        }

        public CreateMToolOption clearListOptions() {
            ((MToolOption)this.option).getToolListOptions().clear();
            return this;
        }

        public CreateMToolOption convertToListOptions() {
            if (TextUtils.isEmpty((String)((MToolOption)this.option).getValue())) {
                return this;
            }
            Collection values = (Collection)CoreTypes.STRING_LIST.convert(((MToolOption)this.option).getValue());
            values.stream().filter(TextUtils::hasContent).map(this::newListOption).map(CreateMToolListOption::access$0).forEach(CreateMToolListOption::apply);
            return this.setValue(null);
        }

        @Override
        protected Predicate<MToolOption> getFilter() {
            return opt -> Objects.equals(opt.getToolId(), ((MToolOption)this.option).getToolId()) && Objects.equals(opt.getOptionId(), ((MToolOption)this.option).getOptionId());
        }
    }
}

