/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.core.external.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.silabs.ss.framework.project.api.core.external.IToolchainDirectImportSupport;
import com.silabs.ss.framework.project.api.core.model.EMappingStatus;
import com.silabs.ss.framework.project.api.core.model.options.DirectOptionMappingFactory;
import com.silabs.ss.framework.project.api.core.model.options.IDirectOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.OptionMappingRegistryFactory;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchain;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.internal.api.core.external.impl.KeilExternalOptions;
import com.silabs.ss.platform.api.descriptor.core.manager.SingletonAccessor;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class KeilDirectOptionsMappings {
    public static final String KEIL_TOOLCHAIN = "com.silabs.ss.tool.ide.c8051.toolchain.keil.cdt";
    public static final String KEIL_ASSEMBLER = "com.silabs.ide.si8051.keil.toolchain.assembler";
    public static final String KEIL_COMPILER = "com.silabs.ide.si8051.keil.toolchain.compiler";
    public static final String KEIL_LINKER = "com.silabs.ide.si8051.keil.toolchain.linker";
    public static final String KEIL_TOOL = "com.silabs.ide.si8051.keil.toolchain";
    public static final ImmutableList<String> LXLinkerOptions = ImmutableList.of((Object)"");
    public static final ImmutableMap<String, IProperty> LXLinkerDirecitives = ImmutableMap.builder().put((Object)"ASSIGN", (Object)KeilExternalOptions.ASSIGN).put((Object)"CLASSES", (Object)KeilExternalOptions.USER_CLASSES).put((Object)"SEGMENTS", (Object)KeilExternalOptions.USER_SECTION).put((Object)"RESERVE", (Object)KeilExternalOptions.RESERVE_STRING).put((Object)"OVERLAY", (Object)KeilExternalOptions.OVERLAY_STRING).build();
    public static final ImmutableMap<String, IProperty> BLLinkerDirecitives = ImmutableMap.builder().put((Object)"BIT", (Object)KeilExternalOptions.BIT_BASE_ADDRESS).put((Object)"BIT_SEGMENT", (Object)KeilExternalOptions.BIT_SEGMENT_NAME).put((Object)"CODE", (Object)KeilExternalOptions.CODE_BASE_ADDRESS).put((Object)"CODE_SEGMENT", (Object)KeilExternalOptions.CODE_SEGEMENT_NAME).put((Object)"DATA", (Object)KeilExternalOptions.DATA_BASE_ADDRESS).put((Object)"DATA_SEGMENT", (Object)KeilExternalOptions.DATA_SEGMENT_NAME).put((Object)"IDATA", (Object)KeilExternalOptions.IDATA_BASE_ADDRESS).put((Object)"IDATA_SEGMENT", (Object)KeilExternalOptions.IDATA_SEGMENT_NAME).put((Object)"XDATA", (Object)KeilExternalOptions.XDATA_BASE_ADDRESS).put((Object)"XDATA_SEGMENT", (Object)KeilExternalOptions.XDATA_SEGMENT_NAME).put((Object)"PDATA", (Object)KeilExternalOptions.PDATA_BASE_ADDRESS).put((Object)"PRECEDE", (Object)KeilExternalOptions.PRECEDE).put((Object)"STACK", (Object)KeilExternalOptions.STACK).put((Object)"OVERLAY", (Object)KeilExternalOptions.OVERLAY_STRING).build();

    private KeilDirectOptionsMappings() {
    }

    public static IProperty getFlagProperty(String flag, String tool) {
        Map<String, IProperty> toolFlags = KeilDirectOptionsMappings.flagProperties().get(tool);
        if (toolFlags == null) {
            return null;
        }
        IProperty property = toolFlags.get(flag.toUpperCase(Locale.ROOT));
        return property;
    }

    @SingletonAccessor
    private static Map<String, Map<String, IProperty>> flagProperties() {
        return FlagPropertiesHolder.flagProperties;
    }

    public static IProperty getMiscFlagsProperty(String tool) {
        if (tool.equals(KEIL_ASSEMBLER)) {
            return KeilExternalOptions.A51_MISC_CONTROLS;
        }
        if (tool.equals(KEIL_COMPILER)) {
            return KeilExternalOptions.C51_MISC_CONTROLS;
        }
        if (tool.equals(KEIL_LINKER)) {
            return KeilExternalOptions.L51_MISC_CONTROLS;
        }
        return null;
    }

    @SingletonAccessor
    public static IDirectOptionMappingRegistry registry() {
        return MappingRegistryHolder.directRegistry;
    }

    private static class FlagPropertiesHolder {
        private static final Map<String, Map<String, IProperty>> flagProperties = new HashMap<String, Map<String, IProperty>>();

        static {
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_ASSEMBLER, KeilExternalOptions.USE_STANDARD, "MACRO", "NOMACRO");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_ASSEMBLER, KeilExternalOptions.USE_MPL, "MPL", "NOMPL");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_ASSEMBLER, KeilExternalOptions.USE_MOD51, "MOD51", "NOMOD51");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_ASSEMBLER, KeilExternalOptions.A51_SET, "SET");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_LINKER, KeilExternalOptions.DISABLE_WARNING_NUMBERS, "DISABLEWARNING", "DW");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_COMPILER, KeilExternalOptions.FUZZY, "FLOATFUZZY", "FF");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_COMPILER, KeilExternalOptions.OPTIMIZE, "OPTIMIZE");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_COMPILER, KeilExternalOptions.C51_WARNING_LEVEL, "WARNINGLEVEL", "WL");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_COMPILER, KeilExternalOptions.SIZE_SPEED, "SIZE", "SPEED");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_COMPILER, KeilExternalOptions.INTERRUPT_VECTOR_ADDRESS, "INTVECTOR", "IV", "NOINTVECTOR", "NOIV");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_COMPILER, KeilExternalOptions.MEMORY_MODEL, "COMPACT", "CP", "LARGE", "LA", "SMALL", "SM");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_COMPILER, KeilExternalOptions.ROM_SIZE, "ROM");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_COMPILER, KeilExternalOptions.VARIABLES_IN_ORDER, "ORDER", "OR");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_COMPILER, KeilExternalOptions.INTEGER_PROMOTION, "INTPROMOTE", "IP", "NOINTPROMOTE", "NOIP");
            FlagPropertiesHolder.mapFlag(KeilDirectOptionsMappings.KEIL_COMPILER, KeilExternalOptions.U_AREGS, "AREGS", "AR", "NOAREGS", "NOAR");
        }

        private FlagPropertiesHolder() {
        }

        private static void mapFlag(String tool, IProperty property, String ... flags) {
            String[] stringArray = flags;
            int n = flags.length;
            int n2 = 0;
            while (n2 < n) {
                String flag = stringArray[n2];
                FlagPropertiesHolder.mapFlag(tool, flag.toUpperCase(Locale.ROOT), property);
                ++n2;
            }
        }

        private static void mapFlag(String tool, String flag, IProperty property) {
            Map toolFlags = flagProperties.computeIfAbsent(tool, t -> new HashMap());
            assert (!toolFlags.containsKey(flag));
            toolFlags.put(flag, property);
        }
    }

    private static class MappingRegistryHolder {
        private static final IDirectOptionMappingRegistry directRegistry = OptionMappingRegistryFactory.INSTANCE.createDirectOptionMappingRegistry();
        private static IToolchainDirectImportSupport tcSupport;

        static {
            MappingRegistryHolder.setupMappingRegistry();
        }

        private MappingRegistryHolder() {
        }

        private static boolean validateTcSupport() {
            String[] values;
            MappingRegistryHolder.initToolchainSupport();
            String[] stringArray = values = new String[]{KeilDirectOptionsMappings.KEIL_ASSEMBLER, KeilDirectOptionsMappings.KEIL_COMPILER, KeilDirectOptionsMappings.KEIL_LINKER, KeilDirectOptionsMappings.KEIL_TOOL};
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String toolId = stringArray[n2];
                IPropertyGroup propGroup = tcSupport.getCdtToolOrToolChainPropertyGroup(toolId);
                if (propGroup == null || propGroup.getProperties().length == 0) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private static IProperty cdtOption(String toolID, String optionID) {
            MappingRegistryHolder.initToolchainSupport();
            IPropertyGroup group = tcSupport.getCdtToolOrToolChainPropertyGroup(toolID);
            return group != null ? group.findProperty(optionID) : null;
        }

        private static void initToolchainSupport() {
            if (tcSupport != null) {
                return;
            }
            IToolchain keilTc = (IToolchain)Toolchain.manager().findCompatible(KeilDirectOptionsMappings.KEIL_TOOLCHAIN);
            if (keilTc != null) {
                tcSupport = (IToolchainDirectImportSupport)keilTc.getAdapter(IToolchainDirectImportSupport.class);
            }
            if (tcSupport == null) {
                tcSupport = IToolchainDirectImportSupport.NONE_TOOLCHAIN_IMPORT_SUPPORT;
            }
        }

        private static void setupMappingRegistry() {
            if (!MappingRegistryHolder.validateTcSupport()) {
                return;
            }
            DirectOptionMappingFactory.with((IProperty)KeilExternalOptions.USE_STANDARD).mapFromTo(MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_ASSEMBLER, "com.silabs.ide.si8051.keil.assembler.category.general.macros"), new Object[]{0, "com.silabs.ide.si8051.keil.assembler.category.general.macros.disabled", 1, "com.silabs.ide.si8051.keil.assembler.category.general.macros.standard"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            DirectOptionMappingFactory.with((IProperty)KeilExternalOptions.USE_MPL).mapFromTo(MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_ASSEMBLER, "com.silabs.ide.si8051.keil.assembler.category.general.macros"), new Object[]{1, "com.silabs.ide.si8051.keil.assembler.category.general.macros.mpl"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            MappingRegistryHolder.mapTrueForInt(KeilExternalOptions.USE_MOD51, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_ASSEMBLER, "com.silabs.ide.si8051.keil.assembler.category.general.sfrnames"));
            MappingRegistryHolder.unmap(KeilExternalOptions.USE_CASE);
            MappingRegistryHolder.mapDirectly(KeilExternalOptions.A51_MISC_CONTROLS, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_ASSEMBLER, "com.silabs.ide.si8051.keil.assembler.category.misc.extraflags"));
            MappingRegistryHolder.unmap(KeilExternalOptions.A51_UNDEFINE);
            MappingRegistryHolder.mapDirectly(KeilExternalOptions.A51_SET, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_ASSEMBLER, "com.silabs.ide.si8051.keil.assembler.category.symbols.def"));
            MappingRegistryHolder.unmap(KeilExternalOptions.AARM_UNDEFINE);
            MappingRegistryHolder.unmap(KeilExternalOptions.C51_UNDEFINE);
            MappingRegistryHolder.mapTrueForInt(KeilExternalOptions.REGISTER_COLORING, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.optimization.coloring"));
            MappingRegistryHolder.mapTrueForInt(KeilExternalOptions.VARIABLES_IN_ORDER, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.general.order_variables"));
            MappingRegistryHolder.mapTrueForInt(KeilExternalOptions.INTEGER_PROMOTION, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.general.promote"));
            MappingRegistryHolder.mapTrueForInt(KeilExternalOptions.U_AREGS, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.optimization.aregs"));
            MappingRegistryHolder.unmap(KeilExternalOptions.USE_INTERRUPT_VECTOR);
            DirectOptionMappingFactory.with((IProperty)KeilExternalOptions.FUZZY).mapFromTo(MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits"), new Object[]{0, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits.0", 1, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits.1", 2, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits.2", 3, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits.3", 4, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits.4", 5, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits.5", 6, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits.6", 7, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits.7"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            DirectOptionMappingFactory.with((IProperty)KeilExternalOptions.FUZZY).mapFromTo(MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits"), new Object[]{8, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits.7", 9, "com.silabs.ide.si8051.keil.compiler.category.general.float_bits.7"}).is(EMappingStatus.PARTIALLY_MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            DirectOptionMappingFactory.with((IProperty)KeilExternalOptions.OPTIMIZE).mapFromTo(MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.optimization.level"), new Object[]{0, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.0", 1, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.1", 2, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.2", 3, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.3", 4, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.4", 5, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.5", 6, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.6", 7, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.7", 8, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.8", 9, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.9"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            DirectOptionMappingFactory.with((IProperty)KeilExternalOptions.OPTIMIZE).mapFromTo(MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.optimization.level"), new Object[]{10, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.9", 11, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.9", 12, "com.silabs.ide.si8051.keil.compiler.category.optimization.level.9"}).is(EMappingStatus.PARTIALLY_MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            DirectOptionMappingFactory.with((IProperty)KeilExternalOptions.C51_WARNING_LEVEL).mapFromTo(MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.general.warning_level"), new Object[]{0, "com.silabs.ide.si8051.keil.compiler.category.general.warning_level.0", 1, "com.silabs.ide.si8051.keil.compiler.category.general.warning_level.1", 2, "com.silabs.ide.si8051.keil.compiler.category.general.warning_level.2"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            DirectOptionMappingFactory.with((IProperty)KeilExternalOptions.SIZE_SPEED).mapFromTo(MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.optimization.emphasis"), new Object[]{0, "com.silabs.ide.si8051.keil.compiler.category.optimization.emphasis.size", 1, "com.silabs.ide.si8051.keil.compiler.category.optimization.emphasis.speed"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            MappingRegistryHolder.unmap(KeilExternalOptions.A_CALL_A_JMP);
            MappingRegistryHolder.mapDirectly(KeilExternalOptions.INTERRUPT_VECTOR_ADDRESS, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.general.vectors"));
            MappingRegistryHolder.unmap(KeilExternalOptions.CARM_UNDEFINE);
            MappingRegistryHolder.mapTrueForInt(KeilExternalOptions.USE_LINKER_CONTROL, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_LINKER, "com.silabs.ide.si8051.keil.linker.category.general.use_control_file"));
            MappingRegistryHolder.mapDirectly(KeilExternalOptions.LINKER_CONTROL_FILE, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_LINKER, "com.silabs.ide.si8051.keil.linker.category.general.control_file"));
            MappingRegistryHolder.unmap(KeilExternalOptions.USE_MEMORY_FROM_TARGET);
            DirectOptionMappingFactory.with((IProperty)KeilExternalOptions.L51_WARNING_LEVEL).mapFromTo(MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_LINKER, "com.silabs.ide.si8051.keil.linker.category.general.warning_level"), new Object[]{0, "com.silabs.ide.si8051.keil.linker.category.general.warning_level.0", 1, "com.silabs.ide.si8051.keil.linker.category.general.warning_level.1", 2, "com.silabs.ide.si8051.keil.linker.category.general.warning_level.2"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            MappingRegistryHolder.mapDirectly(KeilExternalOptions.DISABLE_WARNING_NUMBERS, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_LINKER, "com.silabs.ide.si8051.keil.linker.category.misc.warnings"));
            MappingRegistryHolder.unmap(KeilExternalOptions.OVERLAY_STRING);
            MappingRegistryHolder.unmap(KeilExternalOptions.ASSIGN);
            MappingRegistryHolder.unmap(KeilExternalOptions.CASE_SENSITIVE_SYMBOLS);
            MappingRegistryHolder.unmap(KeilExternalOptions.RESERVE_STRING);
            MappingRegistryHolder.unmap(KeilExternalOptions.USER_CLASSES);
            MappingRegistryHolder.unmap(KeilExternalOptions.USER_SECTION);
            MappingRegistryHolder.unmap(KeilExternalOptions.CODE_BASE_ADDRESS);
            MappingRegistryHolder.unmap(KeilExternalOptions.XDATA_BASE_ADDRESS);
            MappingRegistryHolder.unmap(KeilExternalOptions.PDATA_BASE_ADDRESS);
            MappingRegistryHolder.unmap(KeilExternalOptions.BIT_BASE_ADDRESS);
            MappingRegistryHolder.unmap(KeilExternalOptions.DATA_BASE_ADDRESS);
            MappingRegistryHolder.unmap(KeilExternalOptions.IDATA_BASE_ADDRESS);
            MappingRegistryHolder.unmap(KeilExternalOptions.PRECEDE);
            MappingRegistryHolder.unmap(KeilExternalOptions.STACK);
            MappingRegistryHolder.unmap(KeilExternalOptions.CODE_SEGEMENT_NAME);
            MappingRegistryHolder.unmap(KeilExternalOptions.XDATA_SEGMENT_NAME);
            MappingRegistryHolder.unmap(KeilExternalOptions.BIT_SEGMENT_NAME);
            MappingRegistryHolder.unmap(KeilExternalOptions.DATA_SEGMENT_NAME);
            MappingRegistryHolder.unmap(KeilExternalOptions.IDATA_SEGMENT_NAME);
            MappingRegistryHolder.mapDirectly(KeilExternalOptions.L51_MISC_CONTROLS, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_LINKER, "com.silabs.ide.si8051.keil.linker.category.misc.extraflags"));
            MappingRegistryHolder.unmap(KeilExternalOptions.LX51_MISC_CONTROLS);
            MappingRegistryHolder.mapTrueForInt(KeilExternalOptions.USE_L251, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_TOOL, "com.silabs.ide.si8051.keil.toolchain.category.general.extended_linker"));
            MappingRegistryHolder.mapTrueForInt(KeilExternalOptions.USE_A251, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_TOOL, "com.silabs.ide.si8051.keil.toolchain.category.general.extended_assembler"));
            DirectOptionMappingFactory.with((IProperty)KeilExternalOptions.MEMORY_MODEL).mapFromTo(MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_TOOL, "com.silabs.ide.si8051.keil.toolchain.category.general.memory_model"), new Object[]{0, "com.silabs.ide.si8051.keil.toolchain.category.general.memory_model.small", 1, "com.silabs.ide.si8051.keil.toolchain.category.general.memory_model.compact", 2, "com.silabs.ide.si8051.keil.toolchain.category.general.memory_model.large"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            MappingRegistryHolder.unmap(KeilExternalOptions.RTOS);
            DirectOptionMappingFactory.with((IProperty)KeilExternalOptions.ROM_SIZE).mapFromTo(MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.general.code"), new Object[]{0, "com.silabs.ide.si8051.keil.compiler.category.general.code.small", 1, "com.silabs.ide.si8051.keil.compiler.category.general.code.compact", 2, "com.silabs.ide.si8051.keil.compiler.category.general.code.large"}).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            MappingRegistryHolder.unmap(KeilExternalOptions.USE_ON_CHIP_ROM);
            MappingRegistryHolder.unmap(KeilExternalOptions.USE_ON_CHIP_XRAM);
            MappingRegistryHolder.mapTrueForInt(KeilExternalOptions.USE_CB, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_LINKER, "com.silabs.ide.si8051.keil.linker.category.banking.enabled"));
            MappingRegistryHolder.mapDirectly(KeilExternalOptions.BANKNO, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_LINKER, "com.silabs.ide.si8051.keil.linker.category.banking.selection"));
            MappingRegistryHolder.unmap(KeilExternalOptions.C_BANKS);
            MappingRegistryHolder.unmap(KeilExternalOptions.USE_XB);
            MappingRegistryHolder.unmap(KeilExternalOptions.USE_XBS);
            MappingRegistryHolder.mapDirectly(KeilExternalOptions.C51_MISC_CONTROLS, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_COMPILER, "com.silabs.ide.si8051.keil.compiler.category.misc.extraflags"));
            MappingRegistryHolder.mapTrueForInt(KeilExternalOptions.DEBUG_INFORMATION, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_TOOL, "com.silabs.ide.si8051.keil.toolchain.category.general.debug"));
            MappingRegistryHolder.mapDirectly(KeilExternalOptions.INCLUDE_PATH, MappingRegistryHolder.cdtOption(KeilDirectOptionsMappings.KEIL_TOOL, "com.silabs.ide.si8051.keil.compiler.category.includes.paths"));
            MappingRegistryHolder.unmap(KeilExternalOptions.N_STOP_U1X);
            MappingRegistryHolder.unmap(KeilExternalOptions.N_STOP_U2X);
        }

        private static void mapDirectly(IProperty property, IProperty options) {
            DirectOptionMappingFactory.with((IProperty)property).mapTo(options).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
        }

        private static void unmap(IProperty property) {
            DirectOptionMappingFactory.with((IProperty)property).is(EMappingStatus.UNMAPPED).addTo((IOptionMappingRegistry)directRegistry);
        }

        private static void mapTrueForInt(IProperty property, IProperty ... specificOptions) {
            DirectOptionMappingFactory.with((IProperty)property).forSpecific((Object)1).mapTrue(specificOptions).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
            DirectOptionMappingFactory.with((IProperty)property).forSpecific((Object)0).mapFalse(specificOptions).is(EMappingStatus.MAPPED).addTo((IOptionMappingRegistry)directRegistry);
        }
    }
}

